/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import org.datanucleus.ClassConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionActiveOnBeginException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.transaction.HeuristicMixedException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.RollbackException;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.transaction.TransactionManager;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionImpl
implements org.datanucleus.Transaction {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    ExecutionContext ec;
    TransactionManager txnMgr;
    boolean active = false;
    boolean committing;
    Synchronization sync;
    protected boolean retainValues;
    protected boolean restoreValues;
    protected boolean optimistic;
    protected boolean nontransactionalRead;
    protected boolean nontransactionalWrite;
    protected boolean rollbackOnly = false;
    protected Boolean serializeRead = null;
    private Set<TransactionEventListener> listenersPerTransaction = new HashSet<TransactionEventListener>();
    private TransactionEventListener ecListener;
    private List<TransactionEventListener> userListeners = new ArrayList<TransactionEventListener>();
    private Map<String, Object> options = null;
    long beginTime;
    boolean closed = false;

    public TransactionImpl(ExecutionContext ec) {
        this.ec = ec;
        this.ecListener = (TransactionEventListener)((Object)ec);
        this.txnMgr = ec.getNucleusContext().getTransactionManager();
        PersistenceConfiguration config = ec.getNucleusContext().getPersistenceConfiguration();
        this.optimistic = config.getBooleanProperty("datanucleus.Optimistic");
        this.retainValues = config.getBooleanProperty("datanucleus.RetainValues");
        this.restoreValues = config.getBooleanProperty("datanucleus.RestoreValues");
        this.nontransactionalRead = config.getBooleanProperty("datanucleus.NontransactionalRead");
        this.nontransactionalWrite = config.getBooleanProperty("datanucleus.NontransactionalWrite");
        int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName(config.getStringProperty("datanucleus.transactionIsolation"));
        this.setOption("transaction.isolation", isolationLevel);
        Boolean serialiseReadProp = config.getBooleanObjectProperty("datanucleus.SerializeRead");
        if (serialiseReadProp != null) {
            this.serializeRead = serialiseReadProp;
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() {
        if (this.ec.getMultithreaded()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.txnMgr.begin(this.ec);
            }
        } else {
            this.txnMgr.begin(this.ec);
        }
        this.internalBegin();
    }

    protected void internalBegin() {
        TransactionEventListener[] ls;
        if (this.active) {
            throw new TransactionActiveOnBeginException(this.ec);
        }
        this.active = true;
        this.beginTime = System.currentTimeMillis();
        if (this.ec.getStatistics() != null) {
            this.ec.getStatistics().transactionStarted();
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015000", this.ec, (Object)("" + this.optimistic)));
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionStarted();
        }
    }

    @Override
    public void preFlush() {
        try {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionPreFlush();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof NucleusException) {
                throw (NucleusException)ex;
            }
            throw new NucleusTransactionException(LOCALISER.msg("015005"), ex);
        }
    }

    @Override
    public void flush() {
        try {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionFlushed();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof NucleusException) {
                throw (NucleusException)ex;
            }
            throw new NucleusTransactionException(LOCALISER.msg("015005"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        try {
            this.flush();
        }
        finally {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionEnded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (!this.isActive()) {
            throw new TransactionNotActiveException();
        }
        if (this.rollbackOnly) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015020"));
            }
            throw new NucleusDataStoreException(LOCALISER.msg("015020")).setFatal();
        }
        long startTime = System.currentTimeMillis();
        boolean success = false;
        boolean canComplete = true;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.flush();
            this.internalPreCommit();
            this.internalCommit();
            success = true;
        }
        catch (RollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicRollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicMixedException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (NucleusUserException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            canComplete = false;
            throw e;
        }
        catch (NucleusException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        finally {
            if (canComplete) {
                try {
                    if (!success) {
                        this.rollback();
                    } else {
                        this.internalPostCommit();
                    }
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        }
        if (errors.size() > 0) {
            throw new NucleusTransactionException(LOCALISER.msg("015007"), errors.toArray(new Throwable[errors.size()]));
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015022", System.currentTimeMillis() - startTime));
        }
    }

    protected void internalPreCommit() {
        TransactionEventListener[] ls;
        this.committing = true;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015001", this.ec));
        }
        if (this.sync != null) {
            this.sync.beforeCompletion();
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionPreCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalCommit() {
        if (this.ec.getMultithreaded()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.txnMgr.commit(this.ec);
            }
        } else {
            this.txnMgr.commit(this.ec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void rollback() {
        block39: {
            if (!this.isActive()) {
                throw new TransactionNotActiveException();
            }
            startTime = System.currentTimeMillis();
            try {
                try {
                    canComplete = true;
                    this.committing = true;
                    try {
                        this.flush();
                        var5_5 = null;
                    }
                    catch (Throwable var4_31) {
                        var5_6 = null;
                        try {
                            try {
                                this.internalPreRollback();
                                v0 = null;
                            }
                            catch (NucleusUserException e) {
                                if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                                    NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                                }
                                canComplete = false;
                                throw e;
                            }
                        }
                        catch (Throwable var7_10) {
                            v0 = var8_12 = null;
                        }
                        if (canComplete) {
                            try {
                                this.internalRollback();
                                var10_15 = null;
                            }
                            catch (Throwable var9_30) {
                                var10_16 = null;
                                try {
                                    this.active = false;
                                    if (this.ec.getStatistics() != null) {
                                        this.ec.getStatistics().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                                    }
                                    var12_23 = null;
                                    this.listenersPerTransaction.clear();
                                    this.rollbackOnly = false;
                                    ** if (this.sync == null) goto lbl-1000
                                }
                                catch (Throwable var11_28) {
                                    var12_24 = null;
                                    this.listenersPerTransaction.clear();
                                    this.rollbackOnly = false;
                                    if (this.sync != null) {
                                        this.sync.afterCompletion(4);
                                    }
                                    throw var11_28;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    this.sync.afterCompletion(4);
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                                throw var9_30;
                            }
                            try {
                                this.active = false;
                                if (this.ec.getStatistics() != null) {
                                    this.ec.getStatistics().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                                }
                                var12_21 = null;
                                this.listenersPerTransaction.clear();
                                this.rollbackOnly = false;
                                ** if (this.sync == null) goto lbl-1000
                            }
                            catch (Throwable var11_27) {
                                var12_22 = null;
                                this.listenersPerTransaction.clear();
                                this.rollbackOnly = false;
                                if (this.sync != null) {
                                    this.sync.afterCompletion(4);
                                }
                                throw var11_27;
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.sync.afterCompletion(4);
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        throw var4_31;
                    }
                    try {
                        try {
                            this.internalPreRollback();
                            v1 = null;
                        }
                        catch (NucleusUserException e) {
                            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                            }
                            canComplete = false;
                            throw e;
                        }
                    }
                    catch (Throwable var7_9) {
                        v1 = var8_11 = null;
                    }
                    if (!canComplete) break block39;
                    try {
                        this.internalRollback();
                        var10_13 = null;
                    }
                    catch (Throwable var9_29) {
                        var10_14 = null;
                        try {
                            this.active = false;
                            if (this.ec.getStatistics() != null) {
                                this.ec.getStatistics().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                            }
                            var12_19 = null;
                            this.listenersPerTransaction.clear();
                            this.rollbackOnly = false;
                            ** if (this.sync == null) goto lbl-1000
                        }
                        catch (Throwable var11_26) {
                            var12_20 = null;
                            this.listenersPerTransaction.clear();
                            this.rollbackOnly = false;
                            if (this.sync != null) {
                                this.sync.afterCompletion(4);
                            }
                            throw var11_26;
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.sync.afterCompletion(4);
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        throw var9_29;
                    }
                    try {
                        this.active = false;
                        if (this.ec.getStatistics() != null) {
                            this.ec.getStatistics().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                        }
                        var12_17 = null;
                        this.listenersPerTransaction.clear();
                        this.rollbackOnly = false;
                        ** if (this.sync == null) goto lbl-1000
                    }
                    catch (Throwable var11_25) {
                        var12_18 = null;
                        this.listenersPerTransaction.clear();
                        this.rollbackOnly = false;
                        if (this.sync != null) {
                            this.sync.afterCompletion(4);
                        }
                        throw var11_25;
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.sync.afterCompletion(4);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (NucleusUserException e) {
                    throw e;
                }
                catch (NucleusException e) {
                    throw new NucleusDataStoreException(TransactionImpl.LOCALISER.msg("015009"), e);
                }
            }
            catch (Throwable var13_34) {
                var14_33 = null;
                this.committing = false;
                throw var13_34;
            }
        }
        var14_32 = null;
        this.committing = false;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(TransactionImpl.LOCALISER.msg("015023", System.currentTimeMillis() - startTime));
        }
    }

    protected void internalPreRollback() {
        TransactionEventListener[] ls;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015002", this.ec));
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionPreRollBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRollback() {
        TransactionEventListener[] ls;
        Transaction tx = this.txnMgr.getTransaction(this.ec);
        if (tx != null) {
            if (this.ec.getMultithreaded()) {
                TransactionImpl transactionImpl = this;
                synchronized (transactionImpl) {
                    this.txnMgr.rollback(this.ec);
                }
            } else {
                this.txnMgr.rollback(this.ec);
            }
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionRolledBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void internalPostCommit() {
        block11: {
            Object v0;
            this.active = false;
            if (this.ec.getStatistics() != null) {
                this.ec.getStatistics().transactionCommitted(System.currentTimeMillis() - this.beginTime);
            }
            Object var2_1 = null;
            try {
                TransactionEventListener[] ls;
                for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                    tel.transactionCommitted();
                }
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var9_15 = v0;
            this.committing = false;
            this.listenersPerTransaction.clear();
            if (this.sync != null) {
                this.sync.afterCompletion(3);
            }
            break block11;
            catch (Throwable throwable) {
                Object v1;
                Object var2_2 = null;
                try {
                    TransactionEventListener[] ls;
                    for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                        tel.transactionCommitted();
                    }
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var9_16 = v1;
                this.committing = false;
                this.listenersPerTransaction.clear();
                if (this.sync != null) {
                    this.sync.afterCompletion(3);
                }
                throw throwable;
            }
        }
    }

    private TransactionEventListener[] getListenersForEvent() {
        TransactionEventListener[] ls = new TransactionEventListener[this.userListeners.size() + this.listenersPerTransaction.size() + 1];
        System.arraycopy(this.listenersPerTransaction.toArray(), 0, ls, 0, this.listenersPerTransaction.size());
        System.arraycopy(this.userListeners.toArray(), 0, ls, this.listenersPerTransaction.size(), this.userListeners.size());
        ls[ls.length - 1] = this.ecListener;
        return ls;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public boolean isCommitting() {
        return this.committing;
    }

    @Override
    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    @Override
    public boolean getOptimistic() {
        return this.optimistic;
    }

    @Override
    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    @Override
    public boolean getRetainValues() {
        return this.retainValues;
    }

    @Override
    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public Synchronization getSynchronization() {
        return this.sync;
    }

    @Override
    public void setNontransactionalRead(boolean nontransactionalRead) {
        this.nontransactionalRead = nontransactionalRead;
    }

    @Override
    public void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.nontransactionalWrite = nontransactionalWrite;
    }

    @Override
    public void setOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    @Override
    public void setRestoreValues(boolean restoreValues) {
        this.restoreValues = restoreValues;
    }

    @Override
    public void setRetainValues(boolean retainValues) {
        this.retainValues = retainValues;
        if (retainValues) {
            this.nontransactionalRead = true;
        }
    }

    @Override
    public void setRollbackOnly() {
        if (this.active) {
            this.rollbackOnly = true;
        }
    }

    @Override
    public void setSynchronization(Synchronization sync) {
        this.sync = sync;
    }

    @Override
    public void addTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.add(listener);
    }

    @Override
    public void removeTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.remove(listener);
        this.userListeners.remove(listener);
    }

    @Override
    public void bindTransactionEventListener(TransactionEventListener listener) {
        this.userListeners.add(listener);
    }

    @Override
    public Boolean getSerializeRead() {
        return this.serializeRead;
    }

    @Override
    public void setSerializeRead(Boolean serializeRead) {
        this.serializeRead = serializeRead;
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public void setOption(String option, int value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, boolean value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, String value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, Object value) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(option, value);
    }
}

