/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.simple;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassConstants;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOList;
import org.datanucleus.store.types.SCOListIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Stack
extends java.util.Stack
implements SCOList,
Cloneable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected transient ObjectProvider ownerOP;
    protected transient String fieldName;
    protected transient int fieldNumber;
    protected java.util.Stack delegate;

    public Stack(ObjectProvider ownerSM, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerSM;
        this.fieldName = mmd.getName();
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            this.delegate = new java.util.Stack();
            this.delegate.addAll(c);
        } else {
            this.delegate = new java.util.Stack();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    public void initialise() {
        this.delegate = new java.util.Stack();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        this.makeDirty();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.fieldNumber);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.Stack detached = new java.util.Stack();
        SCOUtils.detachCopyForCollection(this.ownerOP, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractMemberMetaData fmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        ArrayList attachedElements = new ArrayList(c.size());
        SCOUtils.attachCopyForCollection(this.ownerOP, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.updateListWithListElements(this, attachedElements);
    }

    public Object clone() {
        return this.delegate.clone();
    }

    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    public boolean empty() {
        return this.delegate.empty();
    }

    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    public Object get(int index) {
        return this.delegate.get(index);
    }

    public int indexOf(Object element) {
        return this.delegate.indexOf(element);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Iterator iterator() {
        return new SCOListIterator(this, this.ownerOP, this.delegate, null, true, -1);
    }

    public ListIterator listIterator() {
        return new SCOListIterator(this, this.ownerOP, this.delegate, null, true, -1);
    }

    public ListIterator listIterator(int index) {
        return new SCOListIterator(this, this.ownerOP, this.delegate, null, true, index);
    }

    public int lastIndexOf(Object element) {
        return this.delegate.lastIndexOf(element);
    }

    public Object peek() {
        return this.delegate.peek();
    }

    public int size() {
        return this.delegate.size();
    }

    public synchronized List subList(int from, int to) {
        return this.delegate.subList(from, to);
    }

    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public void add(int index, Object element) {
        this.delegate.add(index, element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.fieldNumber, element);
        }
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public boolean add(Object element) {
        boolean success = this.delegate.add(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.fieldNumber, element);
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public void addElement(Object element) {
        this.delegate.add(element);
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationAdd(this.fieldNumber, iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public boolean addAll(int index, Collection elements) {
        boolean success = this.delegate.addAll(index, elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationAdd(this.fieldNumber, iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized void clear() {
        AbstractMemberMetaData mmd;
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = this.delegate.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.fieldNumber, iter.next());
            }
        }
        if (this.ownerOP != null && !this.delegate.isEmpty() && SCOUtils.hasDependentElement(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            ArrayList copy = new ArrayList(this.delegate);
            Iterator iter = copy.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public Object pop() {
        Object obj = this.delegate.pop();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return obj;
    }

    public Object push(Object element) {
        Object obj = this.delegate.push(element);
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return obj;
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        AbstractMemberMetaData mmd;
        boolean success = this.delegate.remove(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationRemove(this.fieldNumber, element);
        }
        if (this.ownerOP != null && allowCascadeDelete && SCOUtils.hasDependentElement(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            this.ownerOP.getExecutionContext().deleteObjectInternal(element);
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public boolean removeAll(Collection elements) {
        AbstractMemberMetaData mmd;
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.fieldNumber, iter.next());
            }
        }
        if (this.ownerOP != null && elements != null && !elements.isEmpty() && SCOUtils.hasDependentElement(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public boolean removeElement(Object element) {
        return this.remove(element);
    }

    public Object remove(int index) {
        AbstractMemberMetaData mmd;
        Object element = this.delegate.remove(index);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationRemove(this.fieldNumber, element);
        }
        if (this.ownerOP != null && SCOUtils.hasDependentElement(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            this.ownerOP.getExecutionContext().deleteObjectInternal(element);
        }
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return element;
    }

    public void removeElementAt(int index) {
        this.remove(index);
    }

    public void removeAllElements() {
        this.clear();
    }

    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public Object set(int index, Object element, boolean allowDependentField) {
        AbstractMemberMetaData mmd;
        Object obj = this.delegate.set(index, element);
        if (this.ownerOP != null && allowDependentField && !this.delegate.contains(obj) && SCOUtils.hasDependentElement(mmd = this.ownerOP.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            this.ownerOP.getExecutionContext().deleteObjectInternal(obj);
        }
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return obj;
    }

    public Object set(int index, Object element) {
        return this.set(index, element, true);
    }

    public void setElementAt(Object element, int index) {
        this.delegate.setElementAt(element, index);
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        java.util.Stack stack = new java.util.Stack();
        stack.addAll(this.delegate);
        return stack;
    }
}

