/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Imports {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private HashMap primitives = new HashMap();
    private HashMap importedClassesByName = new HashMap();
    private HashSet importedPackageNames = new HashSet();

    public Imports() {
        this.primitives.put("boolean", Boolean.TYPE);
        this.primitives.put("byte", Byte.TYPE);
        this.primitives.put("char", Character.TYPE);
        this.primitives.put("short", Short.TYPE);
        this.primitives.put("int", Integer.TYPE);
        this.primitives.put("long", Long.TYPE);
        this.primitives.put("float", Float.TYPE);
        this.primitives.put("double", Double.TYPE);
        this.importedPackageNames.add("java.lang");
    }

    public void importPackage(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            this.importedPackageNames.add(className.substring(0, lastDot));
        }
    }

    public void importClass(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            this.importedClassesByName.put(className.substring(lastDot + 1), className);
        }
    }

    public void parseImports(String imports) {
        String importDecl;
        StringTokenizer t1 = new StringTokenizer(imports, ";");
        while (t1.hasMoreTokens() && ((importDecl = t1.nextToken().trim()).length() != 0 || t1.hasMoreTokens())) {
            int lastDot;
            StringTokenizer t2 = new StringTokenizer(importDecl, " ");
            if (t2.countTokens() != 2 || !t2.nextToken().equals("import")) {
                throw new NucleusUserException(LOCALISER.msg("021002", (Object)importDecl));
            }
            String importName = t2.nextToken();
            String lastPart = importName.substring((lastDot = importName.lastIndexOf(".")) + 1);
            if (lastPart.equals("*")) {
                if (lastDot < 1) {
                    throw new NucleusUserException(LOCALISER.msg("021003", (Object)importName));
                }
                this.importedPackageNames.add(importName.substring(0, lastDot));
                continue;
            }
            if (this.importedClassesByName.put(lastPart, importName) == null) continue;
            NucleusLogger.QUERY.info(LOCALISER.msg("021004", (Object)importName));
        }
    }

    public Class resolveClassDeclaration(String classDecl, ClassLoaderResolver clr, ClassLoader primaryClassLoader) {
        Class c;
        boolean isArray;
        boolean bl = isArray = classDecl.indexOf(91) >= 0;
        if (isArray) {
            classDecl = classDecl.substring(0, classDecl.indexOf(91));
        }
        if (classDecl.indexOf(46) < 0) {
            String cd;
            c = (Class)this.primitives.get(classDecl);
            if (c == null && (cd = (String)this.importedClassesByName.get(classDecl)) != null) {
                c = clr.classForName(cd, primaryClassLoader);
            }
            if (c == null) {
                for (String packageName : this.importedPackageNames) {
                    try {
                        Class c1 = clr.classForName(packageName + '.' + classDecl, primaryClassLoader);
                        if (c != null && c1 != null) {
                            throw new NucleusUserException(LOCALISER.msg("021008", (Object)c.getName(), (Object)c1.getName()));
                        }
                        c = c1;
                    }
                    catch (ClassNotResolvedException e) {}
                }
                if (c == null) {
                    throw new ClassNotResolvedException(classDecl);
                }
                if (NucleusLogger.GENERAL.isDebugEnabled()) {
                    NucleusLogger.GENERAL.debug(LOCALISER.msg("021010", (Object)classDecl, (Object)c.getName()));
                }
            }
        } else {
            c = clr.classForName(classDecl, primaryClassLoader);
        }
        if (isArray) {
            c = Array.newInstance(c, 0).getClass();
        }
        return c;
    }
}

