/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.NucleusEnhanceException;
import org.datanucleus.enhancer.jdo.JDOClassEnhancer;
import org.datanucleus.enhancer.jdo.JPAEnhancementNamer;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.CommandLine;
import org.datanucleus.util.JavaUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNucleusEnhancer {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassEnhancer.class.getClassLoader());
    public static final NucleusLogger LOGGER = NucleusLogger.getLoggerInstance("DataNucleus.Enhancer");
    private MetaDataManager metadataMgr;
    private ClassLoaderResolver clr;
    private String apiName = "JDO";
    private String enhancerVersion = null;
    private String outputDirectory = null;
    private boolean verbose = false;
    private boolean systemOut = false;
    private boolean generatePK = true;
    private boolean generateConstructor = true;
    private boolean detachListener = false;
    protected ClassLoader userClassLoader = null;
    private Collection<EnhanceComponent> componentsToEnhance = new ArrayList<EnhanceComponent>();
    private Map<String, byte[]> bytesForClassesToEnhanceByClassName = null;
    private Map<String, byte[]> enhancedBytesByClassName = null;
    private Map<String, byte[]> pkClassBytesByClassName = null;

    public DataNucleusEnhancer(String apiName, Properties props) {
        this.apiName = apiName;
        NucleusContext nucleusContext = new NucleusContext(apiName, NucleusContext.ContextType.ENHANCEMENT, props);
        if (props != null) {
            nucleusContext.getPersistenceConfiguration().setPersistenceProperties(props);
        }
        this.metadataMgr = nucleusContext.getMetaDataManager();
        this.clr = nucleusContext.getClassLoaderResolver(null);
        this.enhancerVersion = nucleusContext.getPluginManager().getVersionForBundle("org.datanucleus");
    }

    private void init() {
    }

    public MetaDataManager getMetaDataManager() {
        return this.metadataMgr;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public DataNucleusEnhancer setOutputDirectory(String dir) {
        this.resetEnhancement();
        this.outputDirectory = dir;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.userClassLoader;
    }

    public DataNucleusEnhancer setClassLoader(ClassLoader loader) {
        this.resetEnhancement();
        this.userClassLoader = loader;
        if (this.userClassLoader != null) {
            this.clr.registerUserClassLoader(this.userClassLoader);
        }
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public DataNucleusEnhancer setVerbose(boolean verbose) {
        this.resetEnhancement();
        this.verbose = verbose;
        return this;
    }

    public DataNucleusEnhancer setSystemOut(boolean sysout) {
        this.resetEnhancement();
        this.systemOut = sysout;
        return this;
    }

    public DataNucleusEnhancer setGeneratePK(boolean flag) {
        this.resetEnhancement();
        this.generatePK = flag;
        return this;
    }

    public DataNucleusEnhancer setGenerateConstructor(boolean flag) {
        this.resetEnhancement();
        this.generateConstructor = flag;
        return this;
    }

    public DataNucleusEnhancer setDetachListener(boolean flag) {
        this.resetEnhancement();
        this.detachListener = flag;
        return this;
    }

    public DataNucleusEnhancer addClass(String className, byte[] bytes) {
        this.init();
        if (className == null) {
            return this;
        }
        if (this.bytesForClassesToEnhanceByClassName == null) {
            this.bytesForClassesToEnhanceByClassName = new HashMap<String, byte[]>();
        }
        this.bytesForClassesToEnhanceByClassName.put(className, bytes);
        this.componentsToEnhance.add(new EnhanceComponent(0, className));
        return this;
    }

    public DataNucleusEnhancer addClasses(String ... classNames) {
        this.init();
        if (classNames == null) {
            return this;
        }
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < classNames.length; ++i) {
            if (classNames[i].endsWith(".class")) {
                String name = classNames[i];
                String msg = null;
                if (!StringUtils.getFileForFilename(classNames[i]).exists()) {
                    msg = LOCALISER.msg("Enhancer.InputFiles.Invalid", (Object)classNames[i]);
                    this.addMessage(msg, true);
                    name = null;
                } else {
                    name = JDOClassEnhancer.getClassNameForFileName(classNames[i]);
                }
                if (name == null) continue;
                names.add(name);
                continue;
            }
            try {
                this.clr.classForName(classNames[i], false);
            }
            catch (ClassNotResolvedException cnre) {
                this.addMessage("Class " + classNames[i] + " not found in CLASSPATH! : " + cnre.getMessage(), true);
            }
            names.add(classNames[i]);
        }
        if (names.size() > 0) {
            this.componentsToEnhance.add(new EnhanceComponent(0, names.toArray(new String[names.size()])));
        }
        return this;
    }

    public DataNucleusEnhancer addFiles(String ... filenames) {
        this.init();
        if (filenames == null) {
            return this;
        }
        ArrayList<String> classFiles = new ArrayList<String>();
        ArrayList<String> mappingFiles = new ArrayList<String>();
        HashSet<String> jarFiles = new HashSet<String>();
        for (int i = 0; i < filenames.length; ++i) {
            if (filenames[i].endsWith(".class")) {
                classFiles.add(filenames[i]);
                continue;
            }
            if (filenames[i].endsWith(".jar")) {
                jarFiles.add(filenames[i]);
                continue;
            }
            mappingFiles.add(filenames[i]);
        }
        if (mappingFiles.size() > 0) {
            this.componentsToEnhance.add(new EnhanceComponent(2, mappingFiles.toArray(new String[mappingFiles.size()])));
        }
        if (jarFiles.size() > 0) {
            this.componentsToEnhance.add(new EnhanceComponent(3, jarFiles.toArray(new String[jarFiles.size()])));
        }
        if (classFiles.size() > 0) {
            this.componentsToEnhance.add(new EnhanceComponent(1, classFiles.toArray(new String[classFiles.size()])));
        }
        return this;
    }

    public DataNucleusEnhancer addJar(String jarFileName) {
        this.init();
        if (jarFileName == null) {
            return this;
        }
        this.componentsToEnhance.add(new EnhanceComponent(3, jarFileName));
        return this;
    }

    public DataNucleusEnhancer addPersistenceUnit(String persistenceUnitName) {
        this.init();
        if (persistenceUnitName == null) {
            return this;
        }
        this.componentsToEnhance.add(new EnhanceComponent(4, persistenceUnitName));
        return this;
    }

    public int enhance() {
        this.init();
        if (this.componentsToEnhance.isEmpty()) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        Collection<FileMetaData> fileMetaData = this.getFileMetadataForInput();
        long inputTime = System.currentTimeMillis();
        HashSet<String> classNames = new HashSet<String>();
        Iterator<FileMetaData> filemdIter = fileMetaData.iterator();
        boolean success = true;
        while (filemdIter.hasNext()) {
            FileMetaData filemd = filemdIter.next();
            for (int packagenum = 0; packagenum < filemd.getNoOfPackages(); ++packagenum) {
                PackageMetaData pmd = filemd.getPackage(packagenum);
                for (int classnum = 0; classnum < pmd.getNoOfClasses(); ++classnum) {
                    ClassMetaData cmd = pmd.getClass(classnum);
                    if (classNames.contains(cmd.getFullClassName())) continue;
                    classNames.add(cmd.getFullClassName());
                    byte[] bytes = this.bytesForClassesToEnhanceByClassName != null ? this.bytesForClassesToEnhanceByClassName.get(cmd.getFullClassName()) : null;
                    ClassEnhancer classEnhancer = this.getClassEnhancer(cmd, bytes);
                    boolean clsSuccess = this.enhanceClass(cmd, classEnhancer, bytes == null);
                    if (clsSuccess) continue;
                    success = false;
                }
            }
        }
        if (!success) {
            throw new NucleusException("Failure during enhancement of classes - see the log for details");
        }
        long enhanceTime = System.currentTimeMillis();
        String msg = LOCALISER.msg("Enhancer.Success", classNames.size(), (Object)("" + (inputTime - startTime)), (Object)("" + (enhanceTime - inputTime)), (Object)("" + (enhanceTime - startTime)));
        this.addMessage(msg, false);
        if (this.bytesForClassesToEnhanceByClassName != null) {
            this.bytesForClassesToEnhanceByClassName.clear();
            this.bytesForClassesToEnhanceByClassName = null;
        }
        this.componentsToEnhance.clear();
        return classNames.size();
    }

    public int validate() {
        this.init();
        if (this.componentsToEnhance.isEmpty()) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        Collection<FileMetaData> fileMetaData = this.getFileMetadataForInput();
        long inputTime = System.currentTimeMillis();
        HashSet<String> classNames = new HashSet<String>();
        for (FileMetaData filemd : fileMetaData) {
            for (int packagenum = 0; packagenum < filemd.getNoOfPackages(); ++packagenum) {
                PackageMetaData pmd = filemd.getPackage(packagenum);
                for (int classnum = 0; classnum < pmd.getNoOfClasses(); ++classnum) {
                    ClassMetaData cmd = pmd.getClass(classnum);
                    if (classNames.contains(cmd.getFullClassName())) continue;
                    classNames.add(cmd.getFullClassName());
                    byte[] bytes = this.bytesForClassesToEnhanceByClassName != null ? this.bytesForClassesToEnhanceByClassName.get(cmd.getFullClassName()) : null;
                    ClassEnhancer classEnhancer = this.getClassEnhancer(cmd, bytes);
                    this.validateClass(cmd, classEnhancer);
                }
            }
        }
        long enhanceTime = System.currentTimeMillis();
        String msg = LOCALISER.msg("Enhancer.Success", classNames.size(), (Object)("" + (inputTime - startTime)), (Object)("" + (enhanceTime - inputTime)), (Object)("" + (enhanceTime - startTime)));
        this.addMessage(msg, false);
        if (this.bytesForClassesToEnhanceByClassName != null) {
            this.bytesForClassesToEnhanceByClassName.clear();
            this.bytesForClassesToEnhanceByClassName = null;
        }
        this.componentsToEnhance.clear();
        return classNames.size();
    }

    protected Collection<FileMetaData> getFileMetadataForInput() {
        Iterator<EnhanceComponent> iter = this.componentsToEnhance.iterator();
        ArrayList<FileMetaData> fileMetaData = new ArrayList<FileMetaData>();
        while (iter.hasNext()) {
            EnhanceComponent comp = iter.next();
            FileMetaData[] filemds = null;
            switch (comp.getType()) {
                case 0: {
                    if (comp.getValue() instanceof String) {
                        String className = (String)comp.getValue();
                        if (this.bytesForClassesToEnhanceByClassName != null && this.bytesForClassesToEnhanceByClassName.get(className) != null) {
                            AbstractClassMetaData cmd = this.metadataMgr.getMetaDataForClass(className, this.clr);
                            if (cmd == null) break;
                            filemds = new FileMetaData[]{cmd.getPackageMetaData().getFileMetaData()};
                            break;
                        }
                        filemds = this.metadataMgr.loadClasses(new String[]{(String)comp.getValue()}, this.userClassLoader);
                        break;
                    }
                    filemds = this.metadataMgr.loadClasses((String[])comp.getValue(), this.userClassLoader);
                    break;
                }
                case 1: {
                    if (comp.getValue() instanceof String) {
                        String className = null;
                        String classFilename = (String)comp.getValue();
                        if (!StringUtils.getFileForFilename(classFilename).exists()) {
                            String msg = LOCALISER.msg("Enhancer.InputFiles.Invalid", (Object)classFilename);
                            this.addMessage(msg, true);
                        } else {
                            className = JDOClassEnhancer.getClassNameForFileName(classFilename);
                        }
                        if (className == null) break;
                        filemds = this.metadataMgr.loadClasses(new String[]{className}, this.userClassLoader);
                        break;
                    }
                    ArrayList<String> classNames = new ArrayList<String>();
                    String[] classFilenames = (String[])comp.getValue();
                    for (int i = 0; i < classFilenames.length; ++i) {
                        String className = null;
                        if (!StringUtils.getFileForFilename(classFilenames[i]).exists()) {
                            String msg = LOCALISER.msg("Enhancer.InputFiles.Invalid", (Object)classFilenames[i]);
                            this.addMessage(msg, true);
                        } else {
                            className = JDOClassEnhancer.getClassNameForFileName(classFilenames[i]);
                        }
                        if (className == null) continue;
                        classNames.add(className);
                    }
                    filemds = this.metadataMgr.loadClasses(classNames.toArray(new String[classNames.size()]), this.userClassLoader);
                    break;
                }
                case 2: {
                    if (comp.getValue() instanceof String) {
                        filemds = this.metadataMgr.loadMetadataFiles(new String[]{(String)comp.getValue()}, this.userClassLoader);
                        break;
                    }
                    filemds = this.metadataMgr.loadMetadataFiles((String[])comp.getValue(), this.userClassLoader);
                    break;
                }
                case 3: {
                    if (comp.getValue() instanceof String) {
                        filemds = this.metadataMgr.loadJar((String)comp.getValue(), this.userClassLoader);
                        break;
                    }
                    String[] jarFilenames = (String[])comp.getValue();
                    HashSet<FileMetaData> filemdsColl = new HashSet<FileMetaData>();
                    for (int i = 0; i < jarFilenames.length; ++i) {
                        FileMetaData[] fmds = this.metadataMgr.loadJar(jarFilenames[i], this.userClassLoader);
                        for (int j = 0; j < fmds.length; ++j) {
                            filemdsColl.add(fmds[j]);
                        }
                    }
                    filemds = filemdsColl.toArray(new FileMetaData[filemdsColl.size()]);
                    break;
                }
                case 4: {
                    PersistenceUnitMetaData pumd = null;
                    try {
                        pumd = this.metadataMgr.getMetaDataForPersistenceUnit((String)comp.getValue());
                    }
                    catch (NucleusException ne) {
                        throw new NucleusEnhanceException(LOCALISER.msg("Enhancer.PersistenceUnit.NoPersistenceFiles", comp.getValue()));
                    }
                    if (pumd == null) {
                        throw new NucleusEnhanceException(LOCALISER.msg("Enhancer.PersistenceUnit.NoSuchUnit", comp.getValue()));
                    }
                    filemds = this.metadataMgr.loadPersistenceUnit(pumd, this.userClassLoader);
                    break;
                }
            }
            if (filemds == null) continue;
            for (int i = 0; i < filemds.length; ++i) {
                fileMetaData.add((FileMetaData)filemds[i]);
            }
        }
        return fileMetaData;
    }

    public byte[] getEnhancedBytes(String className) {
        byte[] bytes;
        if (this.enhancedBytesByClassName != null && (bytes = this.enhancedBytesByClassName.get(className)) != null) {
            return bytes;
        }
        throw new NucleusException("No enhanced bytes available for " + className);
    }

    public byte[] getPkClassBytes(String className) {
        byte[] bytes;
        if (this.pkClassBytesByClassName != null && (bytes = this.pkClassBytesByClassName.get(className)) != null) {
            return bytes;
        }
        throw new NucleusException("No pk class bytes available for " + className);
    }

    protected void resetEnhancement() {
        if (this.enhancedBytesByClassName != null) {
            this.enhancedBytesByClassName.clear();
            this.enhancedBytesByClassName = null;
        }
        if (this.pkClassBytesByClassName != null) {
            this.pkClassBytesByClassName.clear();
            this.pkClassBytesByClassName = null;
        }
    }

    protected ClassEnhancer getClassEnhancer(ClassMetaData cmd, byte[] bytes) {
        JDOClassEnhancer classEnhancer = null;
        classEnhancer = bytes != null ? new JDOClassEnhancer(cmd, this.clr, this.metadataMgr, bytes) : new JDOClassEnhancer(cmd, this.clr, this.metadataMgr);
        if (this.apiName.equalsIgnoreCase("jpa")) {
            classEnhancer.setNamer(JPAEnhancementNamer.getInstance());
        }
        HashSet<String> options = new HashSet<String>();
        if (this.generatePK) {
            options.add("generate-primary-key");
        }
        if (this.generateConstructor) {
            options.add("generate-default-constructor");
        }
        if (this.detachListener) {
            options.add("generate-detach-listener");
        }
        classEnhancer.setOptions(options);
        return classEnhancer;
    }

    protected void addMessage(String msg, boolean error) {
        if (error) {
            LOGGER.error(msg);
        } else {
            LOGGER.info(msg);
        }
        if (this.systemOut) {
            System.out.println(msg);
        }
    }

    protected boolean enhanceClass(ClassMetaData cmd, ClassEnhancer enhancer, boolean store) {
        boolean success = true;
        try {
            boolean enhanced;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(LOCALISER.msg("Enhancer.EnhanceClassStart", (Object)cmd.getFullClassName()));
            }
            if (enhanced = enhancer.enhance()) {
                if (this.enhancedBytesByClassName == null) {
                    this.enhancedBytesByClassName = new HashMap<String, byte[]>();
                }
                this.enhancedBytesByClassName.put(cmd.getFullClassName(), enhancer.getClassBytes());
                byte[] pkClassBytes = enhancer.getPrimaryKeyClassBytes();
                if (pkClassBytes != null) {
                    if (this.pkClassBytesByClassName == null) {
                        this.pkClassBytesByClassName = new HashMap<String, byte[]>();
                    }
                    this.pkClassBytesByClassName.put(cmd.getFullClassName(), pkClassBytes);
                }
                if (store) {
                    enhancer.save(this.outputDirectory);
                }
                if (this.isVerbose()) {
                    if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                        this.addMessage("ENHANCED (PersistenceCapable) : " + cmd.getFullClassName(), false);
                    } else if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                        this.addMessage("ENHANCED (PersistenceAware) : " + cmd.getFullClassName(), false);
                    } else {
                        this.addMessage("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName(), false);
                    }
                }
            } else {
                if (this.isVerbose()) {
                    if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                        this.addMessage("ERROR (PersistenceCapable) : " + cmd.getFullClassName(), false);
                    } else if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                        this.addMessage("ERROR (PersistenceAware) : " + cmd.getFullClassName(), false);
                    } else {
                        this.addMessage("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName(), false);
                    }
                }
                if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                    success = false;
                }
            }
        }
        catch (IOException ioe) {
            if (this.isVerbose()) {
                this.addMessage("ERROR (NonPersistent) : " + cmd.getFullClassName(), false);
            }
            String msg = LOCALISER.msg("Enhancer.ErrorEnhancingClass", (Object)cmd.getFullClassName(), (Object)ioe.getMessage());
            LOGGER.error(msg, ioe);
            System.out.println(msg);
            success = false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LOCALISER.msg("Enhancer.EnhanceClassEnd", (Object)cmd.getFullClassName()));
        }
        return success;
    }

    protected boolean validateClass(ClassMetaData cmd, ClassEnhancer enhancer) {
        boolean enhanced;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LOCALISER.msg("Enhancer.ValidateClassStart", (Object)cmd.getFullClassName()));
        }
        if (enhanced = enhancer.validate()) {
            if (this.isVerbose()) {
                if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                    this.addMessage("ENHANCED (PersistenceCapable) : " + cmd.getFullClassName(), false);
                } else if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                    this.addMessage("ENHANCED (PersistenceAware) : " + cmd.getFullClassName(), false);
                } else {
                    this.addMessage("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName(), false);
                }
            }
        } else if (this.isVerbose()) {
            if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                this.addMessage("NOT ENHANCED (PersistenceCapable) : " + cmd.getFullClassName(), false);
            } else if (cmd.getPersistenceModifier() == ClassPersistenceModifier.PERSISTENCE_AWARE) {
                this.addMessage("NOT ENHANCED (PersistenceAware) : " + cmd.getFullClassName(), false);
            } else {
                this.addMessage("NOT ENHANCED (NonPersistent) : " + cmd.getFullClassName(), false);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(LOCALISER.msg("Enhancer.ValidateClassEnd", (Object)cmd.getFullClassName()));
        }
        return true;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("VendorName", "DataNucleus");
        props.setProperty("VersionNumber", this.enhancerVersion);
        props.setProperty("API", this.apiName);
        return props;
    }

    public static void main(String[] args) throws Exception {
        String val;
        CommandLine cl = new CommandLine();
        cl.addOption("pu", "persistenceUnit", "<name-of-persistence-unit>", "name of the persistence unit to enhance");
        cl.addOption("dir", "directory", "<name-of-directory>", "name of the directory containing things to enhance");
        cl.addOption("d", "dest", "<directory>", "output directory");
        cl.addOption("checkonly", "checkonly", null, "only check if the class is enhanced");
        cl.addOption("q", "quiet", null, "no output");
        cl.addOption("v", "verbose", null, "verbose output");
        cl.addOption("api", "api", "<api-name>", "API Name (JDO, JPA, etc)");
        cl.addOption("alwaysDetachable", "alwaysDetachable", null, "Always detachable?");
        cl.addOption("generatePK", "generatePK", "<generate-pk>", "Generate PK class where needed?");
        cl.addOption("generateConstructor", "generateConstructor", "<generate-constructor>", "Generate default constructor where needed?");
        cl.addOption("detachListener", "detachListener", "<detach-listener>", "Use Detach Listener?");
        cl.parse(args);
        String apiName = cl.hasOption("api") ? cl.getOptionArg("api") : "JDO";
        Properties props = new Properties();
        props.setProperty("datanucleus.plugin.allowUserBundles", "true");
        if (cl.hasOption("alwaysDetachable")) {
            props.setProperty("datanucleus.metadata.alwaysDetachable", "true");
        }
        DataNucleusEnhancer enhancer = new DataNucleusEnhancer(apiName, props);
        boolean quiet = false;
        if (cl.hasOption("q")) {
            quiet = true;
        } else if (cl.hasOption("v")) {
            enhancer.setVerbose(true);
        }
        if (!quiet) {
            enhancer.setSystemOut(true);
        }
        String msg = LOCALISER.msg("Enhancer.ClassEnhancer", (Object)enhancer.enhancerVersion, (Object)apiName, (Object)(JavaUtils.getJREMajorVersion() + "." + JavaUtils.getJREMinorVersion()));
        LOGGER.info(msg);
        if (!quiet) {
            System.out.println(msg);
        }
        if (cl.hasOption("d")) {
            String destination = cl.getOptionArg("d");
            File tmp = new File(destination);
            if (tmp.exists()) {
                if (!tmp.isDirectory()) {
                    System.out.println(destination + " is not directory. please set directory.");
                    System.exit(1);
                }
            } else {
                tmp.mkdirs();
            }
            enhancer.setOutputDirectory(destination);
        }
        if (cl.hasOption("generateConstructor") && (val = cl.getOptionArg("generateConstructor")).equalsIgnoreCase("false")) {
            enhancer.setGenerateConstructor(false);
        }
        if (cl.hasOption("generatePK") && (val = cl.getOptionArg("generatePK")).equalsIgnoreCase("false")) {
            enhancer.setGeneratePK(false);
        }
        if (cl.hasOption("detachListener") && (val = cl.getOptionArg("detachListener")).equalsIgnoreCase("true")) {
            enhancer.setDetachListener(true);
        }
        boolean validating = cl.hasOption("checkonly");
        LOGGER.debug(LOCALISER.msg("Enhancer.Classpath"));
        if (enhancer.isVerbose()) {
            System.out.println(LOCALISER.msg("Enhancer.Classpath"));
        }
        StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokeniser.hasMoreTokens()) {
            String entry = LOCALISER.msg("Enhancer.Classpath.Entry", (Object)tokeniser.nextToken());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(entry);
            }
            if (!enhancer.isVerbose()) continue;
            System.out.println(entry);
        }
        if (enhancer.isVerbose()) {
            System.out.flush();
        }
        String persistenceUnitName = cl.hasOption("pu") ? cl.getOptionArg("pu") : null;
        String directoryName = cl.hasOption("dir") ? cl.getOptionArg("dir") : null;
        String[] filenames = cl.getDefaultArgs();
        int numClasses = 0;
        try {
            if (persistenceUnitName != null) {
                enhancer.addPersistenceUnit(persistenceUnitName);
            } else if (directoryName != null) {
                File dir = new File(directoryName);
                if (!dir.exists()) {
                    System.out.println(directoryName + " is not a directory. please set this as a directory");
                    System.exit(1);
                }
                Collection<File> files = ClassUtils.getFilesForDirectory(dir);
                int i = 0;
                String[] fileNames = new String[files.size()];
                for (File file : files) {
                    fileNames[i++] = file.getPath();
                }
                enhancer.addFiles(fileNames);
            } else {
                enhancer.addFiles(filenames);
            }
            numClasses = validating ? enhancer.validate() : enhancer.enhance();
        }
        catch (NucleusException jpe) {
            System.out.println(jpe.getMessage());
            msg = LOCALISER.msg("Enhancer.Failure");
            LOGGER.error(msg, jpe);
            if (!quiet) {
                System.out.println(msg);
            }
            System.exit(1);
        }
        if (numClasses == 0) {
            msg = LOCALISER.msg("Enhancer.NoClassesEnhanced");
            LOGGER.info(msg);
            if (!quiet) {
                System.out.println(msg);
            }
        }
    }

    static class EnhanceComponent {
        public static final int CLASS = 0;
        public static final int CLASS_FILE = 1;
        public static final int MAPPING_FILE = 2;
        public static final int JAR_FILE = 3;
        public static final int PERSISTENCE_UNIT = 4;
        int type;
        Object value;

        public EnhanceComponent(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }
    }
}

