/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.FlushProcess;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlushOrdered
implements FlushProcess {
    ExecutionContextImpl ec;

    public FlushOrdered(ExecutionContextImpl ec) {
        this.ec = ec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NucleusOptimisticException> execute(List<ObjectProvider> dirtyOPs, List<ObjectProvider> indirectDirtyOPs) {
        int i;
        Object[] toFlushIndirect;
        Object[] toFlushDirect;
        ArrayList<NucleusOptimisticException> optimisticFailures = null;
        try {
            if (this.ec.getMultithreaded()) {
                this.ec.getLock().lock();
            }
            toFlushDirect = dirtyOPs.toArray();
            dirtyOPs.clear();
            toFlushIndirect = indirectDirtyOPs.toArray();
            indirectDirtyOPs.clear();
        }
        finally {
            if (this.ec.getMultithreaded()) {
                this.ec.getLock().unlock();
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010003", dirtyOPs.size() + indirectDirtyOPs.size()));
        }
        HashSet classesToFlush = null;
        if (this.ec.getNucleusContext().getStoreManager().getQueryManager().getQueryResultsCache() != null) {
            classesToFlush = new HashSet();
        }
        for (i = 0; i < toFlushDirect.length; ++i) {
            ObjectProvider objectProvider = (ObjectProvider)toFlushDirect[i];
            try {
                objectProvider.flush();
                if (classesToFlush == null) continue;
                classesToFlush.add(objectProvider.getObject().getClass());
                continue;
            }
            catch (NucleusOptimisticException oe) {
                if (optimisticFailures == null) {
                    optimisticFailures = new ArrayList<NucleusOptimisticException>();
                }
                optimisticFailures.add(oe);
            }
        }
        for (i = 0; i < toFlushIndirect.length; ++i) {
            ObjectProvider objectProvider = (ObjectProvider)toFlushIndirect[i];
            try {
                objectProvider.flush();
                if (classesToFlush == null) continue;
                classesToFlush.add(objectProvider.getObject().getClass());
                continue;
            }
            catch (NucleusOptimisticException oe) {
                if (optimisticFailures == null) {
                    optimisticFailures = new ArrayList();
                }
                optimisticFailures.add(oe);
            }
        }
        if (classesToFlush != null) {
            for (Class clazz : classesToFlush) {
                this.ec.getNucleusContext().getStoreManager().getQueryManager().evictQueryResultsForType(clazz);
            }
        }
        return optimisticFailures;
    }
}

