/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;

public class DeleteFieldManager
extends AbstractFieldManager {
    private final ObjectProvider op;
    private boolean nullBidirIfNotDependent = false;

    public DeleteFieldManager(ObjectProvider op) {
        this(op, false);
    }

    public DeleteFieldManager(ObjectProvider op, boolean nullBidirIfNotDependent) {
        this.op = op;
        this.nullBidirIfNotDependent = nullBidirIfNotDependent;
    }

    protected void processPersistable(Object pc) {
        ObjectProvider pcSM = this.op.getExecutionContext().findObjectProvider(pc);
        if (pcSM != null && (pcSM.isDeleting() || pcSM.becomingDeleted())) {
            return;
        }
        this.op.getExecutionContext().deleteObjectInternal(pc);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        block8: {
            ApiAdapter api;
            AbstractMemberMetaData mmd;
            block13: {
                block11: {
                    RelationType relationType;
                    ExecutionContext ec;
                    block12: {
                        block9: {
                            ObjectProvider valueOP;
                            block10: {
                                if (value == null) break block8;
                                mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                                ec = this.op.getExecutionContext();
                                relationType = mmd.getRelationType(ec.getClassLoaderResolver());
                                api = ec.getApiAdapter();
                                if (!api.isPersistable(value)) break block9;
                                if (!mmd.isDependent()) break block10;
                                this.processPersistable(value);
                                break block8;
                            }
                            if (!this.nullBidirIfNotDependent || !RelationType.isBidirectional(relationType) || mmd.isEmbedded() || (valueOP = ec.findObjectProvider(value)) == null || valueOP.getLifecycleState().isDeleted() || valueOP.isDeleting()) break block8;
                            AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(ec.getClassLoaderResolver())[0];
                            valueOP.replaceFieldMakeDirty(relMmd.getAbsoluteFieldNumber(), null);
                            valueOP.flush();
                            break block8;
                        }
                        if (!(value instanceof Collection)) break block11;
                        boolean dependent = mmd.getCollection().isDependentElement();
                        if (mmd.isCascadeRemoveOrphans()) {
                            dependent = true;
                        }
                        if (!dependent) break block12;
                        Collection coll = (Collection)value;
                        for (Object element : coll) {
                            if (!api.isPersistable(element)) continue;
                            this.processPersistable(element);
                        }
                        break block8;
                    }
                    if (!this.nullBidirIfNotDependent || !RelationType.isBidirectional(relationType) || mmd.isEmbedded() || mmd.getCollection().isEmbeddedElement() || relationType != RelationType.ONE_TO_MANY_BI) break block8;
                    Collection coll = (Collection)value;
                    for (Object element : coll) {
                        ObjectProvider elementOP;
                        if (!api.isPersistable(element) || (elementOP = ec.findObjectProvider(element)) == null || elementOP.getLifecycleState().isDeleted() || elementOP.isDeleting()) continue;
                        AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(ec.getClassLoaderResolver())[0];
                        elementOP.replaceFieldMakeDirty(relMmd.getAbsoluteFieldNumber(), null);
                        elementOP.flush();
                    }
                    break block8;
                }
                if (!(value instanceof Map)) break block13;
                Map map = (Map)value;
                if (mmd.hasMap() && mmd.getMap().isDependentKey()) {
                    Set keys = map.keySet();
                    for (Object mapKey : keys) {
                        if (!api.isPersistable(mapKey)) continue;
                        this.processPersistable(mapKey);
                    }
                }
                if (!mmd.hasMap() || !mmd.getMap().isDependentValue()) break block8;
                Collection values = map.values();
                for (Object mapValue : values) {
                    if (!api.isPersistable(mapValue)) continue;
                    this.processPersistable(mapValue);
                }
                break block8;
            }
            if (value instanceof Object[] && mmd.hasArray() && mmd.getArray().isDependentElement()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    if (!api.isPersistable(element)) continue;
                    this.processPersistable(element);
                }
            }
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeStringField(int fieldNumber, String value) {
    }
}

