/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.jdo;

import org.datanucleus.asm.ClassVisitor;
import org.datanucleus.asm.MethodVisitor;
import org.datanucleus.asm.Type;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.ClassMethod;
import org.datanucleus.enhancer.jdo.JDOClassEnhancer;

public abstract class JDOClassMethod
extends ClassMethod {
    protected MethodVisitor visitor;

    public JDOClassMethod(ClassEnhancer enhancer, String name, int access, Object returnType, Object[] argTypes, String[] argNames) {
        super(enhancer, name, access, returnType, argTypes, argNames);
    }

    public JDOClassMethod(ClassEnhancer enhancer, String name, int access, Object returnType, Object[] argTypes, String[] argNames, String[] exceptions) {
        super(enhancer, name, access, returnType, argTypes, argNames, exceptions);
    }

    protected JDOClassEnhancer getClassEnhancer() {
        return (JDOClassEnhancer)this.enhancer;
    }

    public void initialise() {
    }

    public void initialise(ClassVisitor classVisitor) {
        Type type = null;
        Type[] argtypes = null;
        type = this.returnType != null ? Type.getType((Class)this.returnType) : Type.VOID_TYPE;
        if (this.argTypes != null) {
            argtypes = new Type[this.argTypes.length];
            for (int i = 0; i < this.argTypes.length; ++i) {
                argtypes[i] = Type.getType((Class)this.argTypes[i]);
            }
        } else {
            argtypes = new Type[]{};
        }
        String methodDesc = Type.getMethodDescriptor(type, argtypes);
        this.visitor = classVisitor.visitMethod(this.access, this.methodName, methodDesc, null, this.exceptions);
    }

    public String getDescriptor() {
        StringBuffer str = new StringBuffer("(");
        if (this.argTypes != null && this.argTypes.length > 0) {
            for (int i = 0; i < this.argTypes.length; ++i) {
                str.append(Type.getDescriptor((Class)this.argTypes[i]));
            }
        }
        str.append(")");
        if (this.returnType != null) {
            str.append(Type.getDescriptor((Class)this.returnType));
        } else {
            str.append("V");
        }
        return str.toString();
    }
}

