/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.queued;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassConstants;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.queued.AddOperation;
import org.datanucleus.store.types.queued.QueuedOperation;
import org.datanucleus.store.types.queued.RemoveCollectionOperation;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationQueue<TStore extends Store> {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private List<QueuedOperation> queuedOperations = new ArrayList<QueuedOperation>();

    public void enqueue(QueuedOperation oper) {
        this.queuedOperations.add(oper);
    }

    public void performAll(TStore store, ObjectProvider op, String fieldName) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023005", (Object)op.getObjectAsPrintable(), (Object)fieldName));
        }
        List<QueuedOperation> flushOperations = this.queuedOperations;
        this.queuedOperations = new ArrayList<QueuedOperation>();
        ListIterator<QueuedOperation> operIter = flushOperations.listIterator();
        while (operIter.hasNext()) {
            Object value;
            QueuedOperation oper = operIter.next();
            if (AddOperation.class.isInstance(oper)) {
                if (operIter.hasNext()) {
                    QueuedOperation operNext = operIter.next();
                    boolean addThenRemove = false;
                    if (RemoveCollectionOperation.class.isInstance(operNext) && (value = ((AddOperation)AddOperation.class.cast(oper)).getValue()) == ((RemoveCollectionOperation)RemoveCollectionOperation.class.cast(operNext)).getValue()) {
                        addThenRemove = true;
                        NucleusLogger.PERSISTENCE.info("Field " + fieldName + " of " + StringUtils.toJVMIDString(op.getObject()) + " had an add then a remove of element " + StringUtils.toJVMIDString(value) + " - operations ignored");
                    }
                    if (addThenRemove) continue;
                    operIter.previous();
                    oper.perform();
                    continue;
                }
                oper.perform();
                continue;
            }
            if (RemoveCollectionOperation.class.isInstance(oper)) {
                if (operIter.hasNext()) {
                    QueuedOperation opNext = operIter.next();
                    boolean removeThenAdd = false;
                    if (AddOperation.class.isInstance(opNext) && (value = ((RemoveCollectionOperation)RemoveCollectionOperation.class.cast(oper)).getValue()) == ((AddOperation)AddOperation.class.cast(opNext)).getValue()) {
                        removeThenAdd = true;
                        NucleusLogger.PERSISTENCE.info("Field " + fieldName + " of " + StringUtils.toJVMIDString(op.getObject()) + " had a remove then add of element " + StringUtils.toJVMIDString(value) + " - operations ignored");
                    }
                    if (removeThenAdd) continue;
                    operIter.previous();
                    oper.perform();
                    continue;
                }
                oper.perform();
                continue;
            }
            oper.perform();
        }
        if (!this.queuedOperations.isEmpty()) {
            this.queuedOperations.clear();
        }
    }
}

