/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.mapping.AppIDObjectIdFieldManager;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.MultiMapping;
import org.datanucleus.store.scostore.PersistableRelationStore;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class PersistableMapping
extends MultiMapping
implements MappingCallbacks {
    protected AbstractClassMetaData cmd;

    public Class getJavaType() {
        return null;
    }

    public void initialize(AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(mmd, container, clr);
        this.prepareDatastoreMapping(clr);
    }

    protected void prepareDatastoreMapping(ClassLoaderResolver clr) {
        if (this.roleForMember != 3 && this.roleForMember != 4 && this.roleForMember != 5 && this.roleForMember != 6) {
            AbstractClassMetaData refCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(this.mmd.getType(), clr);
            JavaTypeMapping referenceMapping = null;
            if (refCmd == null) {
                throw new NucleusUserException("You have a field " + this.mmd.getFullFieldName() + " that has type " + this.mmd.getTypeName() + " but this type has no known metadata. Your mapping is incorrect");
            }
            if (refCmd.getInheritanceMetaData() != null && refCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                AbstractClassMetaData[] cmds = this.storeMgr.getClassesManagingTableForClass(refCmd, clr);
                if (cmds != null && cmds.length > 0) {
                    if (cmds.length > 1) {
                        NucleusLogger.PERSISTENCE.warn("Field " + this.mmd.getFullFieldName() + " represents either a 1-1 relation, " + "or a N-1 relation where the other end uses \"subclass-table\" inheritance strategy and more " + "than 1 subclasses with a table. This is not fully supported");
                    }
                } else {
                    return;
                }
                referenceMapping = this.storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIdMapping();
            } else {
                referenceMapping = this.storeMgr.getDatastoreClass(this.mmd.getType().getName(), clr).getIdMapping();
            }
            CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper(this.mmd, referenceMapping, true);
            RelationType relationType = this.mmd.getRelationType(clr);
            boolean createDatastoreMappings = true;
            if (relationType == RelationType.MANY_TO_ONE_BI) {
                AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
                createDatastoreMappings = relatedMmds[0].getJoinMetaData() == null;
            } else if (relationType == RelationType.ONE_TO_ONE_BI) {
                boolean bl = createDatastoreMappings = this.mmd.getMappedBy() == null;
            }
            if (relationType == RelationType.MANY_TO_ONE_UNI) {
                this.storeMgr.newJoinDatastoreContainerObject(this.mmd, clr);
            } else {
                for (int i = 0; i < referenceMapping.getNumberOfDatastoreMappings(); ++i) {
                    DatastoreMapping refDatastoreMapping = referenceMapping.getDatastoreMapping(i);
                    JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType());
                    this.addJavaTypeMapping(mapping);
                    if (createDatastoreMappings) {
                        ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(refDatastoreMapping.getDatastoreField().getIdentifier());
                        if (colmd == null) {
                            throw new NucleusUserException(LOCALISER.msg("041038", refDatastoreMapping.getDatastoreField().getIdentifier(), (Object)this.toString())).setFatal();
                        }
                        MappingManager mmgr = this.storeMgr.getMappingManager();
                        DatastoreField col = mmgr.createDatastoreField(this.mmd, this.datastoreContainer, mapping, colmd, refDatastoreMapping.getDatastoreField(), clr);
                        DatastoreMapping datastoreMapping = mmgr.createDatastoreMapping(mapping, col, refDatastoreMapping.getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                        this.addDatastoreMapping(datastoreMapping);
                        continue;
                    }
                    mapping.setReferenceMapping(referenceMapping);
                }
            }
        }
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        ExecutionContext ec = nucleusCtx.getApiAdapter().getExecutionContext(value);
        if (this.cmd == null) {
            this.cmd = nucleusCtx.getMetaDataManager().getMetaDataForClass(this.getType(), ec != null ? ec.getClassLoaderResolver() : nucleusCtx.getClassLoaderResolver(null));
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(this.cmd.getPKMemberPositions()[index]);
            ObjectProvider sm = null;
            if (ec != null) {
                sm = ec.findObjectProvider(value);
            }
            if (sm == null) {
                if (mmd instanceof FieldMetaData) {
                    return ClassUtils.getValueOfFieldByReflection(value, mmd.getName());
                }
                return ClassUtils.getValueOfMethodByReflection(value, ClassUtils.getJavaBeanGetterName(mmd.getName(), false), null);
            }
            if (!mmd.isPrimaryKey()) {
                nucleusCtx.getApiAdapter().isLoaded(sm, mmd.getAbsoluteFieldNumber());
            }
            SingleValueFieldManager fm = new SingleValueFieldManager();
            sm.provideFields(new int[]{mmd.getAbsoluteFieldNumber()}, fm);
            return fm.fetchObjectField(mmd.getAbsoluteFieldNumber());
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)nucleusCtx.getApiAdapter().getIdForObject(value);
            return oid != null ? oid.getKeyValue() : null;
        }
        return null;
    }

    public void setObject(ExecutionContext ec, Object ps, int[] param, Object value) {
        this.setObject(ec, ps, param, value, null, -1);
    }

    public void setObject(ExecutionContext ec, Object ps, int[] param, Object value, ObjectProvider ownerSM, int ownerFieldNumber) {
        if (value == null) {
            this.setObjectAsNull(ec, ps, param);
        } else {
            this.setObjectAsValue(ec, ps, param, value, ownerSM, ownerFieldNumber);
        }
    }

    private void setObjectAsNull(ExecutionContext ec, Object ps, int[] param) {
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings[i];
            if (mapping.getNumberOfDatastoreMappings() <= 0) continue;
            int[] posMapping = new int[mapping.getNumberOfDatastoreMappings()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = param[n++];
            }
            mapping.setObject(ec, ps, posMapping, null);
        }
    }

    private boolean hasDatastoreAttributedPrimaryKeyValues(MetaDataManager mdm, StoreManager srm, ClassLoaderResolver clr) {
        AbstractClassMetaData acmd;
        boolean hasDatastoreAttributedPrimaryKeyValues = false;
        if (this.mmd != null && this.roleForMember != 4 && this.roleForMember != 3 && this.roleForMember != 5 && this.roleForMember != 6 && (acmd = mdm.getMetaDataForClass(this.mmd.getType(), clr)).getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < acmd.getPKMemberPositions().length; ++i) {
                IdentityStrategy strategy = acmd.getMetaDataForManagedMemberAtAbsolutePosition(acmd.getPKMemberPositions()[i]).getValueStrategy();
                if (strategy == null) continue;
                hasDatastoreAttributedPrimaryKeyValues |= srm.isStrategyDatastoreAttributed(acmd, acmd.getPKMemberPositions()[i]);
            }
        }
        return hasDatastoreAttributedPrimaryKeyValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObjectAsValue(ExecutionContext ec, Object ps, int[] param, Object value, ObjectProvider ownerSM, int ownerFieldNumber) {
        ApiAdapter api = ec.getApiAdapter();
        if (!api.isPersistable(value)) {
            throw new NucleusException(LOCALISER.msg("041016", value.getClass(), value)).setFatal();
        }
        ObjectProvider valueSM = ec.findObjectProvider(value);
        try {
            Object attachedValue;
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            boolean hasDatastoreAttributedPrimaryKeyValues = this.hasDatastoreAttributedPrimaryKeyValues(ec.getMetaDataManager(), this.storeMgr, clr);
            boolean inserted = false;
            if (ownerFieldNumber >= 0) {
                inserted = this.storeMgr.isObjectInserted(valueSM, ownerFieldNumber);
            } else if (this.mmd == null) {
                inserted = this.storeMgr.isObjectInserted(valueSM, this.type);
            }
            if (valueSM != null) {
                if (ec.getApiAdapter().isDetached(value) && valueSM.getReferencedPC() != null && ownerSM != null && this.mmd != null) {
                    ownerSM.replaceFieldMakeDirty(ownerFieldNumber, valueSM.getReferencedPC());
                }
                if (valueSM.isWaitingToBeFlushedToDatastore()) {
                    valueSM.flush();
                }
            } else if (ec.getApiAdapter().isDetached(value) && (attachedValue = ec.persistObjectInternal(value, null, -1, 0)) != value && ownerSM != null) {
                ownerSM.replaceFieldMakeDirty(ownerFieldNumber, attachedValue);
            }
            if (inserted || !ec.isInserting(value) || !hasDatastoreAttributedPrimaryKeyValues && this.mmd != null && this.mmd.isPrimaryKey() || !hasDatastoreAttributedPrimaryKeyValues && ownerSM == valueSM && api.getIdForObject(value) != null) {
                Object id = api.getIdForObject(value);
                boolean requiresPersisting = false;
                if (ec.getApiAdapter().isDetached(value) && ownerSM != null) {
                    if (ownerSM.isInserting()) {
                        if (!ec.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.attachSameDatastore") && ec.getObjectFromCache(api.getIdForObject(value)) == null) {
                            try {
                                Object obj = ec.findObject(api.getIdForObject(value), true, false, value.getClass().getName());
                                if (obj != null) {
                                    ObjectProvider objSM = ec.findObjectProvider(obj);
                                    if (objSM != null) {
                                        ec.evictFromTransaction(objSM);
                                    }
                                    ec.removeObjectFromLevel1Cache(api.getIdForObject(value));
                                }
                            }
                            catch (NucleusObjectNotFoundException onfe) {
                                requiresPersisting = true;
                            }
                        }
                    } else {
                        requiresPersisting = true;
                    }
                } else if (id == null) {
                    requiresPersisting = true;
                } else {
                    ExecutionContext pcEC = ec.getApiAdapter().getExecutionContext(value);
                    if (pcEC != null && ec != pcEC) {
                        throw new NucleusUserException(LOCALISER.msg("041015"), id);
                    }
                }
                if (requiresPersisting) {
                    if (this.mmd != null && !this.mmd.isCascadePersist() && !ec.getApiAdapter().isDetached(value)) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007006", (Object)this.mmd.getFullFieldName()));
                        }
                        throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), value);
                    }
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007007", this.mmd != null ? this.mmd.getFullFieldName() : null));
                    }
                    try {
                        Object pcNew = ec.persistObjectInternal(value, null, -1, 0);
                        if (hasDatastoreAttributedPrimaryKeyValues) {
                            ec.flushInternal(false);
                        }
                        id = api.getIdForObject(pcNew);
                        if (ec.getApiAdapter().isDetached(value) && ownerSM != null) {
                            ownerSM.replaceFieldMakeDirty(ownerFieldNumber, pcNew);
                            RelationType relationType = this.mmd.getRelationType(clr);
                            if (relationType == RelationType.MANY_TO_ONE_BI) {
                                if (NucleusLogger.PERSISTENCE.isInfoEnabled()) {
                                    NucleusLogger.PERSISTENCE.info("PCMapping.setObject : object " + ownerSM.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional." + " Have just attached the N side so should really update the reference in the 1 side collection" + " to refer to this attached object. Not yet implemented");
                                }
                            } else if (relationType == RelationType.ONE_TO_ONE_BI) {
                                AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
                                ObjectProvider relatedSM = ec.findObjectProvider(pcNew);
                                relatedSM.replaceFieldMakeDirty(relatedMmds[0].getAbsoluteFieldNumber(), ownerSM.getObject());
                            }
                        }
                    }
                    catch (NotYetFlushedException e) {
                        this.setObjectAsNull(ec, ps, param);
                        throw new NotYetFlushedException(value);
                    }
                }
                if (valueSM != null) {
                    valueSM.setStoringPC();
                }
                if (this.getNumberOfDatastoreMappings() > 0) {
                    if (id instanceof OID) {
                        OID oid = (OID)id;
                        try {
                            this.getDatastoreMapping(0).setObject(ps, param[0], oid.getKeyValue());
                        }
                        catch (Exception e) {
                            this.getDatastoreMapping(0).setObject(ps, param[0], oid.getKeyValue().toString());
                        }
                    } else {
                        boolean fieldsSet = false;
                        if (api.isSingleFieldIdentity(id) && this.javaTypeMappings.length > 1) {
                            Object key = api.getTargetKeyForSingleFieldIdentity(id);
                            AbstractClassMetaData keyCmd = ec.getMetaDataManager().getMetaDataForClass(key.getClass(), clr);
                            if (keyCmd != null && keyCmd.getIdentityType() == IdentityType.NONDURABLE) {
                                ObjectProvider keyOP = ec.findObjectProvider(key);
                                int[] fieldNums = keyCmd.getAllMemberPositions();
                                AppIDObjectIdFieldManager fm = new AppIDObjectIdFieldManager(param, ec, ps, this.javaTypeMappings);
                                for (int i = 0; i < fieldNums.length; ++i) {
                                    keyOP.provideFields(new int[]{fieldNums[i]}, fm);
                                }
                                fieldsSet = true;
                            }
                        }
                        if (!fieldsSet) {
                            ((PersistenceCapable)value).jdoCopyKeyFieldsFromObjectId((PersistenceCapable.ObjectIdFieldConsumer)new AppIDObjectIdFieldManager(param, ec, ps, this.javaTypeMappings), id);
                        }
                    }
                }
            } else {
                if (valueSM != null) {
                    valueSM.setStoringPC();
                }
                if (this.getNumberOfDatastoreMappings() > 0) {
                    this.setObjectAsNull(ec, ps, param);
                    throw new NotYetFlushedException(value);
                }
            }
            Object var22_26 = null;
            if (valueSM != null) {
                valueSM.unsetStoringPC();
            }
        }
        catch (Throwable throwable) {
            Object var22_27 = null;
            if (valueSM != null) {
                valueSM.unsetStoringPC();
            }
            throw throwable;
        }
    }

    public Object getObject(ExecutionContext ec, Object rs, int[] resultIndexes) {
        if (this.storeMgr.getResultValueAtPosition(rs, this, resultIndexes[0]) == null) {
            return null;
        }
        if (this.cmd == null) {
            this.cmd = ec.getMetaDataManager().getMetaDataForClass(this.getType(), ec.getClassLoaderResolver());
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            return MappingHelper.getObjectForDatastoreIdentity(ec, this, rs, resultIndexes, this.cmd);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            return MappingHelper.getObjectForApplicationIdentity(ec, this, rs, resultIndexes, this.cmd);
        }
        return null;
    }

    public void postFetch(ObjectProvider sm) {
    }

    public void insertPostProcessing(ObjectProvider op) {
    }

    public void postInsert(ObjectProvider sm) {
        Object pc = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
        RelationType relationType = this.mmd.getRelationType(clr);
        if (pc != null) {
            if (relationType == RelationType.ONE_TO_ONE_BI) {
                ObjectProvider otherSM = sm.getExecutionContext().findObjectProvider(pc);
                AbstractMemberMetaData relatedMmd = this.mmd.getRelatedMemberMetaDataForObject(clr, sm.getObject(), pc);
                if (relatedMmd == null) {
                    throw new NucleusUserException("You have a field " + this.mmd.getFullFieldName() + " that is 1-1 bidir yet cannot find the equivalent field at the other side. Why is that?");
                }
                Object relatedValue = otherSM.provideField(relatedMmd.getAbsoluteFieldNumber());
                if (relatedValue == null) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("041018", (Object)sm.getObjectAsPrintable(), (Object)this.mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(pc), (Object)relatedMmd.getFullFieldName()));
                    }
                    otherSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), sm.getObject());
                } else if (relatedValue != sm.getObject()) {
                    throw new NucleusUserException(LOCALISER.msg("041020", (Object)sm.getObjectAsPrintable(), (Object)this.mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(relatedValue)));
                }
            } else if (relationType == RelationType.MANY_TO_ONE_BI && relatedMmds[0].hasCollection()) {
                boolean contained;
                Collection relatedColl;
                ObjectProvider otherSM = sm.getExecutionContext().findObjectProvider(pc);
                if (otherSM != null && (relatedColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber())) != null && !(relatedColl instanceof SCOCollection) && !(contained = relatedColl.contains(sm.getObject()))) {
                    NucleusLogger.PERSISTENCE.info(LOCALISER.msg("041022", (Object)sm.getObjectAsPrintable(), (Object)this.mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(pc), (Object)relatedMmds[0].getFullFieldName()));
                }
            } else if (relationType == RelationType.MANY_TO_ONE_UNI) {
                ObjectProvider otherSM = sm.getExecutionContext().findObjectProvider(pc);
                if (otherSM == null) {
                    Object other = sm.getExecutionContext().persistObjectInternal(pc, null, -1, 0);
                    otherSM = sm.getExecutionContext().findObjectProvider(other);
                }
                PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, this.mmd.getType());
                store.add(sm, otherSM);
            }
        }
    }

    public void postUpdate(ObjectProvider sm) {
        Object pc = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        RelationType relationType = this.mmd.getRelationType(clr);
        if (pc == null) {
            if (relationType == RelationType.MANY_TO_ONE_UNI) {
                PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, this.mmd.getType());
                store.remove(sm);
            }
            return;
        }
        ObjectProvider otherSM = sm.getExecutionContext().findObjectProvider(pc);
        if (otherSM == null && (relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_UNI)) {
            Object other = sm.getExecutionContext().persistObjectInternal(pc, null, -1, 0);
            otherSM = sm.getExecutionContext().findObjectProvider(other);
        }
        if (relationType == RelationType.MANY_TO_ONE_UNI) {
            PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, this.mmd.getType());
            store.update(sm, otherSM);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void preDelete(ObjectProvider sm) {
        ExecutionContext ec = sm.getExecutionContext();
        int fieldNumber = this.mmd.getAbsoluteFieldNumber();
        try {
            ec.getApiAdapter().isLoaded(sm, fieldNumber);
        }
        catch (JDOObjectNotFoundException onfe) {
            return;
        }
        Object pc = sm.provideField(fieldNumber);
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        RelationType relationType = this.mmd.getRelationType(clr);
        if (relationType == RelationType.MANY_TO_ONE_UNI) {
            PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, this.mmd.getType());
            store.remove(sm);
        }
        boolean dependent = this.mmd.isDependent();
        if (this.mmd.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
        boolean hasFK = false;
        if (!dependent) {
            if (this.mmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (relatedMmds != null && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (ec.getNucleusContext().getPersistenceConfiguration().getStringProperty("datanucleus.deletionPolicy").equals("JDO2")) {
                hasFK = false;
            }
        }
        if (relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI && this.mmd.getMappedBy() == null) {
            if (dependent) {
                boolean relatedObjectDeleted = ec.getApiAdapter().isDeleted(pc);
                if (this.isNullable() && !relatedObjectDeleted) {
                    sm.replaceFieldMakeDirty(fieldNumber, null);
                    this.storeMgr.getPersistenceHandler().updateObject(sm, new int[]{fieldNumber});
                    if (relatedObjectDeleted) return;
                    ec.deleteObjectInternal(pc);
                    return;
                }
                NucleusLogger.DATASTORE_PERSIST.warn("Delete of " + StringUtils.toJVMIDString(sm.getObject()) + " needs delete of related object at " + this.mmd.getFullFieldName() + " but cannot delete it direct since FK is here");
                return;
            }
            AbstractMemberMetaData relatedMmd = this.mmd.getRelatedMemberMetaDataForObject(clr, sm.getObject(), pc);
            if (relatedMmd == null) return;
            ObjectProvider otherSM = ec.findObjectProvider(pc);
            if (otherSM == null) return;
            Object currentValue = otherSM.provideField(relatedMmd.getAbsoluteFieldNumber());
            if (currentValue == null) return;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("041019", (Object)StringUtils.toJVMIDString(pc), (Object)relatedMmd.getFullFieldName(), (Object)sm.getObjectAsPrintable()));
            }
            otherSM.replaceFieldMakeDirty(relatedMmd.getAbsoluteFieldNumber(), null);
            if (!ec.getManageRelations()) return;
            otherSM.getExecutionContext().getRelationshipManager(otherSM).relationChange(relatedMmd.getAbsoluteFieldNumber(), sm.getObject(), null);
            return;
        }
        if (relationType == RelationType.ONE_TO_ONE_BI && this.mmd.getMappedBy() != null) {
            DatastoreClass relatedTable = this.storeMgr.getDatastoreClass(relatedMmds[0].getClassName(), clr);
            JavaTypeMapping relatedMapping = relatedTable.getMemberMapping(relatedMmds[0]);
            boolean isNullable = relatedMapping.isNullable();
            ObjectProvider otherSM = ec.findObjectProvider(pc);
            if (!dependent) {
                if (hasFK) return;
                if (!this.isNullable()) return;
                Object currentRelatedValue = otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (currentRelatedValue == null) return;
                otherSM.replaceFieldMakeDirty(relatedMmds[0].getAbsoluteFieldNumber(), null);
                this.storeMgr.getPersistenceHandler().updateObject(otherSM, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
                if (!ec.getManageRelations()) return;
                otherSM.getExecutionContext().getRelationshipManager(otherSM).relationChange(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), null);
                return;
            }
            if (isNullable) {
                otherSM.replaceFieldMakeDirty(relatedMmds[0].getAbsoluteFieldNumber(), null);
                this.storeMgr.getPersistenceHandler().updateObject(otherSM, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
            }
            ec.deleteObjectInternal(pc);
            return;
        }
        if (relationType == RelationType.MANY_TO_ONE_BI) {
            ObjectProvider otherSM = ec.findObjectProvider(pc);
            if (relatedMmds[0].getJoinMetaData() == null) {
                if (otherSM.isDeleting()) {
                    return;
                }
                if (dependent) {
                    if (this.isNullable()) {
                        sm.replaceFieldMakeDirty(fieldNumber, null);
                        this.storeMgr.getPersistenceHandler().updateObject(sm, new int[]{fieldNumber});
                    }
                    if (ec.getApiAdapter().isDeleted(pc)) {
                        return;
                    }
                    ec.deleteObjectInternal(pc);
                    return;
                }
                if (!relatedMmds[0].hasCollection()) {
                    if (!relatedMmds[0].hasMap()) return;
                    return;
                }
                if (ec.getApiAdapter().isDeleted(otherSM.getObject())) return;
                if (otherSM.isDeleting()) return;
                ec.markDirty(otherSM, false);
                otherSM.isLoaded(relatedMmds[0].getAbsoluteFieldNumber());
                Collection otherColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (otherColl == null) return;
                if (ec.getManageRelations()) {
                    otherSM.getExecutionContext().getRelationshipManager(otherSM).relationRemove(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject());
                }
                NucleusLogger.PERSISTENCE.debug("ManagedRelationships : delete of object causes removal from collection at " + relatedMmds[0].getFullFieldName());
                otherColl.remove(sm.getObject());
                return;
            }
            if (dependent) {
                ec.deleteObjectInternal(pc);
                return;
            }
            if (relatedMmds[0].hasCollection()) {
                if (ec.getApiAdapter().isDeleted(otherSM.getObject())) return;
                if (otherSM.isDeleting()) return;
                ec.markDirty(otherSM, false);
                otherSM.isLoaded(relatedMmds[0].getAbsoluteFieldNumber());
                Collection otherColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (otherColl == null) return;
                NucleusLogger.PERSISTENCE.debug("ManagedRelationships : delete of object causes removal from collection at " + relatedMmds[0].getFullFieldName());
                otherColl.remove(sm.getObject());
                return;
            }
            if (!relatedMmds[0].hasMap()) return;
            return;
        } else {
            if (relationType != RelationType.MANY_TO_ONE_UNI) return;
            if (!dependent) return;
            ec.deleteObjectInternal(pc);
        }
    }
}

