/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.OID;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.util.ClassUtils;

public class PersistableIdMapping
extends PersistableMapping {
    public PersistableIdMapping(PersistableMapping pcMapping) {
        this.initialize(pcMapping.storeMgr, pcMapping.type);
        this.datastoreContainer = pcMapping.datastoreContainer;
        this.javaTypeMappings = new JavaTypeMapping[pcMapping.javaTypeMappings.length];
        System.arraycopy(pcMapping.javaTypeMappings, 0, this.javaTypeMappings, 0, this.javaTypeMappings.length);
    }

    public Object getObject(ExecutionContext ec, Object rs, int[] param) {
        Object value = super.getObject(ec, rs, param);
        if (value != null) {
            ApiAdapter api = ec.getApiAdapter();
            return api.getIdForObject(value);
        }
        return null;
    }

    public void setObject(ExecutionContext ec, Object ps, int[] param, Object value) {
        if (value == null) {
            super.setObject(ec, ps, param, null);
            return;
        }
        if (this.cmd == null) {
            this.cmd = ec.getMetaDataManager().getMetaDataForClass(this.getType(), ec.getClassLoaderResolver());
        }
        if (value instanceof OID) {
            if (this.getJavaTypeMapping()[0] instanceof OIDMapping) {
                this.getJavaTypeMapping()[0].setObject(ec, ps, param, value);
            } else {
                Object key = ((OID)value).getKeyValue();
                if (key instanceof String) {
                    this.getJavaTypeMapping()[0].setString(ec, ps, param, (String)key);
                } else {
                    this.getJavaTypeMapping()[0].setObject(ec, ps, param, key);
                }
            }
        } else if (ec.getApiAdapter().isSingleFieldIdentity(value)) {
            Object key = ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(value);
            if (key instanceof String) {
                this.getJavaTypeMapping()[0].setString(ec, ps, param, (String)key);
            } else {
                this.getJavaTypeMapping()[0].setObject(ec, ps, param, key);
            }
        } else {
            String[] pkMemberNames = this.cmd.getPrimaryKeyMemberNames();
            for (int i = 0; i < pkMemberNames.length; ++i) {
                Object pkMemberValue = ClassUtils.getValueForIdentityField(value, pkMemberNames[i]);
                if (pkMemberValue instanceof Byte) {
                    this.getDatastoreMapping(i).setByte(ps, param[i], (Byte)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof Character) {
                    this.getDatastoreMapping(i).setChar(ps, param[i], ((Character)pkMemberValue).charValue());
                    continue;
                }
                if (pkMemberValue instanceof Integer) {
                    this.getDatastoreMapping(i).setInt(ps, param[i], (Integer)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof Long) {
                    this.getDatastoreMapping(i).setLong(ps, param[i], (Long)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof Short) {
                    this.getDatastoreMapping(i).setShort(ps, param[i], (Short)pkMemberValue);
                    continue;
                }
                if (pkMemberValue instanceof String) {
                    this.getDatastoreMapping(i).setString(ps, param[i], (String)pkMemberValue);
                    continue;
                }
                this.getDatastoreMapping(i).setObject(ps, param[i], pkMemberValue);
            }
        }
    }
}

