/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.DiscriminatorLongMapping;
import org.datanucleus.store.mapped.mapping.DiscriminatorStringMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public class DiscriminatorMapping
extends SingleFieldMapping {
    private final JavaTypeMapping delegate;

    public DiscriminatorMapping(DatastoreAdapter dba, DatastoreContainerObject table, JavaTypeMapping delegate, DiscriminatorMetaData dismd) {
        ColumnMetaData colmd;
        this.initialize(table.getStoreManager(), delegate.getType());
        this.datastoreContainer = table;
        this.delegate = delegate;
        IdentifierFactory idFactory = table.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier id = null;
        if (dismd.getColumnMetaData() == null) {
            id = idFactory.newDiscriminatorFieldIdentifier();
            colmd = new ColumnMetaData();
            colmd.setName(id.getIdentifierName());
            dismd.setColumnMetaData(colmd);
        } else {
            colmd = dismd.getColumnMetaData();
            if (colmd.getName() == null) {
                id = idFactory.newDiscriminatorFieldIdentifier();
                colmd.setName(id.getIdentifierName());
            } else {
                id = idFactory.newDatastoreFieldIdentifier(colmd.getName());
            }
        }
        DatastoreField column = table.addDatastoreField(this.getType(), id, this, dismd.getColumnMetaData());
        table.getStoreManager().getMappingManager().createDatastoreMapping(delegate, column, this.getType());
    }

    public Class getJavaType() {
        return DiscriminatorMapping.class;
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        Object valueObj = value;
        if (value instanceof String && (this.getType().equals(ClassNameConstants.LONG) || this.getType().equals(ClassNameConstants.JAVA_LANG_LONG))) {
            valueObj = Long.valueOf((String)value);
        }
        this.delegate.setObject(ec, preparedStatement, exprIndex, valueObj);
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        Object value;
        Object valueObj = value = this.delegate.getObject(ec, resultSet, exprIndex);
        if (value instanceof String && (this.getType().equals(ClassNameConstants.LONG) || this.getType().equals(ClassNameConstants.JAVA_LANG_LONG))) {
            valueObj = Long.valueOf((String)value);
        }
        return valueObj;
    }

    public int getNumberOfDatastoreMappings() {
        return this.delegate.getNumberOfDatastoreMappings();
    }

    public DatastoreMapping getDatastoreMapping(int index) {
        return this.delegate.getDatastoreMapping(index);
    }

    public DatastoreMapping[] getDatastoreMappings() {
        return this.delegate.getDatastoreMappings();
    }

    public void addDatastoreMapping(DatastoreMapping datastoreMapping) {
        this.delegate.addDatastoreMapping(datastoreMapping);
    }

    public static DiscriminatorMapping createDiscriminatorMapping(DatastoreContainerObject table, DiscriminatorMetaData dismd) {
        MappedStoreManager storeMgr = table.getStoreManager();
        MappingManager mapMgr = storeMgr.getMappingManager();
        if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
            return new DiscriminatorStringMapping(storeMgr.getDatastoreAdapter(), table, mapMgr.getMapping(String.class), dismd);
        }
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            ColumnMetaData disColmd = dismd.getColumnMetaData();
            if (disColmd != null && disColmd.getJdbcType() != null) {
                if (disColmd.getJdbcType().equalsIgnoreCase("INTEGER") || disColmd.getJdbcType().equalsIgnoreCase("BIGINT") || disColmd.getJdbcType().equalsIgnoreCase("NUMERIC")) {
                    return new DiscriminatorLongMapping(storeMgr.getDatastoreAdapter(), table, mapMgr.getMapping(Long.class), dismd);
                }
                return new DiscriminatorStringMapping(storeMgr.getDatastoreAdapter(), table, mapMgr.getMapping(String.class), dismd);
            }
            return new DiscriminatorStringMapping(storeMgr.getDatastoreAdapter(), table, mapMgr.getMapping(String.class), dismd);
        }
        return null;
    }
}

