/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.JDOStateManager;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.FieldValues;
import org.datanucleus.util.Localiser;

public class JDOStateManagerFactory
implements ObjectProviderFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private static JDOStateManagerFactory instance = null;

    protected JDOStateManagerFactory() {
    }

    public static JDOStateManagerFactory getInstance() {
        if (instance == null) {
            instance = new JDOStateManagerFactory();
        }
        return instance;
    }

    public ObjectProvider newForHollow(ExecutionContext ec, Class pcClass, Object id) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForHollow(id, null, cls);
        return sm;
    }

    public ObjectProvider newForHollow(ExecutionContext ec, Class pcClass, Object id, FieldValues fv) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForHollow(id, fv, cls);
        return sm;
    }

    public ObjectProvider newForHollowPreConstructed(ExecutionContext ec, Object id, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForHollowPreConstructed(id, pc);
        return sm;
    }

    public ObjectProvider newForHollowPopulatedAppId(ExecutionContext ec, Class pcClass, FieldValues fv) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForHollowAppId(fv, cls);
        return sm;
    }

    public ObjectProvider newForPersistentClean(ExecutionContext ec, Object id, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForPersistentClean(id, pc);
        return sm;
    }

    public ObjectProvider newForEmbedded(ExecutionContext ec, Object pc, boolean copyPc, ObjectProvider ownerOP, int ownerFieldNumber) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForEmbedded(pc, copyPc);
        if (ownerOP != null) {
            sm.addEmbeddedOwner(ownerOP, ownerFieldNumber);
        }
        return sm;
    }

    public ObjectProvider newForEmbedded(ExecutionContext ec, AbstractClassMetaData cmd, ObjectProvider ownerOP, int ownerFieldNumber) {
        Class pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        JDOStateManager sm = (JDOStateManager)this.newForHollow(ec, pcClass, null);
        sm.initialiseForEmbedded(sm.getObject(), false);
        if (ownerOP != null) {
            sm.addEmbeddedOwner(ownerOP, ownerFieldNumber);
        }
        return sm;
    }

    public ObjectProvider newForPersistentNew(ExecutionContext ec, Object pc, FieldValues preInsertChanges) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForPersistentNew(pc, preInsertChanges);
        return sm;
    }

    public ObjectProvider newForTransactionalTransient(ExecutionContext ec, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForTransactionalTransient(pc);
        return sm;
    }

    public ObjectProvider newForDetached(ExecutionContext ec, Object pc, Object id, Object version) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForDetached(pc, id, version);
        return sm;
    }

    public ObjectProvider newForPNewToBeDeleted(ExecutionContext ec, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForPNewToBeDeleted(pc);
        return sm;
    }

    public ObjectProvider newForCachedPC(ExecutionContext ec, Object id, CachedPC cachedPC) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(cachedPC.getObjectClass(), ec.getClassLoaderResolver());
        JDOStateManager sm = new JDOStateManager(ec, cmd);
        sm.initialiseForCachedPC(cachedPC, id);
        return sm;
    }

    private Class getInitialisedClassForClass(Class pcCls, ClassLoaderResolver clr) {
        try {
            return clr.classForName(pcCls.getName(), pcCls.getClassLoader(), true);
        }
        catch (ClassNotResolvedException e) {
            throw new NucleusUserException(LOCALISER.msg("026015", (Object)pcCls.getName())).setFatal();
        }
    }
}

