/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import javax.jdo.spi.JDOImplHelper;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.api.ApiAdapterFactory;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.cache.NullLevel2Cache;
import org.datanucleus.enhancer.jdo.JDOImplementationCreator;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionIsolationNotSupportedException;
import org.datanucleus.identity.IdentityKeyTranslator;
import org.datanucleus.identity.IdentityStringTranslator;
import org.datanucleus.management.FactoryStatistics;
import org.datanucleus.management.jmx.ManagementManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.JDOStateManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.federation.FederatedStoreManager;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.TransactionManager;
import org.datanucleus.transaction.jta.TransactionManagerFinder;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.validation.BeanValidatorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NucleusContext {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private final ContextType type;
    private final PersistenceConfiguration config;
    private final PluginManager pluginManager;
    private MetaDataManager metaDataManager = null;
    private final String classLoaderResolverClassName;
    private final ApiAdapter apiAdapter;
    private TypeManager typeManager;
    private transient StoreManager storeMgr = null;
    private boolean jca = false;
    private Level2Cache cache;
    private transient TransactionManager txManager = null;
    private transient javax.transaction.TransactionManager jtaTxManager = null;
    private transient Map<String, ClassLoaderResolver> classLoaderResolverMap = new HashMap<String, ClassLoaderResolver>();
    private transient ManagementManager jmxManager = null;
    private transient FactoryStatistics statistics = null;
    public static final Random random = new Random();
    private Class datastoreIdentityClass = null;
    private IdentityStringTranslator idStringTranslator = null;
    private boolean idStringTranslatorInit = false;
    private IdentityKeyTranslator idKeyTranslator = null;
    private boolean idKeyTranslatorInit = false;
    private ImplementationCreator implCreator;
    private List<ExecutionContext.LifecycleListener> executionContextListeners = new ArrayList<ExecutionContext.LifecycleListener>();
    private transient FetchGroupManager fetchGrpMgr;
    private transient Object validatorFactory = null;
    private transient boolean validatorFactoryInit = false;
    public static final Set<String> STARTUP_PROPERTIES = new HashSet<String>();

    public NucleusContext(String apiName, Map startupProps) {
        this(apiName, ContextType.PERSISTENCE, startupProps);
    }

    public NucleusContext(String apiName, Map startupProps, PluginManager pluginMgr) {
        this(apiName, ContextType.PERSISTENCE, startupProps, pluginMgr);
    }

    public NucleusContext(String apiName, ContextType type, Map startupProps) {
        this(apiName, type, startupProps, null);
    }

    public NucleusContext(String apiName, ContextType type, Map startupProps, PluginManager pluginMgr) {
        this.type = type;
        this.pluginManager = pluginMgr != null ? pluginMgr : PluginManager.createPluginManager(startupProps, this.getClass().getClassLoader());
        this.config = new PersistenceConfiguration(this.pluginManager);
        if (startupProps != null && !startupProps.isEmpty()) {
            this.config.setPersistenceProperties(startupProps);
        }
        String clrName = this.config.getStringProperty("datanucleus.classLoaderResolverName");
        this.classLoaderResolverClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.classloader_resolver", "name", clrName, "class-name");
        if (this.classLoaderResolverClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("001001", (Object)clrName)).setFatal();
        }
        this.apiAdapter = ApiAdapterFactory.getInstance().getApiAdapter(apiName, this.pluginManager);
        this.config.setDefaultProperties(this.apiAdapter.getDefaultFactoryProperties());
        if (type == ContextType.PERSISTENCE) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    JDOImplHelper.registerAuthorizedStateManagerClass(JDOStateManager.class);
                    return null;
                }
            });
        }
    }

    public ContextType getType() {
        return this.type;
    }

    public ApiAdapter getApiAdapter() {
        return this.apiAdapter;
    }

    public String getApiName() {
        return this.apiAdapter.getName();
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        return this.config;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public synchronized MetaDataManager getMetaDataManager() {
        if (this.metaDataManager == null) {
            String apiName = this.apiAdapter.getName();
            try {
                this.metaDataManager = (MetaDataManager)this.getPluginManager().createExecutableExtension("org.datanucleus.metadata_manager", new String[]{"name"}, new String[]{apiName}, "class", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this});
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER.msg("008010", (Object)apiName, (Object)e.getMessage()), e);
            }
            if (this.metaDataManager == null) {
                throw new NucleusException(LOCALISER.msg("008009", (Object)apiName));
            }
        }
        return this.metaDataManager;
    }

    public TypeManager getTypeManager() {
        if (this.typeManager == null) {
            this.typeManager = new TypeManager(this.apiAdapter, this.pluginManager, this.getClassLoaderResolver(null));
        }
        return this.typeManager;
    }

    public ClassLoaderResolver getClassLoaderResolver(ClassLoader primaryLoader) {
        ClassLoaderResolver clr;
        String resolverName;
        String key = resolverName = this.config.getStringProperty("datanucleus.classLoaderResolverName");
        if (primaryLoader != null) {
            key = key + ":[" + StringUtils.toJVMIDString(primaryLoader) + "]";
        }
        if (this.classLoaderResolverMap == null) {
            this.classLoaderResolverMap = new HashMap<String, ClassLoaderResolver>();
        }
        if ((clr = this.classLoaderResolverMap.get(key)) != null) {
            return clr;
        }
        try {
            clr = (ClassLoaderResolver)this.pluginManager.createExecutableExtension("org.datanucleus.classloader_resolver", "name", resolverName, "class-name", new Class[]{ClassLoader.class}, new Object[]{primaryLoader});
            clr.registerUserClassLoader((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader"));
        }
        catch (ClassNotFoundException cnfe) {
            throw new NucleusUserException(LOCALISER.msg("001002", (Object)this.classLoaderResolverClassName), cnfe).setFatal();
        }
        catch (Exception e) {
            throw new NucleusUserException(LOCALISER.msg("001003", (Object)this.classLoaderResolverClassName), e).setFatal();
        }
        this.classLoaderResolverMap.put(key, clr);
        return clr;
    }

    public synchronized void initialise() {
        if (this.type == ContextType.PERSISTENCE) {
            boolean loadClasses;
            ClassLoaderResolver clr = this.getClassLoaderResolver(null);
            clr.registerUserClassLoader((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader"));
            Set<String> propNamesWithDatastore = this.config.getPropertyNamesWithPrefix("datanucleus.datastore.");
            if (propNamesWithDatastore == null) {
                String reqdIsolation;
                NucleusLogger.DATASTORE.debug("Creating StoreManager for datastore");
                Map<String, Object> datastoreProps = this.config.getDatastoreProperties();
                this.storeMgr = NucleusContext.createStoreManagerForProperties(this.config.getPersistenceProperties(), datastoreProps, clr, this);
                String transactionIsolation = this.config.getStringProperty("datanucleus.transactionIsolation");
                if (transactionIsolation != null && !transactionIsolation.equalsIgnoreCase(reqdIsolation = NucleusContext.getTransactionIsolationForStoreManager(this.storeMgr, transactionIsolation))) {
                    this.config.setProperty("datanucleus.transactionIsolation", reqdIsolation);
                }
            } else {
                NucleusLogger.DATASTORE.debug("Creating FederatedStoreManager to handle federation of primary StoreManager and " + propNamesWithDatastore.size() + " secondary datastores");
                this.storeMgr = new FederatedStoreManager(clr, this);
            }
            NucleusLogger.DATASTORE.debug("StoreManager now created");
            String puName = this.config.getStringProperty("datanucleus.PersistenceUnitName");
            if (puName != null && (loadClasses = this.config.getBooleanProperty("datanucleus.persistenceUnitLoadClasses"))) {
                Collection<String> loadedClasses = this.getMetaDataManager().getClassesWithMetaData();
                this.storeMgr.addClasses(loadedClasses.toArray(new String[loadedClasses.size()]), clr);
            }
        }
        this.logConfiguration();
    }

    public static String getTransactionIsolationForStoreManager(StoreManager storeMgr, String transactionIsolation) {
        Collection srmOptions;
        if (transactionIsolation != null && !(srmOptions = storeMgr.getSupportedOptions()).contains("TransactionIsolationLevel." + transactionIsolation)) {
            if (transactionIsolation.equals("read-uncommitted")) {
                if (srmOptions.contains("TransactionIsolationLevel.read-committed")) {
                    return "read-committed";
                }
                if (srmOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    return "repeatable-read";
                }
                if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    return "serializable";
                }
            } else if (transactionIsolation.equals("read-committed")) {
                if (srmOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    return "repeatable-read";
                }
                if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    return "serializable";
                }
            } else if (transactionIsolation.equals("repeatable-read")) {
                if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    return "serializable";
                }
            } else {
                throw new TransactionIsolationNotSupportedException(transactionIsolation);
            }
        }
        return transactionIsolation;
    }

    public static StoreManager createStoreManagerForProperties(Map<String, Object> props, Map<String, Object> datastoreProps, ClassLoaderResolver clr, NucleusContext nucCtx) {
        Extension[] exts = nucCtx.getPluginManager().getExtensionPoint("org.datanucleus.store_manager").getExtensions();
        Class[] ctrArgTypes = new Class[]{ClassConstants.CLASS_LOADER_RESOLVER, ClassConstants.NUCLEUS_CONTEXT, Map.class};
        Object[] ctrArgs = new Object[]{clr, nucCtx, datastoreProps};
        StoreManager storeMgr = null;
        String storeManagerType = (String)props.get("datanucleus.storeManagerType".toLowerCase());
        if (storeManagerType != null) {
            for (int e = 0; storeMgr == null && e < exts.length; ++e) {
                ConfigurationElement[] confElm = exts[e].getConfigurationElements();
                for (int c = 0; storeMgr == null && c < confElm.length; ++c) {
                    String key = confElm[c].getAttribute("key");
                    if (!key.equalsIgnoreCase(storeManagerType)) continue;
                    try {
                        storeMgr = (StoreManager)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "key", storeManagerType, "class-name", ctrArgTypes, ctrArgs);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new NucleusException(t.getMessage(), t).setFatal();
                    }
                    catch (Exception ex) {
                        throw new NucleusException(ex.getMessage(), ex).setFatal();
                    }
                }
            }
            if (storeMgr == null) {
                throw new NucleusUserException(LOCALISER.msg("008004", (Object)storeManagerType)).setFatal();
            }
        }
        if (storeMgr == null) {
            int idx;
            String url = (String)props.get("datanucleus.connectionurl");
            if (url != null && (idx = url.indexOf(58)) > -1) {
                url = url.substring(0, idx);
            }
            for (int e = 0; storeMgr == null && e < exts.length; ++e) {
                ConfigurationElement[] confElm = exts[e].getConfigurationElements();
                for (int c = 0; storeMgr == null && c < confElm.length; ++c) {
                    String urlKey = confElm[c].getAttribute("url-key");
                    if (url != null && !urlKey.equalsIgnoreCase(url)) continue;
                    try {
                        storeMgr = (StoreManager)nucCtx.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "url-key", url == null ? urlKey : url, "class-name", ctrArgTypes, ctrArgs);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new NucleusException(t.getMessage(), t).setFatal();
                    }
                    catch (Exception ex) {
                        throw new NucleusException(ex.getMessage(), ex).setFatal();
                    }
                }
            }
            if (storeMgr == null) {
                throw new NucleusUserException(LOCALISER.msg("008004", (Object)url)).setFatal();
            }
        }
        return storeMgr;
    }

    public synchronized void close() {
        if (this.fetchGrpMgr != null) {
            this.fetchGrpMgr.clearFetchGroups();
        }
        if (this.storeMgr != null) {
            this.storeMgr.close();
            this.storeMgr = null;
        }
        if (this.metaDataManager != null) {
            this.metaDataManager.close();
            this.metaDataManager = null;
        }
        if (this.statistics != null) {
            if (this.jmxManager != null) {
                this.jmxManager.deregisterMBean(this.statistics.getRegisteredName());
            }
            this.statistics = null;
        }
        if (this.jmxManager != null) {
            this.jmxManager.close();
            this.jmxManager = null;
        }
        if (this.cache != null) {
            this.cache.close();
            NucleusLogger.CACHE.debug(LOCALISER.msg("004009"));
        }
        this.classLoaderResolverMap.clear();
        this.classLoaderResolverMap = null;
        this.datastoreIdentityClass = null;
    }

    protected void logConfiguration() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            String timeZoneID;
            NucleusLogger.PERSISTENCE.debug("================= Persistence Configuration ===============");
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("008000", (Object)"DataNucleus", (Object)this.pluginManager.getVersionForBundle("org.datanucleus")));
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("008001", (Object)this.config.getStringProperty("datanucleus.ConnectionURL"), (Object)this.config.getStringProperty("datanucleus.ConnectionDriverName"), (Object)this.config.getStringProperty("datanucleus.ConnectionUserName")));
            NucleusLogger.PERSISTENCE.debug("JDK : " + System.getProperty("java.version") + " on " + System.getProperty("os.name"));
            NucleusLogger.PERSISTENCE.debug("Persistence API : " + this.apiAdapter.getName());
            NucleusLogger.PERSISTENCE.debug("Plugin Registry : " + this.pluginManager.getRegistryClassName());
            Object primCL = this.config.getProperty("datanucleus.primaryClassLoader");
            NucleusLogger.PERSISTENCE.debug("ClassLoading : " + this.config.getStringProperty("datanucleus.classLoaderResolverName") + (primCL != null ? "primary=" + primCL : ""));
            if (this.config.hasPropertyNotNull("datanucleus.PersistenceUnitName")) {
                NucleusLogger.PERSISTENCE.debug("Persistence-Unit : " + this.config.getStringProperty("datanucleus.PersistenceUnitName"));
            }
            if ((timeZoneID = this.config.getStringProperty("datanucleus.ServerTimeZoneID")) == null) {
                timeZoneID = TimeZone.getDefault().getID();
            }
            NucleusLogger.PERSISTENCE.debug("Standard Options : " + (this.config.getBooleanProperty("datanucleus.Multithreaded") ? "pm-multithreaded" : "pm-singlethreaded") + (this.config.getBooleanProperty("datanucleus.RetainValues") ? ", retain-values" : "") + (this.config.getBooleanProperty("datanucleus.RestoreValues") ? ", restore-values" : "") + (this.config.getBooleanProperty("datanucleus.NontransactionalRead") ? ", nontransactional-read" : "") + (this.config.getBooleanProperty("datanucleus.NontransactionalWrite") ? ", nontransactional-write" : "") + (this.config.getBooleanProperty("datanucleus.IgnoreCache") ? ", ignoreCache" : "") + ", serverTimeZone=" + timeZoneID);
            NucleusLogger.PERSISTENCE.debug("Persistence Options :" + (this.config.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit") ? " reachability-at-commit" : "") + (this.config.getBooleanProperty("datanucleus.DetachAllOnCommit") ? " detach-all-on-commit" : "") + (this.config.getBooleanProperty("datanucleus.DetachAllOnRollback") ? " detach-all-on-rollback" : "") + (this.config.getBooleanProperty("datanucleus.DetachOnClose") ? " detach-on-close" : "") + (this.config.getBooleanProperty("datanucleus.manageRelationships") ? (this.config.getBooleanProperty("datanucleus.manageRelationshipsChecks") ? " managed-relations(checked)" : "managed-relations(unchecked)") : "") + " deletion-policy=" + this.config.getStringProperty("datanucleus.deletionPolicy"));
            String txnType = "RESOURCE_LOCAL";
            if (TransactionType.JTA.toString().equalsIgnoreCase(this.config.getStringProperty("datanucleus.TransactionType"))) {
                txnType = this.isJcaMode() ? "JTA (via JCA adapter)" : "JTA";
            }
            NucleusLogger.PERSISTENCE.debug("Transactions : type=" + txnType + ", mode=" + (this.config.getBooleanProperty("datanucleus.Optimistic") ? "optimistic" : "datastore") + ", isolation=" + this.config.getStringProperty("datanucleus.transactionIsolation"));
            NucleusLogger.PERSISTENCE.debug("Value Generation : txn-isolation=" + this.config.getStringProperty("datanucleus.valuegeneration.transactionIsolation") + " connection=" + (this.config.getStringProperty("datanucleus.valuegeneration.transactionAttribute").equalsIgnoreCase("New") ? "New" : "Existing"));
            NucleusLogger.PERSISTENCE.debug("Cache : Level1 (" + this.config.getStringProperty("datanucleus.cache.level1.type") + ")" + ", Level2 (" + this.config.getStringProperty("datanucleus.cache.level2.type") + ", mode=" + this.config.getStringProperty("datanucleus.cache.level2.mode") + ")" + ", QueryResults (" + this.config.getStringProperty("datanucleus.cache.queryResults.type") + ")" + (this.config.getBooleanProperty("datanucleus.cache.collections") ? ", Collections/Maps " : ""));
            NucleusLogger.PERSISTENCE.debug("===========================================================");
        }
    }

    public synchronized Class getDatastoreIdentityClass() {
        if (this.datastoreIdentityClass == null) {
            String dsidName = this.config.getStringProperty("datanucleus.datastoreIdentityType");
            String datastoreIdentityClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.store_datastoreidentity", "name", dsidName, "class-name");
            if (datastoreIdentityClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)dsidName)).setFatal();
            }
            ClassLoaderResolver clr = this.getClassLoaderResolver(null);
            try {
                this.datastoreIdentityClass = clr.classForName(datastoreIdentityClassName, ClassConstants.NUCLEUS_CONTEXT_LOADER);
            }
            catch (ClassNotResolvedException cnre) {
                throw new NucleusUserException(LOCALISER.msg("002002", (Object)dsidName, (Object)datastoreIdentityClassName)).setFatal();
            }
        }
        return this.datastoreIdentityClass;
    }

    public synchronized IdentityStringTranslator getIdentityStringTranslator() {
        if (this.idStringTranslatorInit) {
            return this.idStringTranslator;
        }
        this.idStringTranslatorInit = true;
        String translatorType = this.config.getStringProperty("datanucleus.identityStringTranslatorType");
        if (translatorType != null) {
            try {
                this.idStringTranslator = (IdentityStringTranslator)this.pluginManager.createExecutableExtension("org.datanucleus.identity_string_translator", "name", translatorType, "class-name", null, null);
                return this.idStringTranslator;
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)translatorType)).setFatal();
            }
        }
        return null;
    }

    public synchronized IdentityKeyTranslator getIdentityKeyTranslator() {
        if (this.idKeyTranslatorInit) {
            return this.idKeyTranslator;
        }
        this.idKeyTranslatorInit = true;
        String translatorType = this.config.getStringProperty("datanucleus.identityKeyTranslatorType");
        if (translatorType != null) {
            try {
                this.idKeyTranslator = (IdentityKeyTranslator)this.pluginManager.createExecutableExtension("org.datanucleus.identity_key_translator", "name", translatorType, "class-name", null, null);
                return this.idKeyTranslator;
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("002001", (Object)translatorType)).setFatal();
            }
        }
        return null;
    }

    public boolean statisticsEnabled() {
        return this.config.getBooleanProperty("datanucleus.enableStatistics") || this.getJMXManager() != null;
    }

    public synchronized ManagementManager getJMXManager() {
        if (this.jmxManager == null && this.config.getStringProperty("datanucleus.jmxType") != null) {
            this.jmxManager = new ManagementManager(this);
        }
        return this.jmxManager;
    }

    public synchronized FactoryStatistics getStatistics() {
        if (this.statistics == null && this.statisticsEnabled()) {
            String name = null;
            if (this.getJMXManager() != null) {
                name = this.jmxManager.getDomainName() + ":InstanceName=" + this.jmxManager.getInstanceName() + ",Type=" + FactoryStatistics.class.getName() + ",Name=Factory" + random.nextInt();
            }
            this.statistics = new FactoryStatistics(name);
            if (this.jmxManager != null) {
                this.jmxManager.registerMBean(this.statistics, name);
            }
        }
        return this.statistics;
    }

    public synchronized ImplementationCreator getImplementationCreator() {
        if (this.implCreator == null) {
            this.implCreator = new JDOImplementationCreator(this.getMetaDataManager());
        }
        return this.implCreator;
    }

    public synchronized TransactionManager getTransactionManager() {
        if (this.txManager == null) {
            this.txManager = new TransactionManager();
        }
        return this.txManager;
    }

    public synchronized javax.transaction.TransactionManager getJtaTransactionManager() {
        if (this.jtaTxManager == null) {
            this.jtaTxManager = new TransactionManagerFinder(this).getTransactionManager(this.getClassLoaderResolver((ClassLoader)this.config.getProperty("datanucleus.primaryClassLoader")));
            if (this.jtaTxManager == null) {
                throw new NucleusTransactionException(LOCALISER.msg("015030"));
            }
        }
        return this.jtaTxManager;
    }

    public boolean isStoreManagerInitialised() {
        return this.storeMgr != null;
    }

    public StoreManager getStoreManager() {
        if (this.storeMgr == null) {
            this.initialise();
        }
        return this.storeMgr;
    }

    public CallbackHandler getValidationHandler(ExecutionContext ec) {
        if (this.validatorFactoryInit && this.validatorFactory == null) {
            return null;
        }
        if (this.config.hasPropertyNotNull("datanucleus.validation.mode") && this.config.getStringProperty("datanucleus.validation.mode").equalsIgnoreCase("none")) {
            this.validatorFactoryInit = true;
            return null;
        }
        try {
            ec.getClassLoaderResolver().classForName("javax.validation.Validation");
        }
        catch (ClassNotResolvedException cnre) {
            this.validatorFactoryInit = true;
            return null;
        }
        try {
            if (this.validatorFactory == null) {
                this.validatorFactoryInit = true;
                this.validatorFactory = this.config.hasPropertyNotNull("datanucleus.validation.factory") ? this.config.getProperty("datanucleus.validation.factory") : Validation.buildDefaultValidatorFactory();
            }
            return new BeanValidatorHandler(ec, (ValidatorFactory)this.validatorFactory);
        }
        catch (Throwable ex) {
            if (this.config.hasPropertyNotNull("datanucleus.validation.mode") && this.config.getStringProperty("datanucleus.validation.mode").equalsIgnoreCase("callback")) {
                throw ec.getApiAdapter().getUserExceptionForException(ex.getMessage(), (Exception)ex);
            }
            NucleusLogger.GENERAL.warn("Unable to create validator handler", ex);
            return null;
        }
    }

    public boolean hasLevel2Cache() {
        this.getLevel2Cache();
        return !(this.cache instanceof NullLevel2Cache);
    }

    public Level2Cache getLevel2Cache() {
        if (this.cache == null) {
            String level2Type = this.config.getStringProperty("datanucleus.cache.level2.type");
            String level2ClassName = this.pluginManager.getAttributeValueForExtension("org.datanucleus.cache_level2", "name", level2Type, "class-name");
            if (level2ClassName == null) {
                throw new NucleusUserException(LOCALISER.msg("004000", (Object)level2Type)).setFatal();
            }
            try {
                this.cache = (Level2Cache)this.pluginManager.createExecutableExtension("org.datanucleus.cache_level2", "name", level2Type, "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this});
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004002", (Object)level2Type));
                }
            }
            catch (Exception e) {
                throw new NucleusUserException(LOCALISER.msg("004001", (Object)level2Type, (Object)level2ClassName), e).setFatal();
            }
        }
        return this.cache;
    }

    public ExecutionContext.LifecycleListener[] getExecutionContextListeners() {
        return this.executionContextListeners.toArray(new ExecutionContext.LifecycleListener[this.executionContextListeners.size()]);
    }

    public void addExecutionContextListener(ExecutionContext.LifecycleListener listener) {
        this.executionContextListeners.add(listener);
    }

    public void removeExecutionContextListener(ExecutionContext.LifecycleListener listener) {
        this.executionContextListeners.remove(listener);
    }

    public synchronized void setJcaMode(boolean jca) {
        this.jca = jca;
    }

    public boolean isJcaMode() {
        return this.jca;
    }

    public synchronized FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this);
        }
        return this.fetchGrpMgr;
    }

    public void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    public void removeInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    public FetchGroup createInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().createFetchGroup(cls, name);
    }

    public FetchGroup getInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        this.getMetaDataManager().getMetaDataForClass(cls, this.getClassLoaderResolver(cls.getClassLoader()));
        if (cls.isInterface() && !this.getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name);
    }

    public Set<FetchGroup> getFetchGroupsWithName(String name) {
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    public boolean isClassCacheable(AbstractClassMetaData cmd) {
        String cacheMode = this.config.getStringProperty("datanucleus.cache.level2.mode");
        if (cacheMode.equalsIgnoreCase("ALL")) {
            return true;
        }
        if (cacheMode.equalsIgnoreCase("NONE")) {
            return false;
        }
        if (cacheMode.equalsIgnoreCase("ENABLE_SELECTIVE")) {
            return cmd.isCacheable() != null && cmd.isCacheable() != false;
        }
        if (cacheMode.equalsIgnoreCase("DISABLE_SELECTIVE")) {
            return cmd.isCacheable() == null || cmd.isCacheable() != false;
        }
        Boolean cacheableFlag = cmd.isCacheable();
        if (cacheableFlag == null) {
            return true;
        }
        return cacheableFlag;
    }

    static {
        STARTUP_PROPERTIES.add("datanucleus.plugin.pluginRegistryClassName");
        STARTUP_PROPERTIES.add("datanucleus.plugin.pluginRegistryBundleCheck");
        STARTUP_PROPERTIES.add("datanucleus.plugin.allowUserBundles");
        STARTUP_PROPERTIES.add("datanucleus.plugin.validatePlugins");
        STARTUP_PROPERTIES.add("datanucleus.classLoaderResolverName");
        STARTUP_PROPERTIES.add("datanucleus.persistenceXmlFilename");
        STARTUP_PROPERTIES.add("datanucleus.primaryClassLoader");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextType {
        PERSISTENCE,
        ENHANCEMENT;

    }
}

