/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.connection;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.datanucleus.ClassConstants;
import org.datanucleus.NucleusContext;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManagerImpl
implements ConnectionManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    NucleusContext nucleusContext;
    Map<String, ConnectionFactory> factories = new HashMap<String, ConnectionFactory>();
    ManagedConnectionPool connectionPool = new ManagedConnectionPool();
    boolean connectionPoolEnabled = true;

    public ConnectionManagerImpl(NucleusContext context) {
        this.nucleusContext = context;
    }

    @Override
    public void closeAllConnections(ConnectionFactory factory, Object poolKey) {
        ManagedConnection mconnFromPool;
        if (poolKey != null && this.connectionPoolEnabled && (mconnFromPool = this.connectionPool.getManagedConnection(factory, poolKey)) != null) {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug("Connection found in the pool : " + mconnFromPool + " for key=" + poolKey + " in factory=" + factory + " but owner object closing so closing connection");
            }
            mconnFromPool.close();
        }
    }

    @Override
    public ManagedConnection allocateConnection(final ConnectionFactory factory, final Object poolKey, Transaction transaction, Map options) {
        ManagedConnection mconnFromPool;
        if (poolKey != null && this.connectionPoolEnabled && (mconnFromPool = this.connectionPool.getManagedConnection(factory, poolKey)) != null) {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug("Connection found in the pool : " + mconnFromPool + " for key=" + poolKey + " in factory=" + factory);
            }
            return mconnFromPool;
        }
        final ManagedConnection mconn = factory.createManagedConnection(poolKey, options == null && transaction != null ? transaction.getOptions() : options);
        if (poolKey != null) {
            if (transaction.isActive()) {
                this.configureTransactionEventListener(transaction, mconn);
                org.datanucleus.transaction.Transaction tx = this.nucleusContext.getTransactionManager().getTransaction(poolKey);
                mconn.setManagedResource();
                this.enlistResource(mconn, tx, options);
            }
            if (this.connectionPoolEnabled) {
                mconn.addListener(new ManagedConnectionResourceListener(){

                    public void transactionFlushed() {
                    }

                    public void transactionPreClose() {
                    }

                    public void managedConnectionPreClose() {
                    }

                    public void managedConnectionPostClose() {
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug("Connection removed from the pool : " + mconn + " for key=" + poolKey + " in factory=" + factory);
                        }
                        ConnectionManagerImpl.this.connectionPool.removeManagedConnection(factory, poolKey);
                        mconn.removeListener(this);
                    }

                    public void resourcePostClose() {
                    }
                });
                if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                    NucleusLogger.CONNECTION.debug("Connection added to the pool : " + mconn + " for key=" + poolKey + " in factory=" + factory);
                }
                this.connectionPool.putManagedConnection(factory, poolKey, mconn);
            }
        }
        return mconn;
    }

    private void configureTransactionEventListener(final Transaction transaction, final ManagedConnection mconn) {
        transaction.addTransactionEventListener(new TransactionEventListener(){

            public void transactionStarted() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transactionRolledBack() {
                try {
                    mconn.close();
                }
                finally {
                    transaction.removeTransactionEventListener(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transactionCommitted() {
                try {
                    mconn.close();
                }
                finally {
                    transaction.removeTransactionEventListener(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transactionEnded() {
                try {
                    mconn.close();
                }
                finally {
                    transaction.removeTransactionEventListener(this);
                }
            }

            public void transactionPreCommit() {
                if (mconn.isLocked()) {
                    throw new NucleusUserException(LOCALISER.msg("009000"));
                }
                mconn.transactionPreClose();
            }

            public void transactionPreRollBack() {
                if (mconn.isLocked()) {
                    throw new NucleusUserException(LOCALISER.msg("009000"));
                }
                mconn.transactionPreClose();
            }

            public void transactionPreFlush() {
            }

            public void transactionFlushed() {
                mconn.transactionFlushed();
            }
        });
    }

    private void enlistResource(ManagedConnection mconn, org.datanucleus.transaction.Transaction tx, Map<String, Object> options) {
        XAResource res = mconn.getXAResource();
        if (res != null) {
            boolean enlistInLocalTM = true;
            if (options != null && options.get("resource-type") != null && ConnectionResourceType.JTA.toString().equalsIgnoreCase((String)options.get("resource-type"))) {
                enlistInLocalTM = false;
            }
            if (enlistInLocalTM) {
                tx.enlistResource(res);
            }
        }
    }

    @Override
    public ConnectionFactory lookupConnectionFactory(String name) {
        return this.factories.get(name);
    }

    @Override
    public void registerConnectionFactory(String name, ConnectionFactory factory) {
        this.factories.put(name, factory);
    }

    @Override
    public void disableConnectionPool() {
        this.connectionPoolEnabled = false;
    }

    class ManagedConnectionPool {
        Map<Object, Map<ConnectionFactory, ManagedConnection>> connectionsPool = new HashMap<Object, Map<ConnectionFactory, ManagedConnection>>();

        ManagedConnectionPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeManagedConnection(ConnectionFactory factory, Object poolKey) {
            Map<Object, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Map<ConnectionFactory, ManagedConnection> connectionsForOM = this.connectionsPool.get(poolKey);
                if (connectionsForOM != null) {
                    if (connectionsForOM.remove(factory) != null && ConnectionManagerImpl.this.nucleusContext.getStatistics() != null) {
                        ConnectionManagerImpl.this.nucleusContext.getStatistics().decrementActiveConnections();
                    }
                    if (connectionsForOM.size() == 0) {
                        this.connectionsPool.remove(poolKey);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedConnection getManagedConnection(ConnectionFactory factory, Object poolKey) {
            Map<Object, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Map<ConnectionFactory, ManagedConnection> connectionsForOM = this.connectionsPool.get(poolKey);
                if (connectionsForOM == null) {
                    return null;
                }
                ManagedConnection mconn = connectionsForOM.get(factory);
                if (mconn != null) {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(LOCALISER.msg("009000"));
                    }
                    return mconn;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putManagedConnection(ConnectionFactory factory, Object poolKey, ManagedConnection mconn) {
            Map<Object, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Map<ConnectionFactory, ManagedConnection> connectionsForOM = this.connectionsPool.get(poolKey);
                if (connectionsForOM == null) {
                    connectionsForOM = new HashMap<ConnectionFactory, ManagedConnection>();
                    this.connectionsPool.put(poolKey, connectionsForOM);
                }
                if (connectionsForOM.put(factory, mconn) == null && ConnectionManagerImpl.this.nucleusContext.getStatistics() != null) {
                    ConnectionManagerImpl.this.nucleusContext.getStatistics().incrementActiveConnections();
                }
            }
        }
    }
}

