/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.state.AbstractStateManager;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.util.NucleusLogger;

public class L2CacheRetrieveFieldManager
extends AbstractFieldManager {
    ObjectProvider op;
    ExecutionContext ec;
    CachedPC cachedPC;

    public L2CacheRetrieveFieldManager(ObjectProvider op, CachedPC cachedpc) {
        this.op = op;
        this.ec = op.getExecutionContext();
        this.cachedPC = cachedpc;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.cachedPC.getFieldValue(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.cachedPC.getFieldValue(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        return ((Character)this.cachedPC.getFieldValue(fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.cachedPC.getFieldValue(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.cachedPC.getFieldValue(fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        return (Integer)this.cachedPC.getFieldValue(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        return (Long)this.cachedPC.getFieldValue(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        return (Short)this.cachedPC.getFieldValue(fieldNumber);
    }

    public String fetchStringField(int fieldNumber) {
        return (String)this.cachedPC.getFieldValue(fieldNumber);
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        Object value = this.cachedPC.getFieldValue(fieldNumber);
        if (mmd.getRelationType(this.ec.getClassLoaderResolver()) != 0) {
            if (value != null) {
                if (Collection.class.isAssignableFrom(value.getClass())) {
                    Collection coll = (Collection)value;
                    try {
                        Collection fieldColl = (Collection)coll.getClass().newInstance();
                        for (Object elementOid : coll) {
                            if (elementOid != null) {
                                Object element = this.ec.findObject(elementOid, null, null, false, false);
                                fieldColl.add(element);
                                continue;
                            }
                            fieldColl.add(null);
                        }
                        return this.op.wrapSCOField(fieldNumber, fieldColl, false, false, true);
                    }
                    catch (Exception e) {
                        NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + value.getClass().getName(), e);
                        return null;
                    }
                }
                if (Map.class.isAssignableFrom(value.getClass())) {
                    Map map = (Map)value;
                    try {
                        Map fieldMap = (Map)map.getClass().newInstance();
                        for (Map.Entry entry : map.entrySet()) {
                            Object mapKey = null;
                            mapKey = mmd.getMap().keyIsPersistent() ? this.ec.findObject(entry.getKey(), null, null, false, false) : (Object)entry.getKey();
                            Object mapValue = null;
                            Object mapValueId = entry.getValue();
                            if (mapValueId != null) {
                                mapValue = mmd.getMap().valueIsPersistent() ? this.ec.findObject(entry.getValue(), null, null, false, false) : (Object)entry.getValue();
                            }
                            fieldMap.put(mapKey, mapValue);
                        }
                        return this.op.wrapSCOField(fieldNumber, fieldMap, false, false, true);
                    }
                    catch (Exception e) {
                        NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + value.getClass().getName(), e);
                        return null;
                    }
                }
                if (value.getClass().isArray()) {
                    try {
                        Object[] elementOIDs = (Object[])value;
                        Class<?> componentType = mmd.getType().getComponentType();
                        Object fieldArr = Array.newInstance(componentType, elementOIDs.length);
                        boolean persistableElement = this.ec.getApiAdapter().isPersistable(componentType);
                        for (int i = 0; i < elementOIDs.length; ++i) {
                            Object element = null;
                            element = elementOIDs[i] == null ? null : (componentType.isInterface() || persistableElement || componentType == Object.class ? this.ec.findObject(elementOIDs[i], null, null, false, false) : elementOIDs[i]);
                            Array.set(fieldArr, i, element);
                        }
                        return fieldArr;
                    }
                    catch (NucleusException ne) {
                        NucleusLogger.CACHE.error("Exception thrown trying to find element of array while getting object with id " + this.op.getInternalObjectId() + " from the L2 cache", ne);
                        return null;
                    }
                }
                if ((mmd.isSerialized() || MetaDataUtils.isMemberEmbedded(mmd, mmd.getRelationType(this.ec.getClassLoaderResolver()), this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager())) && this.ec.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheEmbedded") && value instanceof CachedPC) {
                    CachedPC valueCachedPC = (CachedPC)value;
                    AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(valueCachedPC.getObjectClass(), this.ec.getClassLoaderResolver());
                    int[] fieldsToLoad = AbstractStateManager.getFlagsSetTo(valueCachedPC.getLoadedFields(), cmd.getAllMemberPositions(), true);
                    ObjectProvider valueOP = ObjectProviderFactory.newForEmbedded(this.ec, cmd, this.op, mmd.getAbsoluteFieldNumber());
                    valueOP.replaceFields(fieldsToLoad, new L2CacheRetrieveFieldManager(valueOP, valueCachedPC));
                    return valueOP.getObject();
                }
                try {
                    return this.ec.findObject(value, null, null, false, false);
                }
                catch (NucleusObjectNotFoundException nonfe) {
                    return null;
                }
            }
            return null;
        }
        if (value == null) {
            return null;
        }
        if (value.getClass() == StringBuffer.class) {
            return new StringBuffer(((StringBuffer)value).toString());
        }
        boolean[] mutables = mmd.getAbstractClassMetaData().getSCOMutableMemberFlags();
        if (mutables[fieldNumber]) {
            return this.op.wrapSCOField(fieldNumber, value, false, false, true);
        }
        return value;
    }
}

