/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateStringConverter
implements TypeConverter<Date, String> {
    private static final ThreadLocal<FormatterInfo> formatterThreadInfo = new ThreadLocal<FormatterInfo>(){

        @Override
        protected FormatterInfo initialValue() {
            return new FormatterInfo();
        }
    };

    private DateFormat getFormatter() {
        FormatterInfo formatInfo = formatterThreadInfo.get();
        if (formatInfo.formatter == null) {
            formatInfo.formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        }
        return formatInfo.formatter;
    }

    @Override
    public Date toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return this.getFormatter().parse(str);
        }
        catch (ParseException pe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Date.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(Date date) {
        return date != null ? this.getFormatter().format(date) : null;
    }

    static class FormatterInfo {
        SimpleDateFormat formatter;

        FormatterInfo() {
        }
    }
}

