/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.properties.PropertyStore;
import org.datanucleus.store.DefaultCandidateExtent;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusConnectionImpl;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.NucleusSequenceImpl;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreDataManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.autostart.AutoStartMechanism;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ConnectionManagerImpl;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.encryption.ConnectionEncryptionProvider;
import org.datanucleus.store.exceptions.DatastoreInitialisationException;
import org.datanucleus.store.exceptions.DatastoreReadOnlyException;
import org.datanucleus.store.exceptions.NoExtentException;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.schema.naming.DN2NamingFactory;
import org.datanucleus.store.schema.naming.JPANamingFactory;
import org.datanucleus.store.schema.naming.NamingCase;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.TypeConversionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStoreManager
extends PropertyStore
implements StoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final String storeManagerKey;
    protected final boolean readOnlyDatastore;
    protected final boolean fixedDatastore;
    protected final boolean autoCreateTables;
    protected final boolean autoCreateColumns;
    protected final boolean autoCreateConstraints;
    protected final boolean autoCreateWarnOnError;
    protected final boolean validateTables;
    protected final boolean validateColumns;
    protected final boolean validateConstraints;
    protected AutoStartMechanism starter = null;
    protected boolean starterInitialised = false;
    protected final NucleusContext nucleusContext;
    private ValueGenerationManager valueGenerationMgr;
    protected StoreDataManager storeDataMgr = new StoreDataManager();
    protected String autoStartMechanism = null;
    protected StorePersistenceHandler persistenceHandler = null;
    private QueryManager queryMgr = null;
    protected StoreSchemaHandler schemaHandler = null;
    protected NamingFactory namingFactory = null;
    protected ConnectionManager connectionMgr;
    protected String txConnectionFactoryName;
    protected String nontxConnectionFactoryName;

    protected AbstractStoreManager(String key, ClassLoaderResolver clr, NucleusContext nucleusContext, Map<String, Object> props) {
        this.storeManagerKey = key;
        this.nucleusContext = nucleusContext;
        if (props != null) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                this.setPropertyInternal(entry.getKey(), entry.getValue());
            }
        }
        this.readOnlyDatastore = this.getBooleanProperty("datanucleus.readOnlyDatastore");
        this.fixedDatastore = this.getBooleanProperty("datanucleus.fixedDatastore");
        if (this.readOnlyDatastore || this.fixedDatastore) {
            this.autoCreateTables = false;
            this.autoCreateColumns = false;
            this.autoCreateConstraints = false;
        } else {
            boolean autoCreateSchema = this.getBooleanProperty("datanucleus.autoCreateSchema");
            if (autoCreateSchema) {
                this.autoCreateTables = true;
                this.autoCreateColumns = true;
                this.autoCreateConstraints = true;
            } else {
                this.autoCreateTables = this.getBooleanProperty("datanucleus.autoCreateTables");
                this.autoCreateColumns = this.getBooleanProperty("datanucleus.autoCreateColumns");
                this.autoCreateConstraints = this.getBooleanProperty("datanucleus.autoCreateConstraints");
            }
        }
        this.autoCreateWarnOnError = this.getBooleanProperty("datanucleus.autoCreateWarnOnError");
        boolean validateSchema = this.getBooleanProperty("datanucleus.validateSchema");
        if (validateSchema) {
            this.validateTables = true;
            this.validateColumns = true;
            this.validateConstraints = true;
        } else {
            this.validateTables = this.getBooleanProperty("datanucleus.validateTables");
            this.validateColumns = !this.validateTables ? false : this.getBooleanProperty("datanucleus.validateColumns");
            this.validateConstraints = this.getBooleanProperty("datanucleus.validateConstraints");
        }
        this.autoStartMechanism = this.getStringProperty("datanucleus.autoStartMechanism");
        this.registerConnectionMgr();
        this.registerConnectionFactory();
        nucleusContext.addExecutionContextListener(new ExecutionContext.LifecycleListener(){

            public void preClose(ExecutionContext ec) {
                ConnectionFactory connFactory = AbstractStoreManager.this.connectionMgr.lookupConnectionFactory(AbstractStoreManager.this.txConnectionFactoryName);
                AbstractStoreManager.this.connectionMgr.closeAllConnections(connFactory, ec);
                connFactory = AbstractStoreManager.this.connectionMgr.lookupConnectionFactory(AbstractStoreManager.this.nontxConnectionFactoryName);
                AbstractStoreManager.this.connectionMgr.closeAllConnections(connFactory, ec);
            }
        });
    }

    protected void registerConnectionMgr() {
        this.connectionMgr = new ConnectionManagerImpl(this.nucleusContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void registerConnectionFactory() {
        ConnectionFactory cf;
        ConfigurationElement cfElem = this.nucleusContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "true"});
        if (cfElem == null) throw new NucleusException("Error creating transactional connection factory. No connection factory plugin defined");
        this.txConnectionFactoryName = cfElem.getAttribute("name");
        try {
            cf = (ConnectionFactory)this.nucleusContext.getPluginManager().createExecutableExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "true"}, "class-name", new Class[]{StoreManager.class, String.class}, new Object[]{this, "tx"});
            this.connectionMgr.registerConnectionFactory(this.txConnectionFactoryName, cf);
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug(LOCALISER.msg("032018", (Object)this.txConnectionFactoryName));
            }
        }
        catch (Exception e) {
            throw new NucleusException("Error creating transactional connection factory", e).setFatal();
        }
        cfElem = this.nucleusContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "false"});
        if (cfElem == null) return;
        this.nontxConnectionFactoryName = cfElem.getAttribute("name");
        try {
            cf = (ConnectionFactory)this.nucleusContext.getPluginManager().createExecutableExtension("org.datanucleus.store_connectionfactory", new String[]{"datastore", "transactional"}, new String[]{this.storeManagerKey, "false"}, "class-name", new Class[]{StoreManager.class, String.class}, new Object[]{this, "nontx"});
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug(LOCALISER.msg("032019", (Object)this.nontxConnectionFactoryName));
            }
            this.connectionMgr.registerConnectionFactory(this.nontxConnectionFactoryName, cf);
            return;
        }
        catch (Exception e) {
            throw new NucleusException("Error creating nontransactional connection factory", e).setFatal();
        }
    }

    @Override
    public synchronized void close() {
        ConnectionFactory cf;
        if (this.txConnectionFactoryName != null && (cf = this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName)) != null) {
            cf.close();
        }
        if (this.nontxConnectionFactoryName != null && (cf = this.connectionMgr.lookupConnectionFactory(this.nontxConnectionFactoryName)) != null) {
            cf.close();
        }
        if (this.valueGenerationMgr != null) {
            this.valueGenerationMgr.clear();
        }
        this.storeDataMgr.clear();
        this.starterInitialised = false;
        this.starter = null;
        if (this.persistenceHandler != null) {
            this.persistenceHandler.close();
            this.persistenceHandler = null;
        }
        if (this.queryMgr != null) {
            this.queryMgr.close();
            this.queryMgr = null;
        }
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionMgr;
    }

    @Override
    public ManagedConnection getConnection(ExecutionContext ec) {
        return this.getConnection(ec, null);
    }

    @Override
    public ManagedConnection getConnection(ExecutionContext ec, Map options) {
        ConnectionFactory connFactory = ec.getTransaction().isActive() ? this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName) : (this.nontxConnectionFactoryName != null ? this.connectionMgr.lookupConnectionFactory(this.nontxConnectionFactoryName) : this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName));
        return connFactory.getConnection(ec, ec.getTransaction(), options);
    }

    public ManagedConnection getConnection(int isolation_level) {
        ConnectionFactory connFactory = null;
        connFactory = this.nontxConnectionFactoryName != null ? this.connectionMgr.lookupConnectionFactory(this.nontxConnectionFactoryName) : this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName);
        HashMap<String, Integer> options = null;
        if (isolation_level >= 0) {
            options = new HashMap<String, Integer>();
            options.put("transaction.isolation", isolation_level);
        }
        return connFactory.getConnection(null, null, options);
    }

    @Override
    public String getConnectionDriverName() {
        return this.getStringProperty("datanucleus.ConnectionDriverName");
    }

    @Override
    public String getConnectionURL() {
        return this.getStringProperty("datanucleus.ConnectionURL");
    }

    @Override
    public String getConnectionUserName() {
        return this.getStringProperty("datanucleus.ConnectionUserName");
    }

    @Override
    public String getConnectionPassword() {
        String decrypterName;
        String password = this.getStringProperty("datanucleus.ConnectionPassword");
        if (password != null && (decrypterName = this.getStringProperty("datanucleus.ConnectionPasswordDecrypter")) != null) {
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            try {
                Class decrypterCls = clr.classForName(decrypterName);
                ConnectionEncryptionProvider decrypter = (ConnectionEncryptionProvider)decrypterCls.newInstance();
                password = decrypter.decrypt(password);
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE.warn("Error invoking decrypter class " + decrypterName, e);
            }
        }
        return password;
    }

    @Override
    public Object getConnectionFactory() {
        return this.getProperty("datanucleus.ConnectionFactory");
    }

    @Override
    public String getConnectionFactoryName() {
        return this.getStringProperty("datanucleus.ConnectionFactoryName");
    }

    @Override
    public Object getConnectionFactory2() {
        return this.getProperty("datanucleus.ConnectionFactory2");
    }

    @Override
    public String getConnectionFactory2Name() {
        return this.getStringProperty("datanucleus.ConnectionFactory2Name");
    }

    @Override
    public boolean isAutoCreateTables() {
        return this.autoCreateTables;
    }

    @Override
    public boolean isAutoCreateColumns() {
        return this.autoCreateColumns;
    }

    @Override
    public boolean isAutoCreateConstraints() {
        return this.autoCreateConstraints;
    }

    public boolean isValidateTables() {
        return this.validateTables;
    }

    public boolean isValidateColumns() {
        return this.validateColumns;
    }

    public boolean isValidateConstraints() {
        return this.validateConstraints;
    }

    @Override
    public StorePersistenceHandler getPersistenceHandler() {
        return this.persistenceHandler;
    }

    @Override
    public QueryManager getQueryManager() {
        if (this.queryMgr == null) {
            this.queryMgr = new QueryManager(this.nucleusContext, this);
        }
        return this.queryMgr;
    }

    @Override
    public StoreSchemaHandler getSchemaHandler() {
        return this.schemaHandler;
    }

    @Override
    public NamingFactory getNamingFactory() {
        if (this.namingFactory == null) {
            this.namingFactory = this.nucleusContext.getApiName().equalsIgnoreCase("JPA") ? new JPANamingFactory(this.nucleusContext) : new DN2NamingFactory(this.nucleusContext);
            String identifierCase = this.getStringProperty("datanucleus.identifier.case");
            if (identifierCase != null) {
                if (identifierCase.equalsIgnoreCase("lowercase")) {
                    this.namingFactory.setNamingCase(NamingCase.LOWER_CASE);
                } else if (identifierCase.equalsIgnoreCase("UPPERCASE")) {
                    this.namingFactory.setNamingCase(NamingCase.UPPER_CASE);
                } else {
                    this.namingFactory.setNamingCase(NamingCase.MIXED_CASE);
                }
            }
        }
        return this.namingFactory;
    }

    @Override
    public NucleusSequence getNucleusSequence(ExecutionContext ec, SequenceMetaData seqmd) {
        return new NucleusSequenceImpl(ec, this, seqmd);
    }

    @Override
    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        ConnectionFactory cf = this.connectionMgr.lookupConnectionFactory(this.txConnectionFactoryName);
        final boolean enlisted = ec.getTransaction().isActive();
        final ManagedConnection mc = cf.getConnection(enlisted ? ec : null, enlisted ? ec.getTransaction() : null, null);
        mc.lock();
        Runnable closeRunnable = new Runnable(){

            public void run() {
                mc.unlock();
                if (!enlisted) {
                    mc.close();
                }
            }
        };
        return new NucleusConnectionImpl(mc.getConnection(), closeRunnable);
    }

    @Override
    public ValueGenerationManager getValueGenerationManager() {
        if (this.valueGenerationMgr == null) {
            this.valueGenerationMgr = new ValueGenerationManager();
        }
        return this.valueGenerationMgr;
    }

    @Override
    public ApiAdapter getApiAdapter() {
        return this.nucleusContext.getApiAdapter();
    }

    @Override
    public String getStoreManagerKey() {
        return this.storeManagerKey;
    }

    @Override
    public String getQueryCacheKey() {
        return this.getStoreManagerKey();
    }

    @Override
    public NucleusContext getNucleusContext() {
        return this.nucleusContext;
    }

    public MetaDataManager getMetaDataManager() {
        return this.nucleusContext.getMetaDataManager();
    }

    @Override
    public Date getDatastoreDate() {
        throw new UnsupportedOperationException();
    }

    protected void registerStoreData(StoreData data) {
        this.storeDataMgr.registerStoreData(data);
        if (this.starter != null && this.starterInitialised) {
            this.starter.addClass(data);
        }
    }

    protected void deregisterAllStoreData() {
        this.storeDataMgr.clear();
        this.starterInitialised = false;
        this.clearAutoStarter();
    }

    protected void logConfiguration() {
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug("======================= Datastore =========================");
            NucleusLogger.DATASTORE.debug("StoreManager : \"" + this.storeManagerKey + "\" (" + this.getClass().getName() + ")");
            if (this.autoStartMechanism != null) {
                String classNames = this.getStringProperty("datanucleus.autoStartClassNames");
                NucleusLogger.DATASTORE.debug("AutoStart : mechanism=" + this.autoStartMechanism + ", mode=" + this.getStringProperty("datanucleus.autoStartMechanismMode") + (classNames != null ? ", classes=" + classNames : ""));
            }
            NucleusLogger.DATASTORE.debug("Datastore : " + (this.readOnlyDatastore ? "read-only" : "read-write") + (this.fixedDatastore ? ", fixed" : "") + (this.getBooleanProperty("datanucleus.SerializeRead") ? ", useLocking" : ""));
            StringBuffer autoCreateOptions = null;
            if (this.autoCreateTables || this.autoCreateColumns || this.autoCreateConstraints) {
                autoCreateOptions = new StringBuffer();
                boolean first = true;
                if (this.autoCreateTables) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Tables");
                    first = false;
                }
                if (this.autoCreateColumns) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Columns");
                    first = false;
                }
                if (this.autoCreateConstraints) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Constraints");
                    first = false;
                }
            }
            StringBuffer validateOptions = null;
            if (this.validateTables || this.validateColumns || this.validateConstraints) {
                validateOptions = new StringBuffer();
                boolean first = true;
                if (this.validateTables) {
                    validateOptions.append("Tables");
                    first = false;
                }
                if (this.validateColumns) {
                    if (!first) {
                        validateOptions.append(",");
                    }
                    validateOptions.append("Columns");
                    first = false;
                }
                if (this.validateConstraints) {
                    if (!first) {
                        validateOptions.append(",");
                    }
                    validateOptions.append("Constraints");
                    first = false;
                }
            }
            NucleusLogger.DATASTORE.debug("Schema Control : AutoCreate(" + (autoCreateOptions != null ? autoCreateOptions.toString() : "None") + ")" + ", Validate(" + (validateOptions != null ? validateOptions.toString() : "None") + ")");
            Object[] queryLanguages = this.nucleusContext.getPluginManager().getAttributeValuesForExtension("org.datanucleus.store_query_query", "datastore", this.storeManagerKey, "name");
            NucleusLogger.DATASTORE.debug("Query Languages : " + (queryLanguages != null ? StringUtils.objectArrayToString(queryLanguages) : "none"));
            NucleusLogger.DATASTORE.debug("Queries : Timeout=" + this.getIntProperty("datanucleus.datastoreReadTimeout"));
            NucleusLogger.DATASTORE.debug("===========================================================");
        }
    }

    @Override
    public void printInformation(String category, PrintStream ps) throws Exception {
        if (category.equalsIgnoreCase("DATASTORE")) {
            ps.println(LOCALISER.msg("032020", (Object)this.storeManagerKey, (Object)this.getConnectionURL(), (Object)(this.readOnlyDatastore ? "read-only" : "read-write"), (Object)(this.fixedDatastore ? ", fixed" : "")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseAutoStart(ClassLoaderResolver clr) throws DatastoreInitialisationException {
        block33: {
            if (this.starterInitialised) {
                return;
            }
            if (this.autoStartMechanism == null) {
                this.autoStartMechanism = "None";
                this.starterInitialised = true;
                return;
            }
            String autoStarterClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.autostart", "name", this.autoStartMechanism, "class-name");
            if (autoStarterClassName != null) {
                String mode = this.getStringProperty("datanucleus.autoStartMechanismMode");
                Class[] argsClass = new Class[]{ClassConstants.STORE_MANAGER, ClassConstants.CLASS_LOADER_RESOLVER};
                Object[] args = new Object[]{this, clr};
                try {
                    this.starter = (AutoStartMechanism)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.autostart", "name", this.autoStartMechanism, "class-name", argsClass, args);
                    if (mode.equalsIgnoreCase("None")) {
                        this.starter.setMode(AutoStartMechanism.Mode.NONE);
                    } else if (mode.equalsIgnoreCase("Checked")) {
                        this.starter.setMode(AutoStartMechanism.Mode.CHECKED);
                    } else if (mode.equalsIgnoreCase("Quiet")) {
                        this.starter.setMode(AutoStartMechanism.Mode.QUIET);
                    } else if (mode.equalsIgnoreCase("Ignored")) {
                        this.starter.setMode(AutoStartMechanism.Mode.IGNORED);
                    }
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.error(StringUtils.getStringFromStackTrace(e));
                }
            }
            if (this.starter == null) {
                this.starterInitialised = true;
                return;
            }
            boolean illegalState = false;
            try {
                Collection existingData;
                if (!this.starter.isOpen()) {
                    this.starter.open();
                }
                if ((existingData = this.starter.getAllClassData()) == null || existingData.size() <= 0) break block33;
                ArrayList<String> classesNeedingAdding = new ArrayList<String>();
                for (StoreData data : existingData) {
                    Class classFound;
                    block34: {
                        if (!data.isFCO()) continue;
                        classFound = null;
                        try {
                            classFound = clr.classForName(data.getName());
                        }
                        catch (ClassNotResolvedException cnre) {
                            if (data.getInterfaceName() == null) break block34;
                            try {
                                this.getNucleusContext().getImplementationCreator().newInstance(clr.classForName(data.getInterfaceName()), clr);
                                classFound = clr.classForName(data.getName());
                            }
                            catch (ClassNotResolvedException cnre2) {
                                // empty catch block
                            }
                        }
                    }
                    if (classFound != null) {
                        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("032003", (Object)data.getName()));
                        classesNeedingAdding.add(data.getName());
                        if (data.getMetaData() != null) continue;
                        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(classFound, clr);
                        if (acmd != null) {
                            data.setMetaData(acmd);
                            continue;
                        }
                        String msg = LOCALISER.msg("034004", (Object)data.getName());
                        if (this.starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                            NucleusLogger.PERSISTENCE.error(msg);
                            throw new DatastoreInitialisationException(msg);
                        }
                        if (this.starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                            NucleusLogger.PERSISTENCE.warn(msg);
                            continue;
                        }
                        if (this.starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                        NucleusLogger.PERSISTENCE.warn(msg);
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034001", (Object)data.getName()));
                        this.starter.deleteClass(data.getName());
                        continue;
                    }
                    String msg = LOCALISER.msg("034000", (Object)data.getName());
                    if (this.starter.getMode() == AutoStartMechanism.Mode.CHECKED) {
                        NucleusLogger.PERSISTENCE.error(msg);
                        throw new DatastoreInitialisationException(msg);
                    }
                    if (this.starter.getMode() == AutoStartMechanism.Mode.IGNORED) {
                        NucleusLogger.PERSISTENCE.warn(msg);
                        continue;
                    }
                    if (this.starter.getMode() != AutoStartMechanism.Mode.QUIET) continue;
                    NucleusLogger.PERSISTENCE.warn(msg);
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034001", (Object)data.getName()));
                    this.starter.deleteClass(data.getName());
                }
                String[] classesToLoad = new String[classesNeedingAdding.size()];
                Iterator classesNeedingAddingIter = classesNeedingAdding.iterator();
                int n = 0;
                while (classesNeedingAddingIter.hasNext()) {
                    classesToLoad[n++] = (String)classesNeedingAddingIter.next();
                }
                try {
                    this.addClasses(classesToLoad, clr);
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034002", e));
                    illegalState = true;
                }
            }
            finally {
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
                if (illegalState) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("034003"));
                    this.starter = null;
                }
            }
        }
        this.starterInitialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAutoStarter() {
        if (this.starter != null) {
            try {
                if (!this.starter.isOpen()) {
                    this.starter.open();
                }
                this.starter.deleteAllClasses();
            }
            finally {
                if (this.starter.isOpen()) {
                    this.starter.close();
                }
            }
        }
    }

    @Override
    public boolean managesClass(String className) {
        return this.storeDataMgr.managesClass(className);
    }

    @Override
    public void addClass(String className, ClassLoaderResolver clr) {
        this.addClasses(new String[]{className}, clr);
    }

    @Override
    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (ClassMetaData classMetaData : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (classMetaData.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || this.storeDataMgr.managesClass(classMetaData.getFullClassName())) continue;
            this.registerStoreData(this.newStoreData(classMetaData, clr));
        }
    }

    protected StoreData newStoreData(ClassMetaData cmd, ClassLoaderResolver clr) {
        return new StoreData(cmd.getFullClassName(), cmd, 1, null);
    }

    @Override
    public void removeAllClasses(ClassLoaderResolver clr) {
    }

    @Override
    public String manageClassForIdentity(Object id, ClassLoaderResolver clr) {
        String className = null;
        if (id instanceof OID) {
            className = ((OID)id).getPcClass();
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd.getIdentityType() != IdentityType.DATASTORE) {
                throw new NucleusUserException(LOCALISER.msg("038001", id, (Object)cmd.getFullClassName()));
            }
        } else if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            className = this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id);
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName())) {
                throw new NucleusUserException(LOCALISER.msg("038001", id, (Object)cmd.getFullClassName()));
            }
        } else {
            throw new NucleusException("StoreManager.manageClassForIdentity called for id=" + id + " yet should only be called for datastore-identity/SingleFieldIdentity");
        }
        if (!this.managesClass(className)) {
            this.addClass(className, clr);
        }
        return className;
    }

    @Override
    public Extent getExtent(ExecutionContext ec, Class c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, ec.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        if (!this.managesClass(c.getName())) {
            this.addClass(c.getName(), ec.getClassLoaderResolver());
        }
        return new DefaultCandidateExtent(ec, c, subclasses, cmd);
    }

    @Override
    public boolean supportsQueryLanguage(String language) {
        if (language == null) {
            return false;
        }
        String name = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.store_query_query", new String[]{"name", "datastore"}, new String[]{language, this.storeManagerKey}, "name");
        return name != null;
    }

    @Override
    public boolean supportsValueStrategy(String strategy) {
        ConfigurationElement elem = this.nucleusContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategy, "true"});
        if (elem != null) {
            return true;
        }
        elem = this.nucleusContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategy, this.storeManagerKey});
        return elem != null;
    }

    @Override
    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        Iterator<AbstractClassMetaData> iter;
        if (id == null) {
            return null;
        }
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        if (id instanceof OID) {
            return ((OID)id).getPcClass();
        }
        if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            return this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id);
        }
        Collection<AbstractClassMetaData> cmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName());
        if (cmds != null && (iter = cmds.iterator()).hasNext()) {
            AbstractClassMetaData cmd = iter.next();
            return cmd.getFullClassName();
        }
        return null;
    }

    @Override
    public boolean isStrategyDatastoreAttributed(AbstractClassMetaData cmd, int absFieldNumber) {
        if (absFieldNumber < 0) {
            if (cmd.isEmbeddedOnly()) {
                return false;
            }
            IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
            if (idmd == null) {
                String strategy = this.getStrategyForNative(cmd, absFieldNumber);
                if (strategy.equalsIgnoreCase("identity")) {
                    return true;
                }
            } else {
                String strategy;
                IdentityStrategy idStrategy = idmd.getValueStrategy();
                if (idStrategy == IdentityStrategy.IDENTITY) {
                    return true;
                }
                if (idStrategy == IdentityStrategy.NATIVE && (strategy = this.getStrategyForNative(cmd, absFieldNumber)).equalsIgnoreCase("identity")) {
                    return true;
                }
            }
        } else {
            String strategy;
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNumber);
            if (mmd.getValueStrategy() == null) {
                return false;
            }
            if (mmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
                return true;
            }
            if (mmd.getValueStrategy() == IdentityStrategy.NATIVE && (strategy = this.getStrategyForNative(cmd, absFieldNumber)).equalsIgnoreCase("identity")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getStrategyValue(ExecutionContext ec, AbstractClassMetaData cmd, int absoluteFieldNumber) {
        AbstractMemberMetaData mmd = null;
        String fieldName = null;
        IdentityStrategy strategy = null;
        String sequence = null;
        String valueGeneratorName = null;
        TableGeneratorMetaData tableGeneratorMetaData = null;
        SequenceMetaData sequenceMetaData = null;
        if (absoluteFieldNumber >= 0) {
            mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            fieldName = mmd.getFullFieldName();
            strategy = mmd.getValueStrategy();
            sequence = mmd.getSequence();
            valueGeneratorName = mmd.getValueGeneratorName();
        } else {
            fieldName = cmd.getFullClassName() + " (datastore id)";
            strategy = cmd.getIdentityMetaData().getValueStrategy();
            sequence = cmd.getIdentityMetaData().getSequence();
            valueGeneratorName = cmd.getIdentityMetaData().getValueGeneratorName();
        }
        if (valueGeneratorName != null) {
            if (strategy == IdentityStrategy.INCREMENT) {
                tableGeneratorMetaData = this.getMetaDataManager().getMetaDataForTableGenerator(ec.getClassLoaderResolver(), valueGeneratorName);
                if (tableGeneratorMetaData == null) {
                    throw new NucleusUserException(LOCALISER.msg("038005", (Object)fieldName, (Object)valueGeneratorName));
                }
            } else if (strategy == IdentityStrategy.SEQUENCE && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(ec.getClassLoaderResolver(), valueGeneratorName)) == null) {
                throw new NucleusUserException(LOCALISER.msg("038006", (Object)fieldName, (Object)valueGeneratorName));
            }
        } else if (strategy == IdentityStrategy.SEQUENCE && sequence != null && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(ec.getClassLoaderResolver(), sequence)) == null) {
            NucleusLogger.VALUEGENERATION.warn("Field " + fieldName + " has been specified to use sequence " + sequence + " but there is no <sequence> specified in the MetaData. " + "Falling back to use a sequence in the datastore with this name directly.");
        }
        String strategyName = strategy.toString();
        if (strategy.equals(IdentityStrategy.CUSTOM)) {
            strategyName = strategy.getCustomName();
        } else if (strategy.equals(IdentityStrategy.NATIVE)) {
            strategyName = this.getStrategyForNative(cmd, absoluteFieldNumber);
        }
        String generatorName = null;
        String generatorNameKeyInManager = null;
        ConfigurationElement elem = this.nucleusContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategyName, "true"});
        if (elem != null) {
            generatorNameKeyInManager = generatorName = elem.getAttribute("name");
        } else {
            elem = this.nucleusContext.getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeManagerKey});
            if (elem != null) {
                generatorName = elem.getAttribute("name");
            }
        }
        if (generatorNameKeyInManager == null) {
            generatorNameKeyInManager = absoluteFieldNumber >= 0 ? mmd.getFullFieldName() : cmd.getBaseAbstractClassMetaData().getFullClassName();
        }
        ValueGenerator generator = null;
        AbstractStoreManager abstractStoreManager = this;
        synchronized (abstractStoreManager) {
            generator = this.getValueGenerationManager().getValueGenerator(generatorNameKeyInManager);
            if (generator == null) {
                if (generatorName == null) {
                    throw new NucleusUserException(LOCALISER.msg("038004", strategy));
                }
                Properties props = this.getPropertiesForGenerator(cmd, absoluteFieldNumber, ec, sequenceMetaData, tableGeneratorMetaData);
                Class cls = null;
                if (elem != null) {
                    cls = this.nucleusContext.getPluginManager().loadClass(elem.getExtension().getPlugin().getSymbolicName(), elem.getAttribute("class-name"));
                }
                if (cls == null) {
                    throw new NucleusException("Cannot create Value Generator for strategy " + generatorName);
                }
                generator = this.getValueGenerationManager().createValueGenerator(generatorNameKeyInManager, cls, props, this, null);
            }
        }
        Object oid = this.getStrategyValueForGenerator(generator, ec);
        if (mmd != null) {
            try {
                Object convertedValue = TypeConversionHelper.convertTo(oid, mmd.getType());
                if (convertedValue == null) {
                    throw new NucleusException(LOCALISER.msg("038003", (Object)mmd.getFullFieldName(), oid)).setFatal();
                }
                oid = convertedValue;
            }
            catch (NumberFormatException nfe) {
                throw new NucleusUserException("Value strategy created value=" + oid + " type=" + oid.getClass().getName() + " but field is of type " + mmd.getTypeName() + ". Use a different strategy or change the type of the field " + mmd.getFullFieldName());
            }
        }
        if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
            NucleusLogger.VALUEGENERATION.debug(LOCALISER.msg("038002", (Object)fieldName, (Object)strategy, (Object)generator.getClass().getName(), oid));
        }
        return oid;
    }

    protected String getStrategyForNative(AbstractClassMetaData cmd, int absFieldNumber) {
        String jdbcType;
        if (absFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNumber);
            Class type = mmd.getType();
            if (String.class.isAssignableFrom(type)) {
                return "uuid-hex";
            }
            if (type == Long.class || type == Integer.class || type == Short.class || type == Long.TYPE || type == Integer.TYPE || type == Short.TYPE) {
                if (this.supportsValueStrategy("identity")) {
                    return "identity";
                }
                if (this.supportsValueStrategy("sequence") && mmd.getSequence() != null) {
                    return "sequence";
                }
                if (this.supportsValueStrategy("increment")) {
                    return "increment";
                }
                throw new NucleusUserException("This datastore provider doesn't support numeric native strategy for member " + mmd.getFullFieldName());
            }
            throw new NucleusUserException("This datastore provider doesn't support native strategy for field of type " + type.getName());
        }
        IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
        if (idmd != null && idmd.getColumnMetaData() != null && MetaDataUtils.isJdbcTypeString(jdbcType = idmd.getColumnMetaData().getJdbcType())) {
            return "uuid-hex";
        }
        if (this.supportsValueStrategy("identity")) {
            return "identity";
        }
        if (this.supportsValueStrategy("sequence") && idmd.getSequence() != null) {
            return "sequence";
        }
        if (this.supportsValueStrategy("increment")) {
            return "increment";
        }
        throw new NucleusUserException("This datastore provider doesn't support numeric native strategy for class " + cmd.getFullClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getStrategyValueForGenerator(ValueGenerator generator, final ExecutionContext ec) {
        Object oid = null;
        ValueGenerator valueGenerator = generator;
        synchronized (valueGenerator) {
            if (generator instanceof AbstractDatastoreGenerator) {
                ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
                    ManagedConnection mconn;

                    public ManagedConnection retrieveConnection() {
                        this.mconn = AbstractStoreManager.this.getConnection(ec);
                        return this.mconn;
                    }

                    public void releaseConnection() {
                        this.mconn.release();
                        this.mconn = null;
                    }
                };
                ((AbstractDatastoreGenerator)generator).setConnectionProvider(connProvider);
            }
            oid = generator.next();
        }
        return oid;
    }

    protected Properties getPropertiesForGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ExecutionContext ec, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        Properties properties = new Properties();
        AbstractMemberMetaData mmd = null;
        IdentityStrategy strategy = null;
        String sequence = null;
        ExtensionMetaData[] extensions = null;
        if (absoluteFieldNumber >= 0) {
            mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            strategy = mmd.getValueStrategy();
            sequence = mmd.getSequence();
            extensions = mmd.getExtensions();
        } else {
            IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
            strategy = idmd.getValueStrategy();
            sequence = idmd.getSequence();
            extensions = idmd.getExtensions();
        }
        properties.setProperty("class-name", cmd.getFullClassName());
        properties.put("root-class-name", cmd.getBaseAbstractClassMetaData().getFullClassName());
        if (mmd != null) {
            properties.setProperty("field-name", mmd.getFullFieldName());
        }
        if (sequence != null) {
            properties.setProperty("sequence-name", sequence);
        }
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                properties.put(extensions[i].getKey(), extensions[i].getValue());
            }
        }
        if (strategy == IdentityStrategy.INCREMENT && tablegenmd != null) {
            properties.put("key-initial-value", "" + tablegenmd.getInitialValue());
            properties.put("key-cache-size", "" + tablegenmd.getAllocationSize());
            if (tablegenmd.getTableName() != null) {
                properties.put("sequence-table-name", tablegenmd.getTableName());
            }
            if (tablegenmd.getCatalogName() != null) {
                properties.put("sequence-catalog-name", tablegenmd.getCatalogName());
            }
            if (tablegenmd.getSchemaName() != null) {
                properties.put("sequence-schema-name", tablegenmd.getSchemaName());
            }
            if (tablegenmd.getPKColumnName() != null) {
                properties.put("sequence-name-column-name", tablegenmd.getPKColumnName());
            }
            if (tablegenmd.getPKColumnName() != null) {
                properties.put("sequence-nextval-column-name", tablegenmd.getValueColumnName());
            }
            if (tablegenmd.getPKColumnValue() != null) {
                properties.put("sequence-name", tablegenmd.getPKColumnValue());
            }
        } else if (strategy == IdentityStrategy.INCREMENT && tablegenmd == null) {
            if (!properties.containsKey("key-cache-size")) {
                int allocSize = this.getIntProperty("datanucleus.valuegeneration.increment.allocationSize");
                properties.put("key-cache-size", "" + allocSize);
            }
        } else if (strategy == IdentityStrategy.SEQUENCE && seqmd != null && seqmd.getDatastoreSequence() != null) {
            if (seqmd.getInitialValue() >= 0) {
                properties.put("key-initial-value", "" + seqmd.getInitialValue());
            }
            if (seqmd.getAllocationSize() > 0) {
                properties.put("key-cache-size", "" + seqmd.getAllocationSize());
            } else {
                int allocSize = this.getIntProperty("datanucleus.valuegeneration.sequence.allocationSize");
                properties.put("key-cache-size", "" + allocSize);
            }
            properties.put("sequence-name", "" + seqmd.getDatastoreSequence());
            ExtensionMetaData[] seqExtensions = seqmd.getExtensions();
            if (seqExtensions != null) {
                for (int i = 0; i < seqExtensions.length; ++i) {
                    properties.put(seqExtensions[i].getKey(), seqExtensions[i].getValue());
                }
            }
        }
        return properties;
    }

    @Override
    public HashSet<String> getSubClassesForClass(String className, boolean includeDescendents, ClassLoaderResolver clr) {
        HashSet<String> subclasses = new HashSet<String>();
        String[] subclassNames = this.getMetaDataManager().getSubclassesForClass(className, includeDescendents);
        if (subclassNames != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                if (!this.storeDataMgr.managesClass(subclassNames[i])) {
                    this.addClass(subclassNames[i], clr);
                }
                subclasses.add(subclassNames[i]);
            }
        }
        return subclasses;
    }

    @Override
    public Collection<String> getSupportedOptions() {
        return Collections.EMPTY_SET;
    }

    public void assertReadOnlyForUpdateOfObject(ObjectProvider op) {
        boolean readonly;
        String value;
        if (this.readOnlyDatastore) {
            if (this.getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(LOCALISER.msg("032004", (Object)op.toPrintableID()), op.getExecutionContext().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("032005", (Object)op.toPrintableID()));
            }
            return;
        }
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.hasExtension("read-only") && !StringUtils.isWhitespace(value = cmd.getValueForExtension("read-only")) && (readonly = Boolean.valueOf(value).booleanValue())) {
            if (this.getStringProperty("datanucleus.readOnlyDatastoreAction").equalsIgnoreCase("EXCEPTION")) {
                throw new DatastoreReadOnlyException(LOCALISER.msg("032006", (Object)op.toPrintableID()), op.getExecutionContext().getClassLoaderResolver());
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("032007", (Object)op.toPrintableID()));
            }
            return;
        }
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getProperty(name);
        }
        return this.nucleusContext.getPersistenceConfiguration().getProperty(name);
    }

    @Override
    public int getIntProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getIntProperty(name);
        }
        return this.nucleusContext.getPersistenceConfiguration().getIntProperty(name);
    }

    @Override
    public String getStringProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getStringProperty(name);
        }
        return this.nucleusContext.getPersistenceConfiguration().getStringProperty(name);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getBooleanProperty(name);
        }
        return this.nucleusContext.getPersistenceConfiguration().getBooleanProperty(name);
    }

    @Override
    public boolean getBooleanProperty(String name, boolean resultIfNotSet) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getBooleanProperty(name, resultIfNotSet);
        }
        return this.nucleusContext.getPersistenceConfiguration().getBooleanProperty(name, resultIfNotSet);
    }

    @Override
    public Boolean getBooleanObjectProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return super.getBooleanObjectProperty(name);
        }
        return this.nucleusContext.getPersistenceConfiguration().getBooleanObjectProperty(name);
    }

    @Override
    public void transactionStarted(ExecutionContext ec) {
    }

    @Override
    public void transactionCommitted(ExecutionContext ec) {
    }

    @Override
    public void transactionRolledBack(ExecutionContext ec) {
    }

    @Override
    public boolean usesBackedSCOWrappers() {
        return false;
    }
}

