/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped;

import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.DuplicateDatastoreFieldException;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.util.Localiser;

public final class ColumnCreator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);

    private ColumnCreator() {
    }

    public static DatastoreField createIndexColumn(JavaTypeMapping mapping, MappedStoreManager storeMgr, ClassLoaderResolver clr, DatastoreContainerObject table, ColumnMetaData colmd, boolean pk) {
        DatastoreIdentifier identifier = null;
        identifier = colmd != null && colmd.getName() != null ? storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colmd.getName()) : storeMgr.getIdentifierFactory().newAdapterIndexFieldIdentifier();
        DatastoreField column = table.addDatastoreField(mapping.getType(), identifier, mapping, colmd);
        storeMgr.getMappingManager().createDatastoreMapping(mapping, column, mapping.getJavaType().getName());
        if (pk) {
            column.setAsPrimaryKey();
        }
        return column;
    }

    public static JavaTypeMapping createColumnsForJoinTables(Class javaType, AbstractMemberMetaData mmd, ColumnMetaData[] columnMetaData, MappedStoreManager storeMgr, DatastoreContainerObject table, boolean primaryKey, boolean nullable, int fieldRole, ClassLoaderResolver clr) {
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMapping(javaType, false, false, mmd.getFullFieldName());
        mapping.setDatastoreContainer(table);
        ColumnCreator.createColumnsForField(javaType, mapping, table, storeMgr, mmd, primaryKey, nullable, false, false, fieldRole, columnMetaData, clr, false);
        return mapping;
    }

    public static JavaTypeMapping createColumnsForField(Class javaType, JavaTypeMapping mapping, DatastoreContainerObject table, MappedStoreManager storeMgr, AbstractMemberMetaData mmd, boolean isPrimaryKey, boolean isNullable, boolean serialised, boolean embedded, int fieldRole, ColumnMetaData[] columnMetaData, ClassLoaderResolver clr, boolean isReferenceField) {
        IdentifierFactory idFactory = storeMgr.getIdentifierFactory();
        if (mapping instanceof ReferenceMapping || mapping instanceof PersistableMapping) {
            DatastoreClass destinationTable;
            JavaTypeMapping container = mapping;
            if (mapping instanceof ReferenceMapping) {
                container = storeMgr.getMappingManager().getMapping(javaType, serialised, embedded, mmd != null ? mmd.getFullFieldName() : null);
                ((ReferenceMapping)mapping).addJavaTypeMapping(container);
            }
            if ((destinationTable = storeMgr.getDatastoreClass(javaType.getName(), clr)) == null) {
                AbstractClassMetaData ownerCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(javaType, clr);
                AbstractClassMetaData[] ownerCmds = storeMgr.getClassesManagingTableForClass(ownerCmd, clr);
                if (ownerCmds == null || ownerCmds.length == 0) {
                    throw new NucleusUserException(LOCALISER.msg("057023", (Object)javaType.getName())).setFatal();
                }
                destinationTable = storeMgr.getDatastoreClass(ownerCmds[0].getFullClassName(), clr);
            }
            if (destinationTable != null) {
                JavaTypeMapping m = destinationTable.getIdMapping();
                ColumnMetaDataContainer columnContainer = null;
                if (columnMetaData != null && columnMetaData.length > 0) {
                    columnContainer = (ColumnMetaDataContainer)((Object)columnMetaData[0].getParent());
                }
                CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper(columnContainer, columnMetaData, m, true);
                for (int i = 0; i < m.getNumberOfDatastoreMappings(); ++i) {
                    JavaTypeMapping refDatastoreMapping = storeMgr.getMappingManager().getMapping(m.getDatastoreMapping(i).getJavaTypeMapping().getJavaType());
                    ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(m.getDatastoreMapping(i).getDatastoreField().getIdentifier());
                    try {
                        AbstractMemberMetaData[] relatedMmds;
                        DatastoreIdentifier identifier = null;
                        identifier = colmd.getName() == null ? (isReferenceField ? idFactory.newReferenceFieldIdentifier(mmd, storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(javaType, clr), m.getDatastoreMapping(i).getDatastoreField().getIdentifier(), storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole) : idFactory.newJoinTableFieldIdentifier(mmd, (relatedMmds = mmd.getRelatedMemberMetaData(clr)) != null ? relatedMmds[0] : null, m.getDatastoreMapping(i).getDatastoreField().getIdentifier(), storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole)) : idFactory.newDatastoreFieldIdentifier(colmd.getName());
                        DatastoreField column = table.addDatastoreField(javaType.getName(), identifier, refDatastoreMapping, colmd);
                        m.getDatastoreMapping(i).getDatastoreField().copyConfigurationTo(column);
                        if (isPrimaryKey) {
                            column.setAsPrimaryKey();
                        }
                        if (isNullable) {
                            column.setNullable();
                        }
                        storeMgr.getMappingManager().createDatastoreMapping(refDatastoreMapping, column, m.getDatastoreMapping(i).getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                    }
                    catch (DuplicateDatastoreFieldException ex) {
                        throw new NucleusUserException("Cannot create column for field " + mmd.getFullFieldName() + " column metadata " + colmd, ex);
                    }
                    ((PersistableMapping)container).addJavaTypeMapping(refDatastoreMapping);
                }
            }
        } else {
            DatastoreField column = null;
            ColumnMetaData colmd = null;
            if (columnMetaData != null && columnMetaData.length > 0) {
                colmd = columnMetaData[0];
            }
            DatastoreIdentifier identifier = null;
            identifier = colmd != null && colmd.getName() != null ? idFactory.newDatastoreFieldIdentifier(colmd.getName()) : idFactory.newJoinTableFieldIdentifier(mmd, null, null, storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(javaType), fieldRole);
            column = table.addDatastoreField(javaType.getName(), identifier, mapping, colmd);
            storeMgr.getMappingManager().createDatastoreMapping(mapping, column, mapping.getJavaTypeForDatastoreMapping(0));
            if (isNullable) {
                column.setNullable();
            }
        }
        return mapping;
    }
}

