/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import org.datanucleus.metadata.AbstractConstraintMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.util.StringUtils;

public class UniqueMetaData
extends AbstractConstraintMetaData
implements ColumnMetaDataContainer {
    boolean deferred = false;

    public UniqueMetaData(UniqueMetaData umd) {
        super(umd);
        int i;
        this.name = umd.name;
        this.table = umd.table;
        this.deferred = umd.deferred;
        for (i = 0; i < umd.members.size(); ++i) {
            this.addMember((AbstractMemberMetaData)umd.members.get(i));
        }
        for (i = 0; i < umd.columns.size(); ++i) {
            this.addColumn((ColumnMetaData)umd.columns.get(i));
        }
    }

    public UniqueMetaData() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.isWhitespace(name) ? null : name;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = StringUtils.isWhitespace(table) ? null : table;
    }

    public final boolean isDeferred() {
        return this.deferred;
    }

    public UniqueMetaData setDeferred(boolean deferred) {
        this.deferred = deferred;
        return this;
    }

    public UniqueMetaData setDeferred(String deferred) {
        if (!StringUtils.isWhitespace(deferred)) {
            this.deferred = Boolean.parseBoolean(deferred);
        }
        return this;
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<unique");
        if (this.table != null) {
            sb.append(" table=\"" + this.table + "\"");
        }
        if (this.deferred) {
            sb.append(" deferred=\"true\"");
        }
        sb.append(this.name != null ? " name=\"" + this.name + "\">\n" : ">\n");
        if (this.memberMetaData != null) {
            for (i = 0; i < this.memberMetaData.length; ++i) {
                sb.append(this.memberMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.columnMetaData != null) {
            for (i = 0; i < this.columnMetaData.length; ++i) {
                sb.append(this.columnMetaData[i].toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</unique>\n");
        return sb.toString();
    }
}

