/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.sco.SCO;

public class PersistFieldManager
extends AbstractFieldManager {
    private final ObjectProvider sm;
    private final boolean replaceSCOsWithWrappers;

    public PersistFieldManager(ObjectProvider sm, boolean replaceSCOsWithWrappers) {
        this.sm = sm;
        this.replaceSCOsWithWrappers = replaceSCOsWithWrappers;
    }

    protected Object processPersistable(Object pc, int ownerFieldNum, int objectType) {
        ApiAdapter adapter = this.sm.getExecutionContext().getApiAdapter();
        if (!adapter.isPersistent(pc) || adapter.isPersistent(pc) && adapter.isDeleted(pc)) {
            if (objectType != 0) {
                return this.sm.getExecutionContext().persistObjectInternal(pc, this.sm, ownerFieldNum, objectType);
            }
            return this.sm.getExecutionContext().persistObjectInternal(pc, null, -1, objectType);
        }
        return pc;
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (value != null) {
            boolean[] secondClassMutableFieldFlags;
            AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            boolean persistCascade = mmd.isCascadePersist();
            ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
            ClassLoaderResolver clr = this.sm.getExecutionContext().getClassLoaderResolver();
            int relationType = mmd.getRelationType(clr);
            if (this.replaceSCOsWithWrappers && (secondClassMutableFieldFlags = this.sm.getClassMetaData().getSCOMutableMemberFlags())[fieldNumber] && !(value instanceof SCO)) {
                value = this.sm.wrapSCOField(fieldNumber, value, false, true, true);
            }
            if (persistCascade) {
                switch (relationType) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        if (!api.isPersistable(value)) break;
                        if (mmd.isEmbedded() || mmd.isSerialized()) {
                            this.processPersistable(value, fieldNumber, 1);
                            break;
                        }
                        this.processPersistable(value, -1, 0);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (mmd.hasCollection()) {
                            Collection coll = (Collection)value;
                            Iterator iter = coll.iterator();
                            int position = 0;
                            while (iter.hasNext()) {
                                Object element = iter.next();
                                if (api.isPersistable(element)) {
                                    if (mmd.getCollection().isEmbeddedElement() || mmd.getCollection().isSerializedElement()) {
                                        this.processPersistable(element, fieldNumber, 2);
                                    } else {
                                        Object newElement = this.processPersistable(element, -1, 0);
                                        ObjectProvider elementSM = this.sm.getExecutionContext().findObjectProvider(newElement);
                                        if (elementSM.getReferencedPC() != null) {
                                            if (coll instanceof List) {
                                                ((List)coll).set(position, newElement);
                                            } else {
                                                coll.remove(element);
                                                coll.add(newElement);
                                            }
                                        }
                                    }
                                }
                                ++position;
                            }
                        } else if (mmd.hasMap()) {
                            Map map = (Map)value;
                            for (Map.Entry entry : map.entrySet()) {
                                ObjectProvider valSM;
                                ObjectProvider keySM;
                                Object mapKey = entry.getKey();
                                Object mapValue = entry.getValue();
                                Object newMapKey = mapKey;
                                Object newMapValue = mapValue;
                                if (api.isPersistable(mapKey)) {
                                    if (mmd.getMap().isEmbeddedKey() || mmd.getMap().isSerializedKey()) {
                                        this.processPersistable(mapKey, fieldNumber, 3);
                                    } else {
                                        newMapKey = this.processPersistable(mapKey, -1, 0);
                                    }
                                }
                                if (api.isPersistable(mapValue)) {
                                    if (mmd.getMap().isEmbeddedValue() || mmd.getMap().isSerializedValue()) {
                                        this.processPersistable(mapValue, fieldNumber, 4);
                                    } else {
                                        newMapValue = this.processPersistable(mapValue, -1, 0);
                                    }
                                }
                                if (newMapKey == mapKey && newMapValue == mapValue) continue;
                                boolean updateKey = false;
                                boolean updateValue = false;
                                if (newMapKey != mapKey && (keySM = this.sm.getExecutionContext().findObjectProvider(newMapKey)).getReferencedPC() != null) {
                                    updateKey = true;
                                }
                                if (newMapValue != mapValue && (valSM = this.sm.getExecutionContext().findObjectProvider(newMapValue)).getReferencedPC() != null) {
                                    updateValue = true;
                                }
                                if (updateKey) {
                                    map.remove(mapKey);
                                    map.put(newMapKey, updateValue ? newMapValue : mapValue);
                                    continue;
                                }
                                if (!updateValue) continue;
                                map.put(mapKey, newMapValue);
                            }
                        } else {
                            if (!mmd.hasArray() || !(value instanceof Object[])) break;
                            Object[] array = (Object[])value;
                            for (int i = 0; i < array.length; ++i) {
                                Object element = array[i];
                                if (!api.isPersistable(element)) continue;
                                if (mmd.getArray().isEmbeddedElement() || mmd.getArray().isSerializedElement()) {
                                    this.processPersistable(element, fieldNumber, 2);
                                    continue;
                                }
                                Object processedElement = this.processPersistable(element, -1, 0);
                                ObjectProvider elementSM = this.sm.getExecutionContext().findObjectProvider(processedElement);
                                if (elementSM.getReferencedPC() == null) continue;
                                array[i] = processedElement;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeStringField(int fieldNumber, String value) {
    }
}

