/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.mapping.BigIntegerMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.ShortMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public abstract class EmbeddedMapping
extends SingleFieldMapping {
    protected List<JavaTypeMapping> javaTypeMappings;
    protected ClassLoaderResolver clr;
    protected EmbeddedMetaData emd;
    protected String typeName;
    protected short objectType = (short)-1;
    protected AbstractClassMetaData embCmd = null;

    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        throw new NucleusException("subclass must override this method").setFatal();
    }

    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject datastoreContainer, ClassLoaderResolver clr, EmbeddedMetaData emd, String typeName, int objectType) {
        super.initialize(fmd, datastoreContainer, clr);
        this.clr = clr;
        this.emd = emd;
        this.typeName = typeName;
        this.objectType = (short)objectType;
        MetaDataManager mmgr = datastoreContainer.getStoreManager().getMetaDataManager();
        AbstractClassMetaData pcCmd = mmgr.getMetaDataForClass(typeName, clr);
        if (pcCmd == null) {
            if (fmd != null) {
                String[] fieldTypes = fmd.getFieldTypes();
                if (fieldTypes != null && fieldTypes.length == 1) {
                    pcCmd = mmgr.getMetaDataForClass(fieldTypes[0], clr);
                } else if (fieldTypes != null && fieldTypes.length > 1) {
                    throw new NucleusUserException("Field " + fmd.getFullFieldName() + " is a reference field that is embedded. " + "DataNucleus doesnt support embedded reference fields that have more than 1 implementation");
                }
            }
            if (pcCmd == null && (pcCmd = mmgr.getMetaDataForInterface(clr.classForName(typeName), clr)) == null && fmd.getFieldTypes() != null && fmd.getFieldTypes().length == 1) {
                pcCmd = mmgr.getMetaDataForInterface(clr.classForName(fmd.getFieldTypes()[0]), clr);
            }
        }
        this.embCmd = pcCmd;
        AbstractMemberMetaData[] embFmds = emd == null && pcCmd.isEmbeddedOnly() ? pcCmd.getManagedMembers() : emd.getMemberMetaData();
        int[] pcFieldNumbers = pcCmd.getAllMemberPositions();
        for (int i = 0; i < pcFieldNumbers.length; ++i) {
            AbstractMemberMetaData pcFmd = pcCmd.getMetaDataForManagedMemberAtAbsolutePosition(pcFieldNumbers[i]);
            if (pcFmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || emd != null && emd.getOwnerMember() != null && emd.getOwnerMember().equals(pcFmd.getName())) continue;
            AbstractMemberMetaData embeddedFmd = null;
            for (int j = 0; j < embFmds.length; ++j) {
                if (embFmds[j] == null) {
                    throw new RuntimeException("embFmds[j] is null" + pcCmd.toString() + " type " + typeName);
                }
                if (pcCmd.getMetaDataForMember(embFmds[j].getName()) == null) {
                    throw new RuntimeException("pcCmd.getField(embFmds[j].getName()) is null" + pcCmd.toString() + " type " + typeName + " embFmds[j].getName() " + embFmds[j].getName());
                }
                if (pcCmd.getMetaDataForMember(embFmds[j].getName()).getAbsoluteFieldNumber() != pcFieldNumbers[i]) continue;
                embeddedFmd = embFmds[j];
                break;
            }
            MappingManager mapMgr = datastoreContainer.getStoreManager().getMappingManager();
            JavaTypeMapping embFmdMapping = embeddedFmd != null ? mapMgr.getMapping(datastoreContainer, embeddedFmd, clr, 2) : mapMgr.getMapping(datastoreContainer, pcFmd, clr, 2);
            this.addJavaTypeMapping(embFmdMapping);
            for (int j = 0; j < embFmdMapping.getNumberOfDatastoreMappings(); ++j) {
                DatastoreField datastoreFld;
                DatastoreMapping datastoreMapping = embFmdMapping.getDatastoreMapping(j);
                this.addDatastoreMapping(datastoreMapping);
                if (!fmd.isPrimaryKey() || (datastoreFld = datastoreMapping.getDatastoreField()) == null) continue;
                datastoreFld.setAsPrimaryKey();
            }
        }
    }

    protected void prepareDatastoreMapping() {
    }

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        if (this.javaTypeMappings == null) {
            this.javaTypeMappings = new ArrayList<JavaTypeMapping>();
        }
        if (mapping == null) {
            throw new NucleusException("mapping argument in EmbeddedMapping.addJavaTypeMapping is null").setFatal();
        }
        this.javaTypeMappings.add(mapping);
    }

    public int getNumberOfJavaTypeMappings() {
        return this.javaTypeMappings != null ? this.javaTypeMappings.size() : 0;
    }

    public JavaTypeMapping getJavaTypeMapping(int i) {
        if (this.javaTypeMappings == null) {
            return null;
        }
        return this.javaTypeMappings.get(i);
    }

    public JavaTypeMapping getJavaTypeMapping(String fieldName) {
        if (this.javaTypeMappings == null) {
            return null;
        }
        for (JavaTypeMapping m : this.javaTypeMappings) {
            if (!m.getMemberMetaData().getName().equals(fieldName)) continue;
            return m;
        }
        return null;
    }

    public void setObject(ExecutionContext ec, Object ps, int[] param, Object value) {
        this.setObject(ec, ps, param, value, null, -1);
    }

    public void setObject(ExecutionContext ec, Object ps, int[] param, Object value, ObjectProvider ownerSM, int ownerFieldNumber) {
        if (value == null) {
            int n = 0;
            String nullColumn = null;
            String nullValue = null;
            if (this.emd != null) {
                nullColumn = this.emd.getNullIndicatorColumn();
                nullValue = this.emd.getNullIndicatorValue();
            }
            for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
                JavaTypeMapping mapping = this.javaTypeMappings.get(i);
                int[] posMapping = new int[mapping.getNumberOfDatastoreMappings()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                if (nullColumn != null && nullValue != null && mapping.getMemberMetaData().getColumnMetaData().length > 0 && mapping.getMemberMetaData().getColumnMetaData()[0].getName().equals(nullColumn)) {
                    if (mapping instanceof IntegerMapping || mapping instanceof BigIntegerMapping || mapping instanceof LongMapping || mapping instanceof ShortMapping) {
                        Number convertedValue = null;
                        try {
                            if (mapping instanceof IntegerMapping || mapping instanceof ShortMapping) {
                                convertedValue = Integer.valueOf(nullValue);
                            } else if (mapping instanceof LongMapping || mapping instanceof BigIntegerMapping) {
                                convertedValue = Long.valueOf(nullValue);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        mapping.setObject(ec, ps, posMapping, convertedValue);
                        continue;
                    }
                    mapping.setObject(ec, ps, posMapping, nullValue);
                    continue;
                }
                if (mapping.getNumberOfDatastoreMappings() <= 0) continue;
                mapping.setObject(ec, ps, posMapping, null);
            }
        } else {
            ApiAdapter api = ec.getApiAdapter();
            if (!api.isPersistable(value)) {
                throw new NucleusException(LOCALISER.msg("041016", value.getClass(), value)).setFatal();
            }
            AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(value.getClass(), ec.getClassLoaderResolver());
            ObjectProvider embSM = ec.findObjectProvider(value);
            if (embSM == null || api.getExecutionContext(value) == null) {
                embSM = ObjectProviderFactory.newForEmbedded(ec, value, false, ownerSM, ownerFieldNumber);
                embSM.setPcObjectType(this.objectType);
            }
            int n = 0;
            for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
                JavaTypeMapping mapping = this.javaTypeMappings.get(i);
                int[] posMapping = new int[mapping.getNumberOfDatastoreMappings()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                int embAbsFieldNum = embCmd.getAbsolutePositionOfMember(mapping.getMemberMetaData().getName());
                Object fieldValue = embSM.provideField(embAbsFieldNum);
                if (mapping instanceof EmbeddedPCMapping) {
                    mapping.setObject(ec, ps, posMapping, fieldValue, embSM, embAbsFieldNum);
                    continue;
                }
                if (mapping.getNumberOfDatastoreMappings() <= 0) continue;
                mapping.setObject(ec, ps, posMapping, fieldValue);
            }
        }
    }

    public Object getObject(ExecutionContext ec, Object rs, int[] param) {
        return this.getObject(ec, rs, param, null, -1);
    }

    public Object getObject(ExecutionContext ec, Object rs, int[] param, ObjectProvider ownerSM, int ownerFieldNumber) {
        int ownerFieldNumberInElement;
        String ownerField;
        Object value = null;
        Class embeddedType = this.getJavaType();
        if (this.mmd.getFieldTypes() != null && this.mmd.getFieldTypes().length > 0) {
            embeddedType = ec.getClassLoaderResolver().classForName(this.mmd.getFieldTypes()[0]);
        }
        ObjectProvider embSM = ObjectProviderFactory.newForHollow(ec, embeddedType, null);
        embSM.setPcObjectType(this.objectType);
        value = embSM.getObject();
        String nullColumn = null;
        String nullValue = null;
        if (this.emd != null) {
            nullColumn = this.emd.getNullIndicatorColumn();
            nullValue = this.emd.getNullIndicatorValue();
        }
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings.get(i);
            int embAbsFieldNum = this.embCmd.getAbsolutePositionOfMember(mapping.getMemberMetaData().getName());
            if (mapping instanceof EmbeddedPCMapping) {
                int numSubParams = mapping.getNumberOfDatastoreMappings();
                int[] subParam = new int[numSubParams];
                int k = 0;
                for (int j = n; j < n + numSubParams; ++j) {
                    subParam[k++] = param[j];
                }
                n += numSubParams;
                Object subValue = mapping.getObject(ec, rs, subParam, embSM, embAbsFieldNum);
                if (subValue == null) continue;
                embSM.replaceField(embAbsFieldNum, subValue);
                continue;
            }
            int[] posMapping = new int[mapping.getNumberOfDatastoreMappings()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = param[n++];
            }
            Object fieldValue = mapping.getObject(ec, rs, posMapping);
            if (fieldValue != null) {
                embSM.replaceField(embAbsFieldNum, fieldValue);
            } else {
                AbstractMemberMetaData embFmd = this.embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embAbsFieldNum);
                if (!embFmd.getType().isPrimitive()) {
                    embSM.replaceField(embAbsFieldNum, fieldValue);
                }
            }
            if (nullColumn == null || !mapping.getMemberMetaData().getColumnMetaData()[0].getName().equals(nullColumn) || (nullValue != null || fieldValue != null) && (nullValue == null || !fieldValue.toString().equals(nullValue))) continue;
            value = null;
            break;
        }
        if (this.emd != null && (ownerField = this.emd.getOwnerMember()) != null && (ownerFieldNumberInElement = this.embCmd.getAbsolutePositionOfMember(ownerField)) >= 0) {
            embSM.replaceField(ownerFieldNumberInElement, ownerSM.getObject());
        }
        if (value != null && ownerSM != null) {
            embSM.addEmbeddedOwner(ownerSM, ownerFieldNumber);
        }
        return value;
    }

    public Class getJavaType() {
        return this.clr.classForName(this.typeName);
    }
}

