/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractQueryResultsCache
implements QueryResultsCache {
    HashSet<String> keysToPin = new HashSet();
    Map<String, List<Object>> pinnedCache = new HashMap<String, List<Object>>();
    Map<String, List<Object>> cache = null;
    private int maxSize = -1;
    private final NucleusContext nucCtx;

    public AbstractQueryResultsCache(NucleusContext nucleusCtx) {
        this.maxSize = nucleusCtx.getPersistenceConfiguration().getIntProperty("datanucleus.cache.queryResults.maxSize");
        this.nucCtx = nucleusCtx;
    }

    @Override
    public void close() {
        this.cache.clear();
        this.cache = null;
        this.pinnedCache.clear();
        this.pinnedCache = null;
    }

    @Override
    public boolean contains(String queryKey) {
        return this.cache.containsKey(queryKey);
    }

    @Override
    public void evict(Class candidate) {
        AbstractClassMetaData cmd = this.nucCtx.getMetaDataManager().getMetaDataForClass(candidate, this.nucCtx.getClassLoaderResolver(candidate.getClassLoader()));
        Iterator<String> iter = this.cache.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (key.matches("JDOQL:* FROM " + candidate.getName() + "*")) {
                NucleusLogger.GENERAL.info(">> Evicting query results for key=" + key);
                iter.remove();
                continue;
            }
            if (key.matches("JPQL:* FROM " + candidate.getName() + "*")) {
                NucleusLogger.GENERAL.info(">> Evicting query results for key=" + key);
                iter.remove();
                continue;
            }
            if (!key.matches("JPQL:* FROM " + cmd.getEntityName() + "*")) continue;
            NucleusLogger.GENERAL.info(">> Evicting query results for key=" + key);
            iter.remove();
        }
    }

    @Override
    public synchronized void evictAll() {
        this.cache.clear();
    }

    @Override
    public synchronized void evict(Query query) {
        String key;
        String baseKey = QueryUtils.getKeyForQueryResultsCache(query, null);
        Iterator<String> iter = this.cache.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            if (!key.startsWith(baseKey)) continue;
            iter.remove();
        }
        iter = this.pinnedCache.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            if (!key.startsWith(baseKey)) continue;
            iter.remove();
        }
    }

    @Override
    public synchronized void evict(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache(query, params);
        this.cache.remove(key);
        this.pinnedCache.remove(key);
    }

    @Override
    public void pin(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache(query, params);
        List<Object> results = this.cache.get(key);
        if (results != null) {
            this.keysToPin.add(key);
            this.pinnedCache.put(key, results);
            this.cache.remove(key);
        }
    }

    @Override
    public void pin(Query query) {
        String key = QueryUtils.getKeyForQueryResultsCache(query, null);
        List<Object> results = this.cache.get(key);
        if (results != null) {
            this.keysToPin.add(key);
            this.pinnedCache.put(key, results);
            this.cache.remove(key);
        }
    }

    @Override
    public void unpin(Query query, Map params) {
        String key = QueryUtils.getKeyForQueryResultsCache(query, params);
        List<Object> results = this.pinnedCache.get(key);
        if (results != null) {
            this.keysToPin.remove(key);
            this.cache.put(key, results);
            this.pinnedCache.remove(key);
        }
    }

    @Override
    public void unpin(Query query) {
        String key = QueryUtils.getKeyForQueryResultsCache(query, null);
        List<Object> results = this.pinnedCache.get(key);
        if (results != null) {
            this.keysToPin.remove(key);
            this.cache.put(key, results);
            this.pinnedCache.remove(key);
        }
    }

    @Override
    public List<Object> get(String queryKey) {
        if (this.pinnedCache.containsKey(queryKey)) {
            return this.pinnedCache.get(queryKey);
        }
        return this.cache.get(queryKey);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public synchronized List<Object> put(String queryKey, List<Object> results) {
        if (this.maxSize >= 0 && this.size() == this.maxSize) {
            return null;
        }
        if (this.keysToPin.contains(queryKey)) {
            return this.pinnedCache.put(queryKey, results);
        }
        return this.cache.put(queryKey, results);
    }

    @Override
    public int size() {
        return this.cache.size();
    }
}

