/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.awt.geom.Rectangle2D;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class Rectangle2dFloatMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(fmd, container, clr);
        this.addDatastoreFields();
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addDatastoreFields();
    }

    protected void addDatastoreFields() {
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return Rectangle2D.Float.class;
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        Rectangle2D.Float rect = (Rectangle2D.Float)value;
        if (index == 0) {
            return rect.getX();
        }
        if (index == 1) {
            return rect.getY();
        }
        if (index == 2) {
            return rect.getWidth();
        }
        if (index == 3) {
            return rect.getHeight();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        Rectangle2D.Float rectangle = (Rectangle2D.Float)value;
        if (rectangle == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDatastoreMapping(i).setObject(preparedStatement, exprIndex[i], null);
            }
        } else {
            this.getDatastoreMapping(0).setFloat(preparedStatement, exprIndex[0], rectangle.x);
            this.getDatastoreMapping(1).setFloat(preparedStatement, exprIndex[1], rectangle.y);
            this.getDatastoreMapping(2).setFloat(preparedStatement, exprIndex[2], rectangle.width);
            this.getDatastoreMapping(3).setFloat(preparedStatement, exprIndex[3], rectangle.height);
        }
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x = this.getDatastoreMapping(0).getFloat(resultSet, exprIndex[0]);
        float y = this.getDatastoreMapping(1).getFloat(resultSet, exprIndex[1]);
        float width = this.getDatastoreMapping(2).getFloat(resultSet, exprIndex[2]);
        float height = this.getDatastoreMapping(3).getFloat(resultSet, exprIndex[3]);
        return new Rectangle2D.Float(x, y, width, height);
    }
}

