/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.federation;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.management.runtime.StoreManagerRuntime;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.federation.FederatedPersistenceHandler;
import org.datanucleus.store.federation.FederatedQueryManager;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.store.valuegenerator.ValueGenerationManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.PersistenceUtils;

public class FederatedStoreManager
implements StoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    StoreManager primaryStoreMgr;
    Map<String, StoreManager> secondaryStoreMgrMap = null;
    final NucleusContext nucleusContext;
    protected StorePersistenceHandler persistenceHandler = null;
    private QueryManager queryMgr = null;

    public FederatedStoreManager(ClassLoaderResolver clr, NucleusContext nucleusContext) {
        Set<String> propNamesWithDatastore;
        String reqdIsolation;
        this.nucleusContext = nucleusContext;
        Map<String, Object> datastoreProps = nucleusContext.getPersistenceConfiguration().getDatastoreProperties();
        this.primaryStoreMgr = NucleusContext.createStoreManagerForProperties(nucleusContext.getPersistenceConfiguration().getPersistenceProperties(), datastoreProps, clr, nucleusContext);
        String transactionIsolation = nucleusContext.getPersistenceConfiguration().getStringProperty("datanucleus.transactionIsolation");
        if (transactionIsolation != null && !transactionIsolation.equalsIgnoreCase(reqdIsolation = NucleusContext.getTransactionIsolationForStoreManager(this.primaryStoreMgr, transactionIsolation))) {
            nucleusContext.getPersistenceConfiguration().setProperty("datanucleus.transactionIsolation", reqdIsolation);
        }
        if ((propNamesWithDatastore = nucleusContext.getPersistenceConfiguration().getPropertyNamesWithPrefix("datanucleus.datastore.")) != null) {
            this.secondaryStoreMgrMap = new HashMap<String, StoreManager>();
            for (String datastorePropName : propNamesWithDatastore) {
                String datastoreName = datastorePropName.substring("datanucleus.datastore.".length());
                String filename = nucleusContext.getPersistenceConfiguration().getStringProperty(datastorePropName);
                Properties fileProps = PersistenceUtils.setPropertiesUsingFile(filename);
                HashMap<String, Object> storeProps = new HashMap<String, Object>();
                for (Map.Entry<Object, Object> entry : fileProps.entrySet()) {
                    String filePropName = (String)entry.getKey();
                    storeProps.put(filePropName, entry.getValue());
                }
                StoreManager storeMgr = NucleusContext.createStoreManagerForProperties(nucleusContext.getPersistenceConfiguration().getPersistenceProperties(), storeProps, clr, nucleusContext);
                NucleusLogger.DATASTORE.info("Created StoreManager of type " + storeMgr.getClass().getName() + " for datastore " + datastoreName);
                this.secondaryStoreMgrMap.put(datastoreName, storeMgr);
            }
        }
        this.persistenceHandler = new FederatedPersistenceHandler(this);
    }

    public NucleusContext getNucleusContext() {
        return this.nucleusContext;
    }

    public void close() {
        this.primaryStoreMgr.close();
        this.primaryStoreMgr = null;
        if (this.secondaryStoreMgrMap != null) {
            for (String name : this.secondaryStoreMgrMap.keySet()) {
                StoreManager secStoreMgr = this.secondaryStoreMgrMap.get(name);
                secStoreMgr.close();
            }
            this.secondaryStoreMgrMap.clear();
            this.secondaryStoreMgrMap = null;
        }
        this.persistenceHandler.close();
        if (this.queryMgr != null) {
            this.queryMgr.close();
            this.queryMgr = null;
        }
    }

    public StoreManager getStoreManagerForClass(AbstractClassMetaData cmd) {
        if (cmd.hasExtension("datastore")) {
            String datastoreName = cmd.getValueForExtension("datastore");
            if (this.secondaryStoreMgrMap == null || !this.secondaryStoreMgrMap.containsKey(datastoreName)) {
                throw new NucleusUserException("Class " + cmd.getFullClassName() + " specified to persist to datastore " + datastoreName + " yet not defined");
            }
            return this.secondaryStoreMgrMap.get(datastoreName);
        }
        return this.primaryStoreMgr;
    }

    public StoreManager getStoreManagerForClass(String className, ClassLoaderResolver clr) {
        AbstractClassMetaData cmd = this.nucleusContext.getMetaDataManager().getMetaDataForClass(className, clr);
        return this.getStoreManagerForClass(cmd);
    }

    public void addClass(String className, ClassLoaderResolver clr) {
        this.getStoreManagerForClass(className, clr).addClass(className, clr);
    }

    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        this.primaryStoreMgr.addClasses(classNames, clr);
    }

    public ApiAdapter getApiAdapter() {
        return this.nucleusContext.getApiAdapter();
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        return this.primaryStoreMgr.getClassNameForObjectID(id, clr, ec);
    }

    public Date getDatastoreDate() {
        return this.primaryStoreMgr.getDatastoreDate();
    }

    public Extent getExtent(ExecutionContext ec, Class c, boolean subclasses) {
        return this.primaryStoreMgr.getExtent(ec, c, subclasses);
    }

    public NucleusConnection getNucleusConnection(ExecutionContext ec) {
        return this.primaryStoreMgr.getNucleusConnection(ec);
    }

    public NucleusSequence getNucleusSequence(ExecutionContext ec, SequenceMetaData seqmd) {
        return this.primaryStoreMgr.getNucleusSequence(ec, seqmd);
    }

    public StoreSchemaHandler getSchemaHandler() {
        return this.primaryStoreMgr.getSchemaHandler();
    }

    public StorePersistenceHandler getPersistenceHandler() {
        return this.persistenceHandler;
    }

    public QueryManager getQueryManager() {
        if (this.queryMgr == null) {
            this.queryMgr = new FederatedQueryManager(this.nucleusContext);
        }
        return this.queryMgr;
    }

    public ValueGenerationManager getValueGenerationManager() {
        return this.primaryStoreMgr.getValueGenerationManager();
    }

    public StoreManagerRuntime getRuntimeManager() {
        return this.primaryStoreMgr.getRuntimeManager();
    }

    public String getStoreManagerKey() {
        return this.primaryStoreMgr.getStoreManagerKey();
    }

    public String getQueryCacheKey() {
        return this.primaryStoreMgr.getQueryCacheKey();
    }

    public Object getStrategyValue(ExecutionContext ec, AbstractClassMetaData cmd, int absoluteFieldNumber) {
        return this.primaryStoreMgr.getStrategyValue(ec, cmd, absoluteFieldNumber);
    }

    public HashSet getSubClassesForClass(String className, boolean includeDescendents, ClassLoaderResolver clr) {
        return this.primaryStoreMgr.getSubClassesForClass(className, includeDescendents, clr);
    }

    public boolean isStrategyDatastoreAttributed(IdentityStrategy identityStrategy, boolean datastoreIdentityField) {
        return this.primaryStoreMgr.isStrategyDatastoreAttributed(identityStrategy, datastoreIdentityField);
    }

    public String manageClassForIdentity(Object id, ClassLoaderResolver clr) {
        return this.primaryStoreMgr.manageClassForIdentity(id, clr);
    }

    public boolean managesClass(String className) {
        return this.primaryStoreMgr.managesClass(className);
    }

    public void printInformation(String category, PrintStream ps) throws Exception {
        this.primaryStoreMgr.printInformation(category, ps);
    }

    public void removeAllClasses(ClassLoaderResolver clr) {
        this.primaryStoreMgr.removeAllClasses(clr);
    }

    public boolean supportsQueryLanguage(String language) {
        return this.primaryStoreMgr.supportsQueryLanguage(language);
    }

    public boolean supportsValueStrategy(String language) {
        return this.primaryStoreMgr.supportsValueStrategy(language);
    }

    public Collection getSupportedOptions() {
        return this.primaryStoreMgr.getSupportedOptions();
    }

    public ConnectionManager getConnectionManager() {
        return this.primaryStoreMgr.getConnectionManager();
    }

    public ManagedConnection getConnection(ExecutionContext ec) {
        return this.primaryStoreMgr.getConnection(ec);
    }

    public ManagedConnection getConnection(ExecutionContext ec, Map options) {
        return this.primaryStoreMgr.getConnection(ec, options);
    }

    public String getConnectionDriverName() {
        return this.primaryStoreMgr.getConnectionDriverName();
    }

    public String getConnectionURL() {
        return this.primaryStoreMgr.getConnectionURL();
    }

    public String getConnectionUserName() {
        return this.primaryStoreMgr.getConnectionUserName();
    }

    public String getConnectionPassword() {
        return this.primaryStoreMgr.getConnectionPassword();
    }

    public Object getConnectionFactory() {
        return this.primaryStoreMgr.getConnectionFactory();
    }

    public Object getConnectionFactory2() {
        return this.primaryStoreMgr.getConnectionFactory2();
    }

    public String getConnectionFactory2Name() {
        return this.primaryStoreMgr.getConnectionFactory2Name();
    }

    public String getConnectionFactoryName() {
        return this.primaryStoreMgr.getConnectionFactoryName();
    }

    public Object getProperty(String name) {
        return this.primaryStoreMgr.getProperty(name);
    }

    public boolean hasProperty(String name) {
        return this.primaryStoreMgr.hasProperty(name);
    }

    public int getIntProperty(String name) {
        return this.primaryStoreMgr.getIntProperty(name);
    }

    public boolean getBooleanProperty(String name) {
        return this.primaryStoreMgr.getBooleanProperty(name);
    }

    public boolean getBooleanProperty(String name, boolean resultIfNotSet) {
        return this.primaryStoreMgr.getBooleanProperty(name, resultIfNotSet);
    }

    public Boolean getBooleanObjectProperty(String name) {
        return this.primaryStoreMgr.getBooleanObjectProperty(name);
    }

    public String getStringProperty(String name) {
        return this.primaryStoreMgr.getStringProperty(name);
    }

    public void transactionStarted(ExecutionContext ec) {
        this.primaryStoreMgr.transactionStarted(ec);
    }

    public void transactionCommitted(ExecutionContext ec) {
        this.primaryStoreMgr.transactionCommitted(ec);
    }

    public void transactionRolledBack(ExecutionContext ec) {
        this.primaryStoreMgr.transactionRolledBack(ec);
    }

    public boolean isAutoCreateTables() {
        return this.primaryStoreMgr.isAutoCreateTables();
    }

    public boolean isAutoCreateConstraints() {
        return this.primaryStoreMgr.isAutoCreateConstraints();
    }

    public boolean isAutoCreateColumns() {
        return this.primaryStoreMgr.isAutoCreateColumns();
    }
}

