/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.ObjectManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityReference;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.Relation;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.JDOStateManagerImpl;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.StateManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectReferencingStoreManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.SingleTypeFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.store.types.sco.SCOContainer;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractStateManager
implements javax.jdo.spi.StateManager,
StateManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected static final SingleTypeFieldManager HOLLOWFIELDMANAGER = new SingleTypeFieldManager();
    protected static final int FLAG_STORING_PC = 65536;
    protected static final int FLAG_NEED_INHERITANCE_VALIDATION = 32768;
    protected static final int FLAG_POSTINSERT_UPDATE = 16384;
    protected static final int FLAG_LOADINGFPFIELDS = 8192;
    protected static final int FLAG_POSTLOAD_PENDING = 4096;
    protected static final int FLAG_CHANGING_STATE = 2048;
    protected static final int FLAG_FLUSHED_NEW = 1024;
    protected static final int FLAG_BECOMING_DELETED = 512;
    protected static final int FLAG_UPDATING_EMBEDDING_FIELDS_WITH_OWNER = 256;
    protected static final int FLAG_RETRIEVING_DETACHED_STATE = 128;
    protected static final int FLAG_RESETTING_DETACHED_STATE = 64;
    protected static final int FLAG_ATTACHING = 32;
    protected static final int FLAG_DETACHING = 16;
    protected static final int FLAG_MAKING_TRANSIENT = 8;
    protected static final int FLAG_FLUSHING = 4;
    protected static final int FLAG_DISCONNECTING = 2;
    protected int flags;
    protected byte jdoDfgFlags;
    protected ObjectManager myOM;
    protected PersistenceCapable myPC;
    protected AbstractClassMetaData cmd;
    protected Object myInternalID;
    protected Object myID;
    protected LifeCycleState myLC;
    protected Object myVersion;
    protected Object transactionalVersion;
    protected FetchPlanForClass myFP;
    protected boolean dirty = false;
    protected boolean[] dirtyFields;
    protected boolean[] loadedFields;
    protected boolean restoreValues = false;
    protected FieldManager currFM = null;
    protected Object readWriteLock = new Object();
    protected short pcObjectType = 0;
    protected short lockMode = 0;
    protected byte savedFlags;
    protected PersistenceCapable savedImage = null;
    protected boolean[] savedLoadedFields = null;

    public AbstractStateManager(ObjectManager om, AbstractClassMetaData cmd) {
        this.myOM = om;
        this.cmd = cmd;
        this.initialiseFieldInformation();
        this.myFP = this.myOM.getFetchPlan().manageFetchPlanForClass(cmd);
    }

    protected void initialiseFieldInformation() {
        int fieldCount = this.getHighestFieldNumber();
        this.dirtyFields = new boolean[fieldCount];
        this.loadedFields = new boolean[fieldCount];
    }

    public void saveFields() {
        this.savedImage = this.myPC.jdoNewInstance((javax.jdo.spi.StateManager)this);
        this.savedImage.jdoCopyFields((Object)this.myPC, this.getAllFieldNumbers());
        this.savedFlags = this.jdoDfgFlags;
        this.savedLoadedFields = (boolean[])this.loadedFields.clone();
    }

    public void clearSavedFields() {
        this.savedImage = null;
        this.savedFlags = 0;
        this.savedLoadedFields = null;
    }

    public void restoreFields() {
        if (this.savedImage != null) {
            this.loadedFields = this.savedLoadedFields;
            this.jdoDfgFlags = this.savedFlags;
            this.myPC.jdoReplaceFlags();
            this.myPC.jdoCopyFields((Object)this.savedImage, this.getAllFieldNumbers());
            this.clearDirtyFlags();
            this.clearSavedFields();
        }
    }

    public void enlistInTransaction() {
        if (!this.myOM.getTransaction().isActive()) {
            return;
        }
        this.myOM.enlistInTransaction(this);
        if (this.jdoDfgFlags == 1 && this.isDefaultFetchGroupLoaded()) {
            this.jdoDfgFlags = (byte)-1;
            this.myPC.jdoReplaceFlags();
        }
    }

    public void evictFromTransaction() {
        this.myOM.evictFromTransaction(this);
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
    }

    protected void replaceStateManager(final PersistenceCapable pc, final javax.jdo.spi.StateManager sm) {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    pc.jdoReplaceStateManager(sm);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            throw new JDOFatalUserException(LOCALISER.msg("026000"), (Throwable)e);
        }
    }

    public javax.jdo.spi.StateManager replacingStateManager(PersistenceCapable pc, javax.jdo.spi.StateManager sm) {
        if (this.myLC == null) {
            throw new JDOFatalInternalException("Null LifeCycleState");
        }
        if (this.myLC.stateType() == 11) {
            return sm;
        }
        if (pc == this.myPC) {
            if (sm == null) {
                return null;
            }
            if (sm == this) {
                return this;
            }
            if (this.myOM == ((AbstractStateManager)sm).getObjectManager()) {
                ((JDOStateManagerImpl)sm).disconnect();
                return this;
            }
            throw new JDOUserException(LOCALISER.msg("026003"));
        }
        if (pc == this.savedImage) {
            return null;
        }
        return sm;
    }

    public void replaceManagedPC(Object pc) {
        if (pc == null) {
            return;
        }
        this.replaceStateManager((PersistenceCapable)pc, this);
        this.replaceStateManager(this.myPC, null);
        this.myPC = (PersistenceCapable)pc;
        this.myOM.putObjectIntoCache(this);
    }

    public PersistenceManager getPersistenceManager(PersistenceCapable pc) {
        if (this.myPC != null && this.disconnectClone(pc)) {
            return null;
        }
        if (this.myOM == null) {
            return null;
        }
        this.myOM.hereIsObjectProvider(this, this.myPC);
        return (PersistenceManager)this.myOM.getOwner();
    }

    protected CallbackHandler getCallbackHandler() {
        return this.myOM.getCallbackHandler();
    }

    protected boolean[] getSecondClassMutableFields() {
        return this.cmd.getSCOMutableMemberFlags();
    }

    protected boolean[] getNonPrimaryKeyFields() {
        return this.cmd.getNonPKMemberFlags();
    }

    protected int[] getAllFieldNumbers() {
        return this.cmd.getAllMemberPositions();
    }

    protected int[] getNonPrimaryKeyFieldNumbers() {
        return this.cmd.getNonPKMemberPositions();
    }

    protected int[] getSecondClassMutableFieldNumbers() {
        return this.cmd.getSCOMutableMemberPositions();
    }

    public StoreManager getStoreManager() {
        return this.myOM.getStoreManager();
    }

    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    public MetaDataManager getMetaDataManager() {
        return this.myOM.getMetaDataManager();
    }

    public ObjectManager getObjectManager() {
        return this.myOM;
    }

    public ExecutionContext getExecutionContext() {
        return this.myOM;
    }

    public Object getObject() {
        return this.myPC;
    }

    public LifeCycleState getLifecycleState() {
        return this.myLC;
    }

    public boolean isRestoreValues() {
        return this.restoreValues;
    }

    protected void setRestoreValues(boolean restore_values) {
        this.restoreValues = restore_values;
    }

    public Object getInternalObjectId() {
        if (this.myID != null) {
            return this.myID;
        }
        if (this.myInternalID == null) {
            this.myInternalID = new IdentityReference(this);
            return this.myInternalID;
        }
        return this.myInternalID;
    }

    public boolean isFlushedToDatastore() {
        return !this.dirty;
    }

    public boolean isDirty(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDirty();
    }

    public boolean isTransactional(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isTransactional();
    }

    public boolean isPersistent(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isPersistent();
    }

    public boolean isNew(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isNew();
    }

    public boolean isDeleted(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() {
        if (this.myLC != this.myOM.getNucleusContext().getApiAdapter().getLifeCycleState(2) && this.myLC != this.myOM.getNucleusContext().getApiAdapter().getLifeCycleState(9)) {
            return;
        }
        this.preStateChange();
        try {
            try {
                this.getCallbackHandler().preClear(this.myPC);
                this.getCallbackHandler().postClear(this.myPC);
                Object var2_1 = null;
                this.myLC = this.myLC.transitionEvict(this);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.myLC = this.myLC.transitionEvict(this);
                throw throwable;
            }
            Object var4_4 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRefresh(this);
            Object var2_1 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(boolean fgOnly) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((StateManager)this, fgOnly);
            Object var3_2 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(FetchPlan fetchPlan) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((StateManager)this, fetchPlan);
            Object var3_2 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistentTransactionalTransient() {
        this.preStateChange();
        try {
            if (this.myLC.isTransactional && !this.myLC.isPersistent) {
                this.makePersistent();
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
            Object var2_1 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeNontransactional() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeNontransactional(this);
            Object var2_1 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionReadField(boolean isLoaded) {
        Object object = this.myOM.getReadWriteLock();
        synchronized (object) {
            Object object2 = this.readWriteLock;
            synchronized (object2) {
                if (this.myLC == null) {
                    return;
                }
                this.preStateChange();
                try {
                    this.myLC = this.myLC.transitionReadField(this, isLoaded);
                    Object var5_4 = null;
                    this.postStateChange();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.postStateChange();
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionWriteField() {
        Object object = this.myOM.getReadWriteLock();
        synchronized (object) {
            Object object2 = this.readWriteLock;
            synchronized (object2) {
                this.preStateChange();
                try {
                    this.myLC = this.myLC.transitionWriteField(this);
                    Object var4_3 = null;
                    this.postStateChange();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.postStateChange();
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBegin(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionBegin(this, tx);
            Object var3_2 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionCommit(this, tx);
            if (this.transactionalVersion != this.myVersion) {
                this.myVersion = this.transactionalVersion;
            }
            this.lockMode = 0;
            Object var3_2 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback(Transaction tx) {
        this.preStateChange();
        try {
            this.myOM.clearDirty(this);
            this.myLC = this.myLC.transitionRollback(this, tx);
            if (this.transactionalVersion != this.myVersion) {
                this.transactionalVersion = this.myVersion;
            }
            this.lockMode = 0;
            Object var3_2 = null;
            this.postStateChange();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postStateChange();
            throw throwable;
        }
    }

    protected abstract void preStateChange();

    protected abstract void postStateChange();

    public Object getVersion(PersistenceCapable pc) {
        if (pc == this.myPC) {
            return this.transactionalVersion;
        }
        return null;
    }

    public Object getVersion() {
        return this.getVersion(this.myPC);
    }

    public void setTransactionalVersion(Object version) {
        this.transactionalVersion = version;
    }

    public Object getTransactionalVersion(Object pc) {
        return this.transactionalVersion;
    }

    public Object getTransactionalVersion() {
        return this.getTransactionalVersion(this.myPC);
    }

    public void setVersion(Object version) {
        this.myVersion = version;
        this.transactionalVersion = version;
    }

    public boolean isEmbedded() {
        return this.pcObjectType > 0;
    }

    public void setPcObjectType(short embeddedType) {
        this.pcObjectType = embeddedType;
    }

    public int getHighestFieldNumber() {
        return this.cmd.getMemberCount();
    }

    protected boolean isFetchPlanLoaded() {
        int[] fpFields = this.myFP.getMemberNumbers();
        for (int i = 0; i < fpFields.length; ++i) {
            if (this.loadedFields[fpFields[i]]) continue;
            return false;
        }
        return true;
    }

    protected boolean isDefaultFetchGroupLoaded() {
        int[] dfgFields = this.cmd.getDFGMemberPositions();
        for (int i = 0; i < dfgFields.length; ++i) {
            if (this.loadedFields[dfgFields[i]]) continue;
            return false;
        }
        return true;
    }

    public boolean[] getDirtyFields() {
        boolean[] copy = new boolean[this.dirtyFields.length];
        System.arraycopy(this.dirtyFields, 0, copy, 0, this.dirtyFields.length);
        return copy;
    }

    public int[] getDirtyFieldNumbers() {
        return AbstractStateManager.getFlagsSetTo(this.dirtyFields, true);
    }

    public boolean[] getLoadedFields() {
        return (boolean[])this.loadedFields.clone();
    }

    public int[] getLoadedFieldNumbers() {
        return AbstractStateManager.getFlagsSetTo(this.loadedFields, true);
    }

    public boolean getAllFieldsLoaded() {
        for (int i = 0; i < this.loadedFields.length; ++i) {
            if (this.loadedFields[i]) continue;
            return false;
        }
        return true;
    }

    public String[] getDirtyFieldNames() {
        int[] dirtyFieldNumbers = AbstractStateManager.getFlagsSetTo(this.dirtyFields, true);
        if (dirtyFieldNumbers != null && dirtyFieldNumbers.length > 0) {
            String[] dirtyFieldNames = new String[dirtyFieldNumbers.length];
            for (int i = 0; i < dirtyFieldNumbers.length; ++i) {
                dirtyFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(dirtyFieldNumbers[i]).getName();
            }
            return dirtyFieldNames;
        }
        return null;
    }

    public String[] getLoadedFieldNames() {
        int[] loadedFieldNumbers = AbstractStateManager.getFlagsSetTo(this.loadedFields, true);
        if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
            String[] loadedFieldNames = new String[loadedFieldNumbers.length];
            for (int i = 0; i < loadedFieldNumbers.length; ++i) {
                loadedFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(loadedFieldNumbers[i]).getName();
            }
            return loadedFieldNames;
        }
        return null;
    }

    public boolean isFieldLoaded(int fieldNumber) {
        return this.loadedFields[fieldNumber];
    }

    protected void clearDirtyFlags() {
        this.dirty = false;
        AbstractStateManager.clearFlags(this.dirtyFields);
    }

    protected void clearDirtyFlags(int[] fields) {
        this.dirty = false;
        AbstractStateManager.clearFlags(this.dirtyFields, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFields() {
        try {
            this.getCallbackHandler().preClear(this.myPC);
            Object var2_1 = null;
            this.clearFieldsByNumbers(this.getAllFieldNumbers());
            this.clearDirtyFlags();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clearFieldsByNumbers(this.getAllFieldNumbers());
            this.clearDirtyFlags();
            if (this.getStoreManager() instanceof ObjectReferencingStoreManager) {
                ((ObjectReferencingStoreManager)((Object)this.getStoreManager())).notifyObjectIsOutdated(this);
            }
            this.jdoDfgFlags = 1;
            this.myPC.jdoReplaceFlags();
            this.getCallbackHandler().postClear(this.myPC);
            throw throwable;
        }
        if (this.getStoreManager() instanceof ObjectReferencingStoreManager) {
            ((ObjectReferencingStoreManager)((Object)this.getStoreManager())).notifyObjectIsOutdated(this);
        }
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
        this.getCallbackHandler().postClear(this.myPC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNonPrimaryKeyFields() {
        try {
            this.getCallbackHandler().preClear(this.myPC);
            Object var2_1 = null;
            this.clearFieldsByNumbers(this.getNonPrimaryKeyFieldNumbers());
            this.clearDirtyFlags(this.getNonPrimaryKeyFieldNumbers());
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clearFieldsByNumbers(this.getNonPrimaryKeyFieldNumbers());
            this.clearDirtyFlags(this.getNonPrimaryKeyFieldNumbers());
            if (this.getStoreManager() instanceof ObjectReferencingStoreManager) {
                ((ObjectReferencingStoreManager)((Object)this.getStoreManager())).notifyObjectIsOutdated(this);
            }
            this.jdoDfgFlags = 1;
            this.myPC.jdoReplaceFlags();
            this.getCallbackHandler().postClear(this.myPC);
            throw throwable;
        }
        if (this.getStoreManager() instanceof ObjectReferencingStoreManager) {
            ((ObjectReferencingStoreManager)((Object)this.getStoreManager())).notifyObjectIsOutdated(this);
        }
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
        this.getCallbackHandler().postClear(this.myPC);
    }

    public void clearLoadedFlags() {
        if (this.getStoreManager() instanceof ObjectReferencingStoreManager) {
            ((ObjectReferencingStoreManager)((Object)this.getStoreManager())).notifyObjectIsOutdated(this);
        }
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
        AbstractStateManager.clearFlags(this.loadedFields);
    }

    protected void clearFieldsByNumbers(int[] fieldNumbers) {
        this.replaceFields(fieldNumbers, HOLLOWFIELDMANAGER);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = false;
            this.dirtyFields[fieldNumbers[i]] = false;
        }
    }

    public byte replacingFlags(PersistenceCapable pc) {
        if (pc != this.myPC) {
            return 0;
        }
        return this.jdoDfgFlags;
    }

    public void providedBooleanField(PersistenceCapable pc, int field, boolean currentValue) {
        this.currFM.storeBooleanField(field, currentValue);
    }

    public void providedByteField(PersistenceCapable pc, int field, byte currentValue) {
        this.currFM.storeByteField(field, currentValue);
    }

    public void providedCharField(PersistenceCapable pc, int field, char currentValue) {
        this.currFM.storeCharField(field, currentValue);
    }

    public void providedDoubleField(PersistenceCapable pc, int field, double currentValue) {
        this.currFM.storeDoubleField(field, currentValue);
    }

    public void providedFloatField(PersistenceCapable pc, int field, float currentValue) {
        this.currFM.storeFloatField(field, currentValue);
    }

    public void providedIntField(PersistenceCapable pc, int field, int currentValue) {
        this.currFM.storeIntField(field, currentValue);
    }

    public void providedLongField(PersistenceCapable pc, int field, long currentValue) {
        this.currFM.storeLongField(field, currentValue);
    }

    public void providedShortField(PersistenceCapable pc, int field, short currentValue) {
        this.currFM.storeShortField(field, currentValue);
    }

    public void providedStringField(PersistenceCapable pc, int field, String currentValue) {
        this.currFM.storeStringField(field, currentValue);
    }

    public void providedObjectField(PersistenceCapable pc, int fieldNumber, Object currentValue) {
        this.currFM.storeObjectField(fieldNumber, currentValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object provideField(PersistenceCapable pc, int fieldNumber) {
        Object obj;
        Object object = this.myOM.getReadWriteLock();
        synchronized (object) {
            Object object2 = this.readWriteLock;
            synchronized (object2) {
                FieldManager prevFM = this.currFM;
                this.currFM = new SingleValueFieldManager();
                try {
                    pc.jdoProvideField(fieldNumber);
                    obj = this.currFM.fetchObjectField(fieldNumber);
                    Object var8_7 = null;
                    this.currFM = prevFM;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.currFM = prevFM;
                    throw throwable;
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideFields(int[] fieldNumbers, FieldManager fm) {
        Object object = this.myOM.getReadWriteLock();
        synchronized (object) {
            Object object2 = this.readWriteLock;
            synchronized (object2) {
                FieldManager prevFM = this.currFM;
                this.currFM = fm;
                try {
                    this.myPC.jdoProvideFields(fieldNumbers);
                    Object var7_6 = null;
                    this.currFM = prevFM;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.currFM = prevFM;
                    throw throwable;
                }
            }
        }
    }

    public abstract void loadUnloadedFieldsInFetchPlanAndVersion();

    protected abstract void replaceField(PersistenceCapable var1, int var2, Object var3, boolean var4);

    protected abstract boolean preWriteField(int var1);

    protected abstract void postWriteField(boolean var1);

    public void setBooleanField(PersistenceCapable pc, int field, boolean currentValue, boolean newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue ? Boolean.TRUE : Boolean.FALSE, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, newValue ? Boolean.TRUE : Boolean.FALSE, true);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(pc, field, newValue ? Boolean.TRUE : Boolean.FALSE, true);
        }
    }

    public void setByteField(PersistenceCapable pc, int field, byte currentValue, byte newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, newValue, true);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(pc, field, newValue, true);
        }
    }

    public void setCharField(PersistenceCapable pc, int field, char currentValue, char newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, Character.valueOf(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, Character.valueOf(newValue), true);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(pc, field, Character.valueOf(newValue), true);
        }
    }

    public void setDoubleField(PersistenceCapable pc, int field, double currentValue, double newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, newValue, true);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(pc, field, newValue, true);
        }
    }

    public void setFloatField(PersistenceCapable pc, int field, float currentValue, float newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, Float.valueOf(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, Float.valueOf(newValue), true);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(pc, field, Float.valueOf(newValue), true);
        }
    }

    public void setIntField(PersistenceCapable pc, int field, int currentValue, int newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, newValue, true);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(pc, field, newValue, true);
        }
    }

    public void setLongField(PersistenceCapable pc, int field, long currentValue, long newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, newValue, true);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(pc, field, newValue, true);
        }
    }

    public void setShortField(PersistenceCapable pc, int field, short currentValue, short newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[field] || currentValue != newValue) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, newValue, true);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(pc, field, newValue, true);
        }
    }

    public void setStringField(PersistenceCapable pc, int field, String currentValue, String newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[field] || !AbstractStateManager.equals(currentValue, newValue)) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, newValue, true);
                this.postWriteField(wasDirty);
            }
        } else {
            this.replaceField(pc, field, newValue, true);
        }
    }

    public void setObjectField(PersistenceCapable pc, int field, Object currentValue, Object newValue) {
        JDOStateManagerImpl currentSM;
        if (currentValue != null && currentValue != newValue && currentValue instanceof PersistenceCapable && (currentSM = (JDOStateManagerImpl)this.myOM.findStateManager(currentValue)) != null && currentSM.isEmbedded()) {
            currentSM.removeEmbeddedOwner(this, field);
        }
        if (pc != this.myPC) {
            this.replaceField(pc, field, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            boolean loadedOldValue = false;
            Object oldValue = currentValue;
            AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(field);
            ClassLoaderResolver clr = this.myOM.getClassLoaderResolver();
            int relationType = fmd.getRelationType(clr);
            this.myOM.removeObjectFromLevel2Cache(this.myID);
            if (!this.loadedFields[field] && currentValue == null) {
                if (this.myOM.getManageRelations() && (relationType == 2 || relationType == 6)) {
                    this.loadField(field);
                    loadedOldValue = true;
                    oldValue = this.provideField(field);
                }
                if (relationType != 0 && newValue == null && (fmd.isDependent() || fmd.isCascadeRemoveOrphans())) {
                    this.loadField(field);
                    loadedOldValue = true;
                    oldValue = this.provideField(field);
                }
            }
            boolean equal = false;
            if (oldValue == null && newValue == null) {
                equal = true;
            } else if (oldValue != null && newValue != null) {
                if (oldValue instanceof PersistenceCapable) {
                    if (oldValue == newValue) {
                        equal = true;
                    }
                } else if (oldValue.equals(newValue)) {
                    equal = true;
                }
            }
            boolean needsSCOUpdating = false;
            if (!this.loadedFields[field] || !equal || fmd.hasArray()) {
                SCO sco;
                Object owner;
                boolean wasDirty = this.preWriteField(field);
                if (oldValue instanceof SCO) {
                    if (oldValue instanceof SCOContainer) {
                        ((SCOContainer)oldValue).load();
                    }
                    ((SCO)oldValue).unsetOwner();
                }
                if (newValue instanceof SCO && (owner = (sco = (SCO)newValue).getOwner()) != null) {
                    throw new JDOUserException(LOCALISER.msg("026007", (Object)sco.getFieldName(), owner));
                }
                this.replaceField(pc, field, newValue, true);
                this.postWriteField(wasDirty);
                if (this.cmd.getSCOMutableMemberFlags()[field] && !(newValue instanceof SCO)) {
                    needsSCOUpdating = true;
                }
            } else if (loadedOldValue) {
                boolean wasDirty = this.preWriteField(field);
                this.replaceField(pc, field, newValue, true);
                this.postWriteField(wasDirty);
            }
            if (!equal && Relation.isBidirectional(relationType) && this.myOM.getManageRelations()) {
                this.myOM.getRelationshipManager(this).relationChange(field, oldValue, newValue);
            }
            if (needsSCOUpdating) {
                newValue = this.wrapSCOField(field, newValue, false, true, true);
            }
            if (oldValue != null && newValue == null && oldValue instanceof PersistenceCapable && (fmd.isDependent() || fmd.isCascadeRemoveOrphans()) && this.myOM.getApiAdapter().isPersistent(oldValue)) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026026", oldValue, (Object)fmd.getFullFieldName()));
                this.myOM.deleteObjectInternal(oldValue);
            }
        } else {
            this.replaceField(pc, field, newValue, true);
        }
    }

    public boolean replacingBooleanField(PersistenceCapable pc, int field) {
        boolean value = this.currFM.fetchBooleanField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public byte replacingByteField(PersistenceCapable obj, int field) {
        byte value = this.currFM.fetchByteField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public char replacingCharField(PersistenceCapable obj, int field) {
        char value = this.currFM.fetchCharField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public double replacingDoubleField(PersistenceCapable obj, int field) {
        double value = this.currFM.fetchDoubleField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public float replacingFloatField(PersistenceCapable obj, int field) {
        float value = this.currFM.fetchFloatField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public int replacingIntField(PersistenceCapable obj, int field) {
        int value = this.currFM.fetchIntField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public long replacingLongField(PersistenceCapable obj, int field) {
        long value = this.currFM.fetchLongField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public short replacingShortField(PersistenceCapable obj, int field) {
        short value = this.currFM.fetchShortField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public String replacingStringField(PersistenceCapable obj, int field) {
        String value = this.currFM.fetchStringField(field);
        this.loadedFields[field] = true;
        return value;
    }

    public Object replacingObjectField(PersistenceCapable obj, int field) {
        try {
            Object value = this.currFM.fetchObjectField(field);
            this.loadedFields[field] = true;
            return value;
        }
        catch (AbstractFetchFieldManager.EndOfFetchPlanGraphException eodge) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceField(PersistenceCapable pc, int fieldNumber, Object value) {
        Object object = this.myOM.getReadWriteLock();
        synchronized (object) {
            Object object2 = this.readWriteLock;
            synchronized (object2) {
                FieldManager prevFM = this.currFM;
                this.currFM = new SingleValueFieldManager();
                try {
                    this.currFM.storeObjectField(fieldNumber, value);
                    pc.jdoReplaceField(fieldNumber);
                    Object var8_7 = null;
                    this.currFM = prevFM;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.currFM = prevFM;
                    throw throwable;
                }
            }
        }
    }

    public boolean getBooleanField(PersistenceCapable pc, int field, boolean currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public byte getByteField(PersistenceCapable pc, int field, byte currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public char getCharField(PersistenceCapable pc, int field, char currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public double getDoubleField(PersistenceCapable pc, int field, double currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public float getFloatField(PersistenceCapable pc, int field, float currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public int getIntField(PersistenceCapable pc, int field, int currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public long getLongField(PersistenceCapable pc, int field, long currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public short getShortField(PersistenceCapable pc, int field, short currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public String getStringField(PersistenceCapable pc, int field, String currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public Object getObjectField(PersistenceCapable pc, int field, Object currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    protected static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected static void clearFlags(boolean[] flags) {
        for (int i = 0; i < flags.length; ++i) {
            flags[i] = false;
        }
    }

    protected static void clearFlags(boolean[] flags, int[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            flags[fields[i]] = false;
        }
    }

    public static int[] getFlagsSetTo(boolean[] flags, boolean state) {
        int[] temp = new int[flags.length];
        int j = 0;
        for (int i = 0; i < flags.length; ++i) {
            if (flags[i] != state) continue;
            temp[j++] = i;
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    protected static int[] getFlagsSetTo(boolean[] flags, int[] indices, boolean state) {
        int[] temp = new int[indices.length];
        int j = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (flags[indices[i]] != state) continue;
            temp[j++] = indices[i];
        }
        if (j != 0) {
            int[] fieldNumbers = new int[j];
            System.arraycopy(temp, 0, fieldNumbers, 0, j);
            return fieldNumbers;
        }
        return null;
    }

    protected static Object peekField(Object obj, String fieldName) {
        try {
            Object value = obj.getClass().getDeclaredField(fieldName).get(obj);
            if (value instanceof PersistenceCapable) {
                return StringUtils.toJVMIDString(value);
            }
            return value;
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public void lock(short lockMode) {
        this.lockMode = lockMode;
    }

    public void unlock() {
        this.lockMode = 0;
    }

    public short getLockMode() {
        return this.lockMode;
    }

    public String toPrintableID() {
        return StringUtils.toJVMIDString(this.myPC);
    }

    public String toString() {
        return "StateManager[pc=" + StringUtils.toJVMIDString(this.myPC) + ", lifecycle=" + this.myLC + "]";
    }

    public boolean isDetaching() {
        return (this.flags & 0x10) != 0;
    }

    protected boolean disconnectClone(PersistenceCapable pc) {
        if ((this.flags & 0x10) != 0) {
            return false;
        }
        if (pc != this.myPC) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026001", (Object)StringUtils.toJVMIDString(pc), (Object)this));
            }
            pc.jdoReplaceFlags();
            this.replaceStateManager(pc, null);
            return true;
        }
        return false;
    }

    public void retrieveDetachState(StateManager sm) {
        if (sm.getObject() instanceof Detachable) {
            ((JDOStateManagerImpl)sm).flags |= 0x80;
            ((Detachable)sm.getObject()).jdoReplaceDetachedState();
            ((JDOStateManagerImpl)sm).flags &= 0xFFFFFF7F;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDetachState() {
        if (this.getObject() instanceof Detachable) {
            this.flags |= 0x40;
            try {
                ((Detachable)this.getObject()).jdoReplaceDetachedState();
                Object var2_1 = null;
                this.flags &= 0xFFFFFFBF;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.flags &= 0xFFFFFFBF;
                throw throwable;
            }
        }
    }

    public Object[] replacingDetachedState(Detachable pc, Object[] currentState) {
        if ((this.flags & 0x40) != 0) {
            return null;
        }
        if ((this.flags & 0x80) != 0) {
            BitSet jdoLoadedFields = (BitSet)currentState[2];
            for (int i = 0; i < this.loadedFields.length; ++i) {
                this.loadedFields[i] = jdoLoadedFields.get(i);
            }
            BitSet jdoModifiedFields = (BitSet)currentState[3];
            for (int i = 0; i < this.dirtyFields.length; ++i) {
                this.dirtyFields[i] = jdoModifiedFields.get(i);
            }
            this.setVersion(currentState[1]);
            return currentState;
        }
        Object[] state = new Object[4];
        state[0] = this.myID;
        state[1] = this.getVersion(this.myPC);
        BitSet loadedState = new BitSet();
        for (int i = 0; i < this.loadedFields.length; ++i) {
            if (this.loadedFields[i]) {
                loadedState.set(i);
                continue;
            }
            loadedState.clear(i);
        }
        state[2] = loadedState;
        BitSet modifiedState = new BitSet();
        for (int i = 0; i < this.dirtyFields.length; ++i) {
            if (this.dirtyFields[i]) {
                modifiedState.set(i);
                continue;
            }
            modifiedState.clear(i);
        }
        state[3] = modifiedState;
        return state;
    }
}

