/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.exceptions.ClassDefinitionException;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractMapStore;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.MapEntrySetStore;
import org.datanucleus.store.mapped.scostore.MapKeySetStore;
import org.datanucleus.store.mapped.scostore.MapValueSetStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.ClassUtils;

public abstract class FKMapStore
extends AbstractMapStore {
    private final int ownerFieldNumber;
    protected final ClassLoaderResolver clr;
    protected int keyFieldNumber = -1;
    private int valueFieldNumber = -1;
    private SetStore keySetStore = null;
    private SetStore valueSetStore = null;
    private SetStore entrySetStore = null;

    public FKMapStore(AbstractMemberMetaData fmd, MappedStoreManager storeMgr, ClassLoaderResolver clr, AbstractMapStoreSpecialization specialization) {
        super(storeMgr, specialization);
        this.clr = clr;
        this.setOwner(fmd, clr);
        MapMetaData mmd = (MapMetaData)fmd.getContainer();
        if (mmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056002", (Object)fmd.getFullFieldName()));
        }
        boolean keyStoredInValue = false;
        if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
            keyStoredInValue = true;
        } else if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() == null) {
            throw new NucleusUserException(LOCALISER.msg("056071", (Object)fmd.getFullFieldName()));
        }
        this.keyType = mmd.getKeyType();
        this.valueType = mmd.getValueType();
        Class keyClass = clr.classForName(this.keyType);
        Class valueClass = clr.classForName(this.valueType);
        ApiAdapter api = ((AbstractStoreManager)this.getStoreManager()).getApiAdapter();
        if (keyStoredInValue && !api.isPersistable(valueClass)) {
            throw new NucleusUserException(LOCALISER.msg("056072", (Object)fmd.getFullFieldName(), (Object)this.valueType));
        }
        if (!keyStoredInValue && !api.isPersistable(keyClass)) {
            throw new NucleusUserException(LOCALISER.msg("056073", (Object)fmd.getFullFieldName(), (Object)this.keyType));
        }
        String ownerFieldName = fmd.getMappedBy();
        if (keyStoredInValue) {
            this.vmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(valueClass, clr);
            if (this.vmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056070", (Object)this.valueType, (Object)fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.valueType, clr);
            this.valueMapping = storeMgr.getDatastoreClass(this.valueType, clr).getIdMapping();
            this.valuesAreEmbedded = false;
            this.valuesAreSerialised = false;
            if (fmd.getMappedBy() != null) {
                AbstractMemberMetaData vofmd = this.vmd.getMetaDataForMember(ownerFieldName);
                if (vofmd == null) {
                    throw new NucleusUserException(LOCALISER.msg("056067", (Object)fmd.getFullFieldName(), (Object)ownerFieldName, (Object)valueClass.getName()));
                }
                if (!clr.isAssignableFrom(vofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                    throw new NucleusUserException(LOCALISER.msg("056068", (Object)fmd.getFullFieldName(), (Object)vofmd.getFullFieldName(), (Object)vofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.vmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getMemberMapping(vofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.valueType, (Object)ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(LOCALISER.msg("056055", (Object)ownerFieldName, (Object)this.valueType, (Object)vofmd.getTypeName(), (Object)fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("056056", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.valueType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((fmd.getKeyMetaData() == null || fmd.getKeyMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056050", (Object)valueClass.getName()));
            }
            String key_field_name = fmd.getKeyMetaData().getMappedBy();
            if (key_field_name != null && (vkfmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForMember(valueClass, clr, key_field_name)) == null) {
                throw new NucleusUserException(LOCALISER.msg("056052", (Object)valueClass.getName(), (Object)key_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("056050", (Object)fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible(vkfmd.getType(), this.keyType, clr)) {
                throw new NucleusUserException(LOCALISER.msg("056051", (Object)fmd.getFullFieldName(), (Object)this.keyType, (Object)vkfmd.getType().getName()));
            }
            String keyFieldName = vkfmd.getName();
            this.keyFieldNumber = this.vmd.getAbsolutePositionOfMember(keyFieldName);
            this.keyMapping = this.valueTable.getMemberMapping(this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(this.keyFieldNumber));
            if (this.keyMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056053", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.valueType, (Object)keyFieldName));
            }
            if (!this.keyMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map key field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.keysAreEmbedded = this.isEmbeddedMapping(this.keyMapping);
            this.keysAreSerialised = this.isEmbeddedMapping(this.keyMapping);
            this.mapTable = this.valueTable;
            if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.mapTable) {
                this.mapTable = this.ownerMapping.getDatastoreContainer();
            }
        } else {
            this.kmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(keyClass, clr);
            if (this.kmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056069", (Object)this.keyType, (Object)fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.keyType, clr);
            this.keyMapping = storeMgr.getDatastoreClass(this.keyType, clr).getIdMapping();
            this.keysAreEmbedded = false;
            this.keysAreSerialised = false;
            if (fmd.getMappedBy() != null) {
                AbstractMemberMetaData kofmd = this.kmd.getMetaDataForMember(ownerFieldName);
                if (kofmd == null) {
                    throw new NucleusUserException(LOCALISER.msg("056067", (Object)fmd.getFullFieldName(), (Object)ownerFieldName, (Object)keyClass.getName()));
                }
                if (!ClassUtils.typesAreCompatible(kofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName(), clr)) {
                    throw new NucleusUserException(LOCALISER.msg("056068", (Object)fmd.getFullFieldName(), (Object)kofmd.getFullFieldName(), (Object)kofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.kmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getMemberMapping(kofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.keyType, (Object)ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(LOCALISER.msg("056055", (Object)ownerFieldName, (Object)this.keyType, (Object)kofmd.getTypeName(), (Object)fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("056056", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.keyType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((fmd.getValueMetaData() == null || fmd.getValueMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056057", (Object)keyClass.getName()));
            }
            String value_field_name = fmd.getValueMetaData().getMappedBy();
            if (value_field_name != null && (vkfmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForMember(keyClass, clr, value_field_name)) == null) {
                throw new NucleusUserException(LOCALISER.msg("056059", (Object)keyClass.getName(), (Object)value_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("056057", (Object)fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible(vkfmd.getType(), this.valueType, clr)) {
                throw new NucleusUserException(LOCALISER.msg("056058", (Object)fmd.getFullFieldName(), (Object)this.valueType, (Object)vkfmd.getType().getName()));
            }
            String valueFieldName = vkfmd.getName();
            this.valueFieldNumber = this.kmd.getAbsolutePositionOfMember(valueFieldName);
            this.valueMapping = this.valueTable.getMemberMapping(this.kmd.getMetaDataForManagedMemberAtAbsolutePosition(this.valueFieldNumber));
            if (this.valueMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056054", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.keyType, (Object)valueFieldName));
            }
            if (!this.valueMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map value field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.valuesAreEmbedded = this.isEmbeddedMapping(this.valueMapping);
            this.valuesAreSerialised = this.isEmbeddedMapping(this.valueMapping);
            this.mapTable = this.valueTable;
            if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.mapTable) {
                this.mapTable = this.ownerMapping.getDatastoreContainer();
            }
        }
        specialization.initialise(this);
        this.initialise();
    }

    protected abstract void initialise();

    protected abstract boolean updateKeyFkInternal(ObjectProvider var1, Object var2, Object var3);

    protected abstract boolean updateValueFkInternal(ObjectProvider var1, Object var2, Object var3);

    protected abstract MapKeySetStore newMapKeySetStore();

    protected abstract MapValueSetStore newMapValueSetStore();

    protected abstract MapEntrySetStore newMapEntrySetStore();

    private boolean updateValueFk(ObjectProvider sm, Object value, Object owner) {
        if (value == null) {
            return false;
        }
        this.validateValueForWriting(sm, value);
        return this.updateValueFkInternal(sm, value, owner);
    }

    private boolean updateKeyFk(ObjectProvider sm, Object key, Object owner) {
        if (key == null) {
            return false;
        }
        this.validateKeyForWriting(sm, key);
        return this.updateKeyFkInternal(sm, key, owner);
    }

    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value == null) {
            throw new NullPointerException(LOCALISER.msg("056063"));
        }
        super.validateValueType(clr, value);
    }

    public Object put(final ObjectProvider sm, final Object newKey, Object newValue) {
        if (this.keyFieldNumber >= 0) {
            this.validateKeyForWriting(sm, newKey);
            this.validateValueType(sm.getExecutionContext().getClassLoaderResolver(), newValue);
        } else {
            this.validateKeyType(sm.getExecutionContext().getClassLoaderResolver(), newKey);
            this.validateValueForWriting(sm, newValue);
        }
        Object oldValue = this.get(sm, newKey);
        if (oldValue != newValue) {
            if (this.vmd != null) {
                if (oldValue != null && !oldValue.equals(newValue)) {
                    this.removeValue(sm, newKey, oldValue);
                }
                ExecutionContext ec = sm.getExecutionContext();
                final Object newOwner = sm.getObject();
                if (ec.getApiAdapter().isPersistent(newValue)) {
                    if (ec != ec.getApiAdapter().getExecutionContext(newValue)) {
                        throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteValueInvalidWithDifferentPM"), ec.getApiAdapter().getIdForObject(newValue));
                    }
                    ObjectProvider vsm = ec.findObjectProvider(newValue);
                    if (this.ownerFieldNumber >= 0) {
                        ec.getApiAdapter().isLoaded(vsm, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.replaceFieldMakeDirty(this.ownerFieldNumber, newOwner);
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(vsm).relationChange(this.ownerFieldNumber, oldOwner, newOwner);
                        }
                    } else {
                        this.updateValueFk(sm, newValue, newOwner);
                    }
                    ec.getApiAdapter().isLoaded(vsm, this.keyFieldNumber);
                    Object oldKey = vsm.provideField(this.keyFieldNumber);
                    vsm.replaceFieldMakeDirty(this.keyFieldNumber, newKey);
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, oldKey, newKey);
                    }
                } else {
                    ec.persistObjectInternal(newValue, new FieldValues(){

                        public void fetchFields(ObjectProvider vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceFieldMakeDirty(FKMapStore.this.ownerFieldNumber, newOwner);
                            }
                            vsm.replaceFieldMakeDirty(FKMapStore.this.keyFieldNumber, newKey);
                            JavaTypeMapping externalFKMapping = FKMapStore.this.valueTable.getExternalMapping(FKMapStore.this.ownerMemberMetaData, 5);
                            if (externalFKMapping != null) {
                                vsm.setAssociatedValue(externalFKMapping, sm.getObject());
                            }
                        }

                        public void fetchNonLoadedFields(ObjectProvider sm2) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, 0);
                }
            } else {
                ExecutionContext ec = sm.getExecutionContext();
                final Object newOwner = sm.getObject();
                if (ec.getApiAdapter().isPersistent(newKey)) {
                    if (ec != ec.getApiAdapter().getExecutionContext(newKey)) {
                        throw new NucleusUserException(LOCALISER.msg("056060"), ec.getApiAdapter().getIdForObject(newKey));
                    }
                    ObjectProvider vsm = ec.findObjectProvider(newKey);
                    if (this.ownerFieldNumber >= 0) {
                        ec.getApiAdapter().isLoaded(vsm, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.replaceFieldMakeDirty(this.ownerFieldNumber, newOwner);
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(vsm).relationChange(this.ownerFieldNumber, oldOwner, newOwner);
                        }
                    } else {
                        this.updateKeyFk(sm, newKey, newOwner);
                    }
                    ec.getApiAdapter().isLoaded(vsm, this.valueFieldNumber);
                    oldValue = vsm.provideField(this.valueFieldNumber);
                    vsm.replaceFieldMakeDirty(this.valueFieldNumber, newValue);
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(vsm).relationChange(this.valueFieldNumber, oldValue, newValue);
                    }
                } else {
                    final Object newValueObj = newValue;
                    ec.persistObjectInternal(newKey, new FieldValues(){

                        public void fetchFields(ObjectProvider vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceFieldMakeDirty(FKMapStore.this.ownerFieldNumber, newOwner);
                            }
                            vsm.replaceFieldMakeDirty(FKMapStore.this.valueFieldNumber, newValueObj);
                            JavaTypeMapping externalFKMapping = FKMapStore.this.valueTable.getExternalMapping(FKMapStore.this.ownerMemberMetaData, 5);
                            if (externalFKMapping != null) {
                                vsm.setAssociatedValue(externalFKMapping, sm.getObject());
                            }
                        }

                        public void fetchNonLoadedFields(ObjectProvider sm2) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, 0);
                }
            }
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getExecutionContext().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public Object remove(ObjectProvider sm, Object key) {
        Object oldValue = this.get(sm, key);
        if (this.keyFieldNumber >= 0) {
            if (oldValue != null) {
                this.removeValue(sm, key, oldValue);
                sm.getExecutionContext().flushInternal(false);
            }
        } else {
            sm.getExecutionContext().deleteObjectInternal(key);
        }
        if (this.ownerMemberMetaData.getMap().isDependentKey()) {
            sm.getExecutionContext().deleteObjectInternal(key);
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue()) {
            sm.getExecutionContext().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    private void removeValue(ObjectProvider sm, Object key, Object oldValue) {
        ExecutionContext ec = sm.getExecutionContext();
        if (this.keyMapping.isNullable()) {
            ObjectProvider vsm = ec.findObjectProvider(oldValue);
            vsm.replaceFieldMakeDirty(this.keyFieldNumber, null);
            if (ec.getManageRelations()) {
                ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, key, null);
            }
            if (this.ownerFieldNumber >= 0) {
                Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                vsm.replaceFieldMakeDirty(this.ownerFieldNumber, null);
                if (ec.getManageRelations()) {
                    ec.getRelationshipManager(vsm).relationChange(this.ownerFieldNumber, oldOwner, null);
                }
            } else {
                this.updateValueFk(sm, oldValue, null);
            }
        } else {
            ec.deleteObjectInternal(oldValue);
        }
    }

    public void clear(ObjectProvider sm) {
        Iterator iter = this.keySetStore().iterator(sm);
        while (iter.hasNext()) {
            this.remove(sm, iter.next());
        }
    }

    public void clearKeyOfValue(ObjectProvider sm, Object key, Object oldValue) {
        ExecutionContext ec = sm.getExecutionContext();
        if (this.keyMapping.isNullable()) {
            ObjectProvider vsm = ec.findObjectProvider(oldValue);
            if (!ec.getApiAdapter().isDeleted(oldValue)) {
                vsm.replaceFieldMakeDirty(this.keyFieldNumber, null);
                if (ec.getManageRelations()) {
                    ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, key, null);
                }
            }
        } else {
            ec.deleteObjectInternal(oldValue);
        }
    }

    public synchronized SetStore keySetStore() {
        return this.keySetStore == null ? this.newMapKeySetStore() : this.keySetStore;
    }

    public synchronized SetStore valueSetStore() {
        return this.valueSetStore == null ? this.newMapValueSetStore() : this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        return this.entrySetStore == null ? this.newMapEntrySetStore() : this.entrySetStore;
    }
}

