/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.FetchPlan;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.JTAJCATransactionImpl;
import org.datanucleus.JTATransactionImpl;
import org.datanucleus.NucleusContext;
import org.datanucleus.NullCallbackHandler;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.TransactionImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level1Cache;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.ClassNotDetachableException;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.CommitStateTransitionException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ObjectDetachedException;
import org.datanucleus.exceptions.RollbackStateTransitionException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.identity.DatastoreUniqueOID;
import org.datanucleus.identity.IdentityTranslator;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.properties.BasePropertyStore;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.state.RelationshipManagerImpl;
import org.datanucleus.state.StateManager;
import org.datanucleus.state.lock.LockManager;
import org.datanucleus.state.lock.LockManagerImpl;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.Type;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.WeakValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectManagerImpl
implements ObjectManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    NucleusContext context;
    private Object owner;
    private boolean closed;
    private FetchPlan fetchPlan;
    private ClassLoaderResolver clr = null;
    private CallbackHandler callbacks;
    private Level1Cache cache;
    private Object objectLookingForStateManager = null;
    private StateManager foundStateManager = null;
    private Transaction tx;
    private Map<Object, StateManager> enlistedSMCache = new WeakValueMap();
    private List<StateManager> dirtySMs = new ArrayList<StateManager>();
    private List<StateManager> indirectDirtySMs = new ArrayList<StateManager>();
    private Set txCachedIds = null;
    private BasePropertyStore properties = new BasePropertyStore();
    private boolean flushing = false;
    private boolean runningDetachAllOnTxnEnd = false;
    private FetchGroupManager fetchGrpMgr;
    private LockManager lockMgr = null;
    private Object readWriteLock = new Object();
    private boolean runningManageRelations = false;
    Map<ObjectProvider, RelationshipManager> managedRelationDetails = null;
    private boolean runningPBRAtCommit = false;
    private Set txKnownPersistedIds = null;
    private Set txKnownDeletedIds = null;
    private Set txFlushedNewIds = null;
    private Set txEnlistedIds = null;
    private ThreadLocal contextInfoThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadContextInfo();
        }
    };
    private StateManager[] detachAllOnTxnEndSMs = null;

    public ObjectManagerImpl(NucleusContext ctx, Object owner, String userName, String password) {
        this.owner = owner;
        this.context = ctx;
        this.closed = false;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        this.clr = ctx.getClassLoaderResolver(contextLoader);
        try {
            ImplementationCreator ic = ctx.getImplementationCreator();
            if (ic != null) {
                this.clr.setRuntimeClassLoader(ic.getClassLoader());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010000", this, (Object)ctx.getStoreManager()));
        }
        PersistenceConfiguration config = ctx.getPersistenceConfiguration();
        for (Map.Entry<String, Object> entry : config.getManagerOverrideableProperties().entrySet()) {
            this.properties.setProperty(entry.getKey().toLowerCase(), entry.getValue());
        }
        if (this.getReachabilityAtCommit()) {
            this.txKnownPersistedIds = new HashSet();
            this.txKnownDeletedIds = new HashSet();
            this.txFlushedNewIds = new HashSet();
            this.txEnlistedIds = new HashSet();
        }
        this.fetchPlan = new FetchPlan(this, this.clr).setMaxFetchDepth(config.getIntProperty("datanucleus.maxFetchDepth"));
        this.initialiseLevel1Cache();
        this.tx = TransactionType.JTA.toString().equalsIgnoreCase(config.getStringProperty("datanucleus.TransactionType")) ? (this.getNucleusContext().isJcaMode() ? new JTAJCATransactionImpl(this) : new JTATransactionImpl(this)) : new TransactionImpl(this);
        final ObjectManagerImpl ec = this;
        this.tx.bindTransactionEventListener(new TransactionEventListener(){

            public void transactionStarted() {
                ObjectManagerImpl.this.getStoreManager().transactionStarted(ec);
                ObjectManagerImpl.this.postBegin();
            }

            public void transactionRolledBack() {
                ObjectManagerImpl.this.getStoreManager().transactionRolledBack(ec);
                ObjectManagerImpl.this.postRollback();
            }

            public void transactionPreRollBack() {
                ObjectManagerImpl.this.preRollback();
            }

            public void transactionPreCommit() {
                ObjectManagerImpl.this.preCommit();
            }

            public void transactionFlushed() {
            }

            public void transactionEnded() {
            }

            public void transactionCommitted() {
                ObjectManagerImpl.this.getStoreManager().transactionCommitted(ec);
                ObjectManagerImpl.this.postCommit();
            }
        });
        if (this.context.hasLevel2Cache()) {
            this.txCachedIds = new HashSet();
        }
    }

    protected void initialiseLevel1Cache() {
        String level1Type = this.context.getPersistenceConfiguration().getStringProperty("datanucleus.cache.level1.type");
        if (level1Type != null && level1Type.equalsIgnoreCase("none")) {
            return;
        }
        String level1ClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name");
        if (level1ClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("003001", (Object)level1Type)).setFatal();
        }
        try {
            this.cache = (Level1Cache)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name", null, null);
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003003", (Object)level1Type));
            }
        }
        catch (Exception e) {
            throw new NucleusUserException(LOCALISER.msg("003002", (Object)level1Type, (Object)level1ClassName), e).setFatal();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public StoreManager getStoreManager() {
        return this.getNucleusContext().getStoreManager();
    }

    @Override
    public ApiAdapter getApiAdapter() {
        return this.getNucleusContext().getApiAdapter();
    }

    @Override
    public TypeManager getTypeManager() {
        return this.getNucleusContext().getTypeManager();
    }

    @Override
    public LockManager getLockManager() {
        if (this.lockMgr == null) {
            this.lockMgr = new LockManagerImpl();
        }
        return this.lockMgr;
    }

    @Override
    public FetchPlan getFetchPlan() {
        this.assertIsOpen();
        return this.fetchPlan;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public NucleusContext getNucleusContext() {
        return this.context;
    }

    @Override
    public MetaDataManager getMetaDataManager() {
        return this.getNucleusContext().getMetaDataManager();
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.properties.hasProperty(name.toLowerCase())) {
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            this.properties.setProperty(intName.toLowerCase(), value);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties.getProperties();
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase())) {
            this.assertIsOpen();
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            return this.properties.getBooleanProperty(intName);
        }
        return null;
    }

    @Override
    public Integer getIntProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase())) {
            this.assertIsOpen();
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            return this.properties.getIntProperty(intName);
        }
        return null;
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase())) {
            this.assertIsOpen();
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            return this.properties.getProperty(intName.toLowerCase());
        }
        return null;
    }

    @Override
    public Set<String> getSupportedProperties() {
        return this.properties.getPropertyNames();
    }

    @Override
    public Integer getDatastoreReadTimeoutMillis() {
        this.assertIsOpen();
        return this.properties.getIntProperty("datanucleus.datastoreReadTimeout".toLowerCase());
    }

    @Override
    public Integer getDatastoreWriteTimeoutMillis() {
        this.assertIsOpen();
        return this.properties.getIntProperty("datanucleus.datastoreWriteTimeout".toLowerCase());
    }

    protected boolean getMultithreaded() {
        this.assertIsOpen();
        return this.properties.getBooleanProperty("datanucleus.Multithreaded".toLowerCase());
    }

    protected boolean getDetachOnClose() {
        this.assertIsOpen();
        return this.properties.getBooleanProperty("datanucleus.DetachOnClose".toLowerCase());
    }

    protected boolean getDetachAllOnCommit() {
        this.assertIsOpen();
        return this.properties.getBooleanProperty("datanucleus.DetachAllOnCommit".toLowerCase());
    }

    protected boolean getDetachAllOnRollback() {
        this.assertIsOpen();
        return this.properties.getBooleanProperty("datanucleus.DetachAllOnRollback".toLowerCase());
    }

    protected boolean getReachabilityAtCommit() {
        this.assertIsOpen();
        return this.properties.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit".toLowerCase());
    }

    public boolean getCopyOnAttach() {
        this.assertIsOpen();
        return this.properties.getBooleanProperty("datanucleus.CopyOnAttach".toLowerCase());
    }

    @Override
    public boolean getIgnoreCache() {
        this.assertIsOpen();
        return this.properties.getBooleanProperty("datanucleus.IgnoreCache".toLowerCase());
    }

    @Override
    public boolean isDelayDatastoreOperationsEnabled() {
        if (this.flushing || this.tx.isCommitting()) {
            return false;
        }
        if (!this.tx.isActive()) {
            return true;
        }
        Boolean delayProp = this.getNucleusContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.datastoreTransactionDelayOperations");
        if (delayProp != null) {
            return delayProp;
        }
        return this.tx.getOptimistic();
    }

    @Override
    public boolean isInserting(Object pc) {
        ObjectProvider sm = this.findObjectProvider(pc);
        if (sm == null) {
            return false;
        }
        return sm.isInserting();
    }

    @Override
    public Transaction getTransaction() {
        this.assertIsOpen();
        return this.tx;
    }

    @Override
    public synchronized void enlistInTransaction(ObjectProvider sm) {
        this.assertActiveTransaction();
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015017", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)sm.getInternalObjectId().toString()));
        }
        if (this.getReachabilityAtCommit() && this.tx.isActive()) {
            if (this.getApiAdapter().isNew(sm.getObject())) {
                this.txFlushedNewIds.add(sm.getInternalObjectId());
            } else if (this.getApiAdapter().isPersistent(sm.getObject()) && !this.getApiAdapter().isDeleted(sm.getObject()) && !this.txFlushedNewIds.contains(sm.getInternalObjectId())) {
                this.txKnownPersistedIds.add(sm.getInternalObjectId());
            }
            if (!this.runningPBRAtCommit) {
                this.txEnlistedIds.add(sm.getInternalObjectId());
            }
        }
        this.enlistedSMCache.put(sm.getInternalObjectId(), (StateManager)sm);
    }

    @Override
    public synchronized void evictFromTransaction(ObjectProvider sm) {
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015019", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.getIdentityAsString(sm.getInternalObjectId())));
        }
        if (this.enlistedSMCache.remove(sm.getInternalObjectId()) == null && NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("010023", (Object)StringUtils.toJVMIDString(sm.getObject()), (Object)this.getIdentityAsString(sm.getInternalObjectId())));
        }
    }

    @Override
    public boolean isEnlistedInTransaction(Object id) {
        if (!this.getReachabilityAtCommit() || !this.tx.isActive()) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.txEnlistedIds.contains(id);
    }

    @Override
    public Object getAttachedObjectForId(Object id) {
        StateManager sm = this.enlistedSMCache.get(id);
        if (sm != null) {
            return sm.getObject();
        }
        if (this.cache != null && (sm = (StateManager)this.cache.get(id)) != null) {
            return sm.getObject();
        }
        return null;
    }

    @Override
    public synchronized void addStateManager(StateManager sm) {
        this.putObjectIntoCache(sm);
    }

    @Override
    public synchronized void removeStateManager(StateManager sm) {
        this.removeObjectFromCache(sm.getInternalObjectId());
        this.enlistedSMCache.remove(sm.getInternalObjectId());
    }

    @Override
    public synchronized StateManager getStateManagerById(Object id) {
        this.assertIsOpen();
        return this.findStateManager(this.getObjectFromCache(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized StateManager findStateManager(Object pc) {
        StateManager sm = null;
        Object previousLookingFor = this.objectLookingForStateManager;
        StateManager previousFound = this.foundStateManager;
        try {
            this.objectLookingForStateManager = pc;
            this.foundStateManager = null;
            ExecutionContext ec = this.getApiAdapter().getExecutionContext(pc);
            if (ec != null && this != ec) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(pc)));
            }
            sm = this.foundStateManager;
            Object var7_6 = null;
            this.objectLookingForStateManager = previousLookingFor;
            this.foundStateManager = previousFound;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.objectLookingForStateManager = previousLookingFor;
            this.foundStateManager = previousFound;
            throw throwable;
        }
        return sm;
    }

    @Override
    public synchronized ObjectProvider findObjectProvider(Object pc) {
        return this.findStateManager(pc);
    }

    @Override
    public ObjectProvider findObjectProvider(Object pc, boolean persist) {
        ObjectProvider sm = this.findObjectProvider(pc);
        if (sm == null && persist) {
            int objectType = 0;
            Object object2 = this.persistObjectInternal(pc, null, null, -1, objectType);
            sm = this.findObjectProvider(object2);
        } else if (sm == null) {
            return null;
        }
        return sm;
    }

    @Override
    public ObjectProvider findObjectProviderForEmbedded(Object value, ObjectProvider owner, AbstractMemberMetaData mmd) {
        ObjectProvider embeddedSM = this.findObjectProvider(value);
        if (embeddedSM == null) {
            embeddedSM = ObjectProviderFactory.newForEmbedded(this, value, false, owner, owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber());
        }
        if (embeddedSM.getEmbeddedOwners() == null || embeddedSM.getEmbeddedOwners().length == 0) {
            int absoluteFieldNumber = owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber();
            embeddedSM.addEmbeddedOwner(owner, absoluteFieldNumber);
            embeddedSM.setPcObjectType((short)1);
        }
        return embeddedSM;
    }

    @Override
    public ObjectProvider newObjectProvider(Object id, Object obj) {
        return ObjectProviderFactory.newForPersistentClean(this, id, obj);
    }

    @Override
    public ObjectProvider newObjectProviderForEmbedded(AbstractMemberMetaData ownerMmd, AbstractClassMetaData cmd, ObjectProvider ownerOP, int ownerFieldNumber) {
        Class pcClass = this.getClassLoaderResolver().classForName(cmd.getFullClassName());
        StateManager sm = (StateManager)ObjectProviderFactory.newForHollow(this, pcClass, null);
        sm.initialiseForEmbedded(sm.getObject(), false);
        if (ownerOP != null) {
            sm.addEmbeddedOwner(ownerOP, ownerFieldNumber);
        }
        return sm;
    }

    @Override
    public synchronized void hereIsObjectProvider(ObjectProvider sm, Object pc) {
        if (this.objectLookingForStateManager == pc) {
            this.foundStateManager = (StateManager)sm;
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            throw new NucleusUserException(LOCALISER.msg("010002"));
        }
        if (this.tx.isActive()) {
            throw new TransactionActiveOnCloseException(this);
        }
        if (!this.dirtySMs.isEmpty() && this.tx.getNontransactionalWrite()) {
            if (this.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.nontx.atomic")) {
                this.processNontransactionalUpdate();
            } else {
                this.tx.begin();
                this.tx.commit();
            }
        }
        if (this.getDetachOnClose()) {
            this.performDetachOnClose();
        }
        ExecutionContext.LifecycleListener[] listener = this.context.getObjectManagerListeners();
        for (int i = 0; i < listener.length; ++i) {
            listener[i].preClose(this);
        }
        this.disconnectSMCache();
        this.disconnectLifecycleListener();
        this.fetchPlan.clearGroups().addGroup("default");
        this.closed = true;
        this.tx = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010001", this));
        }
    }

    @Override
    public void disconnectSMCache() {
        if (this.cache != null) {
            HashSet cachedSMsClone = new HashSet(this.cache.values());
            for (StateManager sm : cachedSMsClone) {
                if (sm == null) continue;
                sm.disconnect();
            }
            this.cache.clear();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003011"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNontransactionalUpdate() {
        if (this.tx.isActive()) {
            return;
        }
        if (!this.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.nontx.atomic")) {
            return;
        }
        if (!this.dirtySMs.isEmpty() && this.tx.getNontransactionalWrite()) {
            for (StateManager sm : this.dirtySMs) {
                this.enlistedSMCache.put(sm.getInternalObjectId(), sm);
            }
            Object object = this.readWriteLock;
            synchronized (object) {
                this.flushInternal(true);
                if (this.context.hasLevel2Cache()) {
                    this.performLevel2CacheUpdateAtCommit();
                }
                if (this.getDetachAllOnCommit()) {
                    this.performDetachAllOnTxnEndPreparation();
                    this.performDetachAllOnTxnEnd();
                }
                ArrayList<RuntimeException> failures = null;
                try {
                    ApiAdapter api = this.getApiAdapter();
                    StateManager[] sms = this.enlistedSMCache.values().toArray(new StateManager[this.enlistedSMCache.size()]);
                    for (int i = 0; i < sms.length; ++i) {
                        try {
                            if (sms[i] == null || sms[i].getObject() == null || !api.isPersistent(sms[i].getObject()) && !api.isTransactional(sms[i].getObject())) continue;
                            sms[i].postCommit(this.getTransaction());
                            continue;
                        }
                        catch (RuntimeException e) {
                            if (failures == null) {
                                failures = new ArrayList<RuntimeException>();
                            }
                            failures.add(e);
                        }
                    }
                    Object var9_8 = null;
                    this.resetTransactionalVariables();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    this.resetTransactionalVariables();
                    throw throwable;
                }
                if (failures != null && !failures.isEmpty()) {
                    throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void evictObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            StateManager sm = this.findStateManager(obj);
            if (sm == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            sm.evict();
            Object var4_3 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictObjects(Class cls, boolean subclasses) {
        this.assertIsOpen();
        if (this.cache != null) {
            Object object = this.readWriteLock;
            synchronized (object) {
                ArrayList stateManagersToEvict = new ArrayList();
                stateManagersToEvict.addAll(this.cache.values());
                for (StateManager sm : stateManagersToEvict) {
                    Object pc = sm.getObject();
                    boolean evict = false;
                    if (!subclasses && pc.getClass() == cls) {
                        evict = true;
                    } else if (subclasses && cls.isAssignableFrom(pc.getClass())) {
                        evict = true;
                    }
                    if (!evict) continue;
                    sm.evict();
                    this.removeObjectFromCache(this.getApiAdapter().getIdForObject(pc));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictAllObjects() {
        this.assertIsOpen();
        if (this.cache != null) {
            Object object = this.readWriteLock;
            synchronized (object) {
                ArrayList stateManagersToEvict = new ArrayList();
                stateManagersToEvict.addAll(this.cache.values());
                for (StateManager sm : stateManagersToEvict) {
                    Object pc = sm.getObject();
                    sm.evict();
                    this.removeObjectFromCache(this.getApiAdapter().getIdForObject(pc));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refreshObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            StateManager sm = this.findStateManager(obj);
            if (sm == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj) && sm.isWaitingToBeFlushedToDatastore()) {
                Object var4_3 = null;
                this.clr.unsetPrimary();
                return;
            }
            sm.refresh();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
        Object var4_4 = null;
        this.clr.unsetPrimary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAllObjects() {
        this.assertIsOpen();
        HashSet<StateManager> toRefresh = new HashSet<StateManager>();
        toRefresh.addAll(this.enlistedSMCache.values());
        toRefresh.addAll(this.dirtySMs);
        toRefresh.addAll(this.indirectDirtySMs);
        if (!this.tx.isActive() && this.cache != null) {
            toRefresh.addAll(this.cache.values());
        }
        Object object = this.readWriteLock;
        synchronized (object) {
            ArrayList<RuntimeException> failures = null;
            Iterator iter = toRefresh.iterator();
            while (iter.hasNext()) {
                try {
                    Object obj = iter.next();
                    StateManager sm = this.getApiAdapter().isPersistable(obj) ? this.findStateManager(obj) : (StateManager)obj;
                    sm.refresh();
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                throw new NucleusUserException(LOCALISER.msg("010037"), failures.toArray(new Exception[failures.size()]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void retrieveObject(Object obj, boolean fgOnly) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            StateManager sm = this.findStateManager(obj);
            if (sm == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            sm.retrieve(fgOnly);
            Object var5_4 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    protected ThreadContextInfo acquireThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        ++threadInfo.referenceCounter;
        return threadInfo;
    }

    protected ThreadContextInfo getThreadContextInfo() {
        return (ThreadContextInfo)this.contextInfoThreadLocal.get();
    }

    protected void releaseThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        if (--threadInfo.referenceCounter <= 0) {
            threadInfo.referenceCounter = 0;
            if (threadInfo.attachedPCById != null) {
                threadInfo.attachedPCById.clear();
            }
            threadInfo.attachedPCById = null;
            this.contextInfoThreadLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object persistObject(Object obj) {
        if (obj == null) {
            return null;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            StateManager sm;
            if (threadInfo.attachedPCById == null) {
                threadInfo.attachedPCById = new HashMap();
            }
            boolean detached = this.getApiAdapter().isDetached(obj);
            Object persistedPc = null;
            if (this.getMultithreaded()) {
                Object object = obj;
                synchronized (object) {
                    persistedPc = this.persistObjectInternal(obj, null, null, -1, 0);
                }
            } else {
                persistedPc = this.persistObjectInternal(obj, null, null, -1, 0);
            }
            if ((sm = this.findStateManager(persistedPc)) != null) {
                if (this.indirectDirtySMs.contains(sm)) {
                    this.dirtySMs.add(sm);
                    this.indirectDirtySMs.remove(sm);
                } else if (!this.dirtySMs.contains(sm)) {
                    this.dirtySMs.add(sm);
                    if (this.txCachedIds != null) {
                        this.txCachedIds.add(sm.getInternalObjectId());
                    }
                }
                if (this.getReachabilityAtCommit() && this.tx.isActive() && (detached || this.getApiAdapter().isNew(persistedPc))) {
                    this.txKnownPersistedIds.add(sm.getInternalObjectId());
                }
            }
            Object object = persistedPc;
            Object var8_8 = null;
            if (!this.tx.isActive()) {
                this.processNontransactionalUpdate();
            }
            this.releaseThreadContextInfo();
            return object;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!this.tx.isActive()) {
                this.processNontransactionalUpdate();
            }
            this.releaseThreadContextInfo();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] persistObjects(Object[] objs) {
        if (objs == null) {
            return null;
        }
        Object[] persistedObjs = new Object[objs.length];
        try {
            this.getStoreManager().getPersistenceHandler().batchStart(this);
            ArrayList<RuntimeException> failures = null;
            for (int i = 0; i < objs.length; ++i) {
                try {
                    persistedObjs[i] = this.persistObject(objs[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                throw new NucleusUserException(LOCALISER.msg("010039"), failures.toArray(new Exception[failures.size()]));
            }
            Object var7_6 = null;
            this.getStoreManager().getPersistenceHandler().batchEnd(this);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.getStoreManager().getPersistenceHandler().batchEnd(this);
            throw throwable;
        }
        return persistedObjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object persistObjectInternal(Object obj, FieldValues preInsertChanges, ObjectProvider ownerSM, int ownerFieldNum, int objectType) {
        if (obj == null) {
            return null;
        }
        Object id = null;
        try {
            StateManager sm;
            ExecutionContext ec;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            if (!this.getApiAdapter().isDetached(obj) && NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
            }
            if ((ec = this.getApiAdapter().getExecutionContext(obj)) != null && ec != this) {
                throw new NucleusUserException(LOCALISER.msg("010007", obj));
            }
            Object persistedPc = obj;
            if (this.getApiAdapter().isDetached(obj)) {
                this.assertDetachable(obj);
                if (this.getCopyOnAttach()) {
                    persistedPc = this.attachObjectCopy(obj, this.getApiAdapter().getIdForObject(obj) == null);
                } else {
                    this.attachObject(obj, this.getApiAdapter().getIdForObject(obj) == null);
                    persistedPc = obj;
                }
            } else if (this.getApiAdapter().isTransactional(obj) && !this.getApiAdapter().isPersistent(obj)) {
                sm = this.findStateManager(obj);
                if (sm == null) {
                    throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
                }
                sm.makePersistentTransactionalTransient();
            } else if (!this.getApiAdapter().isPersistent(obj)) {
                sm = this.findStateManager(obj);
                if (sm == null) {
                    if (objectType != 0 && ownerSM != null) {
                        sm = (StateManager)ObjectProviderFactory.newForEmbedded(this, obj, false, ownerSM, ownerFieldNum);
                        sm.setPcObjectType((short)objectType);
                        sm.makePersistent();
                        id = sm.getInternalObjectId();
                    } else {
                        sm = (StateManager)ObjectProviderFactory.newForPersistentNew(this, obj, preInsertChanges);
                        sm.makePersistent();
                        id = sm.getInternalObjectId();
                    }
                } else if (sm.getReferencedPC() == null) {
                    sm.makePersistent();
                    id = sm.getInternalObjectId();
                } else {
                    persistedPc = sm.getReferencedPC();
                }
            } else if (this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().getIdForObject(obj) == null) {
                sm = this.findStateManager(obj);
                sm.makePersistent();
                id = sm.getInternalObjectId();
            } else if (this.getApiAdapter().isDeleted(obj)) {
                sm = this.findStateManager(obj);
                sm.makePersistent();
                id = sm.getInternalObjectId();
            } else if (this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().isTransactional(obj) && this.getApiAdapter().isDirty(obj) && this.isDelayDatastoreOperationsEnabled()) {
                sm = this.findStateManager(obj);
                sm.makePersistent();
                id = sm.getInternalObjectId();
            }
            if (id != null && this.txCachedIds != null) {
                this.txCachedIds.add(id);
            }
            Object object = persistedPc;
            Object var11_10 = null;
            this.clr.unsetPrimary();
            return object;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    @Override
    public Object persistObjectInternal(Object pc, ObjectProvider ownerSM, int ownerFieldNum, int objectType) {
        if (ownerSM != null) {
            StateManager sm = this.findStateManager(ownerSM.getObject());
            return this.persistObjectInternal(pc, null, sm, ownerFieldNum, objectType);
        }
        return this.persistObjectInternal(pc, null, null, ownerFieldNum, objectType);
    }

    @Override
    public Object persistObjectInternal(Object pc, FieldValues preInsertChanges, int objectType) {
        return this.persistObjectInternal(pc, preInsertChanges, null, -1, objectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteObject(Object obj) {
        try {
            StateManager sm = this.findStateManager(obj);
            if (sm != null) {
                if (this.indirectDirtySMs.contains(sm)) {
                    this.indirectDirtySMs.remove(sm);
                    this.dirtySMs.add(sm);
                } else if (!this.dirtySMs.contains(sm)) {
                    this.dirtySMs.add(sm);
                    if (this.txCachedIds != null) {
                        this.txCachedIds.add(sm.getInternalObjectId());
                    }
                }
            }
            if (this.getMultithreaded()) {
                Object object = obj;
                synchronized (object) {
                    this.deleteObjectInternal(obj);
                }
            } else {
                this.deleteObjectInternal(obj);
            }
            if (this.getReachabilityAtCommit() && this.tx.isActive() && sm != null && this.getApiAdapter().isDeleted(obj)) {
                this.txKnownDeletedIds.add(sm.getInternalObjectId());
            }
            Object var6_5 = null;
            if (!this.tx.isActive()) {
                this.processNontransactionalUpdate();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!this.tx.isActive()) {
                this.processNontransactionalUpdate();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectInternal(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            StateManager sm;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            Object pc = obj;
            if (this.getApiAdapter().isDetached(obj)) {
                pc = this.findObject(this.getApiAdapter().getIdForObject(obj), true, true, null);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010019", (Object)StringUtils.toJVMIDString(pc)));
            }
            if (this.getApiAdapter().getName().equals("JDO")) {
                if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010020"));
                }
                if (!this.getApiAdapter().isPersistent(pc) && this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010021"));
                }
            }
            if ((sm = this.findStateManager(pc)) == null) {
                if (!this.getApiAdapter().allowDeleteOfNonPersistentObject()) {
                    throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(pc)));
                }
                sm = (StateManager)ObjectProviderFactory.newForPNewToBeDeleted(this, pc);
            }
            if (this.txCachedIds != null) {
                this.txCachedIds.add(sm.getInternalObjectId());
            }
            sm.deletePersistent();
            Object var5_4 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjects(Object[] objs) {
        if (objs == null) {
            return;
        }
        try {
            this.getStoreManager().getPersistenceHandler().batchStart(this);
            ArrayList<RuntimeException> failures = null;
            for (int i = 0; i < objs.length; ++i) {
                try {
                    this.deleteObject(objs[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                throw new NucleusUserException(LOCALISER.msg("010040"), failures.toArray(new Exception[failures.size()]));
            }
            Object var6_5 = null;
            this.getStoreManager().getPersistenceHandler().batchEnd(this);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.getStoreManager().getPersistenceHandler().batchEnd(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void makeObjectTransient(Object obj, FetchPlanState state) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010022", (Object)StringUtils.toJVMIDString(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj)) {
                StateManager sm = this.findStateManager(obj);
                sm.makeTransient(state);
            }
            Object var5_4 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void makeObjectTransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            StateManager sm;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (this.getApiAdapter().isPersistent(obj)) {
                this.assertActiveTransaction();
            }
            if ((sm = this.findStateManager(obj)) == null) {
                sm = (StateManager)ObjectProviderFactory.newForTransactionalTransient(this, obj);
            }
            sm.makeTransactional();
            Object var4_3 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeObjectNontransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            if (!this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().isTransactional(obj) && this.getApiAdapter().isDirty(obj)) {
                throw new NucleusUserException(LOCALISER.msg("010024"));
            }
            StateManager sm = this.findStateManager(obj);
            sm.makeNontransactional();
            Object var4_3 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    @Override
    public synchronized void attachObject(Object pc, boolean sco) {
        this.assertIsOpen();
        this.assertClassPersistable(pc.getClass());
        ApiAdapter api = this.getApiAdapter();
        Object id = api.getIdForObject(pc);
        if (id != null && this.isInserting(pc)) {
            return;
        }
        if (id == null && !sco) {
            this.persistObjectInternal(pc, null, null, -1, 0);
            return;
        }
        if (api.isDetached(pc)) {
            StateManager l1CachedSM;
            if (this.cache != null && (l1CachedSM = (StateManager)this.cache.get(id)) != null && l1CachedSM.getObject() != pc) {
                throw new NucleusUserException(LOCALISER.msg("010017", (Object)StringUtils.toJVMIDString(pc)));
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010016", (Object)StringUtils.toJVMIDString(pc)));
            }
        } else {
            return;
        }
        StateManager sm = (StateManager)ObjectProviderFactory.newForDetached(this, pc, id, api.getVersionForObject(pc));
        sm.attach(sco);
    }

    @Override
    public synchronized Object attachObjectCopy(Object pc, boolean sco) {
        this.assertIsOpen();
        this.assertClassPersistable(pc.getClass());
        this.assertDetachable(pc);
        ApiAdapter api = this.getApiAdapter();
        Object id = api.getIdForObject(pc);
        if (id != null && this.isInserting(pc)) {
            return pc;
        }
        if (id == null && !sco) {
            return this.persistObjectInternal(pc, null, null, -1, 0);
        }
        if (api.isPersistent(pc)) {
            return pc;
        }
        Object pcTarget = null;
        if (sco) {
            boolean detached = this.getApiAdapter().isDetached(pc);
            StateManager smTarget = (StateManager)ObjectProviderFactory.newForEmbedded(this, pc, true, null, -1);
            pcTarget = smTarget.getObject();
            if (detached) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010018", (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(pcTarget)));
                }
                smTarget.attachCopy(pc, sco);
            }
        } else {
            boolean detached = this.getApiAdapter().isDetached(pc);
            pcTarget = this.findObject(id, false, false, pc.getClass().getName());
            if (detached) {
                Object obj = null;
                HashMap attachedPCById = this.getThreadContextInfo().attachedPCById;
                if (attachedPCById != null) {
                    obj = attachedPCById.get(this.getApiAdapter().getIdForObject(pc));
                }
                if (obj != null) {
                    pcTarget = obj;
                } else {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010018", (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(pcTarget)));
                    }
                    pcTarget = this.findStateManager(pcTarget).attachCopy(pc, sco);
                    if (attachedPCById != null) {
                        attachedPCById.put(this.getApiAdapter().getIdForObject(pc), pcTarget);
                    }
                }
            }
        }
        return pcTarget;
    }

    @Override
    public synchronized void detachObject(Object obj, FetchPlanState state) {
        StateManager sm;
        this.assertIsOpen();
        this.assertClassPersistable(obj.getClass());
        this.assertDetachable(obj);
        if (this.getApiAdapter().isDetached(obj)) {
            return;
        }
        if (!this.getApiAdapter().isPersistent(obj) && this.tx.isActive()) {
            this.persistObjectInternal(obj, null, null, -1, 0);
        }
        if ((sm = this.findStateManager(obj)) == null) {
            throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
        }
        sm.detach(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object detachObjectCopy(Object pc, FetchPlanState state) {
        this.assertIsOpen();
        this.assertClassPersistable(pc.getClass());
        Object thePC = pc;
        try {
            StateManager sm;
            this.clr.setPrimary(pc.getClass().getClassLoader());
            if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isDetached(pc)) {
                if (this.tx.isActive()) {
                    thePC = this.persistObjectInternal(pc, null, null, -1, 0);
                } else {
                    throw new NucleusUserException(LOCALISER.msg("010014"));
                }
            }
            if (this.getApiAdapter().isDetached(thePC)) {
                thePC = this.findObject(this.getApiAdapter().getIdForObject(thePC), false, true, null);
            }
            if ((sm = this.findStateManager(thePC)) == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(thePC)));
            }
            Object object = sm.detachCopy(state);
            Object var7_6 = null;
            this.clr.unsetPrimary();
            return object;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    @Override
    public void detachAll() {
        HashSet<StateManager> smsToDetach = new HashSet<StateManager>();
        smsToDetach.addAll(this.enlistedSMCache.values());
        if (this.cache != null) {
            smsToDetach.addAll(this.cache.values());
        }
        FetchPlanState fps = new FetchPlanState();
        Iterator iter = smsToDetach.iterator();
        while (iter.hasNext()) {
            ((StateManager)iter.next()).detach(fps);
        }
    }

    @Override
    public Object newInstance(Class cls) {
        this.assertIsOpen();
        if (this.getApiAdapter().isPersistable(cls) && !Modifier.isAbstract(cls.getModifiers())) {
            try {
                return cls.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new NucleusUserException(iae.toString(), iae);
            }
            catch (InstantiationException ie) {
                throw new NucleusUserException(ie.toString(), ie);
            }
        }
        this.assertHasImplementationCreator();
        return this.getNucleusContext().getImplementationCreator().newInstance(cls, this.clr);
    }

    @Override
    public boolean exists(Object obj) {
        if (obj == null) {
            return false;
        }
        Object id = this.getApiAdapter().getIdForObject(obj);
        if (id == null) {
            return false;
        }
        try {
            this.findObject(id, true, false, obj.getClass().getName());
        }
        catch (NucleusObjectNotFoundException onfe) {
            return false;
        }
        return true;
    }

    @Override
    public Set getManagedObjects() {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        Collection<StateManager> sms = this.enlistedSMCache.values();
        for (StateManager sm : sms) {
            objs.add(sm.getObject());
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        Collection<StateManager> sms = this.enlistedSMCache.values();
        block0: for (StateManager sm : sms) {
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i] != sm.getObject().getClass()) continue;
                objs.add(sm.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        Collection<StateManager> sms = this.enlistedSMCache.values();
        block0: for (StateManager sm : sms) {
            for (int i = 0; i < states.length; ++i) {
                if (!this.getApiAdapter().getObjectState(sm.getObject()).equals(states[i])) continue;
                objs.add(sm.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states, Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        Collection<StateManager> sms = this.enlistedSMCache.values();
        Iterator<StateManager> smsIter = sms.iterator();
        block0: while (smsIter.hasNext()) {
            boolean matches = false;
            StateManager sm = smsIter.next();
            for (int i = 0; i < states.length; ++i) {
                if (this.getApiAdapter().getObjectState(sm.getObject()).equals(states[i])) {
                    int j = 0;
                    while (i < classes.length) {
                        if (classes[j] == sm.getObject().getClass()) {
                            matches = true;
                            objs.add(sm.getObject());
                            break;
                        }
                        ++i;
                    }
                }
                if (matches) continue block0;
            }
        }
        return objs;
    }

    @Override
    public Object findObjectUsingAID(Type pcType, FieldValues fv, boolean ignoreCache, boolean checkInheritance) {
        Object pc;
        Object oid;
        this.assertIsOpen();
        Class pcClass = pcType.getType();
        StateManager sm = (StateManager)ObjectProviderFactory.newForHollowPopulatedAppId(this, pcClass, fv);
        if (!ignoreCache) {
            oid = sm.getInternalObjectId();
            pc = this.getObjectFromCache(oid);
            if (pc != null) {
                sm = this.findStateManager(pc);
                sm.loadFieldValues(fv);
                return pc;
            }
            if (checkInheritance) {
                String[] subclasses;
                ApiAdapter api = this.getApiAdapter();
                if ((oid instanceof OID || api.isSingleFieldIdentity(oid)) && (subclasses = this.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
                    for (int i = 0; i < subclasses.length; ++i) {
                        if (api.isDatastoreIdentity(oid)) {
                            oid = OIDFactory.getInstance(this.getNucleusContext(), subclasses[i], ((OID)oid).getKeyValue());
                        } else if (api.isSingleFieldIdentity(oid)) {
                            oid = api.getNewSingleFieldIdentity(oid.getClass(), this.clr.classForName(subclasses[i]), api.getTargetKeyForSingleFieldIdentity(oid));
                        }
                        pc = this.getObjectFromCache(oid);
                        if (pc == null) continue;
                        sm = this.findStateManager(pc);
                        sm.loadFieldValues(fv);
                        this.putObjectIntoLevel2Cache(sm, false);
                        return pc;
                    }
                }
            }
        }
        if (checkInheritance) {
            sm.checkInheritance(fv);
            if (!ignoreCache && (pc = this.getObjectFromCache(oid = sm.getInternalObjectId())) != null) {
                sm = this.findStateManager(pc);
                sm.loadFieldValues(fv);
                this.putObjectIntoLevel2Cache(sm, false);
                return pc;
            }
        }
        this.putObjectIntoCache(sm);
        if (this.txCachedIds != null && !this.txCachedIds.contains(sm.getInternalObjectId())) {
            this.putObjectIntoLevel2Cache(sm, false);
        }
        return sm.getObject();
    }

    @Override
    public Object findObject(Object id, FieldValues fv, Class cls, boolean ignoreCache) {
        StateManager sm;
        this.assertIsOpen();
        boolean createdHollow = false;
        Object pc = null;
        if (!ignoreCache) {
            pc = this.getObjectFromCache(id);
        }
        if (pc == null) {
            pc = this.getStoreManager().getPersistenceHandler().findObject(this, id);
        }
        if (pc == null) {
            String className;
            String string = className = cls != null ? cls.getName() : null;
            if (cls == null) {
                className = this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
                if (className == null) {
                    throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
                }
                if (id instanceof OID) {
                    id = OIDFactory.getInstance(this.getNucleusContext(), className, ((OID)id).getKeyValue());
                    pc = this.getObjectFromCache(id);
                }
            }
            if (pc == null) {
                if (cls == null) {
                    try {
                        cls = this.clr.classForName(className, id.getClass().getClassLoader());
                    }
                    catch (ClassNotResolvedException e) {
                        String msg = LOCALISER.msg("010027", (Object)this.getIdentityAsString(id));
                        NucleusLogger.PERSISTENCE.warn(msg);
                        throw new NucleusUserException(msg, e);
                    }
                }
                createdHollow = true;
                StateManager sm2 = (StateManager)ObjectProviderFactory.newForHollowPopulated(this, cls, id, fv);
                pc = sm2.getObject();
                this.putObjectIntoCache(sm2);
                this.putObjectIntoLevel2Cache(sm2, false);
            }
        }
        if (pc != null && fv != null && !createdHollow && (sm = this.findStateManager(pc)) != null) {
            fv.fetchNonLoadedFields(sm);
        }
        return pc;
    }

    @Override
    public Object[] findObjects(Object[] identities, boolean validate) {
        this.assertIsOpen();
        ApiAdapter api = this.getApiAdapter();
        Object[] objs = new Object[identities.length];
        Object[] ids = new Object[identities.length];
        ArrayList<Object> idsToFind = new ArrayList<Object>();
        for (int i = 0; i < identities.length; ++i) {
            if (identities[i] == null) {
                throw new NucleusUserException(LOCALISER.msg("010044"));
            }
            if (this.getNucleusContext().getIdentityTranslator() != null) {
                IdentityTranslator translator = this.getNucleusContext().getIdentityTranslator();
                ids[i] = translator.getIdentity(this, identities[i]);
            } else {
                ids[i] = identities[i];
            }
            Object pc = this.getObjectFromCache(ids[i]);
            if (pc != null) {
                objs[i] = pc;
                if (!(ids[i] instanceof SCOID) || !api.isPersistent(pc) || api.isNew(pc) || api.isDeleted(pc) || api.isTransactional(pc)) continue;
                throw new NucleusUserException(LOCALISER.msg("010005"));
            }
            idsToFind.add(ids[i]);
        }
        Object[] foundPcs = null;
        foundPcs = this.getStoreManager().getPersistenceHandler().findObjects(this, idsToFind.toArray());
        int foundPcIdx = 0;
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            Object pc = objs[i];
            boolean fromCache = true;
            if (pc == null) {
                pc = foundPcs[foundPcIdx];
                ++foundPcIdx;
            }
            StateManager sm = null;
            if (pc == null) {
                String className = null;
                String originalClassName = null;
                boolean checkedClassName = false;
                if (id instanceof SCOID) {
                    throw new NucleusUserException(LOCALISER.msg("010006"));
                }
                if (id instanceof DatastoreUniqueOID) {
                    throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
                }
                if (api.isDatastoreIdentity(id) || api.isSingleFieldIdentity(id)) {
                    originalClassName = this.getStoreManager().manageClassForIdentity(id, this.clr);
                } else {
                    originalClassName = this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
                    checkedClassName = true;
                }
                if (validate) {
                    String string = className = checkedClassName ? originalClassName : this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
                    if (className == null) {
                        throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
                    }
                    if (originalClassName != null && !originalClassName.equals(className)) {
                        if (api.isDatastoreIdentity(id)) {
                            id = OIDFactory.getInstance(this.getNucleusContext(), className, ((OID)id).getKeyValue());
                            pc = this.getObjectFromCache(id);
                        } else if (api.isSingleFieldIdentity(id)) {
                            id = api.getNewSingleFieldIdentity(id.getClass(), this.clr.classForName(className), api.getTargetKeyForSingleFieldIdentity(id));
                            pc = this.getObjectFromCache(id);
                        }
                    }
                } else {
                    className = originalClassName;
                }
                if (pc == null) {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                        sm = (StateManager)ObjectProviderFactory.newForHollow(this, pcClass, id);
                        pc = sm.getObject();
                        fromCache = false;
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id)));
                        throw new NucleusUserException(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id)), e);
                    }
                }
            }
            boolean performValidationWhenCached = this.context.getPersistenceConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
            if (validate && (!fromCache || performValidationWhenCached)) {
                if (fromCache && pc != null && api.isTransactional(pc)) {
                    objs[i] = pc;
                    continue;
                }
                sm = this.findStateManager(pc);
                if (sm != null && !fromCache) {
                    this.putObjectIntoCache(sm);
                }
                try {
                    sm.validate();
                }
                catch (NucleusObjectNotFoundException onfe) {
                    this.removeObjectFromCache(sm.getInternalObjectId());
                    throw onfe;
                }
                if (sm.getObject() != pc) {
                    this.removeObjectFromCache(sm.getInternalObjectId());
                    fromCache = false;
                    pc = sm.getObject();
                }
            }
            objs[i] = pc;
            if (sm == null || fromCache) continue;
            this.putObjectIntoCache(sm);
            this.putObjectIntoLevel2Cache(sm, false);
        }
        return objs;
    }

    @Override
    public Object findObject(Object id, boolean validate, boolean checkInheritance, String objectClassName) {
        this.assertIsOpen();
        if (id == null) {
            throw new NucleusUserException(LOCALISER.msg("010044"));
        }
        if (this.getNucleusContext().getIdentityTranslator() != null) {
            IdentityTranslator translator = this.getNucleusContext().getIdentityTranslator();
            id = translator.getIdentity(this, id);
        }
        Object pc = this.getObjectFromCache(id);
        boolean fromCache = true;
        ApiAdapter api = this.getApiAdapter();
        if (id instanceof SCOID && pc != null && api.isPersistent(pc) && !api.isNew(pc) && !api.isDeleted(pc) && !api.isTransactional(pc)) {
            throw new NucleusUserException(LOCALISER.msg("010005"));
        }
        if (pc != null && api.isTransactional(pc)) {
            return pc;
        }
        StateManager sm = null;
        if (pc == null && (pc = this.getStoreManager().getPersistenceHandler().findObject(this, id)) == null) {
            String className = null;
            String originalClassName = null;
            boolean checkedClassName = false;
            if (id instanceof SCOID) {
                throw new NucleusUserException(LOCALISER.msg("010006"));
            }
            if (id instanceof DatastoreUniqueOID) {
                throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
            }
            if (api.isDatastoreIdentity(id) || api.isSingleFieldIdentity(id)) {
                originalClassName = this.getStoreManager().manageClassForIdentity(id, this.clr);
            } else if (objectClassName != null) {
                originalClassName = objectClassName;
            } else {
                originalClassName = this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
                checkedClassName = true;
            }
            if (checkInheritance) {
                className = !checkedClassName ? this.getStoreManager().getClassNameForObjectID(id, this.clr, this) : originalClassName;
                if (className == null) {
                    throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
                }
                if (originalClassName != null && !originalClassName.equals(className)) {
                    if (api.isDatastoreIdentity(id)) {
                        id = OIDFactory.getInstance(this.getNucleusContext(), className, ((OID)id).getKeyValue());
                        pc = this.getObjectFromCache(id);
                    } else if (api.isSingleFieldIdentity(id)) {
                        id = api.getNewSingleFieldIdentity(id.getClass(), this.clr.classForName(className), api.getTargetKeyForSingleFieldIdentity(id));
                        pc = this.getObjectFromCache(id);
                    }
                }
            } else {
                className = originalClassName;
            }
            if (pc == null) {
                try {
                    Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                    if (Modifier.isAbstract(pcClass.getModifiers())) {
                        throw new NucleusObjectNotFoundException(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id), (Object)className));
                    }
                    sm = (StateManager)ObjectProviderFactory.newForHollow(this, pcClass, id);
                    pc = sm.getObject();
                    fromCache = false;
                    if (!checkInheritance && !validate) {
                        sm.markForInheritanceValidation();
                    }
                }
                catch (ClassNotResolvedException e) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id)));
                    throw new NucleusUserException(LOCALISER.msg("010027", (Object)this.getIdentityAsString(id)), e);
                }
            }
        }
        boolean performValidationWhenCached = this.context.getPersistenceConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
        if (validate && (!fromCache || performValidationWhenCached)) {
            if (sm == null) {
                sm = this.findStateManager(pc);
            }
            if (sm != null && !fromCache) {
                this.putObjectIntoCache(sm);
            }
            try {
                sm.validate();
            }
            catch (NucleusObjectNotFoundException onfe) {
                this.removeObjectFromCache(sm.getInternalObjectId());
                throw onfe;
            }
            if (sm.getObject() != pc) {
                fromCache = false;
                this.removeObjectFromCache(sm.getInternalObjectId());
            }
            if (!fromCache) {
                pc = sm.getObject();
            }
        }
        if (sm != null && !fromCache) {
            this.putObjectIntoCache(sm);
            this.putObjectIntoLevel2Cache(sm, false);
        }
        return pc;
    }

    @Override
    public Object newObjectId(Class pcClass, Object key) {
        this.assertIsOpen();
        if (pcClass == null) {
            throw new NucleusUserException(LOCALISER.msg("010028"));
        }
        this.assertClassPersistable(pcClass);
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(pcClass, this.clr);
        if (cmd == null) {
            throw new NoPersistenceInformationException(pcClass.getName());
        }
        if (!this.getStoreManager().managesClass(cmd.getFullClassName())) {
            this.getStoreManager().addClass(cmd.getFullClassName(), this.clr);
        }
        Object id = null;
        if (cmd.usesSingleFieldIdentityClass()) {
            Class idType = this.clr.classForName(cmd.getObjectidClass());
            id = this.getApiAdapter().getNewSingleFieldIdentity(idType, pcClass, key);
        } else if (key instanceof String) {
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (Modifier.isAbstract(pcClass.getModifiers()) && cmd.getObjectidClass() != null) {
                    try {
                        Constructor c = this.clr.classForName(cmd.getObjectidClass()).getDeclaredConstructor(String.class);
                        id = c.newInstance((String)key);
                    }
                    catch (Exception e) {
                        String msg = LOCALISER.msg("010030", (Object)cmd.getObjectidClass(), (Object)cmd.getFullClassName());
                        NucleusLogger.PERSISTENCE.error(msg);
                        NucleusLogger.PERSISTENCE.error(e);
                        throw new NucleusUserException(msg);
                    }
                } else {
                    this.clr.classForName(pcClass.getName(), true);
                    id = this.getApiAdapter().getNewApplicationIdentityObjectId(pcClass, key);
                }
            } else {
                id = OIDFactory.getInstance(this.getNucleusContext(), (String)key);
            }
        } else {
            throw new NucleusUserException(LOCALISER.msg("010029", (Object)pcClass.getName(), (Object)key.getClass().getName()));
        }
        return id;
    }

    @Override
    public Object newObjectId(String className, Object pc) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            Object nextIdentifier = this.getStoreManager().getStrategyValue(this, cmd, -1);
            return OIDFactory.getInstance(this.getNucleusContext(), cmd.getFullClassName(), nextIdentifier);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getApiAdapter().getNewApplicationIdentityObjectId(pc, cmd);
        }
        return new SCOID(className);
    }

    @Override
    public synchronized void clearDirty(StateManager sm) {
        this.dirtySMs.remove(sm);
        this.indirectDirtySMs.remove(sm);
    }

    @Override
    public synchronized void clearDirty() {
        this.dirtySMs.clear();
        this.indirectDirtySMs.clear();
    }

    @Override
    public synchronized void markDirty(ObjectProvider op, boolean directUpdate) {
        if (this.tx.isCommitting() && !this.tx.isActive()) {
            throw new NucleusException("Cannot change objects when transaction is no longer active.");
        }
        StateManager sm = (StateManager)op;
        boolean isInDirty = this.dirtySMs.contains(sm);
        boolean isInIndirectDirty = this.indirectDirtySMs.contains(sm);
        if (!(this.isDelayDatastoreOperationsEnabled() || isInDirty || isInIndirectDirty || this.dirtySMs.size() < this.getNucleusContext().getPersistenceConfiguration().getIntProperty("datanucleus.datastoreTransactionFlushLimit"))) {
            this.flushInternal(false);
        }
        if (directUpdate) {
            if (isInIndirectDirty) {
                this.indirectDirtySMs.remove(sm);
                this.dirtySMs.add(sm);
            } else if (!isInDirty) {
                this.dirtySMs.add(sm);
                if (this.txCachedIds != null) {
                    this.txCachedIds.add(sm.getInternalObjectId());
                }
            }
        } else if (!isInDirty && !isInIndirectDirty) {
            this.indirectDirtySMs.add(sm);
            if (this.txCachedIds != null) {
                this.txCachedIds.add(sm.getInternalObjectId());
            }
        }
    }

    @Override
    public boolean getManageRelations() {
        return this.properties.getBooleanProperty("datanucleus.manageRelationships");
    }

    @Override
    public boolean getManageRelationsChecks() {
        return this.properties.getBooleanProperty("datanucleus.manageRelationshipsChecks");
    }

    @Override
    public RelationshipManager getRelationshipManager(ObjectProvider op) {
        RelationshipManager relMgr;
        if (!this.getManageRelations()) {
            return null;
        }
        if (this.managedRelationDetails == null) {
            this.managedRelationDetails = new ConcurrentHashMap<ObjectProvider, RelationshipManager>();
        }
        if ((relMgr = this.managedRelationDetails.get(op)) == null) {
            relMgr = new RelationshipManagerImpl((StateManager)op);
            this.managedRelationDetails.put(op, relMgr);
        }
        return relMgr;
    }

    @Override
    public boolean isManagingRelations() {
        return this.runningManageRelations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performManagedRelationships() {
        if (this.getManageRelations() && this.managedRelationDetails != null && !this.managedRelationDetails.isEmpty()) {
            try {
                RelationshipManager relMgr;
                LifeCycleState lc;
                this.runningManageRelations = true;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013000"));
                }
                if (this.getManageRelationsChecks()) {
                    for (ObjectProvider sm : this.managedRelationDetails.keySet()) {
                        lc = sm.getLifecycleState();
                        if (lc == null || lc.isDeleted()) continue;
                        relMgr = this.managedRelationDetails.get(sm);
                        relMgr.checkConsistency();
                    }
                }
                for (ObjectProvider op : this.managedRelationDetails.keySet()) {
                    lc = op.getLifecycleState();
                    if (lc == null || lc.isDeleted()) continue;
                    relMgr = this.managedRelationDetails.get(op);
                    relMgr.process();
                    relMgr.clearFields();
                }
                this.managedRelationDetails.clear();
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013001"));
                }
                Object var6_5 = null;
                this.runningManageRelations = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.runningManageRelations = false;
                throw throwable;
            }
        }
    }

    @Override
    public boolean isFlushing() {
        return this.flushing;
    }

    @Override
    public synchronized void flush() {
        this.assertIsOpen();
        if (this.tx.isActive()) {
            this.performManagedRelationships();
            this.flushInternal(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flushInternal(boolean flushToDatastore) {
        this.assertIsOpen();
        if (!flushToDatastore && this.dirtySMs.size() == 0 && this.indirectDirtySMs.size() == 0) {
            return;
        }
        this.flushing = true;
        try {
            List<NucleusOptimisticException> optimisticFailures = null;
            Boolean optimisedFlag = this.getNucleusContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.flush.optimised");
            optimisticFailures = optimisedFlag != null ? (optimisedFlag != false ? this.flushInternalNonReferential() : this.flushInternalWithOrdering()) : (!this.getStoreManager().getPersistenceHandler().useReferentialIntegrity() ? this.flushInternalNonReferential() : this.flushInternalWithOrdering());
            if (flushToDatastore) {
                this.tx.flush();
            }
            if (optimisticFailures != null) {
                throw new NucleusOptimisticException(LOCALISER.msg("010031"), optimisticFailures.toArray(new Throwable[optimisticFailures.size()]));
            }
            Object var5_4 = null;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010004"));
            }
            this.flushing = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010004"));
            }
            this.flushing = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NucleusOptimisticException> flushInternalWithOrdering() {
        StateManager sm;
        int i;
        Object[] toFlushIndirect;
        Object[] toFlushDirect;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010003", this.dirtySMs.size() + this.indirectDirtySMs.size()));
        }
        ArrayList<NucleusOptimisticException> optimisticFailures = null;
        List<StateManager> list = this.dirtySMs;
        synchronized (list) {
            toFlushDirect = this.dirtySMs.toArray();
            this.dirtySMs.clear();
        }
        List<StateManager> list2 = this.indirectDirtySMs;
        synchronized (list2) {
            toFlushIndirect = this.indirectDirtySMs.toArray();
            this.indirectDirtySMs.clear();
        }
        for (i = 0; i < toFlushDirect.length; ++i) {
            sm = (StateManager)toFlushDirect[i];
            try {
                sm.flush();
                continue;
            }
            catch (NucleusOptimisticException oe) {
                if (optimisticFailures == null) {
                    optimisticFailures = new ArrayList<NucleusOptimisticException>();
                }
                optimisticFailures.add(oe);
            }
        }
        for (i = 0; i < toFlushIndirect.length; ++i) {
            sm = (StateManager)toFlushIndirect[i];
            try {
                sm.flush();
                continue;
            }
            catch (NucleusOptimisticException oe) {
                if (optimisticFailures == null) {
                    optimisticFailures = new ArrayList();
                }
                optimisticFailures.add(oe);
            }
        }
        return optimisticFailures;
    }

    protected List<NucleusOptimisticException> flushInternalNonReferential() {
        ArrayList<NucleusOptimisticException> optimisticFailures = null;
        StorePersistenceHandler persistenceHandler = this.getStoreManager().getPersistenceHandler();
        HashSet<StateManager> opsToFlush = new HashSet<StateManager>();
        opsToFlush.addAll(this.dirtySMs);
        this.dirtySMs.clear();
        opsToFlush.addAll(this.indirectDirtySMs);
        this.indirectDirtySMs.clear();
        HashSet<ObjectProvider> opsToDelete = new HashSet<ObjectProvider>();
        HashSet<ObjectProvider> opsToInsert = new HashSet<ObjectProvider>();
        Iterator opIter = opsToFlush.iterator();
        while (opIter.hasNext()) {
            ObjectProvider op = (ObjectProvider)opIter.next();
            if (op.isEmbedded()) {
                op.markAsFlushed();
                opIter.remove();
                continue;
            }
            if (op.getLifecycleState().isNew() && !op.isFlushedToDatastore() && !op.isFlushedNew()) {
                opsToInsert.add(op);
                opIter.remove();
                continue;
            }
            if (!op.getLifecycleState().isDeleted() || op.isFlushedToDatastore()) continue;
            if (!op.getLifecycleState().isNew()) {
                opsToDelete.add(op);
                opIter.remove();
                continue;
            }
            if (!op.getLifecycleState().isNew() || !op.isFlushedNew()) continue;
            opsToDelete.add(op);
            opIter.remove();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010046", opsToDelete.size(), (Object)opsToInsert.size(), (Object)opsToFlush.size()));
        }
        if (!opsToDelete.isEmpty()) {
            for (ObjectProvider objectProvider : opsToDelete) {
                objectProvider.setFlushing(true);
                this.getCallbackHandler().preDelete(objectProvider.getObject());
            }
            try {
                persistenceHandler.deleteObjects(opsToDelete.toArray(new ObjectProvider[opsToDelete.size()]));
            }
            catch (NucleusOptimisticException noe) {
                if (optimisticFailures == null) {
                    optimisticFailures = new ArrayList<NucleusOptimisticException>();
                }
                optimisticFailures.add(noe);
            }
            for (ObjectProvider objectProvider : opsToDelete) {
                this.getCallbackHandler().postDelete(objectProvider.getObject());
                objectProvider.setFlushedNew(false);
                objectProvider.markAsFlushed();
                objectProvider.setFlushing(false);
            }
        }
        if (!opsToInsert.isEmpty()) {
            for (ObjectProvider objectProvider : opsToInsert) {
                objectProvider.setFlushing(true);
                this.getCallbackHandler().preStore(objectProvider.getObject());
            }
            persistenceHandler.insertObjects(opsToInsert.toArray(new ObjectProvider[opsToInsert.size()]));
            for (ObjectProvider objectProvider : opsToInsert) {
                this.getCallbackHandler().postStore(objectProvider.getObject());
                objectProvider.markAsFlushed();
                objectProvider.setFlushing(false);
                this.putObjectIntoCache(objectProvider);
            }
        }
        if (!opsToFlush.isEmpty()) {
            for (ObjectProvider objectProvider : opsToFlush) {
                try {
                    objectProvider.flush();
                }
                catch (NucleusOptimisticException oe) {
                    if (optimisticFailures == null) {
                        optimisticFailures = new ArrayList();
                    }
                    optimisticFailures.add(oe);
                }
            }
        }
        return optimisticFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postBegin() {
        Object object = this.readWriteLock;
        synchronized (object) {
            int i;
            StateManager[] sms = this.dirtySMs.toArray(new StateManager[this.dirtySMs.size()]);
            for (i = 0; i < sms.length; ++i) {
                sms[i].preBegin(this.tx);
            }
            sms = this.indirectDirtySMs.toArray(new StateManager[this.indirectDirtySMs.size()]);
            for (i = 0; i < sms.length; ++i) {
                sms[i].preBegin(this.tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preCommit() {
        Object object = this.readWriteLock;
        synchronized (object) {
            this.flush();
            if (this.getReachabilityAtCommit()) {
                try {
                    try {
                        this.runningPBRAtCommit = true;
                        this.performReachabilityAtCommit();
                        this.getTransaction().flush();
                    }
                    catch (Throwable t) {
                        NucleusLogger.PERSISTENCE.error(t);
                        if (t instanceof NucleusException) {
                            throw (NucleusException)t;
                        }
                        throw new NucleusException("Unexpected error during precommit", t);
                    }
                    Object var4_2 = null;
                    this.runningPBRAtCommit = false;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    this.runningPBRAtCommit = false;
                    throw throwable;
                }
            }
            if (this.context.hasLevel2Cache()) {
                this.performLevel2CacheUpdateAtCommit();
            }
            if (this.getDetachAllOnCommit()) {
                this.performDetachAllOnTxnEndPreparation();
            }
        }
    }

    @Override
    public boolean isObjectModifiedInTransaction(Object id) {
        if (this.txCachedIds != null) {
            return this.txCachedIds.contains(id);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLevel2CacheUpdateAtCommit() {
        Level2Cache l2Cache;
        Level2Cache level2Cache = l2Cache = this.context.getLevel2Cache();
        synchronized (level2Cache) {
            for (Object id : this.txCachedIds) {
                StateManager sm = this.enlistedSMCache.get(id);
                if (sm == null) {
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(LOCALISER.msg("004014", id));
                    }
                    l2Cache.evict(id);
                    continue;
                }
                Object objID = this.getApiAdapter().getIdForObject(sm.getObject());
                if (objID == null) continue;
                if (this.getApiAdapter().isDeleted(sm.getObject())) {
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(LOCALISER.msg("004007", (Object)StringUtils.toJVMIDString(sm.getObject()), sm.getInternalObjectId()));
                    }
                    l2Cache.evict(objID);
                    continue;
                }
                if (this.getApiAdapter().isDetached(sm.getObject())) continue;
                this.putObjectIntoLevel2CacheInternal(sm, true);
            }
            this.txCachedIds.clear();
        }
    }

    private void performReachabilityAtCommit() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010032"));
        }
        if (this.txKnownPersistedIds.size() > 0 && this.txFlushedNewIds.size() > 0) {
            HashSet currentReachables = new HashSet();
            Object[] ids = this.txKnownPersistedIds.toArray();
            HashSet<Object> objectNotFound = new HashSet<Object>();
            for (int i = 0; i < ids.length; ++i) {
                if (this.txKnownDeletedIds.contains(ids[i])) continue;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug("Performing reachability algorithm on object with id \"" + ids[i] + "\"");
                }
                try {
                    StateManager sm = this.findStateManager(this.findObject(ids[i], true, true, null));
                    sm.runReachability(currentReachables);
                    if (i % 10000 != 0 && i != ids.length - 1) continue;
                    this.flushInternal(true);
                    continue;
                }
                catch (NucleusObjectNotFoundException ex) {
                    objectNotFound.add(ids[i]);
                }
            }
            this.txFlushedNewIds.removeAll(currentReachables);
            Object[] nonReachableIds = this.txFlushedNewIds.toArray();
            if (nonReachableIds != null && nonReachableIds.length > 0) {
                StateManager sm;
                int i;
                for (i = 0; i < nonReachableIds.length; ++i) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010033", nonReachableIds[i]));
                    }
                    try {
                        if (objectNotFound.contains(nonReachableIds[i])) continue;
                        sm = this.findStateManager(this.findObject(nonReachableIds[i], true, true, null));
                        sm.nullifyFields();
                        if (i % 10000 != 0 && i != nonReachableIds.length - 1) continue;
                        this.flushInternal(true);
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
                for (i = 0; i < nonReachableIds.length; ++i) {
                    try {
                        if (objectNotFound.contains(nonReachableIds[i])) continue;
                        sm = this.findStateManager(this.findObject(nonReachableIds[i], true, true, null));
                        sm.deletePersistent();
                        if (i % 10000 != 0 && i != nonReachableIds.length - 1) continue;
                        this.flushInternal(true);
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
            }
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010034"));
        }
    }

    private void performDetachAllOnTxnEndPreparation() {
        ArrayList<StateManager> sms = new ArrayList<StateManager>();
        Collection roots = this.fetchPlan.getDetachmentRoots();
        Class[] rootClasses = this.fetchPlan.getDetachmentRootClasses();
        if (roots != null && roots.size() > 0) {
            for (Object obj : roots) {
                sms.add(this.findStateManager(obj));
            }
        } else if (rootClasses != null && rootClasses.length > 0) {
            StateManager[] txSMs = this.enlistedSMCache.values().toArray(new StateManager[this.enlistedSMCache.size()]);
            block3: for (int i = 0; i < txSMs.length; ++i) {
                for (int j = 0; j < rootClasses.length; ++j) {
                    if (txSMs[i].getObject().getClass() != rootClasses[j]) continue;
                    sms.add(txSMs[i]);
                    continue block3;
                }
            }
        } else if (this.cache != null) {
            sms.addAll(this.cache.values());
        }
        Iterator smsIter = sms.iterator();
        while (smsIter.hasNext()) {
            StateManager sm = (StateManager)smsIter.next();
            Object pc = sm.getObject();
            if (pc == null || this.getApiAdapter().isDetached(pc) || this.getApiAdapter().isDeleted(pc)) continue;
            FetchPlanState state = new FetchPlanState();
            try {
                sm.loadFieldsInFetchPlan(state);
            }
            catch (NucleusObjectNotFoundException onfe) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010013", (Object)StringUtils.toJVMIDString(pc), sm.getInternalObjectId()));
                smsIter.remove();
            }
        }
        this.detachAllOnTxnEndSMs = sms.toArray(new StateManager[sms.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachAllOnTxnEnd() {
        try {
            this.runningDetachAllOnTxnEnd = true;
            StateManager[] smsToDetach = this.detachAllOnTxnEndSMs;
            DetachState state = new DetachState(this.getApiAdapter());
            for (int i = 0; i < smsToDetach.length; ++i) {
                Object pc = smsToDetach[i].getObject();
                if (pc == null) continue;
                smsToDetach[i].detach(state);
            }
            this.detachAllOnTxnEndSMs = null;
            Object var6_5 = null;
            this.runningDetachAllOnTxnEnd = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.runningDetachAllOnTxnEnd = false;
            throw throwable;
        }
    }

    @Override
    public boolean isRunningDetachAllOnCommit() {
        return this.runningDetachAllOnTxnEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachOnClose() {
        if (this.cache != null) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010011"));
            try {
                this.tx.begin();
                ArrayList toDetach = new ArrayList();
                toDetach.addAll(this.cache.values());
                for (StateManager sm : toDetach) {
                    if (sm == null || sm.getObject() == null || sm.getObjectManager().getApiAdapter().isDeleted(sm.getObject())) continue;
                    try {
                        sm.detach(new DetachState(this.getApiAdapter()));
                    }
                    catch (NucleusObjectNotFoundException onfe) {}
                }
                this.tx.commit();
                Object var6_5 = null;
                if (this.tx.isActive()) {
                    this.tx.rollback();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.tx.isActive()) {
                    this.tx.rollback();
                }
                throw throwable;
            }
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010012"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postCommit() {
        Object object = this.readWriteLock;
        synchronized (object) {
            if (this.getDetachAllOnCommit()) {
                this.performDetachAllOnTxnEnd();
            }
            ArrayList<RuntimeException> failures = null;
            try {
                ApiAdapter api = this.getApiAdapter();
                StateManager[] sms = this.enlistedSMCache.values().toArray(new StateManager[this.enlistedSMCache.size()]);
                for (int i = 0; i < sms.length; ++i) {
                    try {
                        if (sms[i] == null || sms[i].getObject() == null || !api.isPersistent(sms[i].getObject()) && !api.isTransactional(sms[i].getObject())) continue;
                        sms[i].postCommit(this.getTransaction());
                        if (!this.getDetachAllOnCommit() || !api.isDetachable(sms[i].getObject())) continue;
                        this.removeStateManager(sms[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                Object var8_7 = null;
                this.resetTransactionalVariables();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.resetTransactionalVariables();
                throw throwable;
            }
            if (failures != null && !failures.isEmpty()) {
                throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preRollback() {
        Object object = this.readWriteLock;
        synchronized (object) {
            ArrayList<RuntimeException> failures = null;
            try {
                Collection<StateManager> sms = this.enlistedSMCache.values();
                for (StateManager sm : sms) {
                    try {
                        sm.preRollback(this.getTransaction());
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                this.clearDirty();
                Object var8_7 = null;
                this.resetTransactionalVariables();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.resetTransactionalVariables();
                throw throwable;
            }
            if (failures != null && !failures.isEmpty()) {
                throw new RollbackStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
            if (this.getDetachAllOnRollback()) {
                this.performDetachAllOnTxnEndPreparation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRollback() {
        Object object = this.readWriteLock;
        synchronized (object) {
            if (this.getDetachAllOnRollback()) {
                this.performDetachAllOnTxnEnd();
            }
        }
    }

    private void resetTransactionalVariables() {
        if (this.getReachabilityAtCommit()) {
            this.txEnlistedIds.clear();
            this.txKnownPersistedIds.clear();
            this.txKnownDeletedIds.clear();
            this.txFlushedNewIds.clear();
        }
        this.enlistedSMCache.clear();
        this.dirtySMs.clear();
        this.indirectDirtySMs.clear();
        this.fetchPlan.resetDetachmentRoots();
        if (this.getManageRelations() && this.managedRelationDetails != null) {
            this.managedRelationDetails.clear();
        }
        if (this.txCachedIds != null) {
            this.txCachedIds.clear();
        }
    }

    @Override
    public void putObjectIntoCache(ObjectProvider op) {
        if (this.cache != null) {
            Object id = op.getInternalObjectId();
            if (id == null || op.getObject() == null) {
                NucleusLogger.CACHE.warn(LOCALISER.msg("003006"));
                return;
            }
            ObjectProvider oldSM = this.cache.put(op.getInternalObjectId(), op);
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                if (oldSM == null) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("003004", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)this.getIdentityAsString(op.getInternalObjectId()), (Object)StringUtils.booleanArrayToString(op.getLoadedFields())));
                } else if (oldSM != op) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("003005", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)this.getIdentityAsString(op.getInternalObjectId()), (Object)StringUtils.booleanArrayToString(op.getLoadedFields())));
                }
            }
        }
    }

    public void putObjectIntoLevel2Cache(StateManager sm, boolean updateIfPresent) {
        if (sm.getInternalObjectId() == null) {
            return;
        }
        if (this.txCachedIds != null && !this.txCachedIds.contains(sm.getInternalObjectId())) {
            this.putObjectIntoLevel2CacheInternal(sm, updateIfPresent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putObjectIntoLevel2CacheInternal(StateManager sm, boolean updateIfPresent) {
        if (sm.getClassMetaData().isCacheable()) {
            Object id = sm.getInternalObjectId();
            Level2Cache l2Cache = this.context.getLevel2Cache();
            if (!updateIfPresent && l2Cache.containsOid(id)) {
                return;
            }
            Level2Cache level2Cache = l2Cache;
            synchronized (level2Cache) {
                CachedPC cachedPC = sm.cache();
                if (cachedPC != null) {
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        if (l2Cache.containsOid(id)) {
                            NucleusLogger.CACHE.debug(LOCALISER.msg("004013", (Object)StringUtils.toJVMIDString(sm.getObject()), id, (Object)StringUtils.booleanArrayToString(cachedPC.getLoadedFields()), (Object)StringUtils.objectArrayToString(cachedPC.getRelationFieldNames())));
                        } else {
                            NucleusLogger.CACHE.debug(LOCALISER.msg("004003", (Object)StringUtils.toJVMIDString(sm.getObject()), id, (Object)StringUtils.booleanArrayToString(cachedPC.getLoadedFields()), (Object)StringUtils.objectArrayToString(cachedPC.getRelationFieldNames())));
                        }
                    }
                    l2Cache.put(id, cachedPC);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObjectFromLevel2Cache(Object id) {
        if (id != null) {
            Level2Cache l2Cache;
            Level2Cache level2Cache = l2Cache = this.context.getLevel2Cache();
            synchronized (level2Cache) {
                if (l2Cache.containsOid(id)) {
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(LOCALISER.msg("004016", id));
                    }
                    l2Cache.evict(id);
                }
            }
        }
    }

    @Override
    public void removeObjectFromCache(Object id) {
        if (id != null && this.cache != null) {
            Object pcRemoved;
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003009", (Object)this.getIdentityAsString(id), (Object)String.valueOf(this.cache.size())));
            }
            if ((pcRemoved = this.cache.remove(id)) == null && NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003010", (Object)this.getIdentityAsString(id)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIdentityInCache(Object id) {
        if (this.cache != null && this.cache.containsKey(id)) {
            return true;
        }
        if (this.context.hasLevel2Cache()) {
            Level2Cache l2Cache;
            Level2Cache level2Cache = l2Cache = this.context.getLevel2Cache();
            synchronized (level2Cache) {
                if (l2Cache.containsOid(id)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectFromCache(Object id) {
        Object pc = null;
        StateManager sm = null;
        if (this.cache != null) {
            sm = (StateManager)this.cache.get(id);
            if (sm != null) {
                pc = sm.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("003008", (Object)StringUtils.toJVMIDString(pc), (Object)this.getIdentityAsString(id), (Object)StringUtils.booleanArrayToString(sm.getLoadedFields()), (Object)("" + this.cache.size())));
                }
                sm.resetDetachState();
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003007", (Object)this.getIdentityAsString(id), (Object)("" + this.cache.size())));
            }
        }
        if (this.context.hasLevel2Cache()) {
            Level2Cache l2Cache = this.context.getLevel2Cache();
            CachedPC cachedPC = null;
            Level2Cache level2Cache = l2Cache;
            synchronized (level2Cache) {
                cachedPC = l2Cache.get(id);
            }
            if (cachedPC != null) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004015", (Object)this.getIdentityAsString(id), (Object)StringUtils.booleanArrayToString(cachedPC.getLoadedFields()), (Object)StringUtils.objectArrayToString(cachedPC.getRelationFieldNames())));
                }
                sm = (StateManager)ObjectProviderFactory.newForCachedPC(this, id, cachedPC);
                pc = sm.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004006", (Object)this.getIdentityAsString(id), (Object)StringUtils.toJVMIDString(pc)));
                }
                if (this.tx.isActive() && this.tx.getOptimistic()) {
                    sm.makeNontransactional();
                } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                    sm.makeNontransactional();
                }
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("004005", (Object)this.getIdentityAsString(id)));
            }
        }
        return null;
    }

    @Override
    public synchronized void replaceObjectId(Object pc, Object oldID, Object newID) {
        if (pc == null || this.getApiAdapter().getIdForObject(pc) == null) {
            NucleusLogger.CACHE.warn(LOCALISER.msg("003006"));
            return;
        }
        StateManager sm = this.findStateManager(pc);
        if (this.cache != null) {
            Object o = this.cache.get(oldID);
            if (o != null) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("003012", (Object)StringUtils.toJVMIDString(pc), (Object)this.getIdentityAsString(oldID), (Object)this.getIdentityAsString(newID)));
                }
                this.cache.remove(oldID);
            }
            if (sm != null) {
                this.putObjectIntoCache(sm);
            }
        }
        if (this.enlistedSMCache.get(oldID) != null && sm != null) {
            this.enlistedSMCache.remove(oldID);
            this.enlistedSMCache.put(newID, sm);
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015018", (Object)StringUtils.toJVMIDString(pc), (Object)this.getIdentityAsString(oldID), (Object)this.getIdentityAsString(newID)));
            }
        }
        if (this.getReachabilityAtCommit() && this.tx.isActive()) {
            if (this.txEnlistedIds.remove(oldID)) {
                this.txEnlistedIds.add(newID);
            }
            if (this.txFlushedNewIds.remove(oldID)) {
                this.txFlushedNewIds.add(newID);
            }
            if (this.txKnownPersistedIds.remove(oldID)) {
                this.txKnownPersistedIds.add(newID);
            }
            if (this.txKnownDeletedIds.remove(oldID)) {
                this.txKnownDeletedIds.add(newID);
            }
        }
    }

    @Override
    public String getIdentityAsString(Object id) {
        if (id == null) {
            return null;
        }
        if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            return this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id) + ":" + this.getApiAdapter().getTargetKeyForSingleFieldIdentity(id);
        }
        return id.toString();
    }

    @Override
    public boolean getSerializeReadForClass(String className) {
        AbstractClassMetaData cmd;
        if (this.tx.isActive() && this.tx.getSerializeRead() != null) {
            return this.tx.getSerializeRead();
        }
        if (this.getProperty("datanucleus.SerializeRead") != null) {
            return this.properties.getBooleanProperty("datanucleus.SerializeRead");
        }
        if (className != null && (cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr)) != null) {
            return cmd.isSerializeRead();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Extent getExtent(Class pcClass, boolean subclasses) {
        this.assertIsOpen();
        try {
            this.clr.setPrimary(pcClass.getClassLoader());
            this.assertClassPersistable(pcClass);
            Extent extent = this.getStoreManager().getExtent(this, pcClass, subclasses);
            Object var5_4 = null;
            this.clr.unsetPrimary();
            return extent;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    @Override
    public synchronized Query newQuery() {
        return this.getStoreManager().getQueryManager().newQuery("JDOQL", this, null);
    }

    public void removeAllInstanceLifecycleListeners() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        if (this.callbacks != null) {
            return this.callbacks;
        }
        if (!this.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.allowCallbacks")) {
            this.callbacks = new NullCallbackHandler();
            return this.callbacks;
        }
        String callbackHandlerClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name");
        if (callbackHandlerClassName != null) {
            try {
                this.callbacks = (CallbackHandler)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name", new Class[]{NucleusContext.class}, new Object[]{this.getNucleusContext()});
                return this.callbacks;
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.error(LOCALISER.msg("025000", (Object)callbackHandlerClassName, (Object)e));
            }
        }
        return null;
    }

    @Override
    public void addListener(Object listener, Class[] classes) {
        this.assertIsOpen();
        if (listener == null) {
            return;
        }
        this.getCallbackHandler().addListener(listener, classes);
    }

    @Override
    public void removeListener(Object listener) {
        this.assertIsOpen();
        if (listener != null) {
            this.getCallbackHandler().removeListener(listener);
        }
    }

    @Override
    public void disconnectLifecycleListener() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("010002")).setFatal();
        }
    }

    @Override
    public void assertClassPersistable(Class cls) {
        if (cls != null && !this.getNucleusContext().getApiAdapter().isPersistable(cls) && !cls.isInterface()) {
            throw new ClassNotPersistableException(cls.getName());
        }
        if (!this.hasPersistenceInformationForClass(cls)) {
            throw new NoPersistenceInformationException(cls.getName());
        }
    }

    protected void assertDetachable(Object object) {
        if (object != null && !this.getApiAdapter().isDetachable(object)) {
            throw new ClassNotDetachableException(object.getClass().getName());
        }
    }

    protected void assertNotDetached(Object object) {
        if (object != null && this.getApiAdapter().isDetached(object)) {
            throw new ObjectDetachedException(object.getClass().getName());
        }
    }

    protected void assertActiveTransaction() {
        if (!this.tx.isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertHasImplementationCreator() {
        if (this.getNucleusContext().getImplementationCreator() == null) {
            throw new NucleusUserException(LOCALISER.msg("010035"));
        }
    }

    @Override
    public boolean hasPersistenceInformationForClass(Class cls) {
        if (cls == null) {
            return false;
        }
        if (this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null) {
            return true;
        }
        if (cls.isInterface()) {
            try {
                this.newInstance(cls);
            }
            catch (RuntimeException ex) {
                NucleusLogger.PERSISTENCE.warn(ex);
            }
            return this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null;
        }
        return false;
    }

    protected FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this.getNucleusContext());
        }
        return this.fetchGrpMgr;
    }

    @Override
    public void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    protected void removeInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    @Override
    public FetchGroup getInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getNucleusContext().getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getNucleusContext().getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name);
    }

    @Override
    public Set getFetchGroupsWithName(String name) {
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    @Override
    public Object getReadWriteLock() {
        return this.readWriteLock;
    }

    static class ThreadContextInfo {
        int referenceCounter = 0;
        HashMap attachedPCById = null;

        ThreadContextInfo() {
        }
    }
}

