/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.awt.geom.Point2D;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class Point2dFloatMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(fmd, container, clr);
        this.addDatastoreFields();
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addDatastoreFields();
    }

    protected void addDatastoreFields() {
        this.addDatastoreField(ClassNameConstants.FLOAT);
        this.addDatastoreField(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return Point2D.Float.class;
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        Point2D.Float pt = (Point2D.Float)value;
        if (index == 0) {
            return pt.getX();
        }
        if (index == 1) {
            return pt.getY();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        Point2D.Float pt = (Point2D.Float)value;
        if (pt == null) {
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], null);
            this.getDatastoreMapping(1).setObject(preparedStatement, exprIndex[1], null);
        } else {
            this.getDatastoreMapping(0).setFloat(preparedStatement, exprIndex[0], pt.x);
            this.getDatastoreMapping(1).setFloat(preparedStatement, exprIndex[1], pt.y);
        }
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x = this.getDatastoreMapping(0).getFloat(resultSet, exprIndex[0]);
        float y = this.getDatastoreMapping(1).getFloat(resultSet, exprIndex[1]);
        return new Point2D.Float(x, y);
    }
}

