/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.CommandLine;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.PersistenceUtils;
import org.datanucleus.util.StringUtils;

public class SchemaTool {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private String apiName = "JDO";
    private String ddlFilename = null;
    private boolean completeDdl = false;
    private boolean verbose = false;
    public static final int SCHEMATOOL_CREATE_MODE = 1;
    public static final int SCHEMATOOL_DELETE_MODE = 2;
    public static final int SCHEMATOOL_VALIDATE_MODE = 3;
    public static final int SCHEMATOOL_DATABASE_INFO_MODE = 4;
    public static final int SCHEMATOOL_SCHEMA_INFO_MODE = 5;
    public static NucleusLogger LOGGER = NucleusLogger.getLoggerInstance("DataNucleus.SchemaTool");

    public static void main(String[] args) throws Exception {
        StoreManager storeMgr;
        String ddlFilename;
        SchemaTool tool = new SchemaTool();
        CommandLine cmd = new CommandLine();
        cmd.addOption("create", "create", null, LOCALISER.msg(false, "014026"));
        cmd.addOption("delete", "delete", null, LOCALISER.msg(false, "014027"));
        cmd.addOption("validate", "validate", null, LOCALISER.msg(false, "014028"));
        cmd.addOption("dbinfo", "dbinfo", null, LOCALISER.msg(false, "014029"));
        cmd.addOption("schemainfo", "schemainfo", null, LOCALISER.msg(false, "014030"));
        cmd.addOption("help", "help", null, LOCALISER.msg(false, "014033"));
        cmd.addOption("ddlFile", "ddlFile", "ddlFile", LOCALISER.msg(false, "014031"));
        cmd.addOption("completeDdl", "completeDdl", null, LOCALISER.msg(false, "014032"));
        cmd.addOption("api", "api", "api", "API Adapter (JDO, JPA, etc)");
        cmd.addOption("v", "verbose", null, "verbose output");
        cmd.addOption("pu", "persistenceUnit", "<persistence-unit>", "name of the persistence unit to handle the schema for");
        cmd.addOption("props", "properties", "props", "path to a properties file");
        cmd.parse(args);
        String[] filenames = cmd.getDefaultArgs();
        if (cmd.hasOption("api")) {
            tool.setApi(cmd.getOptionArg("api"));
        }
        String msg = null;
        int mode = 1;
        if (cmd.hasOption("create")) {
            mode = 1;
            msg = LOCALISER.msg(false, "014000");
        } else if (cmd.hasOption("delete")) {
            mode = 2;
            msg = LOCALISER.msg(false, "014001");
        } else if (cmd.hasOption("validate")) {
            mode = 3;
            msg = LOCALISER.msg(false, "014002");
        } else if (cmd.hasOption("dbinfo")) {
            mode = 4;
            msg = LOCALISER.msg(false, "014003");
        } else if (cmd.hasOption("schemainfo")) {
            mode = 5;
            msg = LOCALISER.msg(false, "014004");
        } else if (cmd.hasOption("help")) {
            System.out.println(LOCALISER.msg(false, "014023"));
            System.out.println(LOCALISER.msg(false, "014024"));
            System.out.println(LOCALISER.msg(false, "014025"));
            System.out.println(cmd.toString());
            System.out.println(LOCALISER.msg(false, "014034"));
            System.out.println(LOCALISER.msg(false, "014035"));
            System.exit(0);
        }
        LOGGER.info(msg);
        System.out.println(msg);
        String propsFileName = null;
        String persistenceUnitName = null;
        if (cmd.hasOption("ddlFile")) {
            tool.setDdlFile(cmd.getOptionArg("ddlFile"));
        }
        if (cmd.hasOption("completeDdl")) {
            tool.setCompleteDdl(true);
        }
        if (cmd.hasOption("v")) {
            tool.setVerbose(true);
        }
        if (cmd.hasOption("pu")) {
            persistenceUnitName = cmd.getOptionArg("pu");
        }
        if (cmd.hasOption("props")) {
            propsFileName = cmd.getOptionArg("props");
        }
        msg = LOCALISER.msg(false, "014005");
        LOGGER.info(msg);
        if (tool.isVerbose()) {
            System.out.println(msg);
        }
        StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokeniser.hasMoreTokens()) {
            msg = LOCALISER.msg(false, "014006", (Object)tokeniser.nextToken());
            LOGGER.info(msg);
            if (!tool.isVerbose()) continue;
            System.out.println(msg);
        }
        if (tool.isVerbose()) {
            System.out.println();
        }
        if ((ddlFilename = tool.getDdlFile()) != null) {
            msg = LOCALISER.msg(false, tool.getCompleteDdl() ? "014018" : "014019", (Object)ddlFilename);
            LOGGER.info(msg);
            if (tool.isVerbose()) {
                System.out.println(msg);
                System.out.println();
            }
        }
        boolean requiresAutoStartTable = false;
        NucleusContext nucleusCtx = null;
        try {
            if (propsFileName != null) {
                Properties props = PersistenceUtils.setPropertiesUsingFile(propsFileName);
                String autostart = props.getProperty("datanucleus.autoStartMechanism");
                if (autostart != null && autostart.equalsIgnoreCase("SchemaTable")) {
                    requiresAutoStartTable = true;
                }
                nucleusCtx = SchemaTool.getNucleusContextForMode(mode, tool.getApi(), props, persistenceUnitName, ddlFilename, tool.isVerbose());
            } else {
                nucleusCtx = SchemaTool.getNucleusContextForMode(mode, tool.getApi(), null, persistenceUnitName, ddlFilename, tool.isVerbose());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating NucleusContext", e);
            System.out.println(LOCALISER.msg(false, "014008", (Object)e.getMessage()));
            System.exit(1);
            return;
        }
        TreeSet<String> classNames = null;
        if (mode != 5 && mode != 4) {
            try {
                MetaDataManager metaDataMgr = nucleusCtx.getMetaDataManager();
                ClassLoaderResolver clr = nucleusCtx.getClassLoaderResolver(null);
                FileMetaData[] filemds = SchemaTool.getFileMetaDataForInput(metaDataMgr, clr, tool.isVerbose(), persistenceUnitName, filenames);
                classNames = new TreeSet<String>();
                if (filemds == null) {
                    msg = LOCALISER.msg(false, "014021");
                    LOGGER.error(msg);
                    System.out.println(msg);
                    System.exit(2);
                    return;
                }
                for (int i = 0; i < filemds.length; ++i) {
                    for (int j = 0; j < filemds[i].getNoOfPackages(); ++j) {
                        for (int k = 0; k < filemds[i].getPackage(j).getNoOfClasses(); ++k) {
                            String className = filemds[i].getPackage(j).getClass(k).getFullClassName();
                            if (classNames.contains(className)) continue;
                            classNames.add(className);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.exit(2);
                return;
            }
        }
        if (!((storeMgr = nucleusCtx.getStoreManager()) instanceof SchemaAwareStoreManager)) {
            LOGGER.error("StoreManager of type " + storeMgr.getClass().getName() + " is not schema-aware so cannot be used with SchemaTool");
            System.exit(2);
            return;
        }
        SchemaAwareStoreManager schemaStoreMgr = (SchemaAwareStoreManager)((Object)storeMgr);
        try {
            if (mode == 1) {
                Properties props = new Properties();
                if (tool.getDdlFile() != null) {
                    props.setProperty("ddlFilename", tool.getDdlFile());
                }
                if (tool.getCompleteDdl()) {
                    props.setProperty("completeDdl", "true");
                }
                if (requiresAutoStartTable) {
                    props.setProperty("autoStartTable", "true");
                }
                schemaStoreMgr.createSchema(classNames, props);
            } else if (mode == 2) {
                schemaStoreMgr.deleteSchema(classNames);
            } else if (mode == 3) {
                schemaStoreMgr.validateSchema(classNames);
            } else if (mode == 4) {
                storeMgr.printInformation("DATASTORE", System.out);
            } else if (mode == 5) {
                storeMgr.printInformation("SCHEMA", System.out);
            }
            msg = LOCALISER.msg(false, "014043");
            LOGGER.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            msg = LOCALISER.msg(false, "014037", (Object)e.getMessage());
            System.out.println(msg);
            LOGGER.error(msg, e);
            System.exit(2);
            return;
        }
    }

    protected static NucleusContext getNucleusContextForMode(int mode, String api, Map userProps, String persistenceUnitName, String ddlFile, boolean verbose) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        if (persistenceUnitName != null) {
            props.put("javax.jdo.option.PersistenceUnitName", persistenceUnitName);
        }
        if (userProps != null) {
            props.putAll(userProps);
        } else {
            String[] propNames = new String[]{"datanucleus.ConnectionURL", "datanucleus.ConnectionDriverName", "datanucleus.ConnectionUserName", "datanucleus.ConnectionPassword", "datanucleus.Mapping", "javax.jdo.option.ConnectionURL", "javax.jdo.option.ConnectionDriverName", "javax.jdo.option.ConnectionUserName", "javax.jdo.option.ConnectionPassword", "javax.jdo.option.Mapping"};
            for (int i = 0; i < propNames.length; ++i) {
                if (System.getProperty(propNames[i]) == null) continue;
                props.put(propNames[i], System.getProperty(propNames[i]));
            }
            if (persistenceUnitName == null && props.get("javax.jdo.option.ConnectionURL") == null && props.get("datanucleus.ConnectionURL") == null && props.get("javax.persistence.jdbc.url") == null) {
                File file = new File(System.getProperty("user.home") + "/datanucleus.properties");
                if (file.exists()) {
                    try {
                        FileInputStream is = new FileInputStream(file);
                        Properties fileProps = new Properties();
                        fileProps.load(is);
                        props.putAll(fileProps);
                        ((InputStream)is).close();
                    }
                    catch (IOException ioe) {}
                } else {
                    throw new NucleusException(LOCALISER.msg("014041"));
                }
            }
        }
        props.put("datanucleus.persistenceApiName", api);
        props.put("datanucleus.autostartmechanism", "None");
        if (mode == 1) {
            if (ddlFile != null) {
                props.put("datanucleus.validateconstraints", "false");
                props.put("datanucleus.validatecolumns", "false");
                props.put("datanucleus.validatetables", "false");
            }
            props.put("datanucleus.autocreateschema", "true");
            props.put("datanucleus.autocreatetables", "true");
            props.put("datanucleus.autocreateconstraints", "true");
            props.put("datanucleus.fixeddatastore", "false");
            props.put("datanucleus.readOnlydatastore", "false");
            props.put("datanucleus.rdbms.checkexisttablesorviews", "true");
        } else if (mode == 2) {
            props.put("datanucleus.fixeddatastore", "false");
            props.put("datanucleus.readonlydatastore", "false");
        } else if (mode == 3) {
            props.put("datanucleus.autocreateschema", "false");
            props.put("datanucleus.autocreatetables", "false");
            props.put("datanucleus.autocreateconstraints", "false");
            props.put("datanucleus.autocreatecolumns", "false");
            props.put("datanucleus.validatetables", "true");
            props.put("datanucleus.validatecolumns", "true");
            props.put("datanucleus.validateconstraints", "true");
        }
        HashMap startupProps = null;
        if (props != null) {
            String[] startupPropNames = NucleusContext.startupProperties;
            for (int i = 0; i < startupPropNames.length; ++i) {
                if (!props.containsKey(startupPropNames[i])) continue;
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put(startupPropNames[i], props.get(startupPropNames[i]));
            }
        }
        NucleusContext nucleusCtx = new NucleusContext(api, 1, startupProps);
        PersistenceConfiguration propConfig = nucleusCtx.getPersistenceConfiguration();
        propConfig.setPersistenceProperties(nucleusCtx.getApiAdapter().getDefaultFactoryProperties());
        PersistenceUnitMetaData pumd = null;
        if (persistenceUnitName != null) {
            pumd = nucleusCtx.getMetaDataManager().getMetaDataForPersistenceUnit(persistenceUnitName);
            if (pumd != null) {
                if (pumd.getProperties() != null) {
                    props.putAll(pumd.getProperties());
                }
            } else {
                throw new NucleusUserException("SchemaTool has been specified to use persistence-unit with name " + persistenceUnitName + " but none was found with that name");
            }
            if (api.equalsIgnoreCase("JPA")) {
                pumd.clearJarFiles();
            }
        }
        propConfig.setPersistenceProperties(props);
        if (pumd != null) {
            nucleusCtx.getMetaDataManager().loadPersistenceUnit(pumd, null);
        }
        nucleusCtx.initialise();
        if (verbose) {
            String msg = LOCALISER.msg(false, "014020");
            LOGGER.info(msg);
            System.out.println(msg);
            Map<String, Object> pmfProps = propConfig.getPersistenceProperties();
            Set<String> keys = pmfProps.keySet();
            ArrayList<String> keyNames = new ArrayList<String>(keys);
            Collections.sort(keyNames);
            for (String key : keyNames) {
                Object value = pmfProps.get(key);
                boolean display = true;
                if (!key.startsWith("datanucleus")) {
                    display = false;
                } else if (key.equals("datanucleus.connectionpassword")) {
                    display = false;
                } else if (value == null) {
                    display = false;
                } else if (value instanceof String && StringUtils.isWhitespace((String)value)) {
                    display = false;
                }
                if (!display) continue;
                msg = LOCALISER.msg(false, "014022", (Object)key, value);
                LOGGER.info(msg);
                System.out.println(msg);
            }
            System.out.println();
        }
        return nucleusCtx;
    }

    protected static FileMetaData[] getFileMetaDataForInput(MetaDataManager metaDataMgr, ClassLoaderResolver clr, boolean verbose, String persistenceUnitName, String[] inputFiles) {
        FileMetaData[] filemds = null;
        String msg = null;
        if (inputFiles == null && persistenceUnitName == null) {
            msg = LOCALISER.msg(false, "014007");
            LOGGER.error(msg);
            System.out.println(msg);
            throw new NucleusUserException(msg);
        }
        if (persistenceUnitName != null) {
            msg = LOCALISER.msg(false, "014015", (Object)persistenceUnitName);
            LOGGER.info(msg);
            if (verbose) {
                System.out.println(msg);
                System.out.println();
            }
            filemds = metaDataMgr.getFileMetaData();
        } else {
            msg = LOCALISER.msg(false, "014009");
            LOGGER.info(msg);
            if (verbose) {
                System.out.println(msg);
            }
            for (int i = 0; i < inputFiles.length; ++i) {
                String entry = LOCALISER.msg(false, "014010", (Object)inputFiles[i]);
                LOGGER.info(entry);
                if (!verbose) continue;
                System.out.println(entry);
            }
            if (verbose) {
                System.out.println();
            }
            try {
                int i;
                LOGGER.debug(LOCALISER.msg(false, "014011", (Object)("" + inputFiles.length)));
                HashSet<String> metadataFiles = new HashSet<String>();
                HashSet<String> classNames = new HashSet<String>();
                for (int i2 = 0; i2 < inputFiles.length; ++i2) {
                    if (inputFiles[i2].endsWith(".class")) {
                        URL classFileURL = null;
                        try {
                            classFileURL = new URL("file:" + inputFiles[i2]);
                        }
                        catch (Exception e) {
                            msg = LOCALISER.msg(false, "014013", (Object)inputFiles[i2]);
                            LOGGER.error(msg);
                            throw new NucleusUserException(msg);
                        }
                        String className = null;
                        try {
                            className = ClassUtils.getClassNameForFileURL(classFileURL);
                        }
                        catch (Exception e) {
                            LOGGER.info("URL " + inputFiles[i2] + " could not be resolved to a class name, so ignoring." + " Specify it as a class explicitly using persistence.xml to overcome this", e);
                        }
                        catch (Error err) {
                            LOGGER.info("URL " + inputFiles[i2] + " could not be resolved to a class name, so ignoring." + " Specify it as a class explicitly using persistence.xml to overcome this", err);
                        }
                        classNames.add(className);
                        continue;
                    }
                    metadataFiles.add(inputFiles[i2]);
                }
                FileMetaData[] filemds1 = metaDataMgr.loadMetadataFiles(metadataFiles.toArray(new String[metadataFiles.size()]), null);
                FileMetaData[] filemds2 = metaDataMgr.loadClasses(classNames.toArray(new String[classNames.size()]), null);
                filemds = new FileMetaData[filemds1.length + filemds2.length];
                int pos = 0;
                for (i = 0; i < filemds1.length; ++i) {
                    filemds[pos++] = filemds1[i];
                }
                for (i = 0; i < filemds2.length; ++i) {
                    filemds[pos++] = filemds2[i];
                }
                LOGGER.debug(LOCALISER.msg(false, "014012", (Object)("" + inputFiles.length)));
            }
            catch (Exception e) {
                msg = LOCALISER.msg(false, "014014", (Object)e.getMessage());
                LOGGER.error(msg, e);
                System.out.println(msg);
                if (e instanceof NucleusException) {
                    throw (NucleusException)e;
                }
                throw new NucleusUserException(msg, e);
            }
        }
        return filemds;
    }

    public String getApi() {
        return this.apiName;
    }

    public SchemaTool setApi(String api) {
        this.apiName = api;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public SchemaTool setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String getDdlFile() {
        return this.ddlFilename;
    }

    public SchemaTool setDdlFile(String file) {
        this.ddlFilename = file;
        return this;
    }

    public SchemaTool setCompleteDdl(boolean completeDdl) {
        this.completeDdl = completeDdl;
        return this;
    }

    public boolean getCompleteDdl() {
        return this.completeDdl;
    }
}

