/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.ListIterator;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.mapped.scostore.AbstractListStore;
import org.datanucleus.store.query.ResultObjectFactory;

public abstract class ListStoreIterator
implements ListIterator {
    private final ObjectProvider sm;
    private final ListIterator delegate;
    private Object lastElement = null;
    private int currentIndex = -1;
    private final AbstractListStore abstractListStore;

    public ListStoreIterator(ObjectProvider sm, Object resultSet, ResultObjectFactory rof, AbstractListStore als) throws MappedDatastoreException {
        this.sm = sm;
        this.abstractListStore = als;
        ExecutionContext ec = sm.getExecutionContext();
        ArrayList<Object> results = new ArrayList<Object>();
        if (resultSet != null) {
            DatastoreContainerObject containerTable = als.getContainerTable();
            boolean elementsAreSerialised = als.isElementsAreSerialised();
            boolean elementsAreEmbedded = als.isElementsAreEmbedded();
            JavaTypeMapping elementMapping = als.getElementMapping();
            while (this.next(resultSet)) {
                Object nextElement;
                int i;
                int[] param;
                if (elementsAreEmbedded || elementsAreSerialised) {
                    param = new int[elementMapping.getNumberOfDatastoreMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    if (elementMapping instanceof SerialisedPCMapping || elementMapping instanceof SerialisedReferenceMapping || elementMapping instanceof EmbeddedElementPCMapping) {
                        int ownerFieldNumber = -1;
                        if (containerTable != null) {
                            ownerFieldNumber = this.getOwnerMemberMetaData(this.abstractListStore.containerTable).getAbsoluteFieldNumber();
                        }
                        nextElement = elementMapping.getObject(ec, resultSet, param, sm, ownerFieldNumber);
                    } else {
                        nextElement = elementMapping.getObject(ec, resultSet, param);
                    }
                } else if (elementMapping instanceof ReferenceMapping) {
                    param = new int[elementMapping.getNumberOfDatastoreMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    nextElement = elementMapping.getObject(ec, resultSet, param);
                } else {
                    nextElement = rof.getObject(ec, resultSet);
                }
                results.add(nextElement);
            }
        }
        this.delegate = results.listIterator();
    }

    public void add(Object o) {
        this.currentIndex = this.delegate.nextIndex();
        this.abstractListStore.add(this.sm, o, this.currentIndex, -1);
        this.delegate.add(o);
        this.lastElement = null;
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public boolean hasPrevious() {
        return this.delegate.hasPrevious();
    }

    public Object next() {
        this.currentIndex = this.delegate.nextIndex();
        this.lastElement = this.delegate.next();
        return this.lastElement;
    }

    public int nextIndex() {
        return this.delegate.nextIndex();
    }

    public Object previous() {
        this.currentIndex = this.delegate.previousIndex();
        this.lastElement = this.delegate.previous();
        return this.lastElement;
    }

    public int previousIndex() {
        return this.delegate.previousIndex();
    }

    public synchronized void remove() {
        if (this.lastElement == null) {
            throw new IllegalStateException("No entry to remove");
        }
        this.abstractListStore.remove(this.sm, this.currentIndex, -1);
        this.delegate.remove();
        this.lastElement = null;
        this.currentIndex = -1;
    }

    public synchronized void set(Object o) {
        if (this.lastElement == null) {
            throw new IllegalStateException("No entry to replace");
        }
        this.abstractListStore.set(this.sm, this.currentIndex, o, true);
        this.delegate.set(o);
        this.lastElement = o;
    }

    protected abstract boolean next(Object var1) throws MappedDatastoreException;

    protected abstract AbstractMemberMetaData getOwnerMemberMetaData(DatastoreContainerObject var1);
}

