/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.jdo.Extent;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JDOReplicationManager {
    protected static final Localiser LOCALISER_JDO = Localiser.getInstance("org.datanucleus.jdo.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    final PersistenceManagerFactory pmfSource;
    final PersistenceManagerFactory pmfTarget;
    protected Properties properties = new Properties();

    public JDOReplicationManager(PersistenceManagerFactory pmf1, PersistenceManagerFactory pmf2) {
        if (pmf1 == null || pmf1.isClosed()) {
            throw new JDOUserException(LOCALISER_JDO.msg("012050"));
        }
        if (pmf2 == null || pmf2.isClosed()) {
            throw new JDOUserException(LOCALISER_JDO.msg("012050"));
        }
        this.pmfSource = pmf1;
        this.pmfTarget = pmf2;
        this.properties.setProperty("datanucleus.replicateObjectGraph", "true");
        this.properties.setProperty("datanucleus.deleteUnknownObjects", "false");
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected boolean getBooleanProperty(String key) {
        String val = this.properties.getProperty(key);
        if (val == null) {
            return false;
        }
        return val.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(Class ... types) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER_JDO.msg("012052", this.pmfSource, (Object)this.pmfTarget, (Object)StringUtils.objectArrayToString(types)));
        }
        OMFContext omfCtxSource = ((JDOPersistenceManagerFactory)this.pmfSource).getOMFContext();
        MetaDataManager mmgr = omfCtxSource.getMetaDataManager();
        ClassLoaderResolver clr = omfCtxSource.getClassLoaderResolver(null);
        for (int i = 0; i < types.length; ++i) {
            AbstractClassMetaData cmd = mmgr.getMetaDataForClass(types[i], clr);
            if (cmd.isDetachable()) continue;
            throw new JDOUserException("Class " + types[i] + " is not detachable so cannot replicate");
        }
        Object[] detachedObjects = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER_JDO.msg("012053"));
        }
        PersistenceManager pm1 = this.pmfSource.getPersistenceManager();
        Transaction tx1 = pm1.currentTransaction();
        if (this.getBooleanProperty("datanucleus.replicateObjectGraph")) {
            pm1.getFetchPlan().setGroup("all");
            pm1.getFetchPlan().setMaxFetchDepth(-1);
        }
        try {
            tx1.begin();
            ArrayList objects = new ArrayList();
            for (int i = 0; i < types.length; ++i) {
                AbstractClassMetaData cmd = mmgr.getMetaDataForClass(types[i], clr);
                if (cmd.isEmbeddedOnly()) continue;
                Extent ex = pm1.getExtent(types[i]);
                Iterator iter = ex.iterator();
                while (iter.hasNext()) {
                    objects.add(iter.next());
                }
            }
            Collection detachedColl = pm1.detachCopyAll(objects);
            detachedObjects = detachedColl.toArray();
            tx1.commit();
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (tx1.isActive()) {
                tx1.rollback();
            }
            pm1.close();
            throw throwable;
        }
        if (tx1.isActive()) {
            tx1.rollback();
        }
        pm1.close();
        this.replicateInTarget(detachedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(String ... classNames) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER_JDO.msg("012052", this.pmfSource, (Object)this.pmfTarget, (Object)StringUtils.objectArrayToString(classNames)));
        }
        OMFContext omfCtxSource = ((JDOPersistenceManagerFactory)this.pmfSource).getOMFContext();
        MetaDataManager mmgr = omfCtxSource.getMetaDataManager();
        ClassLoaderResolver clr = omfCtxSource.getClassLoaderResolver(null);
        for (int i = 0; i < classNames.length; ++i) {
            AbstractClassMetaData cmd = mmgr.getMetaDataForClass(classNames[i], clr);
            if (cmd.isDetachable()) continue;
            throw new JDOUserException("Class " + classNames[i] + " is not detachable so cannot replicate");
        }
        Object[] detachedObjects = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER_JDO.msg("012053"));
        }
        PersistenceManager pm1 = this.pmfSource.getPersistenceManager();
        Transaction tx1 = pm1.currentTransaction();
        if (this.getBooleanProperty("datanucleus.replicateObjectGraph")) {
            pm1.getFetchPlan().setGroup("all");
            pm1.getFetchPlan().setMaxFetchDepth(-1);
        }
        try {
            tx1.begin();
            clr = ((JDOPersistenceManager)pm1).getObjectManager().getClassLoaderResolver();
            ArrayList objects = new ArrayList();
            for (int i = 0; i < classNames.length; ++i) {
                Class cls = clr.classForName(classNames[i]);
                AbstractClassMetaData cmd = mmgr.getMetaDataForClass(cls, clr);
                if (cmd.isEmbeddedOnly()) continue;
                Extent ex = pm1.getExtent(cls);
                Iterator iter = ex.iterator();
                while (iter.hasNext()) {
                    objects.add(iter.next());
                }
            }
            Collection detachedColl = pm1.detachCopyAll(objects);
            detachedObjects = detachedColl.toArray();
            tx1.commit();
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (tx1.isActive()) {
                tx1.rollback();
            }
            pm1.close();
            throw throwable;
        }
        if (tx1.isActive()) {
            tx1.rollback();
        }
        pm1.close();
        this.replicateInTarget(detachedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(Object ... oids) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER_JDO.msg("012051", this.pmfSource, (Object)this.pmfTarget, (Object)StringUtils.objectArrayToString(oids)));
        }
        Object[] detachedObjects = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER_JDO.msg("012053"));
        }
        PersistenceManager pm1 = this.pmfSource.getPersistenceManager();
        Transaction tx1 = pm1.currentTransaction();
        if (this.getBooleanProperty("datanucleus.replicateObjectGraph")) {
            pm1.getFetchPlan().setGroup("all");
            pm1.getFetchPlan().setMaxFetchDepth(-1);
        }
        try {
            tx1.begin();
            Object[] objs = pm1.getObjectsById(oids);
            detachedObjects = pm1.detachCopyAll(objs);
            tx1.commit();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (tx1.isActive()) {
                tx1.rollback();
            }
            pm1.close();
            throw throwable;
        }
        if (tx1.isActive()) {
            tx1.rollback();
        }
        pm1.close();
        this.replicateInTarget(detachedObjects);
    }

    public void replicateRegisteredClasses() {
        ClassLoaderResolver clr = ((JDOPersistenceManager)this.pmfSource.getPersistenceManager()).getObjectManager().getClassLoaderResolver();
        MetaDataManager mmgr = ((JDOPersistenceManagerFactory)this.pmfSource).getOMFContext().getMetaDataManager();
        Collection classNames = mmgr.getClassesWithMetaData();
        ArrayList<Class> arrayTypes = new ArrayList<Class>();
        for (String className : classNames) {
            AbstractClassMetaData cmd = mmgr.getMetaDataForClass(className, clr);
            if (cmd.isEmbeddedOnly()) continue;
            arrayTypes.add(clr.classForName(className));
        }
        this.replicate(arrayTypes.toArray(new Class[arrayTypes.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replicateInTarget(Object ... detachedObjects) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER_JDO.msg("012054"));
        }
        JDOPersistenceManager pm2 = (JDOPersistenceManager)this.pmfTarget.getPersistenceManager();
        Transaction tx2 = pm2.currentTransaction();
        try {
            tx2.begin();
            pm2.makePersistentAll(detachedObjects);
            tx2.commit();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tx2.isActive()) {
                tx2.rollback();
            }
            pm2.close();
            throw throwable;
        }
        if (tx2.isActive()) {
            tx2.rollback();
        }
        pm2.close();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER_JDO.msg("012055"));
        }
    }
}

