/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.exceptions.NullValueException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.util.StringUtils;

public class InterfaceMapping
extends ReferenceMapping {
    private String implementationClasses;

    public void initialize(AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        Class fieldTypeCls;
        super.initialize(mmd, container, clr);
        if (mmd.getType().isInterface() && mmd.getFieldTypes() != null && mmd.getFieldTypes().length == 1 && (fieldTypeCls = clr.classForName(mmd.getFieldTypes()[0])).isInterface()) {
            this.type = mmd.getFieldTypes()[0];
        }
    }

    public void setImplementationClasses(String implementationClasses) {
        this.implementationClasses = implementationClasses;
    }

    public Object getObject(ExecutionContext ec, Object rs, int[] pos) {
        if (ec.getMetaDataManager().isPersistentInterface(this.type)) {
            String[] implTypes = null;
            implTypes = this.implementationClasses != null ? StringUtils.split(this.implementationClasses, ",") : ec.getMetaDataManager().getClassesImplementingInterface(this.getType(), ec.getClassLoaderResolver());
            int n = 0;
            for (int i = 0; i < implTypes.length; ++i) {
                JavaTypeMapping mapping;
                if (implTypes.length > this.javaTypeMappings.length) {
                    int j;
                    PersistableMapping m = (PersistableMapping)this.javaTypeMappings[0];
                    MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
                    mapping = storeMgr.getMappingManager().getMapping(ec.getClassLoaderResolver().classForName(implTypes[i]));
                    for (j = 0; j < m.getDatastoreMappings().length; ++j) {
                        mapping.addDatastoreMapping(m.getDatastoreMappings()[j]);
                    }
                    for (j = 0; j < m.getJavaTypeMapping().length; ++j) {
                        ((PersistableMapping)mapping).addJavaTypeMapping(m.getJavaTypeMapping()[j]);
                    }
                    ((PersistableMapping)mapping).setReferenceMapping(m.getReferenceMapping());
                } else {
                    mapping = this.javaTypeMappings[i];
                }
                if (n >= pos.length) {
                    n = 0;
                }
                int[] posMapping = mapping.getReferenceMapping() != null ? new int[mapping.getReferenceMapping().getNumberOfDatastoreMappings()] : new int[mapping.getNumberOfDatastoreMappings()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = pos[n++];
                }
                Object value = null;
                try {
                    value = mapping.getObject(ec, rs, posMapping);
                }
                catch (NullValueException e) {
                }
                catch (NucleusObjectNotFoundException onfe) {
                    // empty catch block
                }
                if (value == null) continue;
                if (value instanceof OID) {
                    String className = mapping.getReferenceMapping() != null ? mapping.getReferenceMapping().getDatastoreMapping(0).getDatastoreField().getStoredJavaType() : mapping.getDatastoreMapping(0).getDatastoreField().getStoredJavaType();
                    value = OIDFactory.getInstance(ec.getOMFContext(), className, ((OID)value).getKeyValue());
                    return ec.findObject(value, false, true, null);
                }
                if (!ec.getClassLoaderResolver().classForName(this.getType()).isAssignableFrom(value.getClass())) continue;
                return value;
            }
            return null;
        }
        return super.getObject(ec, rs, pos);
    }
}

