/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.transaction;

import java.util.Hashtable;
import org.datanucleus.management.ManagementServer;
import org.datanucleus.management.runtime.TransactionRuntime;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.util.ClassUtils;

public class TransactionManager {
    private boolean containerManagedConnections = false;
    Hashtable<Object, Transaction> transactions = new Hashtable();
    private TransactionRuntime txRuntime = null;

    public void setContainerManagedConnections(boolean flag) {
        this.containerManagedConnections = flag;
    }

    public void registerMbean(String domainName, String instanceName, ManagementServer mgmtServer) {
        if (mgmtServer != null) {
            this.txRuntime = new TransactionRuntime();
            String mbeanName = domainName + ":InstanceName=" + instanceName + ",Type=" + ClassUtils.getClassNameForClass(this.txRuntime.getClass()) + ",Name=TransactionRuntime";
            mgmtServer.registerMBean(this.txRuntime, mbeanName);
        }
    }

    public TransactionRuntime getTransactionRuntime() {
        return this.txRuntime;
    }

    public synchronized void begin(Object om) {
        Transaction tx = this.transactions.get(om);
        if (tx != null) {
            throw new NucleusTransactionException("Invalid state. Transaction has already started");
        }
        tx = new Transaction();
        this.transactions.put(om, tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Object om) {
        Transaction tx = this.transactions.get(om);
        if (tx == null) {
            throw new NucleusTransactionException("Invalid state. Transaction does not exist");
        }
        try {
            if (!this.containerManagedConnections) {
                tx.commit();
            }
            Object var4_3 = null;
            this.transactions.remove(om);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.transactions.remove(om);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Object om) {
        Transaction tx = this.transactions.get(om);
        if (tx == null) {
            throw new NucleusTransactionException("Invalid state. Transaction does not exist");
        }
        try {
            if (!this.containerManagedConnections) {
                tx.rollback();
            }
            Object var4_3 = null;
            this.transactions.remove(om);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.transactions.remove(om);
            throw throwable;
        }
    }

    public synchronized Transaction getTransaction(Object om) {
        if (om == null) {
            return null;
        }
        return this.transactions.get(om);
    }

    public void resume(Object om, Transaction tx) {
        throw new UnsupportedOperationException();
    }

    public synchronized void setRollbackOnly(Object om) {
        Transaction tx = this.transactions.get(om);
        if (tx == null) {
            throw new NucleusTransactionException("Invalid state. Transaction does not exist");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(Object om, int millis) {
        throw new UnsupportedOperationException();
    }

    public Transaction suspend(Object om) {
        throw new UnsupportedOperationException();
    }
}

