/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.properties.PersistencePropertyValidator;
import org.datanucleus.properties.PropertyTypeInvalidException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.PersistenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceConfiguration {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ExecutionContext.class.getClassLoader());
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>();

    public Set<String> getSupportedProperties() {
        return this.propertyMappings.keySet();
    }

    public void setDefaultProperties(PluginManager pluginMgr) {
        ConfigurationElement[] propElements = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.persistence_properties", null, null);
        if (propElements != null) {
            for (int i = 0; i < propElements.length; ++i) {
                String name = propElements[i].getAttribute("name");
                String intName = propElements[i].getAttribute("internal-name");
                String value = propElements[i].getAttribute("value");
                this.propertyMappings.put(name.toLowerCase(), new PropertyMapping(name, intName, value, propElements[i].getAttribute("validator")));
                String systemValue = System.getProperty(name);
                if (systemValue != null) {
                    if (intName != null) {
                        this.setPropertyInternal(intName, systemValue);
                        continue;
                    }
                    this.setPropertyInternal(name, systemValue);
                    continue;
                }
                if (this.properties.containsKey(name) || value == null) continue;
                if (intName != null) {
                    this.setPropertyInternal(intName, value);
                    continue;
                }
                this.setPropertyInternal(name, value);
            }
        }
    }

    public Map<String, Object> getPersistenceProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name.toLowerCase());
    }

    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public long getLongProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj instanceof String) {
                Long longVal = Long.valueOf((String)obj);
                this.setPropertyInternal(name, longVal);
                return longVal;
            }
        } else {
            return 0L;
        }
        throw new PropertyTypeInvalidException(name, "long");
    }

    public int getIntProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj instanceof String) {
                Integer intVal = Integer.valueOf((String)obj);
                this.setPropertyInternal(name, intVal);
                return intVal;
            }
        } else {
            return 0;
        }
        throw new PropertyTypeInvalidException(name, "int");
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean resultIfNotSet) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof String) {
                Boolean boolVal = Boolean.valueOf((String)obj);
                this.setPropertyInternal(name, boolVal);
                return boolVal;
            }
        } else {
            return resultIfNotSet;
        }
        throw new PropertyTypeInvalidException(name, "boolean");
    }

    public Boolean getBooleanObjectProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof String) {
                Boolean boolVal = Boolean.valueOf((String)obj);
                this.setPropertyInternal(name, boolVal);
                return boolVal;
            }
        } else {
            return null;
        }
        throw new PropertyTypeInvalidException(name, "Boolean");
    }

    public String getStringProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
        } else {
            return null;
        }
        throw new PropertyTypeInvalidException(name, "String");
    }

    private void setPropertyInternal(String name, Object value) {
        this.properties.put(name.toLowerCase(), value);
    }

    public synchronized void setPropertiesUsingFile(String filename) {
        if (filename == null) {
            return;
        }
        Properties props = null;
        try {
            props = PersistenceUtils.setPropertiesUsingFile(filename);
            this.setPropertyInternal("datanucleus.propertiesFile", filename);
        }
        catch (NucleusUserException nue) {
            this.properties.remove("datanucleus.propertiesFile");
            throw nue;
        }
        if (props != null && !props.isEmpty()) {
            this.setPersistenceProperties(props);
        }
    }

    public void setPersistenceProperties(Map props) {
        Set keys = props.keySet();
        for (Object keyObj : keys) {
            if (!(keyObj instanceof String)) continue;
            String key = (String)keyObj;
            Object valueObj = props.get(keyObj);
            this.setProperty(key, valueObj);
        }
    }

    public void setProperty(String name, Object value) {
        if (name != null) {
            String propertyName = name.trim();
            PropertyMapping mapping = this.propertyMappings.get(propertyName.toLowerCase());
            if (mapping != null) {
                if (mapping.validatorName != null) {
                    PersistencePropertyValidator validator = null;
                    try {
                        Class<?> validatorCls = Class.forName(mapping.validatorName);
                        validator = (PersistencePropertyValidator)validatorCls.newInstance();
                    }
                    catch (Exception e) {
                        NucleusLogger.PERSISTENCE.warn("Error creating validator of type " + mapping.validatorName, e);
                    }
                    if (validator != null) {
                        boolean validated;
                        boolean bl = validated = mapping.internalName != null ? validator.validate(mapping.internalName, value) : validator.validate(propertyName, value);
                        if (!validated) {
                            throw new IllegalArgumentException(LOCALISER.msg("008012", (Object)propertyName, value));
                        }
                    }
                }
                if (mapping.internalName != null) {
                    this.setPropertyInternal(mapping.internalName, value);
                } else {
                    this.setPropertyInternal(mapping.name, value);
                }
                if (propertyName.equals("datanucleus.propertiesFile")) {
                    this.setPropertiesUsingFile((String)value);
                } else if (propertyName.equals("datanucleus.localisation.messageCodes")) {
                    boolean included = this.getBooleanProperty("datanucleus.localisation.messageCodes");
                    Localiser.setDisplayCodesInMessages(included);
                } else if (propertyName.equals("datanucleus.localisation.language")) {
                    String language = this.getStringProperty("datanucleus.localisation.language");
                    Localiser.setLanguage(language);
                }
            } else {
                this.setPropertyInternal(propertyName, value);
                if (this.propertyMappings.size() > 0) {
                    NucleusLogger.PERSISTENCE.info(LOCALISER.msg("008015", (Object)propertyName));
                }
            }
        }
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PersistenceConfiguration)) {
            return false;
        }
        PersistenceConfiguration config = (PersistenceConfiguration)obj;
        return !(this.properties == null ? config.properties != null : !((Object)this.properties).equals(config.properties));
    }

    class PropertyMapping {
        String name;
        String internalName;
        String value;
        String validatorName;

        public PropertyMapping(String name, String intName, String val, String validator) {
            this.name = name;
            this.internalName = intName;
            this.value = val;
            this.validatorName = validator;
        }
    }
}

