/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.util.BitSet;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.ObjectStringConverter;

public class BitSetStringConverter
implements ObjectStringConverter {
    public Object toObject(String str) {
        if (str == null) {
            return null;
        }
        BitSet set = new BitSet();
        StringTokenizer tokeniser = new StringTokenizer(str.substring(1, str.length() - 1), ",");
        while (tokeniser.hasMoreTokens()) {
            String token = tokeniser.nextToken().trim();
            try {
                int position = new Integer(token);
                set.set(position);
            }
            catch (NumberFormatException nfe) {
                throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)BitSet.class.getName()), nfe);
            }
        }
        return set;
    }

    public String toString(Object obj) {
        String str;
        if (obj instanceof BitSet) {
            BitSet set = (BitSet)obj;
            str = set.toString();
        } else {
            str = (String)obj;
        }
        return str;
    }
}

