/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.typesafe.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.jdo.annotations.PersistenceCapable;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"javax.jdo.annotations.PersistenceCapable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JDOQueryProcessor
extends AbstractProcessor {
    String prefix = "Q";
    Types typesHandler;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        this.typesHandler = this.processingEnv.getTypeUtils();
        Set<? extends Element> elements = roundEnv.getRootElements();
        for (Element element : elements) {
            this.processClass((TypeElement)element);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClass(TypeElement el) {
        if (el == null || !JDOQueryProcessor.isJDOAnnotated(el)) {
            return;
        }
        Elements elementUtils = this.processingEnv.getElementUtils();
        String className = elementUtils.getBinaryName(el).toString();
        String pkgName = className.substring(0, className.lastIndexOf(46));
        String classSimpleName = className.substring(className.lastIndexOf(46) + 1);
        String classNameNew = this.prefix + className;
        System.out.println("JDO QueryProcessor orig=" + className + " new=" + classNameNew);
        TypeElement superEl = this.getPersistentSupertype(el);
        try {
            JavaFileObject javaFile = this.processingEnv.getFiler().createSourceFile(classNameNew, new Element[0]);
            Writer w = javaFile.openWriter();
            try {
                w.append("package " + pkgName + ";\n");
                w.append("\n");
                w.append("public class " + this.prefix + classSimpleName);
                if (superEl != null) {
                    String superClassName = elementUtils.getBinaryName(superEl).toString();
                    w.append(" extends ").append(this.prefix + superClassName);
                }
                w.append("\n");
                w.append("{\n");
                w.append("}\n");
                w.flush();
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                w.close();
                throw throwable;
            }
            w.close();
            {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TypeElement getPersistentSupertype(TypeElement element) {
        TypeMirror superType = element.getSuperclass();
        if (superType == null || element != null && "java.lang.Object".equals(element.toString())) {
            return null;
        }
        TypeElement superElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(superType);
        if (JDOQueryProcessor.isJDOAnnotated(superElement)) {
            return superElement;
        }
        return this.getPersistentSupertype(superElement);
    }

    public static boolean isJDOAnnotated(TypeElement el) {
        return el.getAnnotation(PersistenceCapable.class) != null;
    }
}

