/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.IncompatibleQueryElementTypeException;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractSetStore;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class FKSetStore
extends AbstractSetStore {
    private final int ownerFieldNumber;

    public FKSetStore(AbstractMemberMetaData fmd, MappedStoreManager storeMgr, ClassLoaderResolver clr, AbstractSetStoreSpecialization specialization) {
        super((StoreManager)storeMgr, clr, specialization);
        this.setOwner(fmd, clr);
        CollectionMetaData colmd = fmd.getCollection();
        if (colmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056001", (Object)fmd.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType(element_class)) {
            this.elementIsPersistentInterface = storeMgr.getOMFContext().getMetaDataManager().isPersistentInterface(element_class.getName());
            if (this.elementIsPersistentInterface) {
                this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForInterface(element_class, clr);
            } else {
                this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
                if (this.emd != null) {
                    // empty if block
                }
            }
        } else {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(LOCALISER.msg("056003", (Object)element_class.getName(), (Object)fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIdMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        if (fmd.getMappedBy() != null) {
            AbstractMemberMetaData eofmd = this.emd.getMetaDataForMember(fmd.getMappedBy());
            if (eofmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056024", (Object)fmd.getFullFieldName(), (Object)fmd.getMappedBy(), (Object)element_class.getName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getAbsolutePositionOfMember(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getMemberMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056029", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType, (Object)ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(LOCALISER.msg("056026", (Object)ownerFieldName, (Object)this.elementType, (Object)eofmd.getTypeName(), (Object)fmd.getClassName()));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056030", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
            }
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.containerTable) {
            this.containerTable = this.ownerMapping.getDatastoreContainer();
        }
    }

    private boolean updateElementFk(ObjectProvider sm, Object element, Object owner) {
        if (element == null) {
            return false;
        }
        this.validateElementForWriting(sm, element, null);
        return this.updateElementFkInternal(sm, element, owner);
    }

    protected int getFieldNumberInElementForBidirectional(ObjectProvider sm) {
        if (this.ownerFieldNumber < 0) {
            return -1;
        }
        return sm.getClassMetaData().getAbsolutePositionOfMember(this.ownerMemberMetaData.getMappedBy());
    }

    public void update(ObjectProvider sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        Iterator elemIter = this.iterator(sm);
        HashSet existing = new HashSet();
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.size() != coll.size()) {
            for (Object elem : coll) {
                if (existing.contains(elem)) continue;
                this.add(sm, elem, 0);
            }
        }
    }

    public boolean add(final ObjectProvider sm, Object element, int size) {
        if (element == null) {
            throw new NucleusUserException(LOCALISER.msg("056039"));
        }
        final Object newOwner = sm.getObject();
        ExecutionContext ec = sm.getExecutionContext();
        boolean inserted = this.validateElementForWriting(sm, element, new FieldValues2(){

            public void fetchFields(ObjectProvider esm) {
                AbstractClassMetaData[] managingCmds;
                boolean isPersistentInterface = FKSetStore.this.storeMgr.getOMFContext().getMetaDataManager().isPersistentInterface(FKSetStore.this.elementType);
                DatastoreClass elementTable = null;
                elementTable = isPersistentInterface ? FKSetStore.this.storeMgr.getDatastoreClass(FKSetStore.this.storeMgr.getOMFContext().getMetaDataManager().getImplementationNameForPersistentInterface(FKSetStore.this.elementType), FKSetStore.this.clr) : FKSetStore.this.storeMgr.getDatastoreClass(FKSetStore.this.elementType, FKSetStore.this.clr);
                if (elementTable == null && (managingCmds = FKSetStore.this.storeMgr.getClassesManagingTableForClass(FKSetStore.this.emd, FKSetStore.this.clr)) != null && managingCmds.length > 0) {
                    for (int i = 0; i < managingCmds.length; ++i) {
                        Class tblCls = FKSetStore.this.clr.classForName(managingCmds[i].getFullClassName());
                        if (!tblCls.isAssignableFrom(esm.getObject().getClass())) continue;
                        elementTable = FKSetStore.this.storeMgr.getDatastoreClass(managingCmds[i].getFullClassName(), FKSetStore.this.clr);
                        break;
                    }
                }
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKSetStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        esm.setAssociatedValue(externalFKMapping, sm.getObject());
                    }
                    if (FKSetStore.this.relationDiscriminatorMapping != null) {
                        esm.setAssociatedValue(FKSetStore.this.relationDiscriminatorMapping, FKSetStore.this.relationDiscriminatorValue);
                    }
                }
                if (FKSetStore.this.getFieldNumberInElementForBidirectional(esm) >= 0 && sm.getExecutionContext().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships")) {
                    Object currentOwner = esm.provideField(FKSetStore.this.getFieldNumberInElementForBidirectional(esm));
                    if (currentOwner == null) {
                        NucleusLogger.PERSISTENCE.info(BaseContainerStore.LOCALISER.msg("056037", (Object)sm.toPrintableID(), (Object)FKSetStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(esm.getObject())));
                        esm.replaceFieldMakeDirty(FKSetStore.this.getFieldNumberInElementForBidirectional(esm), newOwner);
                    } else if (currentOwner != newOwner && sm.getReferencedPC() == null) {
                        throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056038", (Object)sm.toPrintableID(), (Object)FKSetStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(esm.getObject()), (Object)StringUtils.toJVMIDString(currentOwner)));
                    }
                }
            }

            public void fetchNonLoadedFields(ObjectProvider sm2) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        if (inserted) {
            return true;
        }
        ObjectProvider elementSM = ec.findObjectProvider(element);
        if (this.getFieldNumberInElementForBidirectional(elementSM) >= 0 && ec.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships")) {
            ec.getApiAdapter().isLoaded(elementSM, this.getFieldNumberInElementForBidirectional(elementSM));
            Object oldOwner = elementSM.provideField(this.getFieldNumberInElementForBidirectional(elementSM));
            if (oldOwner != newOwner) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("055009", (Object)sm.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(element)));
                }
                elementSM.setObjectField(element, this.getFieldNumberInElementForBidirectional(elementSM), oldOwner, newOwner);
                if (ec.isFlushing()) {
                    elementSM.flush();
                }
            }
            return oldOwner != newOwner;
        }
        boolean contained = this.contains(sm, element);
        return contained ? false : this.updateElementFk(sm, element, newOwner);
    }

    public boolean addAll(ObjectProvider sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean success = false;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (!this.add(sm, iter.next(), -1)) continue;
            success = true;
        }
        return success;
    }

    public boolean remove(ObjectProvider ownerSM, Object element, int size, boolean allowDependentField) {
        if (element == null) {
            return false;
        }
        if (!this.validateElementForReading(ownerSM, element)) {
            return false;
        }
        Object elementToRemove = element;
        ExecutionContext ec = ownerSM.getExecutionContext();
        if (ec.getApiAdapter().isDetached(element)) {
            elementToRemove = ec.findObject(ec.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        ObjectProvider elementSM = ec.findObjectProvider(elementToRemove);
        Object oldOwner = null;
        if (this.ownerFieldNumber >= 0 && !ec.getApiAdapter().isDeleted(elementToRemove)) {
            ec.getApiAdapter().isLoaded(elementSM, this.ownerFieldNumber);
            oldOwner = elementSM.provideField(this.ownerFieldNumber);
        }
        if (this.ownerFieldNumber >= 0 && oldOwner != ownerSM.getObject() && oldOwner != null) {
            return false;
        }
        boolean deleteElement = this.checkRemovalOfElementShouldDelete(ownerSM);
        if (deleteElement) {
            if (ec.getApiAdapter().isPersistable(elementToRemove) && ec.getApiAdapter().isDeleted(elementToRemove)) {
                elementSM.flush();
            } else {
                ec.deleteObjectInternal(elementToRemove);
            }
        } else {
            this.manageRemovalOfElement(ownerSM, elementToRemove);
            this.updateElementFk(ownerSM, elementToRemove, null);
        }
        return true;
    }

    public boolean removeAll(ObjectProvider sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean success = true;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (!this.remove(sm, iter.next(), -1, true)) continue;
            success = false;
        }
        return success;
    }

    protected boolean checkRemovalOfElementShouldDelete(ObjectProvider ownerSM) {
        boolean delete = false;
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug(LOCALISER.msg("056034"));
            }
            delete = true;
        } else if (this.ownerMapping.isNullable()) {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug(LOCALISER.msg("056036"));
            }
            delete = false;
        } else {
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug(LOCALISER.msg("056035"));
            }
            delete = true;
        }
        return delete;
    }

    protected void manageRemovalOfElement(ObjectProvider ownerSM, Object element) {
        ObjectProvider elementSM;
        ExecutionContext ec = ownerSM.getExecutionContext();
        if (this.relationType == 4 && ec.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && !ec.getApiAdapter().isDeleted(element) && (elementSM = ec.findObjectProvider(element)) != null) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("055010", (Object)ownerSM.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(element)));
            }
            elementSM.replaceFieldMakeDirty(this.getFieldNumberInElementForBidirectional(elementSM), null);
            if (ec.isFlushing()) {
                elementSM.flush();
            }
        }
    }

    public void clear(ObjectProvider ownerSM) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        boolean deleteElements = this.checkRemovalOfElementShouldDelete(ownerSM);
        if (deleteElements) {
            Iterator elementsIter = this.iterator(ownerSM);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    if (ec.getApiAdapter().isPersistable(element) && ec.getApiAdapter().isDeleted(element)) {
                        ObjectProvider elementSM = ec.findObjectProvider(element);
                        elementSM.flush();
                        continue;
                    }
                    ec.deleteObjectInternal(element);
                }
            }
        } else {
            ec.getApiAdapter().isLoaded(ownerSM, this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Collection value = (Collection)ownerSM.provideField(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Iterator elementsIter = null;
            elementsIter = value != null && !value.isEmpty() ? value.iterator() : this.iterator(ownerSM);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    this.manageRemovalOfElement(ownerSM, element);
                }
            }
            this.clearInternal(ownerSM, ec);
        }
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier setTableAlias, Class filteredElementType, ScalarExpression elementExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        ScalarExpression ownerExpr;
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        DatastoreClass filteredElementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), clr);
        if (stmt.getTableExpression(elementTableAlias) == null) {
            stmt.newTableExpression(filteredElementTable, elementTableAlias);
        }
        DatastoreIdentifier containerRangeVar = setTableAlias;
        if (existsQuery) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                // empty if block
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
        } else if (parentStmt != stmt) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        } else if (elementExpr.getLogicSetExpression().getMainTable() == filteredElementTable) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        } else {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.innerJoin(ownerExpr, ownerSetExpr, stmt.getTableExpression(containerRangeVar), true, true);
        }
        JavaTypeMapping elementTableID = filteredElementTable.getIdMapping();
        return elementTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }

    protected abstract void clearInternal(ObjectProvider var1, ExecutionContext var2);

    protected abstract boolean updateElementFkInternal(ObjectProvider var1, Object var2, Object var3);
}

