/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.awt.geom.Rectangle2D;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.OMFContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class Rectangle2dDoubleMapping
extends SingleFieldMultiMapping {
    private static final Rectangle2D.Double sampleValue = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);

    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(fmd, container, clr);
        this.addDatastoreFields();
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addDatastoreFields();
    }

    protected void addDatastoreFields() {
        this.addDatastoreField(ClassNameConstants.DOUBLE);
        this.addDatastoreField(ClassNameConstants.DOUBLE);
        this.addDatastoreField(ClassNameConstants.DOUBLE);
        this.addDatastoreField(ClassNameConstants.DOUBLE);
    }

    public Class getJavaType() {
        return Rectangle2D.Double.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return sampleValue;
    }

    public Object getValueForDatastoreMapping(OMFContext omfCtx, int index, Object value) {
        Rectangle2D.Double qc = (Rectangle2D.Double)value;
        if (index == 0) {
            return qc.getX();
        }
        if (index == 1) {
            return qc.getY();
        }
        if (index == 2) {
            return qc.getWidth();
        }
        if (index == 3) {
            return qc.getHeight();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        Rectangle2D rectangle = (Rectangle2D)value;
        if (rectangle == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDatastoreMapping(i).setObject(preparedStatement, exprIndex[i], null);
            }
        } else {
            this.getDatastoreMapping(0).setDouble(preparedStatement, exprIndex[0], rectangle.getX());
            this.getDatastoreMapping(1).setDouble(preparedStatement, exprIndex[1], rectangle.getY());
            this.getDatastoreMapping(2).setDouble(preparedStatement, exprIndex[2], rectangle.getWidth());
            this.getDatastoreMapping(3).setDouble(preparedStatement, exprIndex[3], rectangle.getHeight());
        }
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        double x = this.getDatastoreMapping(0).getDouble(resultSet, exprIndex[0]);
        double y = this.getDatastoreMapping(1).getDouble(resultSet, exprIndex[1]);
        double width = this.getDatastoreMapping(2).getDouble(resultSet, exprIndex[2]);
        double height = this.getDatastoreMapping(3).getDouble(resultSet, exprIndex[3]);
        return new Rectangle2D.Double(x, y, width, height);
    }
}

