/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.ClassUtils;

public class IdentityUtils {
    public static Object getDatastoreIdentityForResultSetRow(ExecutionContext ec, AbstractClassMetaData cmd, Class pcClass, boolean inheritanceCheck, Object resultSet, StatementClassMapping mappingDefinition) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            StatementMappingIndex datastoreIdMapping;
            JavaTypeMapping mapping;
            OID oid;
            if (pcClass == null) {
                pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
            }
            if ((oid = (OID)(mapping = (datastoreIdMapping = mappingDefinition.getMappingForMemberPosition(StatementClassMapping.MEMBER_DATASTORE_ID)).getMapping()).getObject(ec, resultSet, datastoreIdMapping.getColumnPositions())) != null && !pcClass.getName().equals(oid.getPcClass())) {
                oid = OIDFactory.getInstance(ec.getOMFContext(), pcClass.getName(), oid.getKeyValue());
            }
            if (inheritanceCheck) {
                if (ec.hasIdentityInCache(oid)) {
                    return oid;
                }
                String[] subclasses = ec.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true);
                if (subclasses != null) {
                    for (int i = 0; i < subclasses.length; ++i) {
                        oid = OIDFactory.getInstance(ec.getOMFContext(), subclasses[i], oid.getKeyValue());
                        if (!ec.hasIdentityInCache(oid)) continue;
                        return oid;
                    }
                }
                String className = ec.getStoreManager().getClassNameForObjectID(oid, ec.getClassLoaderResolver(), ec);
                return OIDFactory.getInstance(ec.getOMFContext(), className, oid.getKeyValue());
            }
            return oid;
        }
        return null;
    }

    public static Object getApplicationIdentityForResultSetRow(ExecutionContext ec, AbstractClassMetaData cmd, Class pcClass, boolean inheritanceCheck, FieldManager resultsFM) {
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            Object id;
            if (pcClass == null) {
                pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
            }
            ApiAdapter api = ec.getApiAdapter();
            int[] pkFieldNums = cmd.getPKMemberPositions();
            Object[] pkFieldValues = new Object[pkFieldNums.length];
            Class[] pkFieldTypes = new Class[pkFieldNums.length];
            for (int i = 0; i < pkFieldNums.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                pkFieldTypes[i] = pkMmd.getType();
                pkFieldValues[i] = pkMmd.getType() == Integer.TYPE ? Integer.valueOf(resultsFM.fetchIntField(pkFieldNums[i])) : (pkMmd.getType() == Short.TYPE ? Short.valueOf(resultsFM.fetchShortField(pkFieldNums[i])) : (pkMmd.getType() == Long.TYPE ? Long.valueOf(resultsFM.fetchLongField(pkFieldNums[i])) : (pkMmd.getType() == Character.TYPE ? Character.valueOf(resultsFM.fetchCharField(pkFieldNums[i])) : (pkMmd.getType() == Boolean.TYPE ? Boolean.valueOf(resultsFM.fetchBooleanField(pkFieldNums[i])) : (pkMmd.getType() == Byte.TYPE ? Byte.valueOf(resultsFM.fetchByteField(pkFieldNums[i])) : (pkMmd.getType() == Double.TYPE ? Double.valueOf(resultsFM.fetchDoubleField(pkFieldNums[i])) : (pkMmd.getType() == Float.TYPE ? Float.valueOf(resultsFM.fetchFloatField(pkFieldNums[i])) : (pkMmd.getType() == String.class ? resultsFM.fetchStringField(pkFieldNums[i]) : resultsFM.fetchObjectField(pkFieldNums[i])))))))));
            }
            Class idClass = ec.getClassLoaderResolver().classForName(cmd.getObjectidClass());
            if (cmd.usesSingleFieldIdentityClass()) {
                id = api.getNewSingleFieldIdentity(idClass, pcClass, pkFieldValues[0]);
                if (inheritanceCheck) {
                    if (ec.hasIdentityInCache(id)) {
                        return id;
                    }
                    String[] subclasses = ec.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true);
                    if (subclasses != null) {
                        for (int i = 0; i < subclasses.length; ++i) {
                            Object subid = api.getNewSingleFieldIdentity(idClass, ec.getClassLoaderResolver().classForName(subclasses[i]), api.getTargetKeyForSingleFieldIdentity(id));
                            if (!ec.hasIdentityInCache(subid)) continue;
                            return subid;
                        }
                    }
                    String className = ec.getStoreManager().getClassNameForObjectID(id, ec.getClassLoaderResolver(), ec);
                    return api.getNewSingleFieldIdentity(idClass, ec.getClassLoaderResolver().classForName(className), pkFieldValues[0]);
                }
                return id;
            }
            try {
                id = idClass.newInstance();
                for (int i = 0; i < pkFieldNums.length; ++i) {
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                    Object value = pkFieldValues[i];
                    if (api.isPersistable(value)) {
                        value = api.getIdForObject(value);
                    }
                    if (pkMmd instanceof FieldMetaData) {
                        Field pkField = idClass.getField(pkMmd.getName());
                        pkField.set(id, value);
                        continue;
                    }
                    Method pkMethod = ClassUtils.getSetterMethodForClass(idClass, pkMmd.getName());
                    pkMethod.invoke((Object)idClass, value);
                }
                return id;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

