/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.exceptions.IncompatibleQueryElementTypeException;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractMapStore;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.MapEntrySetStore;
import org.datanucleus.store.mapped.scostore.MapKeySetStore;
import org.datanucleus.store.mapped.scostore.MapValueSetStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public abstract class JoinMapStore
extends AbstractMapStore {
    private SetStore keySetStore = null;
    private SetStore valueSetStore = null;
    private SetStore entrySetStore = null;
    protected final JavaTypeMapping adapterMapping;
    protected ClassLoaderResolver clr;

    public JoinMapStore(DatastoreContainerObject mapTable, ClassLoaderResolver clr, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, JavaTypeMapping orderMapping, String keyType, boolean isEmbeddedKey, boolean isSerialisedKey, String valueType, boolean isEmbeddedValue, boolean isSerialisedValue, AbstractMemberMetaData ownerMemberMetaData, AbstractMapStoreSpecialization specialization) {
        super(mapTable.getStoreManager(), specialization);
        this.clr = clr;
        this.mapTable = mapTable;
        this.setOwner(ownerMemberMetaData, clr);
        this.ownerMapping = ownerMapping;
        this.keyMapping = keyMapping;
        this.valueMapping = valueMapping;
        this.adapterMapping = orderMapping;
        this.keyType = keyType;
        this.keysAreEmbedded = isEmbeddedKey;
        this.keysAreSerialised = isSerialisedKey;
        this.valueType = valueType;
        this.valuesAreEmbedded = isEmbeddedValue;
        this.valuesAreSerialised = isSerialisedValue;
        Class key_class = clr.classForName(keyType);
        this.kmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(key_class, clr);
        Class value_class = clr.classForName(valueType);
        if (ClassUtils.isReferenceType(value_class)) {
            NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("056066", (Object)value_class.getName()));
            this.vmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(value_class, null, clr);
            if (this.vmd != null) {
                valueType = value_class.getName();
                this.valueTable = this.storeMgr.getDatastoreClass(this.vmd.getFullClassName(), clr);
            }
        } else {
            this.vmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(value_class, clr);
            if (this.vmd != null) {
                valueType = this.vmd.getFullClassName();
                this.valueTable = this.valuesAreEmbedded ? null : this.storeMgr.getDatastoreClass(valueType, clr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(ObjectProvider sm, Map m) {
        Map.Entry entry;
        Iterator iter;
        ManagedConnection mconn;
        ExecutionContext ec;
        if (m == null || m.size() == 0) {
            return;
        }
        HashSet puts = new HashSet();
        HashSet updates = new HashSet();
        for (Map.Entry e : m.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            this.validateKeyForWriting(sm, key);
            this.validateValueForWriting(sm, value);
            try {
                Object oldValue = this.getValue(sm, key);
                if (oldValue == value) continue;
                updates.add(e);
            }
            catch (NoSuchElementException nsee) {
                if (value == null) continue;
                puts.add(e);
            }
        }
        boolean batched = this.allowsBatching();
        if (puts.size() > 0) {
            try {
                ec = sm.getExecutionContext();
                mconn = this.storeMgr.getConnection(ec);
                try {
                    iter = puts.iterator();
                    while (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        this.internalPut(sm, mconn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056016", (Object)e.getMessage()), e);
            }
        }
        if (updates.size() > 0) {
            try {
                ec = sm.getExecutionContext();
                mconn = this.storeMgr.getConnection(ec);
                try {
                    iter = updates.iterator();
                    while (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        this.internalUpdate(sm, mconn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException mde) {
                throw new NucleusDataStoreException(LOCALISER.msg("056016", (Object)mde.getMessage()), mde);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(ObjectProvider sm, Object key, Object value) {
        MapMetaData mapmd;
        Object oldValue;
        this.validateKeyForWriting(sm, key);
        this.validateValueForWriting(sm, value);
        boolean exists = false;
        try {
            oldValue = this.getValue(sm, key);
            exists = true;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            exists = false;
        }
        if (oldValue != value) {
            try {
                ExecutionContext ec = sm.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                try {
                    if (exists) {
                        this.internalUpdate(sm, mconn, false, key, value, true);
                    } else {
                        this.internalPut(sm, mconn, false, key, value, true);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056016", (Object)e.getMessage()), e);
            }
        }
        if ((mapmd = this.ownerMemberMetaData.getMap()).isDependentValue() && !mapmd.isEmbeddedValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getExecutionContext().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public Object remove(ObjectProvider sm, Object key) {
        boolean exists;
        Object oldValue;
        if (!this.validateKeyForReading(sm, key)) {
            return null;
        }
        try {
            oldValue = this.getValue(sm, key);
            exists = true;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            exists = false;
        }
        ExecutionContext ec = sm.getExecutionContext();
        if (exists) {
            this.removeInternal(sm, key);
        }
        MapMetaData mapmd = this.ownerMemberMetaData.getMap();
        ApiAdapter api = ec.getApiAdapter();
        if (mapmd.isDependentKey() && !mapmd.isEmbeddedKey() && api.isPersistable(key)) {
            ec.deleteObjectInternal(key);
        }
        if (mapmd.isDependentValue() && !mapmd.isEmbeddedValue() && api.isPersistable(oldValue) && !this.containsValue(sm, oldValue)) {
            ec.deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    protected abstract void removeInternal(ObjectProvider var1, Object var2);

    public void clear(ObjectProvider ownerSM) {
        HashSet<Object> dependentElements = null;
        if (this.ownerMemberMetaData.getMap().isDependentKey() || this.ownerMemberMetaData.getMap().isDependentValue()) {
            dependentElements = new HashSet<Object>();
            ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
            Iterator iter = this.entrySetStore().iterator(ownerSM);
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                MapMetaData mapmd = this.ownerMemberMetaData.getMap();
                if (api.isPersistable(entry.getKey()) && mapmd.isDependentKey() && !mapmd.isEmbeddedKey()) {
                    dependentElements.add(entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || !mapmd.isDependentValue() || mapmd.isEmbeddedValue()) continue;
                dependentElements.add(entry.getValue());
            }
        }
        this.clearInternal(ownerSM);
        if (dependentElements != null && dependentElements.size() > 0) {
            ownerSM.getExecutionContext().deleteObjects(dependentElements.toArray());
        }
    }

    protected abstract void clearInternal(ObjectProvider var1);

    public synchronized SetStore keySetStore() {
        if (this.keySetStore == null) {
            this.keySetStore = this.newMapKeySetStore();
        }
        return this.keySetStore;
    }

    public synchronized SetStore valueSetStore() {
        if (this.valueSetStore == null) {
            this.valueSetStore = this.newMapValueSetStore();
        }
        return this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        if (this.entrySetStore == null) {
            this.entrySetStore = this.newMapEntrySetStore();
        }
        return this.entrySetStore;
    }

    public JavaTypeMapping getAdapterMapping() {
        return this.adapterMapping;
    }

    protected abstract MapKeySetStore newMapKeySetStore();

    protected abstract MapValueSetStore newMapValueSetStore();

    protected abstract MapEntrySetStore newMapEntrySetStore();

    protected abstract void internalUpdate(ObjectProvider var1, ManagedConnection var2, boolean var3, Object var4, Object var5, boolean var6) throws MappedDatastoreException;

    protected abstract int[] internalPut(ObjectProvider var1, ManagedConnection var2, boolean var3, Object var4, Object var5, boolean var6) throws MappedDatastoreException;

    public ScalarExpression joinKeysTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias, Class filteredKeyType, ScalarExpression keyExpr, DatastoreIdentifier keyTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.keyType, filteredKeyType) && !clr.isAssignableFrom(filteredKeyType, this.keyType)) {
            throw new IncompatibleQueryElementTypeException(this.keyType, filteredKeyType == null ? null : filteredKeyType.getName());
        }
        LogicSetExpression mapTblExpr = stmt.newTableExpression(this.mapTable, mapTableAlias);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        if (!parentStmt.hasCrossJoin(mapTblExpr)) {
            stmt.crossJoin(mapTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredKeyType.getName())) {
            return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        if (this.keysAreEmbedded || this.keysAreSerialised) {
            return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        DatastoreClass keyTable = this.storeMgr.getDatastoreClass(filteredKeyType.getName(), stmt.getClassLoaderResolver());
        JavaTypeMapping keyTableID = keyTable.getIdMapping();
        LogicSetExpression keyTblExpr = stmt.getTableExpression(keyTableAlias);
        if (keyTblExpr == null) {
            keyTblExpr = stmt.newTableExpression(keyTable, keyTableAlias);
        }
        ScalarExpression keyMapExpr = this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        if (!parentStmt.hasCrossJoin(keyTblExpr)) {
            stmt.crossJoin(keyTblExpr, true);
        }
        if (keyExpr == null) {
            keyExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyTableAlias));
        }
        if (keyExpr.getLogicSetExpression() != null && !keyTable.equals(keyExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(keyMapExpr.eq(keyExpr), true);
            return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        ScalarExpression kExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyTableAlias));
        stmt.andCondition(keyMapExpr.eq(kExpr), true);
        return kExpr;
    }

    public ScalarExpression[] joinKeysValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias, Class filteredKeyType, Class filteredValueType, ScalarExpression keyExpr, ScalarExpression valExpr, DatastoreIdentifier keyTableAlias, DatastoreIdentifier valueTableAlias) {
        ScalarExpression[] qclKeyValues = new ScalarExpression[]{this.joinKeysTo(stmt, parentStmt, ownerMapping, ownerTe, mapTableAlias, filteredKeyType, keyExpr, keyTableAlias), this.joinValuesTo(stmt, parentStmt, ownerMapping, ownerTe, mapTableAlias, filteredValueType, valExpr, valueTableAlias)};
        return qclKeyValues;
    }

    public ScalarExpression joinValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias, Class filteredValueType, ScalarExpression valExpr, DatastoreIdentifier valueTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.valueType, filteredValueType) && !clr.isAssignableFrom(filteredValueType, this.valueType)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, filteredValueType == null ? null : filteredValueType.getName());
        }
        LogicSetExpression mapTblExpr = stmt.newTableExpression(this.mapTable, mapTableAlias);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        if (!parentStmt.hasCrossJoin(mapTblExpr)) {
            stmt.crossJoin(mapTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredValueType.getName())) {
            return this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            return this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        DatastoreClass valueTable = this.storeMgr.getDatastoreClass(filteredValueType.getName(), stmt.getClassLoaderResolver());
        JavaTypeMapping valueTableID = valueTable.getIdMapping();
        LogicSetExpression valueTblExpr = stmt.getTableExpression(valueTableAlias);
        if (valueTblExpr == null) {
            valueTblExpr = stmt.newTableExpression(valueTable, valueTableAlias);
        }
        ScalarExpression valueMapExpr = this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        if (!parentStmt.hasCrossJoin(valueTblExpr)) {
            stmt.crossJoin(valueTblExpr, true);
        }
        if (valExpr == null) {
            valExpr = valueTableID.newScalarExpression(stmt, stmt.getTableExpression(valueTableAlias));
        }
        if (valExpr.getLogicSetExpression() != null && !valueTable.equals(valExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(valueMapExpr.eq(valExpr), true);
            return this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        ScalarExpression valueExpr = valueTableID.newScalarExpression(stmt, stmt.getTableExpression(valueTableAlias));
        stmt.andCondition(valueMapExpr.eq(valueExpr), true);
        return valueExpr;
    }
}

