/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.math.BigInteger;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.CharacterLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class IntegerLiteral
extends NumericExpression
implements Literal {
    private final Number value;
    Object rawValue;
    private StatementText stUsingParameter = new StatementText();
    private final boolean useParameter;

    public IntegerLiteral(QueryExpression qs, JavaTypeMapping mapping, Number value) {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        this.st.append(String.valueOf(value));
        this.stUsingParameter.appendParameter(mapping, value);
        this.useParameter = true;
    }

    public IntegerLiteral(QueryExpression qs, JavaTypeMapping mapping, Number value, boolean useParameter) {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        this.st.append(String.valueOf(value));
        this.stUsingParameter.appendParameter(mapping, value);
        this.useParameter = useParameter;
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, NumericExpression.class);
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) == 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, OP_EQ, literal);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, NumericExpression.class);
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) != 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(expr, OP_NOTEQ, literal);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) < 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) <= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_LTEQ, expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) > 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).compareTo(new BigInteger(((IntegerLiteral)expr).value.toString())) >= 0);
        }
        if (expr instanceof CharacterExpression) {
            CharacterLiteral literal = new CharacterLiteral(this.qs, this.mapping, String.valueOf((char)this.value.intValue()));
            return new BooleanExpression(literal, OP_GTEQ, expr);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).add(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).add(BigInteger.valueOf(v)));
        }
        return super.add(expr);
    }

    public ScalarExpression sub(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).subtract(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).subtract(BigInteger.valueOf(v)));
        }
        return super.sub(expr);
    }

    public ScalarExpression mul(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).multiply(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).multiply(BigInteger.valueOf(v)));
        }
        return super.mul(expr);
    }

    public ScalarExpression div(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).divide(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).divide(BigInteger.valueOf(v)));
        }
        return super.div(expr);
    }

    public ScalarExpression mod(ScalarExpression expr) {
        if (expr instanceof IntegerLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).mod(new BigInteger(((IntegerLiteral)expr).value.toString())));
        }
        if (expr instanceof CharacterLiteral) {
            char v = ((CharacterLiteral)expr).getValue().toString().charAt(0);
            return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).mod(BigInteger.valueOf(v)));
        }
        return super.mod(expr);
    }

    public ScalarExpression neg() {
        return new IntegerLiteral(this.qs, this.mapping, new BigInteger(this.value.toString()).negate());
    }

    public StatementText toStatementText(int mode) {
        if (mode == ScalarExpression.FILTER && this.useParameter) {
            return this.stUsingParameter;
        }
        return super.toStatementText(mode);
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }
}

