/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.MapStoreQueryable;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.types.sco.SCOUtils;

public abstract class AbstractMapStore
extends BaseContainerStore
implements MapStore,
MapStoreQueryable {
    protected boolean iterateUsingDiscriminator = false;
    protected DatastoreContainerObject mapTable;
    protected DatastoreClass valueTable;
    protected AbstractClassMetaData kmd;
    protected AbstractClassMetaData vmd;
    protected JavaTypeMapping keyMapping;
    protected JavaTypeMapping valueMapping;
    protected String keyType;
    protected String valueType;
    protected boolean keysAreEmbedded;
    protected boolean keysAreSerialised;
    protected boolean valuesAreEmbedded;
    protected boolean valuesAreSerialised;
    protected final AbstractMapStoreSpecialization specialization;

    public AbstractMapStore(StoreManager storeMgr, AbstractMapStoreSpecialization specialization) {
        super(storeMgr);
        this.specialization = specialization;
    }

    public boolean keysAreEmbedded() {
        return this.keysAreEmbedded;
    }

    public boolean keysAreSerialised() {
        return this.keysAreSerialised;
    }

    public boolean valuesAreEmbedded() {
        return this.valuesAreEmbedded;
    }

    public boolean valuesAreSerialised() {
        return this.valuesAreSerialised;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public boolean containsKey(ObjectProvider sm, Object key) {
        if (key == null) {
            return false;
        }
        try {
            this.getValue(sm, key);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean containsValue(ObjectProvider sm, Object value) {
        if (value == null) {
            return false;
        }
        if (!this.validateValueForReading(sm, value)) {
            return false;
        }
        return this.specialization.containsValue(sm, value, this);
    }

    public Object get(ObjectProvider sm, Object key) {
        try {
            return this.getValue(sm, key);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void putAll(ObjectProvider sm, Map m) {
        for (Map.Entry e : m.entrySet()) {
            this.put(sm, e.getKey(), e.getValue());
        }
    }

    protected void validateKeyType(ClassLoaderResolver clr, Object key) {
        if (key == null) {
            throw new NullPointerException(LOCALISER.msg("056062"));
        }
        if (!clr.isAssignableFrom(this.keyType, key.getClass())) {
            throw new ClassCastException(LOCALISER.msg("056064", (Object)key.getClass().getName(), (Object)this.keyType));
        }
    }

    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value != null && !clr.isAssignableFrom(this.valueType, value.getClass())) {
            throw new ClassCastException(LOCALISER.msg("056065", (Object)value.getClass().getName(), (Object)this.valueType));
        }
    }

    protected boolean validateKeyForReading(ObjectProvider sm, Object key) {
        this.validateKeyType(sm.getExecutionContext().getClassLoaderResolver(), key);
        if (!this.keysAreEmbedded && !this.keysAreSerialised) {
            ExecutionContext ec = sm.getExecutionContext();
            if (!(key == null || ec.getApiAdapter().isPersistent(key) && ec == ec.getApiAdapter().getExecutionContext(key) || ec.getApiAdapter().isDetached(key))) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateValueForReading(ObjectProvider sm, Object value) {
        this.validateValueType(sm.getExecutionContext().getClassLoaderResolver(), value);
        if (!this.valuesAreEmbedded && !this.valuesAreSerialised) {
            ExecutionContext ec = sm.getExecutionContext();
            if (!(value == null || ec.getApiAdapter().isPersistent(value) && ec == ec.getApiAdapter().getExecutionContext(value) || ec.getApiAdapter().isDetached(value))) {
                return false;
            }
        }
        return true;
    }

    protected void validateKeyForWriting(ObjectProvider sm, Object key) {
        this.validateKeyType(sm.getExecutionContext().getClassLoaderResolver(), key);
        if (!this.keysAreEmbedded && !this.keysAreSerialised) {
            ExecutionContext ec = sm.getExecutionContext();
            SCOUtils.validateObjectForWriting(ec, key, null);
        }
    }

    protected void validateValueForWriting(ObjectProvider sm, Object value) {
        this.validateValueType(sm.getExecutionContext().getClassLoaderResolver(), value);
        if (!this.valuesAreEmbedded && !this.valuesAreSerialised) {
            ExecutionContext ec = sm.getExecutionContext();
            SCOUtils.validateObjectForWriting(ec, value, null);
        }
    }

    protected abstract Object getValue(ObjectProvider var1, Object var2) throws NoSuchElementException;

    public boolean updateEmbeddedKey(ObjectProvider sm, Object key, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.keyMapping != null && this.keyMapping instanceof EmbeddedKeyPCMapping) {
            String fieldName = this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedKeyPCMapping)this.keyMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            modified = this.specialization.updatedEmbeddedKey(sm, key, fieldNumber, newValue, fieldMapping, this);
        }
        return modified;
    }

    public boolean updateEmbeddedValue(ObjectProvider sm, Object value, int fieldNumber, Object newValue) {
        boolean modified = false;
        if (this.valueMapping != null && this.valueMapping instanceof EmbeddedValuePCMapping) {
            String fieldName = this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedValuePCMapping)this.valueMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            modified = this.specialization.updateEmbeddedValue(sm, value, fieldNumber, newValue, fieldMapping, this);
        }
        return modified;
    }

    public JavaTypeMapping getValueMapping() {
        return this.valueMapping;
    }

    public JavaTypeMapping getKeyMapping() {
        return this.keyMapping;
    }

    public boolean isValuesAreEmbedded() {
        return this.valuesAreEmbedded;
    }

    public boolean isValuesAreSerialised() {
        return this.valuesAreSerialised;
    }

    public DatastoreContainerObject getMapTable() {
        return this.mapTable;
    }

    public AbstractClassMetaData getKmd() {
        return this.kmd;
    }

    public AbstractClassMetaData getVmd() {
        return this.vmd;
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInMapExpr));
        stmt.select(mapTableAlias, this.valueMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias) {
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapTableAlias, qs.getClassLoaderResolver());
        stmt.setParent(qs);
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.storeMgr.getMappingManager().getMapping(String.class);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    public ScalarExpression[] joinKeysToGet(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier mapTableAlias, Class filteredKeyType, DatastoreIdentifier keyTableAlias, DatastoreIdentifier valueTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        Class value_class = clr.classForName(this.valueType);
        return this.joinKeysValuesTo(stmt, parentStmt, ownerMapping, te, mapTableAlias, filteredKeyType, value_class, null, null, keyTableAlias, valueTableAlias);
    }
}

