/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionActiveOnBeginException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.transaction.HeuristicMixedException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.RollbackException;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionImpl
implements org.datanucleus.Transaction {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    Object key;
    protected OMFContext omfContext;
    protected StoreManager storeManager;
    Transaction tx;
    boolean active = false;
    boolean committing;
    Synchronization sync;
    protected boolean retainValues;
    protected boolean restoreValues;
    protected boolean optimistic;
    protected boolean nontransactionalRead;
    protected boolean nontransactionalWrite;
    protected boolean rollbackOnly = false;
    protected Boolean serializeRead = null;
    private Set<TransactionEventListener> listenersPerTransaction = new HashSet<TransactionEventListener>();
    private Set<TransactionEventListener> listeners = new HashSet<TransactionEventListener>();
    private Map<String, Object> options = new HashMap<String, Object>();
    long beginTime;

    public TransactionImpl(OMFContext omfContext, StoreManager storeManager, Object key) {
        this.omfContext = omfContext;
        this.storeManager = storeManager;
        this.key = key;
        PersistenceConfiguration config = omfContext.getPersistenceConfiguration();
        this.optimistic = config.getBooleanProperty("datanucleus.Optimistic");
        this.retainValues = config.getBooleanProperty("datanucleus.RetainValues");
        this.restoreValues = config.getBooleanProperty("datanucleus.RestoreValues");
        this.nontransactionalRead = config.getBooleanProperty("datanucleus.NontransactionalRead");
        this.nontransactionalWrite = config.getBooleanProperty("datanucleus.NontransactionalWrite");
        int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName(config.getStringProperty("datanucleus.transactionIsolation"));
        this.setOption("transaction.isolation", isolationLevel);
        Boolean serialiseReadProp = config.getBooleanObjectProperty("datanucleus.SerializeRead");
        if (serialiseReadProp != null) {
            this.serializeRead = serialiseReadProp;
        } else {
            Boolean rdbmsProp = config.getBooleanObjectProperty("datanucleus.rdbms.useUpdateLock");
            if (rdbmsProp != null) {
                this.serializeRead = rdbmsProp;
            }
        }
    }

    @Override
    public void begin() {
        this.omfContext.getTransactionManager().begin(this.key);
        this.tx = this.omfContext.getTransactionManager().getTransaction(this.key);
        if (this.optimistic && !this.storeManager.getSupportedOptions().contains("OptimisticTransaction")) {
            throw new NucleusUserException(LOCALISER.msg("010050"));
        }
        this.internalBegin();
    }

    protected void internalBegin() {
        TransactionEventListener[] l;
        if (this.active) {
            throw new TransactionActiveOnBeginException(this.key);
        }
        this.active = true;
        this.beginTime = System.currentTimeMillis();
        if (this.omfContext.getTransactionManager().getTransactionRuntime() != null) {
            this.omfContext.getTransactionManager().getTransactionRuntime().transactionStarted();
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015000", this.key, (Object)("" + this.optimistic)));
        }
        for (TransactionEventListener tel : l = this.listeners.toArray(new TransactionEventListener[this.listeners.size()])) {
            tel.transactionStarted();
        }
        for (TransactionEventListener tel : l = this.listenersPerTransaction.toArray(new TransactionEventListener[this.listenersPerTransaction.size()])) {
            tel.transactionStarted();
        }
    }

    @Override
    public void flush() {
        try {
            TransactionEventListener[] l;
            for (TransactionEventListener tel : l = this.listeners.toArray(new TransactionEventListener[this.listeners.size()])) {
                tel.transactionFlushed();
            }
            for (TransactionEventListener tel : l = this.listenersPerTransaction.toArray(new TransactionEventListener[this.listenersPerTransaction.size()])) {
                tel.transactionFlushed();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof NucleusException) {
                throw (NucleusException)ex;
            }
            throw new NucleusTransactionException(LOCALISER.msg("015005"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        TransactionEventListener[] l2;
        try {
            this.flush();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            TransactionEventListener[] l2;
            Object var2_2 = null;
            for (TransactionEventListener tel : l2 = this.listeners.toArray(new TransactionEventListener[this.listeners.size()])) {
                tel.transactionEnded();
            }
            for (TransactionEventListener tel : l2 = this.listenersPerTransaction.toArray(new TransactionEventListener[this.listenersPerTransaction.size()])) {
                tel.transactionEnded();
            }
            throw throwable;
        }
        for (TransactionEventListener tel : l2 = this.listeners.toArray(new TransactionEventListener[this.listeners.size()])) {
            tel.transactionEnded();
        }
        for (TransactionEventListener tel : l2 = this.listenersPerTransaction.toArray(new TransactionEventListener[this.listenersPerTransaction.size()])) {
            tel.transactionEnded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void commit() {
        ArrayList<Throwable> errors;
        long startTime;
        block38: {
            if (!this.isActive()) {
                throw new TransactionNotActiveException();
            }
            if (this.rollbackOnly) {
                if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                    NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015020"));
                }
                throw new NucleusDataStoreException(LOCALISER.msg("015020")).setFatal();
            }
            startTime = System.currentTimeMillis();
            boolean success = false;
            boolean canComplete = true;
            errors = new ArrayList<Throwable>();
            this.flush();
            this.internalPreCommit();
            this.internalCommit();
            success = true;
            Object var8_5 = null;
            if (!canComplete) break block38;
            try {
                if (!success) {
                    this.rollback();
                } else {
                    this.internalPostCommit();
                }
            }
            catch (Throwable e2) {
                errors.add(e2);
            }
            this.tx = null;
            {
                break block38;
                catch (RollbackException e) {
                    if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                        NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                    }
                    errors.add(e);
                    Object var8_6 = null;
                    if (!canComplete) break block38;
                    try {
                        if (!success) {
                            this.rollback();
                        } else {
                            this.internalPostCommit();
                        }
                    }
                    catch (Throwable e2) {
                        errors.add(e2);
                    }
                    this.tx = null;
                    break block38;
                }
                catch (HeuristicRollbackException e) {
                    if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                        NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                    }
                    errors.add(e);
                    Object var8_7 = null;
                    if (!canComplete) break block38;
                    try {
                        if (!success) {
                            this.rollback();
                        } else {
                            this.internalPostCommit();
                        }
                    }
                    catch (Throwable e2) {
                        errors.add(e2);
                    }
                    this.tx = null;
                    break block38;
                }
                catch (HeuristicMixedException e) {
                    if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                        NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                    }
                    errors.add(e);
                    Object var8_8 = null;
                    if (!canComplete) break block38;
                    try {
                        if (!success) {
                            this.rollback();
                        } else {
                            this.internalPostCommit();
                        }
                    }
                    catch (Throwable e2) {
                        errors.add(e2);
                    }
                    this.tx = null;
                    break block38;
                }
                catch (NucleusUserException e) {
                    if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                        NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                    }
                    canComplete = false;
                    throw e;
                }
                catch (NucleusException e) {
                    if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                        NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                    }
                    errors.add(e);
                    Object var8_9 = null;
                    if (!canComplete) break block38;
                    try {
                        if (!success) {
                            this.rollback();
                        } else {
                            this.internalPostCommit();
                        }
                    }
                    catch (Throwable e2) {
                        errors.add(e2);
                    }
                    this.tx = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (canComplete) {
                    try {
                        if (!success) {
                            this.rollback();
                        } else {
                            this.internalPostCommit();
                        }
                    }
                    catch (Throwable e2) {
                        errors.add(e2);
                    }
                    this.tx = null;
                }
                throw throwable;
            }
        }
        if (errors.size() > 0) {
            throw new NucleusTransactionException(LOCALISER.msg("015007"), errors.toArray(new Throwable[errors.size()]));
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015022", System.currentTimeMillis() - startTime));
        }
    }

    protected void internalPreCommit() {
        TransactionEventListener[] l;
        this.committing = true;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015001", this.key));
        }
        if (this.sync != null) {
            this.sync.beforeCompletion();
        }
        for (TransactionEventListener tel : l = this.listeners.toArray(new TransactionEventListener[this.listeners.size()])) {
            tel.transactionPreCommit();
        }
        for (TransactionEventListener tel : l = this.listenersPerTransaction.toArray(new TransactionEventListener[this.listenersPerTransaction.size()])) {
            tel.transactionPreCommit();
        }
    }

    protected void internalCommit() {
        this.omfContext.getTransactionManager().commit(this.key);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void rollback() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void internalPreRollback() {
        TransactionEventListener[] l;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015002", this.key));
        }
        for (TransactionEventListener tel : l = this.listeners.toArray(new TransactionEventListener[this.listeners.size()])) {
            tel.transactionPreRollBack();
        }
        for (TransactionEventListener tel : l = this.listenersPerTransaction.toArray(new TransactionEventListener[this.listenersPerTransaction.size()])) {
            tel.transactionPreRollBack();
        }
    }

    protected void internalRollback() {
        TransactionEventListener[] l;
        Transaction tx = this.omfContext.getTransactionManager().getTransaction(this.key);
        if (tx != null) {
            this.omfContext.getTransactionManager().rollback(this.key);
        }
        for (TransactionEventListener tel : l = this.listeners.toArray(new TransactionEventListener[this.listeners.size()])) {
            tel.transactionRolledBack();
        }
        for (TransactionEventListener tel : l = this.listenersPerTransaction.toArray(new TransactionEventListener[this.listenersPerTransaction.size()])) {
            tel.transactionRolledBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void internalPostCommit() {
        this.active = false;
        if (this.omfContext.getTransactionManager().getTransactionRuntime() != null) {
            this.omfContext.getTransactionManager().getTransactionRuntime().transactionCommitted(System.currentTimeMillis() - this.beginTime);
        }
        Object var2_1 = null;
        try {
            TransactionEventListener[] l;
            for (TransactionEventListener tel : l = this.listeners.toArray(new TransactionEventListener[this.listeners.size()])) {
                tel.transactionCommitted();
            }
            for (TransactionEventListener tel : l = this.listenersPerTransaction.toArray(new TransactionEventListener[this.listenersPerTransaction.size()])) {
                tel.transactionCommitted();
            }
            Object var9_13 = null;
            this.committing = false;
            this.listenersPerTransaction.clear();
            if (this.sync == null) return;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.committing = false;
            this.listenersPerTransaction.clear();
            if (this.sync == null) throw throwable;
            this.sync.afterCompletion(3);
            throw throwable;
        }
        this.sync.afterCompletion(3);
        return;
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                TransactionEventListener[] l;
                for (TransactionEventListener tel : l = this.listeners.toArray(new TransactionEventListener[this.listeners.size()])) {
                    tel.transactionCommitted();
                }
                for (TransactionEventListener tel : l = this.listenersPerTransaction.toArray(new TransactionEventListener[this.listenersPerTransaction.size()])) {
                    tel.transactionCommitted();
                }
                Object var9_15 = null;
                this.committing = false;
                this.listenersPerTransaction.clear();
                if (this.sync == null) throw throwable;
            }
            catch (Throwable throwable2) {
                Object var9_16 = null;
                this.committing = false;
                this.listenersPerTransaction.clear();
                if (this.sync == null) throw throwable2;
                this.sync.afterCompletion(3);
                throw throwable2;
            }
            this.sync.afterCompletion(3);
            {
                throw throwable;
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isCommitting() {
        return this.committing;
    }

    @Override
    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    @Override
    public boolean getOptimistic() {
        return this.optimistic;
    }

    @Override
    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    @Override
    public boolean getRetainValues() {
        return this.retainValues;
    }

    @Override
    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public Synchronization getSynchronization() {
        return this.sync;
    }

    @Override
    public void setNontransactionalRead(boolean nontransactionalRead) {
        this.nontransactionalRead = nontransactionalRead;
    }

    @Override
    public synchronized void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.nontransactionalWrite = nontransactionalWrite;
    }

    @Override
    public synchronized void setOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    @Override
    public synchronized void setRestoreValues(boolean restoreValues) {
        this.restoreValues = restoreValues;
    }

    @Override
    public synchronized void setRetainValues(boolean retainValues) {
        this.retainValues = retainValues;
        if (retainValues) {
            this.nontransactionalRead = true;
        }
    }

    @Override
    public void setRollbackOnly() {
        if (this.active) {
            this.rollbackOnly = true;
        }
    }

    @Override
    public synchronized void setSynchronization(Synchronization sync) {
        this.sync = sync;
    }

    @Override
    public void addTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.add(listener);
    }

    @Override
    public void bindTransactionEventListener(TransactionEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.remove(listener);
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public Boolean getSerializeRead() {
        return this.serializeRead;
    }

    @Override
    public void setSerializeRead(Boolean serializeRead) {
        this.serializeRead = serializeRead;
    }

    @Override
    public boolean lockReadObjects() {
        return this.serializeRead != null ? this.serializeRead : false;
    }

    @Override
    public void setOption(String option, int value) {
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, boolean value) {
        this.options.put(option, new Boolean(value));
    }

    @Override
    public void setOption(String option, String value) {
        this.options.put(option, value);
    }
}

