/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.lang.reflect.Method;
import java.math.BigInteger;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class EnumMapping
extends SingleFieldMapping {
    protected static final String ENUM_VALUE_GETTER = "enum-value-getter";
    protected static final String ENUM_GETTER_BY_VALUE = "enum-getter-by-value";
    protected String datastoreJavaType = ClassNameConstants.JAVA_LANG_STRING;

    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        ColumnMetaData[] colmds;
        if (fmd != null && fmd.isSerialized()) {
            this.datastoreJavaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
        } else if (fmd != null && (colmds = EnumMapping.getColumnMetaDataForMember(fmd, this.roleForMember)) != null && MetaDataUtils.isJdbcTypeNumeric(colmds[0].getJdbcType())) {
            this.datastoreJavaType = ClassNameConstants.JAVA_LANG_INTEGER;
        }
        super.initialize(fmd, container, clr);
    }

    public Object[] getValidValues(int index) {
        if (this.mmd != null && this.mmd.getColumnMetaData() != null && this.mmd.getColumnMetaData().length > 0 && this.mmd.getColumnMetaData()[0].hasExtension("enum-check-constraint") && this.mmd.getColumnMetaData()[0].getValueForExtension("enum-check-constraint").equalsIgnoreCase("true")) {
            try {
                Enum[] values = (Enum[])this.mmd.getType().getMethod("values", null).invoke((Object)null, (Object[])null);
                if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
                    Object[] valueStrings = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        valueStrings[i] = values[i].toString();
                    }
                    return valueStrings;
                }
                Object[] valueInts = new Integer[values.length];
                for (int i = 0; i < values.length; ++i) {
                    valueInts[i] = values[i].ordinal();
                }
                return valueInts;
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.warn(StringUtils.getStringFromStackTrace(e));
            }
        }
        return super.getValidValues(index);
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        return this.datastoreJavaType;
    }

    public Class getJavaType() {
        return Enum.class;
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        if (value == null) {
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], null);
        } else if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            if (value instanceof Enum) {
                String getterMethodName;
                Long longVal;
                int intVal = ((Enum)value).ordinal();
                String methodName = null;
                if (this.roleForMember == 2) {
                    if (this.mmd != null && this.mmd.hasExtension(ENUM_VALUE_GETTER)) {
                        methodName = this.mmd.getValueForExtension(ENUM_VALUE_GETTER);
                    }
                } else if (this.roleForMember == 3 || this.roleForMember == 4) {
                    if (this.mmd != null && this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().hasExtension(ENUM_VALUE_GETTER)) {
                        methodName = this.mmd.getElementMetaData().getValueForExtension(ENUM_VALUE_GETTER);
                    }
                } else if (this.roleForMember == 5) {
                    if (this.mmd != null && this.mmd.getKeyMetaData() != null && this.mmd.getKeyMetaData().hasExtension(ENUM_VALUE_GETTER)) {
                        methodName = this.mmd.getKeyMetaData().getValueForExtension(ENUM_VALUE_GETTER);
                    }
                } else if (this.roleForMember == 6 && this.mmd != null && this.mmd.getValueMetaData() != null && this.mmd.getValueMetaData().hasExtension(ENUM_VALUE_GETTER)) {
                    methodName = this.mmd.getValueMetaData().getValueForExtension(ENUM_VALUE_GETTER);
                }
                if (methodName != null && (longVal = this.getValueForEnumUsingMethod((Enum)value, getterMethodName = this.mmd.getValueForExtension(ENUM_VALUE_GETTER))) != null) {
                    intVal = longVal.intValue();
                }
                this.getDatastoreMapping(0).setInt(preparedStatement, exprIndex[0], intVal);
            } else if (value instanceof BigInteger) {
                this.getDatastoreMapping(0).setInt(preparedStatement, exprIndex[0], ((BigInteger)value).intValue());
            }
        } else if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String stringVal = value instanceof String ? (String)value : ((Enum)value).name();
            this.getDatastoreMapping(0).setString(preparedStatement, exprIndex[0], stringVal);
        } else {
            super.setObject(ec, preparedStatement, exprIndex, value);
        }
    }

    protected Long getValueForEnumUsingMethod(Enum value, String methodName) {
        try {
            Method getterMethod = ClassUtils.getMethodForClass(value.getClass(), methodName, null);
            Number num = (Number)getterMethod.invoke((Object)value, null);
            return new Long(num.longValue());
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.warn("Specified enum value-getter for method " + methodName + " on field " + this.mmd.getFullFieldName() + " gave an error on extracting the value : " + e.getMessage());
            return null;
        }
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            long longVal = this.getDatastoreMapping(0).getLong(resultSet, exprIndex[0]);
            Class enumType = null;
            if (this.mmd == null) {
                enumType = ec.getClassLoaderResolver().classForName(this.type);
            } else {
                enumType = this.mmd.getType();
                if (this.roleForMember == 2 && this.mmd != null && this.mmd.hasExtension(ENUM_GETTER_BY_VALUE)) {
                    String getterMethodName = this.mmd.getValueForExtension(ENUM_GETTER_BY_VALUE);
                    return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                }
                if (this.roleForMember == 3) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getCollection().getElementType());
                    if (this.mmd != null && this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().hasExtension(ENUM_GETTER_BY_VALUE)) {
                        String getterMethodName = this.mmd.getElementMetaData().getValueForExtension(ENUM_GETTER_BY_VALUE);
                        return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                    }
                } else if (this.roleForMember == 4) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getArray().getElementType());
                    if (this.mmd != null && this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().hasExtension(ENUM_GETTER_BY_VALUE)) {
                        String getterMethodName = this.mmd.getElementMetaData().getValueForExtension(ENUM_GETTER_BY_VALUE);
                        return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                    }
                } else if (this.roleForMember == 5) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getMap().getKeyType());
                    if (this.mmd != null && this.mmd.getKeyMetaData() != null && this.mmd.getKeyMetaData().hasExtension(ENUM_GETTER_BY_VALUE)) {
                        String getterMethodName = this.mmd.getKeyMetaData().getValueForExtension(ENUM_GETTER_BY_VALUE);
                        return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                    }
                } else if (this.roleForMember == 6) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getMap().getValueType());
                    if (this.mmd != null && this.mmd.getValueMetaData() != null && this.mmd.getValueMetaData().hasExtension(ENUM_GETTER_BY_VALUE)) {
                        String getterMethodName = this.mmd.getValueMetaData().getValueForExtension(ENUM_GETTER_BY_VALUE);
                        return this.getEnumValueForMethod(enumType, longVal, getterMethodName);
                    }
                }
            }
            return enumType.getEnumConstants()[(int)longVal];
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            String stringVal = this.getDatastoreMapping(0).getString(resultSet, exprIndex[0]);
            Class enumType = null;
            if (this.mmd == null) {
                enumType = ec.getClassLoaderResolver().classForName(this.type);
            } else {
                enumType = this.mmd.getType();
                if (this.roleForMember == 3) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getCollection().getElementType());
                } else if (this.roleForMember == 4) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getArray().getElementType());
                } else if (this.roleForMember == 5) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getMap().getKeyType());
                } else if (this.roleForMember == 6) {
                    enumType = ec.getClassLoaderResolver().classForName(this.mmd.getMap().getValueType());
                }
            }
            return Enum.valueOf(enumType, stringVal);
        }
        return super.getObject(ec, resultSet, exprIndex);
    }

    protected Object getEnumValueForMethod(Class enumType, long val, String methodName) {
        try {
            Method getterMethod = ClassUtils.getMethodForClass(enumType, methodName, new Class[]{Short.TYPE});
            return getterMethod.invoke(null, (short)val);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.warn("Specified enum getter-by-value for field " + this.mmd.getFullFieldName() + " gave an error on extracting the enum so just using the ordinal : " + e.getMessage());
            try {
                Method getterMethod = ClassUtils.getMethodForClass(enumType, methodName, new Class[]{Integer.TYPE});
                return getterMethod.invoke(null, (int)val);
            }
            catch (Exception e2) {
                NucleusLogger.PERSISTENCE.warn("Specified enum getter-by-value for field " + this.mmd.getFullFieldName() + " gave an error on extracting the enum so just using the ordinal : " + e2.getMessage());
                return null;
            }
        }
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        throw new UnsupportedOperationException();
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            IntegerLiteral expr = new IntegerLiteral(qs, (JavaTypeMapping)this, BigInteger.valueOf(((Enum)value).ordinal()));
            ((Literal)expr).setRawValue(value);
            return expr;
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            StringLiteral expr = new StringLiteral(qs, (JavaTypeMapping)this, ((Enum)value).name());
            ((Literal)expr).setRawValue(value);
            return expr;
        }
        return null;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
            return new NumericExpression(qs, this, te);
        }
        if (this.datastoreJavaType.equals(ClassNameConstants.JAVA_LANG_STRING)) {
            return new StringExpression(qs, this, te);
        }
        return null;
    }
}

