/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.Iterator;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.EmbeddedElementPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.query.ResultObjectFactory;

public abstract class ArrayStoreIterator
implements Iterator {
    private final ExecutionContext ec;
    private final Iterator delegate;
    private Object lastElement = null;

    public ArrayStoreIterator(ObjectProvider sm, Object rs, ResultObjectFactory rof, ElementContainerStore backingStore) throws MappedDatastoreException {
        this.ec = sm.getExecutionContext();
        ArrayList<Object> results = new ArrayList<Object>();
        if (rs != null) {
            JavaTypeMapping elementMapping = backingStore.getElementMapping();
            while (this.next(rs)) {
                Object nextElement;
                int i;
                int[] param;
                if (backingStore.isElementsAreEmbedded() || backingStore.isElementsAreSerialised()) {
                    param = new int[elementMapping.getNumberOfDatastoreMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    if (elementMapping instanceof SerialisedPCMapping || elementMapping instanceof SerialisedReferenceMapping || elementMapping instanceof EmbeddedElementPCMapping) {
                        int ownerFieldNumber = -1;
                        if (backingStore.getContainerTable() != null) {
                            ownerFieldNumber = this.getOwnerFieldMetaData(backingStore.getContainerTable()).getAbsoluteFieldNumber();
                        }
                        nextElement = elementMapping.getObject(this.ec, rs, param, sm, ownerFieldNumber);
                    } else {
                        nextElement = elementMapping.getObject(this.ec, rs, param);
                    }
                } else if (elementMapping instanceof ReferenceMapping) {
                    param = new int[elementMapping.getNumberOfDatastoreMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    nextElement = elementMapping.getObject(this.ec, rs, param);
                } else {
                    nextElement = rof.getObject(this.ec, rs);
                }
                results.add(nextElement);
            }
        }
        this.delegate = results.iterator();
    }

    protected abstract AbstractMemberMetaData getOwnerFieldMetaData(DatastoreContainerObject var1);

    protected abstract boolean next(Object var1) throws MappedDatastoreException;

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        this.lastElement = this.delegate.next();
        return this.lastElement;
    }

    public synchronized void remove() {
    }
}

