/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query;

import java.util.StringTokenizer;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.JPQLQueryHelper;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SQLSingleStringParser {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private Query query;
    private String queryString;
    int keywordPosition = -1;

    public SQLSingleStringParser(Query query, String queryString) {
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(LOCALISER.msg("043000", (Object)queryString));
        }
        this.query = query;
        this.queryString = queryString;
    }

    public void parse() {
        new Compiler(new Parser(this.queryString)).compile();
    }

    private class Parser {
        final String queryString;
        int queryStringPos = 0;
        final String[] tokens;
        final String[] keywords;
        int tokenIndex = -1;

        public Parser(String str) {
            this.queryString = str;
            StringTokenizer tokenizer = new StringTokenizer(str);
            this.tokens = new String[tokenizer.countTokens()];
            this.keywords = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.tokens[i++] = tokenizer.nextToken();
            }
            for (i = 0; i < this.tokens.length; ++i) {
                if (JPQLQueryHelper.isKeyword(this.tokens[i])) {
                    this.keywords[i] = this.tokens[i];
                    continue;
                }
                if (i >= this.tokens.length - 1 || !JPQLQueryHelper.isKeyword(this.tokens[i] + ' ' + this.tokens[i + 1])) continue;
                this.keywords[i] = this.tokens[i];
                this.keywords[++i] = this.tokens[i];
            }
        }

        public String parseContent(String keywordToIgnore, boolean allowSubentries) {
            String content = "";
            int level = 0;
            while (this.tokenIndex < this.tokens.length - 1) {
                ++this.tokenIndex;
                if (allowSubentries) {
                    for (int i = 0; i < this.tokens[this.tokenIndex].length(); ++i) {
                        char c = this.tokens[this.tokenIndex].charAt(i);
                        if (c == '(') {
                            ++level;
                            continue;
                        }
                        if (c != ')') continue;
                        --level;
                    }
                }
                if (level == 0 && JPQLQueryHelper.isKeyword(this.tokens[this.tokenIndex]) && !this.tokens[this.tokenIndex].equals(keywordToIgnore)) {
                    --this.tokenIndex;
                    break;
                }
                if (level == 0 && this.tokenIndex < this.tokens.length - 1 && JPQLQueryHelper.isKeyword(this.tokens[this.tokenIndex] + ' ' + this.tokens[this.tokenIndex + 1])) {
                    --this.tokenIndex;
                    break;
                }
                int endPos = this.queryString.indexOf(this.tokens[this.tokenIndex], this.queryStringPos) + this.tokens[this.tokenIndex].length();
                String contentValue = this.queryString.substring(this.queryStringPos, endPos);
                this.queryStringPos = endPos;
                if (content.length() == 0) {
                    content = contentValue;
                    continue;
                }
                content = content + contentValue;
            }
            return content;
        }

        public boolean parseKeywordIgnoreCase(String keyword) {
            if (this.tokenIndex < this.tokens.length - 1) {
                ++this.tokenIndex;
                if (this.keywords[this.tokenIndex] != null) {
                    if (this.keywords[this.tokenIndex].equalsIgnoreCase(keyword)) {
                        this.queryStringPos = this.queryString.indexOf(this.keywords[this.tokenIndex], this.queryStringPos) + this.keywords[this.tokenIndex].length() + 1;
                        return true;
                    }
                    if (keyword.indexOf(32) > -1 && (this.keywords[this.tokenIndex] + ' ' + this.keywords[this.tokenIndex + 1]).equalsIgnoreCase(keyword)) {
                        this.queryStringPos = this.queryString.indexOf(this.keywords[this.tokenIndex], this.queryStringPos) + this.keywords[this.tokenIndex].length() + 1;
                        this.queryStringPos = this.queryString.indexOf(this.keywords[this.tokenIndex + 1], this.queryStringPos) + this.keywords[this.tokenIndex + 1].length() + 1;
                        ++this.tokenIndex;
                        return true;
                    }
                }
                --this.tokenIndex;
            }
            return false;
        }

        public String parseKeyword() {
            if (this.tokenIndex < this.tokens.length - 1) {
                ++this.tokenIndex;
                if (this.keywords[this.tokenIndex] != null) {
                    return this.keywords[this.tokenIndex];
                }
                --this.tokenIndex;
            }
            return null;
        }
    }

    private class Compiler {
        Parser tokenizer;

        Compiler(Parser tokenizer) {
            this.tokenizer = tokenizer;
        }

        private void compile() {
            this.compileQuery();
            String keyword = this.tokenizer.parseKeyword();
            if (keyword != null && JPQLQueryHelper.isKeyword(keyword)) {
                throw new NucleusUserException(LOCALISER.msg("043001", (Object)keyword));
            }
        }

        private void compileQuery() {
            boolean update = false;
            boolean delete = false;
            if (!this.tokenizer.parseKeywordIgnoreCase("SELECT")) {
                if (this.tokenizer.parseKeywordIgnoreCase("UPDATE")) {
                    update = true;
                    SQLSingleStringParser.this.query.setType((short)1);
                } else if (this.tokenizer.parseKeywordIgnoreCase("DELETE")) {
                    delete = true;
                    SQLSingleStringParser.this.query.setType((short)2);
                } else {
                    throw new NucleusUserException(LOCALISER.msg("043002"));
                }
            }
            if (update) {
                this.compileUpdate();
            } else if (!delete) {
                this.compileResult();
            }
            if (this.tokenizer.parseKeywordIgnoreCase("FROM")) {
                this.compileFrom();
            }
            if (this.tokenizer.parseKeywordIgnoreCase("WHERE")) {
                this.compileWhere();
            }
            if (this.tokenizer.parseKeywordIgnoreCase("GROUP BY")) {
                if (update || delete) {
                    throw new NucleusUserException(LOCALISER.msg("043007"));
                }
                this.compileGroup();
            }
            if (this.tokenizer.parseKeywordIgnoreCase("HAVING")) {
                if (update || delete) {
                    throw new NucleusUserException(LOCALISER.msg("043008"));
                }
                this.compileHaving();
            }
            if (this.tokenizer.parseKeywordIgnoreCase("ORDER BY")) {
                if (update || delete) {
                    throw new NucleusUserException(LOCALISER.msg("043009"));
                }
                this.compileOrder();
            }
        }

        private void compileResult() {
            String content = this.tokenizer.parseContent(null, false);
            if (content.length() > 0) {
                SQLSingleStringParser.this.query.setResult(content);
            }
        }

        private void compileUpdate() {
            String content = this.tokenizer.parseContent(null, false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("043010"));
            }
            String contentUpper = content.toUpperCase();
            int setIndex = contentUpper.indexOf("SET");
            if (setIndex < 0) {
                throw new NucleusUserException(LOCALISER.msg("043011"));
            }
            SQLSingleStringParser.this.query.setFrom(content.substring(0, setIndex).trim());
            SQLSingleStringParser.this.query.setUpdate(content.substring(setIndex + 3).trim());
        }

        private void compileFrom() {
            String content = this.tokenizer.parseContent(null, false);
            if (content.length() > 0) {
                SQLSingleStringParser.this.query.setFrom(content);
            }
        }

        private void compileWhere() {
            String content = this.tokenizer.parseContent("FROM", true);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("043004", (Object)"WHERE", (Object)"<filter>"));
            }
            String contentUpper = content.toUpperCase();
            if (contentUpper.indexOf("SELECT") > 0) {
                StringBuffer contentStr = new StringBuffer(content);
                boolean parsed = false;
                int currentPosition = 0;
                int subqueryNum = 1;
                block0: while (!parsed) {
                    contentUpper = contentStr.toString().toUpperCase();
                    int selectPos = contentUpper.indexOf("SELECT", currentPosition);
                    if (selectPos < 0) {
                        parsed = true;
                        break;
                    }
                    int startPosition = currentPosition = selectPos;
                    for (int i = currentPosition - 1; i >= 0; --i) {
                        if (contentStr.charAt(i) != '(') continue;
                        startPosition = i;
                        break;
                    }
                    int level = 0;
                    for (int i = currentPosition; i < content.length(); ++i) {
                        if (contentStr.charAt(i) == '(') {
                            ++level;
                        } else if (contentStr.charAt(i) == ')') {
                            --level;
                        }
                        if (level != -1) continue;
                        String subqueryString = contentStr.substring(currentPosition, i);
                        String subqueryVarName = "DATANUCLEUS_SUBQUERY_" + subqueryNum;
                        Query subquery = (Query)ClassUtils.newInstance(SQLSingleStringParser.this.query.getClass(), new Class[]{ExecutionContext.class, String.class}, new Object[]{SQLSingleStringParser.this.query.getObjectManager(), subqueryString});
                        SQLSingleStringParser.this.query.addSubquery(subquery, "double " + subqueryVarName, null, null);
                        contentStr.replace(startPosition, i + 1, " " + subqueryVarName + " ");
                        ++subqueryNum;
                        continue block0;
                    }
                }
                SQLSingleStringParser.this.query.setFilter(contentStr.toString());
            } else {
                SQLSingleStringParser.this.query.setFilter(content);
            }
        }

        private void compileGroup() {
            String content = this.tokenizer.parseContent(null, false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("043004", (Object)"GROUP BY", (Object)"<grouping>"));
            }
            SQLSingleStringParser.this.query.setGrouping(content);
        }

        private void compileHaving() {
            String content = this.tokenizer.parseContent("FROM", true);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("043004", (Object)"HAVING", (Object)"<having>"));
            }
            SQLSingleStringParser.this.query.setHaving(content);
        }

        private void compileOrder() {
            String content = this.tokenizer.parseContent(null, false);
            if (content.length() == 0) {
                throw new NucleusUserException(LOCALISER.msg("043004", (Object)"ORDER BY", (Object)"<ordering>"));
            }
            SQLSingleStringParser.this.query.setOrdering(content);
        }
    }
}

