/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.ImplementsMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class ClassMetaData
extends AbstractClassMetaData {
    protected List<ImplementsMetaData> implementations = new ArrayList<ImplementsMetaData>();
    protected ImplementsMetaData[] implementsMetaData;
    protected boolean isAbstract;

    public ClassMetaData(PackageMetaData parent, String name) {
        super(parent, name);
    }

    public ClassMetaData(InterfaceMetaData imd, String implClassName, boolean copyFields) {
        super(imd, implClassName, copyFields);
    }

    public ClassMetaData(ClassMetaData cmd, String implClassName) {
        super(cmd, implClassName);
    }

    public synchronized void populate(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr) {
        if (this.isInitialised() || this.isPopulated()) {
            NucleusLogger.METADATA.error(LOCALISER.msg("044068", (Object)this.name));
            throw new NucleusException(LOCALISER.msg("044068", (Object)this.fullName)).setFatal();
        }
        if (this.populating) {
            return;
        }
        try {
            try {
                if (NucleusLogger.METADATA.isDebugEnabled()) {
                    NucleusLogger.METADATA.debug(LOCALISER.msg("044075", (Object)this.fullName));
                }
                this.populating = true;
                Class cls = this.loadClass(clr, primary, mmgr);
                this.isAbstract = Modifier.isAbstract(cls.getModifiers());
                if (!this.isMetaDataComplete()) {
                    mmgr.addAnnotationsDataToClass(cls, this, clr);
                }
                mmgr.addORMDataToClass(cls, clr);
                if (ClassUtils.isInnerClass(this.fullName) && !Modifier.isStatic(cls.getModifiers()) && this.persistenceModifier == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                    throw new InvalidMetaDataException(LOCALISER, "044063", (Object)this.fullName);
                }
                if (this.entityName == null) {
                    this.entityName = this.name;
                }
                this.determineSuperClassName(clr, cls, mmgr);
                this.inheritIdentity();
                this.determineIdentity();
                this.validateUserInputForIdentity();
                this.addMetaDataForMembersNotInMetaData(cls, mmgr);
                if (this.objectidClass == null) {
                    this.populateMemberMetaData(clr, cls, true, primary, mmgr);
                    this.determineObjectIdClass(mmgr);
                    this.populateMemberMetaData(clr, cls, false, primary, mmgr);
                } else {
                    this.populateMemberMetaData(clr, cls, true, primary, mmgr);
                    this.populateMemberMetaData(clr, cls, false, primary, mmgr);
                    this.determineObjectIdClass(mmgr);
                }
                this.validateUserInputForInheritanceMetaData();
                this.determineInheritanceMetaData(mmgr);
                this.applyDefaultDiscriminatorValueWhenNotSpecified();
                this.validateUnmappedColumns();
                for (int i = 0; i < this.implementations.size(); ++i) {
                    this.implementations.get(i).populate(clr, primary, mmgr);
                }
                if (this.persistentInterfaceImplNeedingTableFromSuperclass) {
                    AbstractClassMetaData acmd = this.getMetaDataForSuperinterfaceManagingTable(cls, clr, mmgr);
                    if (acmd != null) {
                        this.table = acmd.table;
                        this.schema = acmd.schema;
                        this.catalog = acmd.catalog;
                    }
                    this.persistentInterfaceImplNeedingTableFromSuperclass = false;
                } else if (this.persistentInterfaceImplNeedingTableFromSubclass) {
                    this.persistentInterfaceImplNeedingTableFromSubclass = false;
                }
                this.setPopulated();
            }
            catch (RuntimeException e) {
                NucleusLogger.METADATA.debug(e);
                throw e;
            }
            Object var7_8 = null;
            this.populating = false;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.populating = false;
            throw throwable;
        }
    }

    private AbstractClassMetaData getMetaDataForSuperinterfaceManagingTable(Class cls, ClassLoaderResolver clr, MetaDataManager mmgr) {
        for (Class<?> superintf : ClassUtils.getSuperinterfaces(cls)) {
            InterfaceMetaData acmd = mmgr.getMetaDataForInterface(superintf, clr);
            if (acmd == null || acmd.getInheritanceMetaData() == null) continue;
            if (acmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE) {
                return acmd;
            }
            if (acmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) continue;
            return this.getMetaDataForSuperinterfaceManagingTable(superintf, clr, mmgr);
        }
        return null;
    }

    protected void addMetaDataForMembersNotInMetaData(Class cls, MetaDataManager mmgr) {
        String api = mmgr.getOMFContext().getApi();
        Collections.sort(this.members);
        try {
            int i;
            boolean hasProperties = false;
            for (int i2 = 0; i2 < this.members.size(); ++i2) {
                if (!(this.members.get(i2) instanceof PropertyMetaData)) continue;
                hasProperties = true;
                break;
            }
            if (hasProperties && api.equalsIgnoreCase("JPA")) {
                Method[] clsMethods = cls.getDeclaredMethods();
                for (i = 0; i < clsMethods.length; ++i) {
                    String propertyName;
                    if (!clsMethods[i].getDeclaringClass().getName().equals(this.fullName) || clsMethods[i].getName().startsWith("jdo") || !clsMethods[i].getName().startsWith("get") && !clsMethods[i].getName().startsWith("is") || ClassUtils.isInnerClass(clsMethods[i].getName()) || Modifier.isStatic(clsMethods[i].getModifiers()) || Collections.binarySearch(this.members, propertyName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName())) >= 0) continue;
                    NucleusLogger.METADATA.debug(LOCALISER.msg("044060", (Object)propertyName, (Object)this.name));
                    PropertyMetaData mmd = new PropertyMetaData((MetaData)this, propertyName);
                    this.members.add(mmd);
                    Collections.sort(this.members);
                }
            }
            Field[] clsFields = cls.getDeclaredFields();
            for (i = 0; i < clsFields.length; ++i) {
                FieldMetaData mmd;
                if (!clsFields[i].getDeclaringClass().getName().equals(this.fullName) || clsFields[i].getName().startsWith("jdo") || ClassUtils.isInnerClass(clsFields[i].getName()) || Modifier.isStatic(clsFields[i].getModifiers()) || Collections.binarySearch(this.members, clsFields[i].getName()) >= 0) continue;
                if (hasProperties && api.equalsIgnoreCase("JPA")) {
                    mmd = new FieldMetaData((MetaData)this, clsFields[i].getName());
                    mmd.setNotPersistent();
                    this.members.add(mmd);
                    Collections.sort(this.members);
                    continue;
                }
                NucleusLogger.METADATA.debug(LOCALISER.msg("044060", (Object)clsFields[i].getName(), (Object)this.name));
                mmd = new FieldMetaData((MetaData)this, clsFields[i].getName());
                this.members.add(mmd);
                Collections.sort(this.members);
            }
        }
        catch (Exception e) {
            NucleusLogger.METADATA.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void populateMemberMetaData(ClassLoaderResolver clr, Class cls, boolean pkMembers, ClassLoader primary, MetaDataManager mmgr) {
        Collections.sort(this.members);
        for (AbstractMemberMetaData mmd : this.members) {
            if (pkMembers != mmd.isPrimaryKey()) continue;
            Class fieldCls = cls;
            if (mmd.className != null && mmd.className.equals("#UNKNOWN")) {
                if (this.pcSuperclassMetaData != null) {
                    AbstractMemberMetaData superFmd = this.pcSuperclassMetaData.getMetaDataForMember(mmd.getName());
                    if (superFmd != null) {
                        mmd.className = superFmd.className != null ? superFmd.className : superFmd.getClassName();
                    }
                } else {
                    mmd.className = null;
                }
            }
            if (!mmd.fieldBelongsToClass()) {
                try {
                    fieldCls = clr.classForName(mmd.getClassName());
                }
                catch (ClassNotResolvedException cnre) {
                    String fieldClassName = this.getPackageName() + "." + mmd.getClassName();
                    try {
                        fieldCls = clr.classForName(fieldClassName);
                        mmd.setClassName(fieldClassName);
                    }
                    catch (ClassNotResolvedException cnre2) {
                        NucleusLogger.METADATA.error(LOCALISER.msg("044080", (Object)fieldClassName));
                        throw new InvalidMetaDataException(LOCALISER, "044080", (Object)fieldClassName);
                    }
                }
            }
            boolean populated = false;
            if (mmd instanceof PropertyMetaData) {
                Method getMethod = null;
                try {
                    getMethod = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(mmd.getName(), false), new Class[0]);
                }
                catch (Exception e) {
                    try {
                        getMethod = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(mmd.getName(), true), new Class[0]);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (getMethod == null && mmd.getPersistenceModifier() != FieldPersistenceModifier.NONE) {
                    throw new InvalidMetaDataException(LOCALISER, "044073", (Object)this.fullName, mmd.getName());
                }
                Method setMethod = null;
                try {
                    String setterName = ClassUtils.getJavaBeanSetterName(mmd.getName());
                    Method[] methods = fieldCls.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals(setterName) || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 1) continue;
                        setMethod = methods[i];
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (setMethod == null && mmd.getPersistenceModifier() != FieldPersistenceModifier.NONE) {
                    throw new InvalidMetaDataException(LOCALISER, "044074", (Object)this.fullName, mmd.getName());
                }
                if (getMethod != null) {
                    mmd.populate(clr, null, getMethod, primary, mmgr);
                    populated = true;
                }
            }
            if (!populated) {
                Field cls_field = null;
                try {
                    cls_field = fieldCls.getDeclaredField(mmd.getName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (cls_field != null) {
                    mmd.populate(clr, cls_field, null, primary, mmgr);
                    populated = true;
                }
            }
            if (populated) continue;
            throw new InvalidMetaDataException(LOCALISER, "044071", (Object)this.fullName, mmd.getFullFieldName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialise(ClassLoaderResolver clr, MetaDataManager mmgr) {
        if (this.initialising || this.isInitialised()) {
            return;
        }
        this.checkPopulated();
        try {
            int i;
            this.initialising = true;
            if (this.pcSuperclassMetaData != null && !this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.initialise(clr, mmgr);
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(LOCALISER.msg("044076", (Object)this.fullName));
            }
            this.validateObjectIdClass(clr, mmgr);
            Iterator membersIter = this.members.iterator();
            int numManaged = 0;
            int numOverridden = 0;
            while (membersIter.hasNext()) {
                AbstractMemberMetaData mmd = (AbstractMemberMetaData)membersIter.next();
                mmd.initialise(clr, mmgr);
                if (!mmd.isJdoField()) continue;
                if (mmd.fieldBelongsToClass()) {
                    ++numManaged;
                    continue;
                }
                ++numOverridden;
            }
            this.managedMembers = new AbstractMemberMetaData[numManaged];
            this.overriddenMembers = new AbstractMemberMetaData[numOverridden];
            membersIter = this.members.iterator();
            int field_id = 0;
            int overridden_field_id = 0;
            this.memberPositionsByName = new HashMap();
            while (membersIter.hasNext()) {
                AbstractMemberMetaData mmd = (AbstractMemberMetaData)membersIter.next();
                if (!mmd.isJdoField()) continue;
                if (mmd.fieldBelongsToClass()) {
                    mmd.setFieldId(field_id);
                    this.managedMembers[field_id] = mmd;
                    this.memberPositionsByName.put(mmd.getName(), field_id);
                    ++field_id;
                    continue;
                }
                this.overriddenMembers[overridden_field_id++] = mmd;
                AbstractMemberMetaData superFmd = this.pcSuperclassMetaData.getMemberBeingOverridden(mmd.getName());
                if (superFmd == null || !superFmd.isPrimaryKey()) continue;
                mmd.setPrimaryKey(true);
            }
            if (this.pcSuperclassMetaData != null) {
                if (!this.pcSuperclassMetaData.isInitialised()) {
                    this.pcSuperclassMetaData.initialise(clr, mmgr);
                }
                this.noOfInheritedManagedMembers = this.pcSuperclassMetaData.getNoOfInheritedManagedMembers() + this.pcSuperclassMetaData.getNoOfManagedMembers();
            }
            this.initialiseMemberPositionInformation(mmgr);
            this.implementsMetaData = new ImplementsMetaData[this.implementations.size()];
            for (i = 0; i < this.implementations.size(); ++i) {
                this.implementsMetaData[i] = this.implementations.get(i);
                this.implementsMetaData[i].initialise(clr, mmgr);
            }
            this.joinMetaData = new JoinMetaData[this.joins.size()];
            for (i = 0; i < this.joinMetaData.length; ++i) {
                this.joinMetaData[i] = (JoinMetaData)this.joins.get(i);
                this.joinMetaData[i].initialise(clr, mmgr);
            }
            this.indexMetaData = new IndexMetaData[this.indexes.size()];
            for (i = 0; i < this.indexMetaData.length; ++i) {
                this.indexMetaData[i] = (IndexMetaData)this.indexes.get(i);
                this.indexMetaData[i].initialise(clr, mmgr);
            }
            this.foreignKeyMetaData = new ForeignKeyMetaData[this.foreignKeys.size()];
            for (i = 0; i < this.foreignKeyMetaData.length; ++i) {
                this.foreignKeyMetaData[i] = (ForeignKeyMetaData)this.foreignKeys.get(i);
                this.foreignKeyMetaData[i].initialise(clr, mmgr);
            }
            this.uniqueMetaData = new UniqueMetaData[this.uniqueConstraints.size()];
            for (i = 0; i < this.uniqueMetaData.length; ++i) {
                this.uniqueMetaData[i] = (UniqueMetaData)this.uniqueConstraints.get(i);
                this.uniqueMetaData[i].initialise(clr, mmgr);
            }
            this.fetchGroupMetaData = new FetchGroupMetaData[this.fetchGroups.size()];
            this.fetchGroupMetaDataByName = new HashMap();
            for (i = 0; i < this.fetchGroupMetaData.length; ++i) {
                this.fetchGroupMetaData[i] = (FetchGroupMetaData)this.fetchGroups.get(i);
                this.fetchGroupMetaData[i].initialise(clr, mmgr);
                this.fetchGroupMetaDataByName.put(this.fetchGroupMetaData[i].getName(), this.fetchGroupMetaData[i]);
            }
            if (this.identityType == IdentityType.DATASTORE && this.identityMetaData == null) {
                if (this.pcSuperclassMetaData != null) {
                    IdentityMetaData superImd = this.pcSuperclassMetaData.getIdentityMetaData();
                    this.identityMetaData = new IdentityMetaData();
                    this.identityMetaData.setColumnName(superImd.getColumnName());
                    this.identityMetaData.setValueStrategy(superImd.getValueStrategy());
                    this.identityMetaData.setSequence(superImd.getSequence());
                } else {
                    this.identityMetaData = new IdentityMetaData();
                }
            }
            if (this.primaryKeyMetaData != null) {
                this.primaryKeyMetaData.initialise(clr, mmgr);
            }
            if (this.versionMetaData != null) {
                this.versionMetaData.initialise(clr, mmgr);
            }
            if (this.identityMetaData != null) {
                this.identityMetaData.initialise(clr, mmgr);
            }
            if (this.inheritanceMetaData != null) {
                this.inheritanceMetaData.initialise(clr, mmgr);
            }
            if (this.identityType == IdentityType.APPLICATION) {
                this.usesSingleFieldIdentityClass = mmgr.getApiAdapter().isSingleFieldIdentityClass(this.getObjectidClass());
            }
            this.joins.clear();
            this.joins = null;
            this.fetchGroups.clear();
            this.fetchGroups = null;
            this.foreignKeys.clear();
            this.foreignKeys = null;
            this.indexes.clear();
            this.indexes = null;
            this.uniqueConstraints.clear();
            this.uniqueConstraints = null;
            this.implementations.clear();
            this.implementations = null;
            this.setInitialised();
            Object var11_13 = null;
            this.initialising = false;
            mmgr.abstractClassMetaDataInitialised(this);
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.initialising = false;
            mmgr.abstractClassMetaDataInitialised(this);
            throw throwable;
        }
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    protected AbstractMemberMetaData newDefaultedProperty(String name) {
        return new FieldMetaData((MetaData)this, name);
    }

    public final ImplementsMetaData[] getImplementsMetaData() {
        return this.implementsMetaData;
    }

    public boolean implementsInterface(String interfaceName) {
        if (this.implementsMetaData != null) {
            for (int i = 0; i < this.implementsMetaData.length; ++i) {
                if (!this.implementsMetaData[i].getName().equals(interfaceName)) continue;
                return true;
            }
        }
        return false;
    }

    public void addImplements(ImplementsMetaData implmd) {
        if (implmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new RuntimeException("Already initialised");
        }
        this.implementations.add(implmd);
        implmd.parent = this;
    }

    public String toString(String prefix, String indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<class name=\"" + this.name + "\"\n");
        if (this.identityType != null) {
            sb.append(prefix).append("       identity-type=\"" + this.identityType + "\"\n");
        }
        if (this.objectidClass != null) {
            sb.append(prefix).append("       objectid-class=\"" + this.objectidClass + "\"\n");
        }
        if (!this.requiresExtent) {
            sb.append(prefix).append("       requires-extent=\"" + this.requiresExtent + "\"\n");
        }
        if (this.embeddedOnly) {
            sb.append(prefix).append("       embedded-only=\"" + this.embeddedOnly + "\"\n");
        }
        if (this.persistenceModifier != null) {
            sb.append(prefix).append("       persistence-modifier=\"" + this.persistenceModifier + "\"\n");
        }
        if (this.catalog != null) {
            sb.append(prefix).append("       catalog=\"" + this.catalog + "\"\n");
        }
        if (this.schema != null) {
            sb.append(prefix).append("       schema=\"" + this.schema + "\"\n");
        }
        if (this.table != null) {
            sb.append(prefix).append("       table=\"" + this.table + "\"\n");
        }
        if (this.detachable) {
            sb.append(prefix).append("       detachable=\"" + this.detachable + "\"\n");
        }
        sb.append(">\n");
        if (this.implementsMetaData != null) {
            for (i = 0; i < this.implementsMetaData.length; ++i) {
                sb.append(this.implementsMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.identityMetaData != null) {
            sb.append(this.identityMetaData.toString(prefix + indent, indent));
        }
        if (this.primaryKeyMetaData != null) {
            sb.append(this.primaryKeyMetaData.toString(prefix + indent, indent));
        }
        if (this.inheritanceMetaData != null) {
            sb.append(this.inheritanceMetaData.toString(prefix + indent, indent));
        }
        if (this.versionMetaData != null) {
            sb.append(this.versionMetaData.toString(prefix + indent, indent));
        }
        if (this.joinMetaData != null) {
            for (i = 0; i < this.joinMetaData.length; ++i) {
                sb.append(this.joinMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.foreignKeyMetaData != null) {
            for (i = 0; i < this.foreignKeyMetaData.length; ++i) {
                sb.append(this.foreignKeyMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.indexMetaData != null) {
            for (i = 0; i < this.indexMetaData.length; ++i) {
                sb.append(this.indexMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.uniqueMetaData != null) {
            for (i = 0; i < this.uniqueMetaData.length; ++i) {
                sb.append(this.uniqueMetaData[i].toString(prefix + indent, indent));
            }
        }
        if (this.managedMembers != null) {
            for (i = 0; i < this.managedMembers.length; ++i) {
                sb.append(this.managedMembers[i].toString(prefix + indent, indent));
            }
        } else if (this.members != null && this.members.size() > 0) {
            for (AbstractMemberMetaData mmd : this.members) {
                sb.append(mmd.toString(prefix + indent, indent));
            }
        }
        if (this.unmappedColumns != null) {
            for (int i2 = 0; i2 < this.unmappedColumns.size(); ++i2) {
                ColumnMetaData col = (ColumnMetaData)this.unmappedColumns.get(i2);
                sb.append(col.toString(prefix + indent, indent));
            }
        }
        if (this.queries != null) {
            for (QueryMetaData q : this.queries) {
                sb.append(q.toString(prefix + indent, indent));
            }
        }
        if (this.fetchGroupMetaData != null) {
            for (int i3 = 0; i3 < this.fetchGroupMetaData.length; ++i3) {
                sb.append(this.fetchGroupMetaData[i3].toString(prefix + indent, indent));
            }
        }
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix + "</class>\n");
        return sb.toString();
    }
}

