/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.Type;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.types.TypeManager;

public class ExecutionContextImpl
implements ExecutionContext {
    ObjectManager om;

    public ExecutionContextImpl(ObjectManager om) {
        this.om = om;
    }

    public ObjectManager getObjectManager() {
        return this.om;
    }

    public Object findObjectUsingAID(Type pcClass, final FieldValues2 fv, boolean ignoreCache, boolean checkInheritance) {
        return this.om.findObjectUsingAID(pcClass.getType(), new FieldValues(){

            public FetchPlan getFetchPlanForLoading() {
                return fv.getFetchPlanForLoading();
            }

            public void fetchNonLoadedFields(StateManager sm) {
                fv.fetchNonLoadedFields(sm.getObjectProvider());
            }

            public void fetchFields(StateManager sm) {
                fv.fetchFields(sm.getObjectProvider());
            }
        }, ignoreCache, checkInheritance);
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.om.getClassLoaderResolver();
    }

    public MetaDataManager getMetaDataManager() {
        return this.om.getMetaDataManager();
    }

    public Transaction getTransaction() {
        return this.om.getTransaction();
    }

    public TypeManager getTypeManager() {
        return this.om.getOMFContext().getTypeManager();
    }

    public ObjectProvider findObjectProvider(Object object, boolean persist) {
        StateManager sm = this.om.findStateManager(object);
        if (sm == null && persist) {
            int objectType = 0;
            Object object2 = this.om.persistObjectInternal(object, null, null, -1, objectType);
            sm = this.om.findStateManager(object2);
        } else if (sm == null) {
            return null;
        }
        return sm.getObjectProvider();
    }

    public ApiAdapter getApiAdapter() {
        return this.om.getApiAdapter();
    }

    public ObjectProvider findObjectProviderForEmbedded(Object value, ObjectProvider owner, AbstractMemberMetaData mmd) {
        StateManager embeddedSM = this.om.findStateManager(value);
        if (embeddedSM == null) {
            embeddedSM = StateManagerFactory.newStateManagerForEmbedded(this.om.getExecutionContext(), value, false);
        }
        if (embeddedSM.getEmbeddedOwners() == null || embeddedSM.getEmbeddedOwners().length == 0) {
            int absoluteFieldNumber = owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber();
            embeddedSM.getObjectProvider().addEmbeddedOwner(owner, absoluteFieldNumber);
            embeddedSM.setPcObjectType(1);
        }
        return embeddedSM.getObjectProvider();
    }

    public ObjectProvider newObjectProvider(Object id, Object obj) {
        ObjectProvider sm = ObjectProviderFactory.newForPersistentClean(this, id, obj);
        return sm;
    }

    public ObjectProvider newObjectProviderForMember(AbstractMemberMetaData mmd) {
        Class pcClass = this.om.getClassLoaderResolver().classForName(mmd.getClassName());
        StateManager sm = StateManagerFactory.newStateManagerForHollow(this.om.getExecutionContext(), pcClass, null);
        if (mmd.isEmbedded() || mmd.getEmbeddedMetaData() != null) {
            sm.initialiseForEmbedded(sm.getObject(), true);
        }
        return sm.getObjectProvider();
    }

    public ObjectProvider newObjectProviderForMember(AbstractMemberMetaData mmd, Type effectiveType) {
        Class pcClass = this.om.getClassLoaderResolver().classForName(effectiveType.getName());
        StateManager sm = StateManagerFactory.newStateManagerForHollow(this.om.getExecutionContext(), pcClass, null);
        if (mmd.isEmbedded() || mmd.getEmbeddedMetaData() != null) {
            sm.initialiseForEmbedded(sm.getObject(), true);
        }
        return sm.getObjectProvider();
    }

    public ObjectProvider newObjectProviderForMember(AbstractMemberMetaData mmd, AbstractClassMetaData effectiveTypeCmd) {
        Class pcClass = this.om.getClassLoaderResolver().classForName(effectiveTypeCmd.getFullClassName());
        StateManager sm = StateManagerFactory.newStateManagerForHollow(this.om.getExecutionContext(), pcClass, null);
        if (mmd.isEmbedded() || mmd.getEmbeddedMetaData() != null || effectiveTypeCmd.isEmbeddedOnly()) {
            sm.initialiseForEmbedded(sm.getObject(), true);
        }
        return sm.getObjectProvider();
    }

    public void deleteObjectInternal(Object pc) {
        this.om.deleteObjectInternal(pc);
    }

    public Object persistObjectInternal(Object pc, ObjectProvider ownerSM, int ownerFieldNum, int objectType) {
        if (ownerSM != null) {
            StateManager sm = this.om.findStateManager(ownerSM.getObject());
            return this.om.persistObjectInternal(pc, null, sm, ownerFieldNum, objectType);
        }
        return this.om.persistObjectInternal(pc, null, null, ownerFieldNum, objectType);
    }

    public boolean isClosed() {
        return this.om.isClosed();
    }

    public FetchPlan getFetchPlan() {
        return this.om.getFetchPlan();
    }

    public Query newQuery() {
        return this.om.newQuery();
    }

    public OMFContext getOMFContext() {
        return this.om.getOMFContext();
    }

    public StoreManager getStoreManager() {
        return this.om.getStoreManager();
    }

    public ObjectProvider findObjectProvider(Object obj) {
        StateManager sm = this.om.findStateManager(obj);
        if (sm == null) {
            return null;
        }
        return sm.getObjectProvider();
    }

    public Object findObject(Object id, boolean validate, boolean checkInheritance, String objectClassName) {
        return this.om.findObject(id, validate, checkInheritance, objectClassName);
    }

    public void flushInternal(boolean flushToDatastore) {
        this.om.flushInternal(flushToDatastore);
    }

    public void detachObject(Object val, FetchPlanState state) {
        this.om.detachObject(val, state);
    }

    public void deleteObjects(Object[] objs) {
        this.om.deleteObjects(objs);
    }

    public Object attachObjectCopy(Object pc, boolean sco) {
        return this.om.attachObjectCopy(pc, sco);
    }

    public Object detachObjectCopy(Object pc, FetchPlanState state) {
        return this.om.detachObjectCopy(pc, state);
    }

    public void refreshObject(Object pc) {
        this.om.refreshObject(pc);
    }

    public void evictFromTransaction(ObjectProvider sm) {
        StateManager sm1 = this.om.findStateManager(sm.getObject());
        this.om.evictFromTransaction(sm1);
    }

    public void removeObjectFromCache(Object pc, Object id) {
        this.om.removeObjectFromCache(pc, id);
    }

    public boolean isFlushing() {
        return this.om.isFlushing();
    }

    public boolean getIgnoreCache() {
        return this.om.getIgnoreCache();
    }

    public Integer getDatastoreReadTimeoutMillis() {
        return this.om.getDatastoreReadTimeoutMillis();
    }

    public Integer getDatastoreWriteTimeoutMillis() {
        return this.om.getDatastoreWriteTimeoutMillis();
    }

    public boolean isDelayDatastoreOperationsEnabled() {
        return this.om.isDelayDatastoreOperationsEnabled();
    }

    public void markDirty(ObjectProvider sm, boolean directUpdate) {
        StateManager sm1 = this.om.findStateManager(sm.getObject());
        this.om.markDirty(sm1, directUpdate);
    }

    public Extent getExtent(Class candidateClass, boolean includeSubclasses) {
        return this.om.getExtent(candidateClass, includeSubclasses);
    }

    public void attachObject(Object pc, boolean sco) {
        this.om.attachObject(pc, sco);
    }

    public Object getObjectFromCache(Object id) {
        return this.om.getObjectFromCache(id);
    }

    public Object findObject(Object id, final FieldValues2 fv, Class pcClass, boolean ignoreCache) {
        return this.om.findObject(id, fv == null ? null : new FieldValues(){

            public FetchPlan getFetchPlanForLoading() {
                return fv.getFetchPlanForLoading();
            }

            public void fetchNonLoadedFields(StateManager sm) {
                fv.fetchNonLoadedFields(sm.getObjectProvider());
            }

            public void fetchFields(StateManager sm) {
                fv.fetchFields(sm.getObjectProvider());
            }
        }, pcClass, ignoreCache);
    }

    public boolean getSerializeReadForClass(String className) {
        return this.om.getSerializeReadForClass(className);
    }

    public void hasPersistenceInformationForClass(Class cls) {
        this.om.hasPersistenceInformationForClass(cls);
    }

    public void makeObjectTransient(Object pc, FetchPlanState state) {
        this.om.makeObjectTransient(pc, state);
    }

    public boolean isInserting(Object pc) {
        return this.om.isInserting(pc);
    }

    public Object getAttachedObjectForId(Object id) {
        return this.om.getAttachedObjectForId(id);
    }

    public ObjectManagerFactoryImpl getObjectManagerFactory() {
        return this.om.getObjectManagerFactory();
    }

    public void persistObjectInternal(Object pc, final FieldValues2 preInsertChanges, int objectType) {
        this.om.persistObjectInternal(pc, preInsertChanges == null ? null : new FieldValues(){

            public FetchPlan getFetchPlanForLoading() {
                return preInsertChanges.getFetchPlanForLoading();
            }

            public void fetchNonLoadedFields(StateManager sm) {
                preInsertChanges.fetchNonLoadedFields(sm.getObjectProvider());
            }

            public void fetchFields(StateManager sm) {
                preInsertChanges.fetchFields(sm.getObjectProvider());
            }
        }, null, -1, objectType);
    }

    public Object newObjectId(String className, Object pc) {
        return this.om.newObjectId(className, pc);
    }

    public Object newObjectId(Class pcClass, Object key) {
        return this.om.newObjectId(pcClass, key);
    }

    public void deleteObject(Object obj) {
        this.om.deleteObject(obj);
    }
}

