/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.StringUtils;

public class ClassUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected static Map constructorsCache = new SoftValueMap();

    public static Object newInstance(Class type, Class[] parameterTypes, Object[] parameters) {
        Object obj;
        try {
            Constructor ctor;
            String name = "" + type.hashCode();
            if (parameterTypes != null) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    name = name + "-" + parameterTypes[i].hashCode();
                }
            }
            if ((ctor = (Constructor)constructorsCache.get(name)) == null) {
                ctor = type.getConstructor(parameterTypes);
                constructorsCache.put(name, ctor);
            }
            obj = ctor.newInstance(parameters);
        }
        catch (NoSuchMethodException e) {
            throw new NucleusException(LOCALISER.msg("030004", (Object)type.getName(), (Object)(Arrays.asList(parameterTypes).toString() + " " + Arrays.asList(type.getConstructors()).toString())), new Exception[]{e}).setFatal();
        }
        catch (IllegalAccessException e) {
            throw new NucleusException(LOCALISER.msg("030005", (Object)type.getName()), new Exception[]{e}).setFatal();
        }
        catch (InstantiationException e) {
            throw new NucleusException(LOCALISER.msg("030006", (Object)type.getName()), new Exception[]{e}).setFatal();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new NucleusException(LOCALISER.msg("030007", (Object)type.getName(), (Object)t)).setFatal();
        }
        return obj;
    }

    public static Constructor getConstructorWithArguments(Class cls, Class[] types) {
        block8: {
            try {
                Constructor<?>[] constructors = cls.getConstructors();
                if (constructors == null) break block8;
                for (int i = 0; i < constructors.length; ++i) {
                    Class<?>[] ctrParams = constructors[i].getParameterTypes();
                    boolean ctrIsValid = true;
                    if (ctrParams != null && ctrParams.length == types.length) {
                        for (int j = 0; j < ctrParams.length; ++j) {
                            Class primType = ClassUtils.getPrimitiveTypeForType(types[j]);
                            if (types[j] == null && ctrParams[j].isPrimitive()) {
                                ctrIsValid = false;
                            } else {
                                if (types[j] == null || ctrParams[j] == types[j] || primType != null && (primType == null || ctrParams[j] == primType)) continue;
                                ctrIsValid = false;
                            }
                            break;
                        }
                    } else {
                        ctrIsValid = false;
                    }
                    if (!ctrIsValid) continue;
                    return constructors[i];
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method getMethodWithArgument(Class cls, String methodName, Class argType) {
        Class primitive;
        Method m = ClassUtils.getMethodForClass(cls, methodName, new Class[]{argType});
        if (m == null && (primitive = ClassUtils.getPrimitiveTypeForType(argType)) != null) {
            m = ClassUtils.getMethodForClass(cls, methodName, new Class[]{primitive});
        }
        return m;
    }

    public static Method getMethodForClass(Class cls, String methodName, Class[] argtypes) {
        try {
            return cls.getDeclaredMethod(methodName, argtypes);
        }
        catch (NoSuchMethodException e) {
            if (cls.getSuperclass() != null) {
                return ClassUtils.getMethodForClass(cls.getSuperclass(), methodName, argtypes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getClassnameForFilename(String filename, String rootfilename) {
        String file_separator;
        if (filename == null) {
            return null;
        }
        String classname = filename;
        if (rootfilename != null) {
            classname = classname.substring(rootfilename.length());
        }
        if ((classname = classname.substring(0, classname.length() - 6)).indexOf(file_separator = System.getProperty("file.separator")) == 0) {
            classname = classname.substring(file_separator.length());
        }
        classname = classname.replace(file_separator, ".");
        return classname;
    }

    public static Collection getClassFilesForDirectory(File dir, boolean normal_classes, boolean inner_classes) {
        if (dir == null) {
            return null;
        }
        HashSet<File> classes = new HashSet<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    if (!files[i].getName().endsWith(".class")) continue;
                    boolean is_inner_class = ClassUtils.isInnerClass(files[i].getName());
                    if ((!normal_classes || is_inner_class) && (!inner_classes || !is_inner_class)) continue;
                    classes.add(files[i]);
                    continue;
                }
                Collection child_classes = ClassUtils.getClassFilesForDirectory(files[i], normal_classes, inner_classes);
                if (child_classes == null || child_classes.size() <= 0) continue;
                classes.addAll(child_classes);
            }
        }
        return classes;
    }

    public static String[] getClassNamesForJarFile(String jarFileName) {
        try {
            JarFile jar = new JarFile(jarFileName);
            return ClassUtils.getClassNamesForJarFile(jar);
        }
        catch (IOException ioe) {
            NucleusLogger.GENERAL.warn("Error opening the jar file " + jarFileName + " : " + ioe.getMessage());
            return null;
        }
    }

    public static String[] getClassNamesForJarFile(URL jarFileURL) {
        File jarFile = new File(jarFileURL.getFile());
        try {
            JarFile jar = new JarFile(jarFile);
            return ClassUtils.getClassNamesForJarFile(jar);
        }
        catch (IOException ioe) {
            NucleusLogger.GENERAL.warn("Error opening the jar file " + jarFileURL.getFile() + " : " + ioe.getMessage());
            return null;
        }
    }

    private static String[] getClassNamesForJarFile(JarFile jar) {
        Enumeration<JarEntry> jarEntries = jar.entries();
        HashSet<String> classes = new HashSet<String>();
        String file_separator = System.getProperty("file.separator");
        while (jarEntries.hasMoreElements()) {
            String entry = jarEntries.nextElement().getName();
            if (!entry.endsWith(".class") || ClassUtils.isInnerClass(entry)) continue;
            String className = entry.substring(0, entry.length() - 6);
            className = className.replace(file_separator, ".");
            classes.add(className);
        }
        return classes.toArray(new String[classes.size()]);
    }

    public static String[] getPackageJdoFilesForJarFile(String jarFileName) {
        try {
            JarFile jar = new JarFile(jarFileName);
            return ClassUtils.getFileNamesWithSuffixForJarFile(jar, "package.jdo");
        }
        catch (IOException ioe) {
            NucleusLogger.GENERAL.warn("Error opening the jar file " + jarFileName + " : " + ioe.getMessage());
            return null;
        }
    }

    public static String[] getPackageJdoFilesForJarFile(URL jarFileURL) {
        File jarFile = new File(jarFileURL.getFile());
        try {
            JarFile jar = new JarFile(jarFile);
            return ClassUtils.getFileNamesWithSuffixForJarFile(jar, "package.jdo");
        }
        catch (IOException ioe) {
            NucleusLogger.GENERAL.warn("Error opening the jar file " + jarFileURL.getFile() + " : " + ioe.getMessage());
            return null;
        }
    }

    private static String[] getFileNamesWithSuffixForJarFile(JarFile jar, String suffix) {
        Enumeration<JarEntry> jarEntries = jar.entries();
        HashSet<String> files = new HashSet<String>();
        while (jarEntries.hasMoreElements()) {
            String entry = jarEntries.nextElement().getName();
            if (!entry.endsWith(suffix)) continue;
            files.add(entry);
        }
        return files.toArray(new String[files.size()]);
    }

    public static String[] getClassNamesForDirectoryAndBelow(File dir) {
        if (dir == null) {
            return null;
        }
        Collection classFiles = ClassUtils.getClassFilesForDirectory(dir, true, false);
        if (classFiles == null || classFiles.isEmpty()) {
            return null;
        }
        String[] classNames = new String[classFiles.size()];
        Iterator iter = classFiles.iterator();
        String file_separator = System.getProperty("file.separator");
        int i = 0;
        while (iter.hasNext()) {
            String filename = ((File)iter.next()).getAbsolutePath();
            String classname = filename.substring(dir.getAbsolutePath().length() + 1, filename.length() - 6);
            classNames[i++] = classname.replace(file_separator, ".");
        }
        return classNames;
    }

    public static boolean isInnerClass(String class_name) {
        if (class_name == null) {
            return false;
        }
        return class_name.indexOf(36) >= 0;
    }

    public static boolean hasDefaultConstructor(Class the_class) {
        if (the_class == null) {
            return false;
        }
        try {
            the_class.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Collection getSuperclasses(Class the_class) {
        ArrayList superclasses = new ArrayList();
        Class c = the_class;
        boolean more_superclasses = true;
        while (more_superclasses) {
            Class superclass = c.getSuperclass();
            if (superclass != null) {
                superclasses.add(superclass);
                c = superclass;
                continue;
            }
            more_superclasses = false;
        }
        return superclasses;
    }

    public static Collection getSuperinterfaces(Class the_class) {
        ArrayList superintfs = new ArrayList();
        Class c = the_class;
        Class<?>[] superinterfaces = c.getInterfaces();
        if (superinterfaces != null) {
            for (int i = 0; i < superinterfaces.length; ++i) {
                if (superintfs.contains(superinterfaces[i])) continue;
                superintfs.add(superinterfaces[i]);
                superintfs.addAll(ClassUtils.getSuperinterfaces(superinterfaces[i]));
            }
        }
        return superintfs;
    }

    public static Field getFieldForClass(Class cls, String fieldName) {
        try {
            return cls.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (cls.getSuperclass() != null) {
                return ClassUtils.getFieldForClass(cls.getSuperclass(), fieldName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Method getGetterMethodForClass(Class cls, String beanName) {
        String getterName = ClassUtils.getJavaBeanGetterName(beanName, false);
        try {
            return cls.getDeclaredMethod(getterName, null);
        }
        catch (NoSuchMethodException e) {
            if (cls.getSuperclass() != null) {
                return ClassUtils.getGetterMethodForClass(cls.getSuperclass(), beanName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        getterName = ClassUtils.getJavaBeanGetterName(beanName, true);
        try {
            return cls.getDeclaredMethod(getterName, null);
        }
        catch (NoSuchMethodException e) {
            if (cls.getSuperclass() != null) {
                return ClassUtils.getGetterMethodForClass(cls.getSuperclass(), beanName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getWrapperTypeNameForPrimitiveTypeName(String typeName) {
        if (typeName.equals("boolean")) {
            return ClassNameConstants.JAVA_LANG_BOOLEAN;
        }
        if (typeName.equals("byte")) {
            return ClassNameConstants.JAVA_LANG_BYTE;
        }
        if (typeName.equals("char")) {
            return ClassNameConstants.JAVA_LANG_CHARACTER;
        }
        if (typeName.equals("double")) {
            return ClassNameConstants.JAVA_LANG_DOUBLE;
        }
        if (typeName.equals("float")) {
            return ClassNameConstants.JAVA_LANG_FLOAT;
        }
        if (typeName.equals("int")) {
            return ClassNameConstants.JAVA_LANG_INTEGER;
        }
        if (typeName.equals("long")) {
            return ClassNameConstants.JAVA_LANG_LONG;
        }
        if (typeName.equals("short")) {
            return ClassNameConstants.JAVA_LANG_SHORT;
        }
        return typeName;
    }

    public static Class getWrapperTypeForPrimitiveType(Class type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        return null;
    }

    public static Class getPrimitiveTypeForType(Class type) {
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        return null;
    }

    public static boolean isPrimitiveWrapperType(String typeName) {
        return typeName.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || typeName.equals(ClassNameConstants.JAVA_LANG_BYTE) || typeName.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || typeName.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || typeName.equals(ClassNameConstants.JAVA_LANG_FLOAT) || typeName.equals(ClassNameConstants.JAVA_LANG_INTEGER) || typeName.equals(ClassNameConstants.JAVA_LANG_LONG) || typeName.equals(ClassNameConstants.JAVA_LANG_SHORT);
    }

    public static boolean isPrimitiveArrayType(String typeName) {
        return typeName.equals(ClassNameConstants.BOOLEAN_ARRAY) || typeName.equals(ClassNameConstants.BYTE_ARRAY) || typeName.equals(ClassNameConstants.CHAR_ARRAY) || typeName.equals(ClassNameConstants.DOUBLE_ARRAY) || typeName.equals(ClassNameConstants.FLOAT_ARRAY) || typeName.equals(ClassNameConstants.INT_ARRAY) || typeName.equals(ClassNameConstants.LONG_ARRAY) || typeName.equals(ClassNameConstants.SHORT_ARRAY);
    }

    public static boolean isPrimitiveType(String typeName) {
        return typeName.equals(ClassNameConstants.BOOLEAN) || typeName.equals(ClassNameConstants.BYTE) || typeName.equals(ClassNameConstants.CHAR) || typeName.equals(ClassNameConstants.DOUBLE) || typeName.equals(ClassNameConstants.FLOAT) || typeName.equals(ClassNameConstants.INT) || typeName.equals(ClassNameConstants.LONG) || typeName.equals(ClassNameConstants.SHORT);
    }

    public static Object convertValue(Object value, Class cls) {
        if (value == null) {
            return null;
        }
        Class type = cls;
        if (cls.isPrimitive()) {
            type = ClassUtils.getWrapperTypeForPrimitiveType(cls);
        }
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (type == Long.class && value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (type == Integer.class && value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (type == Short.class && value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (type == Float.class && value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (type == Double.class && value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    public static boolean typesAreCompatible(Class cls1, String clsName2, ClassLoaderResolver clr) {
        if (clr.isAssignableFrom(cls1, clsName2)) {
            return true;
        }
        if (cls1.isPrimitive()) {
            return clr.isAssignableFrom(ClassUtils.getWrapperTypeForPrimitiveType(cls1), clsName2);
        }
        if (ClassUtils.isPrimitiveWrapperType(cls1.getName())) {
            return clr.isAssignableFrom(ClassUtils.getPrimitiveTypeForType(cls1), clsName2);
        }
        return false;
    }

    public static boolean typesAreCompatible(Class cls1, Class cls2) {
        if (cls1.isAssignableFrom(cls2)) {
            return true;
        }
        if (cls1.isPrimitive()) {
            return ClassUtils.getWrapperTypeForPrimitiveType(cls1).isAssignableFrom(cls2);
        }
        return false;
    }

    public static String createFullClassName(String pkg_name, String cls_name) {
        if (StringUtils.isWhitespace(cls_name)) {
            throw new IllegalArgumentException("Class name not specified");
        }
        if (StringUtils.isWhitespace(pkg_name)) {
            return cls_name;
        }
        if (cls_name.indexOf(46) >= 0) {
            return cls_name;
        }
        return pkg_name + "." + cls_name;
    }

    public static String getJavaLangClassForType(String type) {
        String baseType = null;
        baseType = type.lastIndexOf(46) < 0 ? type : type.substring(type.lastIndexOf(46) + 1);
        if (baseType.equals("String") || baseType.equals("Object") || baseType.equals("Boolean") || baseType.equals("Byte") || baseType.equals("Character") || baseType.equals("Double") || baseType.equals("Float") || baseType.equals("Integer") || baseType.equals("Long") || baseType.equals("Short") || baseType.equals("Number") || baseType.equals("StringBuffer")) {
            return "java.lang." + baseType;
        }
        return type;
    }

    public static boolean classesAreDescendents(ClassLoaderResolver clr, String class_name_1, String class_name_2) {
        Class class_1 = clr.classForName(class_name_1);
        Class class_2 = clr.classForName(class_name_2);
        if (class_1 == null || class_2 == null) {
            return false;
        }
        return class_1.isAssignableFrom(class_2) || class_2.isAssignableFrom(class_1);
    }

    public static void dumpClassInformation(Class cls) {
        int j;
        Annotation[] annots;
        int i;
        NucleusLogger.GENERAL.info("----------------------------------------");
        NucleusLogger.GENERAL.info("Class Information for class " + cls.getName());
        Collection superclasses = ClassUtils.getSuperclasses(cls);
        for (Class superclass : superclasses) {
            NucleusLogger.GENERAL.info("    Superclass : " + superclass.getName());
        }
        Class<?>[] interfaces = cls.getInterfaces();
        if (interfaces != null) {
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                NucleusLogger.GENERAL.info("    Interface : " + interfaces[i2].getName());
            }
        }
        try {
            Method[] methods = cls.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                NucleusLogger.GENERAL.info("    Method : " + methods[i].toString());
                annots = methods[i].getAnnotations();
                if (annots == null) continue;
                for (j = 0; j < annots.length; ++j) {
                    NucleusLogger.GENERAL.info("        annotation=" + annots[j]);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Field[] fields = cls.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                NucleusLogger.GENERAL.info("    Field : " + fields[i].toString());
                annots = fields[i].getAnnotations();
                if (annots == null) continue;
                for (j = 0; j < annots.length; ++j) {
                    NucleusLogger.GENERAL.info("        annotation=" + annots[j]);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        NucleusLogger.GENERAL.info("----------------------------------------");
    }

    public static String getJavaBeanGetterName(String fieldName, boolean isBoolean) {
        if (fieldName == null) {
            return null;
        }
        String prefix = isBoolean ? "is" : "get";
        String name = fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        return prefix + name;
    }

    public static String getJavaBeanSetterName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String prefix = "set";
        String name = fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        return prefix + name;
    }

    public static String getFieldNameForJavaBeanGetter(String methodName) {
        if (methodName == null) {
            return null;
        }
        if (methodName.startsWith("get")) {
            if (methodName.length() < 4) {
                return null;
            }
            if (methodName.length() == 4) {
                return methodName.toLowerCase().substring(3);
            }
            if (Character.isUpperCase(methodName.charAt(3)) && Character.isUpperCase(methodName.charAt(4))) {
                return methodName.substring(3);
            }
            return methodName.toLowerCase().charAt(3) + methodName.substring(4);
        }
        if (methodName.startsWith("is")) {
            if (methodName.length() < 3) {
                return null;
            }
            if (methodName.length() == 3) {
                return methodName.toLowerCase().substring(2);
            }
            if (Character.isUpperCase(methodName.charAt(2)) && Character.isUpperCase(methodName.charAt(3))) {
                return methodName.substring(2);
            }
            return methodName.toLowerCase().charAt(2) + methodName.substring(3);
        }
        return null;
    }

    public static String getFieldNameForJavaBeanSetter(String methodName) {
        if (methodName == null) {
            return null;
        }
        if (methodName.startsWith("set")) {
            if (methodName.length() < 4) {
                return null;
            }
            if (methodName.length() == 4) {
                return methodName.toLowerCase().substring(3);
            }
            if (Character.isUpperCase(methodName.charAt(3)) && Character.isUpperCase(methodName.charAt(4))) {
                return methodName.substring(3);
            }
            return methodName.toLowerCase().charAt(3) + methodName.substring(4);
        }
        return null;
    }

    public static String getClassNameForFileURL(final URL fileURL) throws ClassNotFoundException {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ClassLoader(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    protected Class findClass(String name) throws ClassNotFoundException {
                        Class<?> clazz;
                        BufferedInputStream in = null;
                        try {
                            try {
                                in = new BufferedInputStream(fileURL.openStream());
                                ByteArrayOutputStream byteStr = new ByteArrayOutputStream();
                                int byt = -1;
                                while ((byt = ((InputStream)in).read()) != -1) {
                                    byteStr.write(byt);
                                }
                                byte[] byteArr = byteStr.toByteArray();
                                clazz = this.defineClass(null, byteArr, 0, byteArr.length);
                                Object var8_9 = null;
                                if (in == null) return clazz;
                            }
                            catch (RuntimeException rex) {
                                throw rex;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                throw new ClassNotFoundException(name);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            if (in == null) throw throwable;
                            try {
                                ((InputStream)in).close();
                                throw throwable;
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                                throw throwable;
                            }
                        }
                        try {}
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            return clazz;
                        }
                        ((InputStream)in).close();
                        return clazz;
                    }
                };
            }
        });
        Class<?> cls = loader.loadClass("garbage");
        return cls != null ? cls.getName() : null;
    }

    public static String getPackageNameForClass(Class cls) {
        if (cls.getPackage() != null) {
            return cls.getPackage().getName();
        }
        int separator = cls.getName().lastIndexOf(46);
        if (separator < 0) {
            return null;
        }
        return cls.getName().substring(0, separator);
    }

    public static String getClassNameForClass(Class cls) {
        int separator = cls.getName().lastIndexOf(46);
        if (separator < 0) {
            return cls.getName();
        }
        return cls.getName().substring(separator + 1);
    }

    public static String getCollectionElementType(Field field) {
        return ClassUtils.getCollectionElementType(field.getType(), field.getGenericType());
    }

    public static String getCollectionElementType(Class type, Type genericType) {
        ParameterizedType paramtype;
        if (!Collection.class.isAssignableFrom(type)) {
            return null;
        }
        String elementType = null;
        if (genericType instanceof ParameterizedType && (paramtype = (ParameterizedType)genericType).getActualTypeArguments().length == 1 && paramtype.getActualTypeArguments()[0] instanceof Class) {
            elementType = ((Class)paramtype.getActualTypeArguments()[0]).getName();
        }
        return elementType;
    }

    public static String getCollectionElementType(Method method) {
        ParameterizedType paramtype;
        if (!Collection.class.isAssignableFrom(method.getReturnType())) {
            return null;
        }
        String elementType = null;
        if (method.getGenericReturnType() instanceof ParameterizedType && (paramtype = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments().length == 1 && paramtype.getActualTypeArguments()[0] instanceof Class) {
            elementType = ((Class)paramtype.getActualTypeArguments()[0]).getName();
        }
        return elementType;
    }

    public static String getMapKeyType(Field field) {
        return ClassUtils.getMapKeyType(field.getType(), field.getGenericType());
    }

    public static String getMapKeyType(Class type, Type genericType) {
        ParameterizedType paramtype;
        if (!Map.class.isAssignableFrom(type)) {
            return null;
        }
        String keyType = null;
        if (genericType instanceof ParameterizedType && (paramtype = (ParameterizedType)genericType).getActualTypeArguments().length == 2 && paramtype.getActualTypeArguments()[0] instanceof Class) {
            keyType = ((Class)paramtype.getActualTypeArguments()[0]).getName();
        }
        return keyType;
    }

    public static String getMapKeyType(Method method) {
        ParameterizedType paramtype;
        if (!Map.class.isAssignableFrom(method.getReturnType())) {
            return null;
        }
        String keyType = null;
        if (method.getGenericReturnType() instanceof ParameterizedType && (paramtype = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments().length == 2 && paramtype.getActualTypeArguments()[0] instanceof Class) {
            keyType = ((Class)paramtype.getActualTypeArguments()[0]).getName();
        }
        return keyType;
    }

    public static String getMapValueType(Field field) {
        return ClassUtils.getMapValueType(field.getType(), field.getGenericType());
    }

    public static String getMapValueType(Class type, Type genericType) {
        ParameterizedType paramtype;
        if (!Map.class.isAssignableFrom(type)) {
            return null;
        }
        String valueType = null;
        if (genericType instanceof ParameterizedType && (paramtype = (ParameterizedType)genericType).getActualTypeArguments().length == 2 && paramtype.getActualTypeArguments()[1] instanceof Class) {
            valueType = ((Class)paramtype.getActualTypeArguments()[1]).getName();
        }
        return valueType;
    }

    public static String getMapValueType(Method method) {
        ParameterizedType paramtype;
        if (!Map.class.isAssignableFrom(method.getReturnType())) {
            return null;
        }
        String valueType = null;
        if (method.getGenericReturnType() instanceof ParameterizedType && (paramtype = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments().length == 2 && paramtype.getActualTypeArguments()[1] instanceof Class) {
            valueType = ((Class)paramtype.getActualTypeArguments()[1]).getName();
        }
        return valueType;
    }

    public static int getModifiersForFieldOfClass(ClassLoaderResolver clr, String className, String fieldName) {
        try {
            Class cls = clr.classForName(className);
            Field fld = cls.getDeclaredField(fieldName);
            return fld.getModifiers();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static boolean isReferenceType(Class cls) {
        if (cls == null) {
            return false;
        }
        return cls.isInterface() || cls.getName().equals("java.lang.Object");
    }

    public static void assertClassForJarExistsInClasspath(ClassLoaderResolver clr, String className, String jarName) {
        try {
            Class cls = clr.classForName(className);
            if (cls == null) {
                throw new NucleusUserException(LOCALISER.msg("001006", (Object)className, (Object)jarName));
            }
        }
        catch (Error err) {
            throw new NucleusUserException(LOCALISER.msg("001006", (Object)className, (Object)jarName));
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusUserException(LOCALISER.msg("001006", (Object)className, (Object)jarName));
        }
    }

    public static boolean stringArrayContainsValue(String[] array, String value) {
        if (value == null || array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!value.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static Object getValueOfMethodByReflection(Object object, String methodName, Object ... args) {
        Object methodValue;
        if (object == null) {
            return null;
        }
        final Method method = ClassUtils.getDeclaredMethodPrivileged(object.getClass(), methodName, null);
        if (method == null) {
            throw new NucleusUserException("Cannot access method: " + methodName + " in type " + object.getClass());
        }
        try {
            if (!method.isAccessible()) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            method.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (SecurityException ex) {
                    throw new NucleusException("Cannot access method: " + methodName, ex).setFatal();
                }
            }
            methodValue = method.invoke(object, args);
        }
        catch (InvocationTargetException e2) {
            throw new NucleusUserException("Cannot access method: " + methodName, e2);
        }
        catch (IllegalArgumentException e2) {
            throw new NucleusUserException("Cannot access method: " + methodName, e2);
        }
        catch (IllegalAccessException e2) {
            throw new NucleusUserException("Cannot access method: " + methodName, e2);
        }
        return methodValue;
    }

    public static Object getValueOfFieldByReflection(Object object, String fieldName) {
        Object fieldValue;
        if (object == null) {
            return null;
        }
        final Field field = ClassUtils.getDeclaredFieldPrivileged(object.getClass(), fieldName);
        if (field == null) {
            throw new NucleusUserException("Cannot access field: " + fieldName + " in type " + object.getClass());
        }
        try {
            if (!field.isAccessible()) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            field.setAccessible(true);
                            return null;
                        }
                    });
                }
                catch (SecurityException ex) {
                    throw new NucleusException("Cannot access field: " + fieldName, ex).setFatal();
                }
            }
            fieldValue = field.get(object);
        }
        catch (IllegalArgumentException e2) {
            throw new NucleusUserException("Cannot access field: " + fieldName, e2);
        }
        catch (IllegalAccessException e2) {
            throw new NucleusUserException("Cannot access field: " + fieldName, e2);
        }
        return fieldValue;
    }

    private static Field getDeclaredFieldPrivileged(final Class clazz, final String fieldName) {
        if (clazz == null || fieldName == null) {
            return null;
        }
        return (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class seekingClass = clazz;
                do {
                    try {
                        return seekingClass.getDeclaredField(fieldName);
                    }
                    catch (SecurityException ex) {
                        throw new NucleusException("CannotGetDeclaredField", ex).setFatal();
                    }
                    catch (NoSuchFieldException ex) {
                    }
                    catch (LinkageError ex) {
                        throw new NucleusException("ClassLoadingError", ex).setFatal();
                    }
                } while ((seekingClass = seekingClass.getSuperclass()) != null);
                return null;
            }
        });
    }

    private static Method getDeclaredMethodPrivileged(final Class clazz, final String methodName, final Class ... argTypes) {
        if (clazz == null || methodName == null) {
            return null;
        }
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Class seekingClass = clazz;
                do {
                    try {
                        return seekingClass.getDeclaredMethod(methodName, argTypes);
                    }
                    catch (SecurityException ex) {
                        throw new NucleusException("Cannot get declared method " + methodName, ex).setFatal();
                    }
                    catch (NoSuchMethodException ex) {
                    }
                    catch (LinkageError ex) {
                        throw new NucleusException("ClassLoadingError", ex).setFatal();
                    }
                } while ((seekingClass = seekingClass.getSuperclass()) != null);
                return null;
            }
        });
    }

    public static Object getValueForIdentityField(Object id, String fieldName) {
        String getterName = ClassUtils.getJavaBeanGetterName(fieldName, false);
        try {
            return ClassUtils.getValueOfMethodByReflection(id, getterName, null);
        }
        catch (NucleusException ne) {
            try {
                return ClassUtils.getValueOfFieldByReflection(id, fieldName);
            }
            catch (NucleusException nucleusException) {
                throw new NucleusUserException("Not possible to get value of field " + fieldName + " from identity " + id);
            }
        }
    }

    public static Class getClassForMemberOfClass(Class cls, String memberName) {
        Field fld = ClassUtils.getFieldForClass(cls, memberName);
        if (fld != null) {
            return fld.getType();
        }
        Method method = ClassUtils.getGetterMethodForClass(cls, memberName);
        if (method != null) {
            return method.getReturnType();
        }
        return null;
    }
}

