/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;

public class StatementText {
    private StringBuffer statementText;
    private List<Parameter> parameters = null;
    private boolean encloseInParentheses = false;
    private String postpend;
    private List appended = new ArrayList();

    public StatementText() {
    }

    public StatementText(String initialStatementText) {
        this();
        this.append(initialStatementText);
    }

    public void clearStatement() {
        this.statementText = null;
        this.appended.clear();
    }

    public void encloseInParentheses() {
        this.statementText = null;
        this.encloseInParentheses = true;
    }

    public StatementText postpend(String s) {
        this.statementText = null;
        this.postpend = s;
        return this;
    }

    public StatementText append(char c) {
        this.statementText = null;
        this.appended.add(new Character(c));
        return this;
    }

    public StatementText append(String s) {
        this.statementText = null;
        this.appended.add(s);
        return this;
    }

    public StatementText append(QueryExpression qsc) {
        this.statementText = null;
        this.appended.add(qsc);
        return this;
    }

    public StatementText append(StatementText st, int mode) {
        this.statementText = null;
        this.appended.add(st.toStatementString(mode));
        if (st.parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<Parameter>();
            }
            this.parameters.addAll(st.parameters);
        }
        return this;
    }

    public StatementText append(ScalarExpression expr) {
        this.statementText = null;
        this.appended.add(expr);
        return this;
    }

    public StatementText appendParameter(JavaTypeMapping mapping, Object value) {
        this.statementText = null;
        this.appended.add(new Parameter(mapping, value));
        return this;
    }

    public void applyParametersToStatement(ExecutionContext ec, Object datastoreStatement) {
        if (this.parameters != null) {
            int num = 1;
            for (Parameter param : this.parameters) {
                JavaTypeMapping mapping = param.mapping;
                Object value = param.value;
                mapping.setObject(ec, datastoreStatement, MappingHelper.getMappingIndices(num, mapping), value);
                if (mapping.getNumberOfDatastoreMappings() > 0) {
                    num += mapping.getNumberOfDatastoreMappings();
                    continue;
                }
                ++num;
            }
        }
    }

    public String toStatementString(int mode) {
        if (this.statementText == null) {
            this.statementText = new StringBuffer();
            if (this.encloseInParentheses) {
                this.statementText.append("(");
            }
            for (int i = 0; i < this.appended.size(); ++i) {
                StatementText st;
                Object item = this.appended.get(i);
                if (item instanceof ScalarExpression) {
                    ScalarExpression expr = (ScalarExpression)item;
                    st = expr.toStatementText(mode);
                    this.statementText.append(st.toStatementString(mode));
                    if (st.parameters == null) continue;
                    if (this.parameters == null) {
                        this.parameters = new ArrayList<Parameter>();
                    }
                    this.parameters.addAll(st.parameters);
                    continue;
                }
                if (item instanceof Parameter) {
                    Parameter param = (Parameter)item;
                    this.statementText.append('?');
                    if (this.parameters == null) {
                        this.parameters = new ArrayList<Parameter>();
                    }
                    this.parameters.add(param);
                    continue;
                }
                if (item instanceof QueryExpression) {
                    QueryExpression qe = (QueryExpression)item;
                    st = qe.toStatementText(false);
                    this.statementText.append(st.toStatementString(mode));
                    if (st.parameters == null) continue;
                    if (this.parameters == null) {
                        this.parameters = new ArrayList<Parameter>();
                    }
                    this.parameters.addAll(st.parameters);
                    continue;
                }
                if (item instanceof StatementText) {
                    StatementText st2 = (StatementText)item;
                    this.statementText.append(st2.toStatementString(mode));
                    if (st2.parameters == null) continue;
                    if (this.parameters == null) {
                        this.parameters = new ArrayList<Parameter>();
                    }
                    this.parameters.addAll(st2.parameters);
                    continue;
                }
                this.statementText.append(item);
            }
            if (this.encloseInParentheses) {
                this.statementText.append(")");
            }
            this.statementText.append(this.postpend == null ? "" : this.postpend);
        }
        return this.statementText.toString();
    }

    public String toString() {
        return this.toStatementString(ScalarExpression.PROJECTION);
    }

    private class Parameter {
        final JavaTypeMapping mapping;
        final Object value;

        public Parameter(JavaTypeMapping mapping, Object value) {
            this.mapping = mapping;
            this.value = value;
        }
    }
}

